/*
 * Copyright (c) 2020, 2022 Oracle and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import io.helidon.common.features.api.Aot;
import io.helidon.common.features.api.Feature;
import io.helidon.common.features.api.HelidonFlavor;

/**
 * Helidon Reactive Messaging.
 */
@Feature(value = "Messaging",
        description = "Reactive messaging support",
        in = HelidonFlavor.SE,
        path = "Messaging"
)
@Aot(description = "Experimental support in native image")
module io.helidon.messaging {
    requires static io.helidon.common.features.api;

    requires java.logging;

    requires io.helidon.common.context;
    requires io.helidon.common.configurable;
    requires io.helidon.config.mp;
    requires transitive io.helidon.common.reactive;
    requires transitive io.helidon.config;
    requires transitive org.reactivestreams;
    requires transitive microprofile.config.api;
    requires transitive microprofile.reactive.messaging.api;
    requires transitive microprofile.reactive.streams.operators.api;

    exports io.helidon.messaging;
}
