/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging;

import io.helidon.config.Config;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public final class Channel<PAYLOAD> {
    private String name;
    private Publisher<Message<PAYLOAD>> publisher;
    private Subscriber<Message<PAYLOAD>> subscriber;
    private Config publisherConfig;
    private Config subscriberConfig;

    void connect() {
        Objects.requireNonNull(this.publisher, "Missing publisher for channel " + this.name);
        Objects.requireNonNull(this.subscriber, "Missing subscriber for channel " + this.name);
        this.publisher.subscribe(this.subscriber);
    }

    void setName(String name) {
        this.name = name;
    }

    Publisher<Message<PAYLOAD>> getPublisher() {
        return this.publisher;
    }

    void setPublisher(Publisher<? extends Message<?>> publisher) {
        this.publisher = publisher;
    }

    Subscriber<Message<PAYLOAD>> getSubscriber() {
        return this.subscriber;
    }

    void setSubscriber(Subscriber<? extends Message<?>> subscriber) {
        this.subscriber = subscriber;
    }

    Config getPublisherConfig() {
        return this.publisherConfig;
    }

    Config getSubscriberConfig() {
        return this.subscriberConfig;
    }

    public String name() {
        return this.name;
    }

    public static <PAYLOAD> Channel<PAYLOAD> create(String name) {
        return Channel.builder().name(name).build();
    }

    public static <PAYLOAD> Channel<PAYLOAD> create() {
        return Channel.builder().build();
    }

    public static <PAYLOAD> Builder<PAYLOAD> builder() {
        return new Builder();
    }

    public static final class Builder<PAYLOAD>
    implements io.helidon.common.Builder<Channel<PAYLOAD>> {
        private final Channel<PAYLOAD> channel = new Channel();

        public Builder<PAYLOAD> name(String name) {
            this.channel.setName(name);
            return this;
        }

        public Builder<PAYLOAD> publisherConfig(Config config) {
            this.channel.publisherConfig = config;
            return this;
        }

        public Builder<PAYLOAD> subscriberConfig(Config config) {
            this.channel.subscriberConfig = config;
            return this;
        }

        public Channel<PAYLOAD> build() {
            if (this.channel.name == null) {
                this.channel.name = UUID.randomUUID().toString();
            }
            return this.channel;
        }

        public Channel<PAYLOAD> get() {
            return this.channel;
        }
    }
}

