/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.oci.tls.certificates.spi;

import java.security.cert.X509Certificate;
import java.util.Objects;

public interface OciCertificatesDownloader {
    public Certificates loadCertificates(String var1);

    public X509Certificate loadCACertificate(String var1);

    public static Certificates create(String version, X509Certificate[] certificates) {
        if (Objects.requireNonNull(version, "Version is required").isBlank()) {
            throw new IllegalArgumentException();
        }
        return new Certificates(version, Objects.requireNonNull(certificates));
    }

    public static class Certificates {
        private final String version;
        private final X509Certificate[] certificates;

        private Certificates(String version, X509Certificate[] certificates) {
            this.version = version;
            this.certificates = certificates;
        }

        public String version() {
            return this.version;
        }

        public X509Certificate[] certificates() {
            return this.certificates;
        }
    }
}

