/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.oci.tls.certificates;

import io.helidon.common.Errors;
import io.helidon.config.Config;
import io.helidon.integrations.oci.tls.certificates.OciCertificatesTlsManager;
import io.helidon.integrations.oci.tls.certificates.OciCertificatesTlsManagerConfigBlueprint;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public interface OciCertificatesTlsManagerConfig
extends OciCertificatesTlsManagerConfigBlueprint {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(OciCertificatesTlsManagerConfig instance) {
        return (Builder)OciCertificatesTlsManagerConfig.builder().from(instance);
    }

    public static OciCertificatesTlsManagerConfig create(Config config) {
        return ((Builder)OciCertificatesTlsManagerConfig.builder().config(config)).buildPrototype();
    }

    public static OciCertificatesTlsManagerConfig create() {
        return OciCertificatesTlsManagerConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, OciCertificatesTlsManagerConfig>
    implements io.helidon.common.Builder<Builder, OciCertificatesTlsManager> {
        private Builder() {
        }

        public OciCertificatesTlsManagerConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.OciCertificatesTlsManagerConfigImpl(this);
        }

        public OciCertificatesTlsManager build() {
            return OciCertificatesTlsManager.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends OciCertificatesTlsManagerConfig> {
        private Config config;
        private String caOcid;
        private String certOcid;
        private String compartmentOcid;
        private String keyOcid;
        private String schedule;
        private Supplier<char[]> keyPassword;
        private URI vaultCryptoEndpoint;
        private URI vaultManagementEndpoint;

        protected BuilderBase() {
        }

        BUILDER self() {
            return (BUILDER)this;
        }

        public BUILDER from(OciCertificatesTlsManagerConfig prototype) {
            this.schedule(prototype.schedule());
            this.vaultCryptoEndpoint(prototype.vaultCryptoEndpoint());
            this.vaultManagementEndpoint(prototype.vaultManagementEndpoint());
            this.compartmentOcid(prototype.compartmentOcid());
            this.caOcid(prototype.caOcid());
            this.certOcid(prototype.certOcid());
            this.keyOcid(prototype.keyOcid());
            this.keyPassword(prototype.keyPassword());
            return this.self();
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.schedule().ifPresent(this::schedule);
            builder.vaultCryptoEndpoint().ifPresent(this::vaultCryptoEndpoint);
            builder.vaultManagementEndpoint().ifPresent(this::vaultManagementEndpoint);
            builder.compartmentOcid().ifPresent(this::compartmentOcid);
            builder.caOcid().ifPresent(this::caOcid);
            builder.certOcid().ifPresent(this::certOcid);
            builder.keyOcid().ifPresent(this::keyOcid);
            builder.keyPassword().ifPresent(this::keyPassword);
            return this.self();
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("schedule").as(String.class).ifPresent(this::schedule);
            config.get("vault-crypto-endpoint").as(URI.class).ifPresent(this::vaultCryptoEndpoint);
            config.get("vault-management-endpoint").as(URI.class).ifPresent(this::vaultManagementEndpoint);
            config.get("compartment-ocid").as(String.class).ifPresent(this::compartmentOcid);
            config.get("ca-ocid").as(String.class).ifPresent(this::caOcid);
            config.get("cert-ocid").as(String.class).ifPresent(this::certOcid);
            config.get("key-ocid").as(String.class).ifPresent(this::keyOcid);
            this.keyPassword(config.get("key-password").asString().as(String::toCharArray).supplier());
            return this.self();
        }

        public BUILDER schedule(String schedule) {
            Objects.requireNonNull(schedule);
            this.schedule = schedule;
            return this.self();
        }

        public BUILDER vaultCryptoEndpoint(URI vaultCryptoEndpoint) {
            Objects.requireNonNull(vaultCryptoEndpoint);
            this.vaultCryptoEndpoint = vaultCryptoEndpoint;
            return this.self();
        }

        public BUILDER clearVaultManagementEndpoint() {
            this.vaultManagementEndpoint = null;
            return this.self();
        }

        public BUILDER vaultManagementEndpoint(URI vaultManagementEndpoint) {
            Objects.requireNonNull(vaultManagementEndpoint);
            this.vaultManagementEndpoint = vaultManagementEndpoint;
            return this.self();
        }

        public BUILDER clearCompartmentOcid() {
            this.compartmentOcid = null;
            return this.self();
        }

        public BUILDER compartmentOcid(String compartmentOcid) {
            Objects.requireNonNull(compartmentOcid);
            this.compartmentOcid = compartmentOcid;
            return this.self();
        }

        public BUILDER caOcid(String caOcid) {
            Objects.requireNonNull(caOcid);
            this.caOcid = caOcid;
            return this.self();
        }

        public BUILDER certOcid(String certOcid) {
            Objects.requireNonNull(certOcid);
            this.certOcid = certOcid;
            return this.self();
        }

        public BUILDER keyOcid(String keyOcid) {
            Objects.requireNonNull(keyOcid);
            this.keyOcid = keyOcid;
            return this.self();
        }

        public BUILDER keyPassword(Supplier<char[]> keyPassword) {
            Objects.requireNonNull(keyPassword);
            this.keyPassword = keyPassword::get;
            return this.self();
        }

        public BUILDER keyPassword(char[] keyPassword) {
            Objects.requireNonNull(keyPassword);
            this.keyPassword = () -> keyPassword;
            return this.self();
        }

        public BUILDER keyPassword(String keyPassword) {
            Objects.requireNonNull(keyPassword);
            this.keyPassword = () -> keyPassword.toCharArray();
            return this.self();
        }

        public Optional<String> schedule() {
            return Optional.ofNullable(this.schedule);
        }

        public Optional<URI> vaultCryptoEndpoint() {
            return Optional.ofNullable(this.vaultCryptoEndpoint);
        }

        public Optional<URI> vaultManagementEndpoint() {
            return Optional.ofNullable(this.vaultManagementEndpoint);
        }

        public Optional<String> compartmentOcid() {
            return Optional.ofNullable(this.compartmentOcid);
        }

        public Optional<String> caOcid() {
            return Optional.ofNullable(this.caOcid);
        }

        public Optional<String> certOcid() {
            return Optional.ofNullable(this.certOcid);
        }

        public Optional<String> keyOcid() {
            return Optional.ofNullable(this.keyOcid);
        }

        public Optional<Supplier<char[]>> keyPassword() {
            return Optional.ofNullable(this.keyPassword);
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "OciCertificatesTlsManagerConfigBuilder{schedule=" + this.schedule + ",vaultCryptoEndpoint=" + this.vaultCryptoEndpoint + ",vaultManagementEndpoint=" + this.vaultManagementEndpoint + ",compartmentOcid=" + this.compartmentOcid + ",caOcid=" + this.caOcid + ",certOcid=" + this.certOcid + ",keyOcid=" + this.keyOcid + ",keyPassword=" + (this.keyPassword == null ? "null" : "****") + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.schedule == null) {
                collector.fatal(this.getClass(), "Property \"schedule\" must not be null, but not set");
            }
            if (this.vaultCryptoEndpoint == null) {
                collector.fatal(this.getClass(), "Property \"vault-crypto-endpoint\" must not be null, but not set");
            }
            if (this.caOcid == null) {
                collector.fatal(this.getClass(), "Property \"ca-ocid\" must not be null, but not set");
            }
            if (this.certOcid == null) {
                collector.fatal(this.getClass(), "Property \"cert-ocid\" must not be null, but not set");
            }
            if (this.keyOcid == null) {
                collector.fatal(this.getClass(), "Property \"key-ocid\" must not be null, but not set");
            }
            if (this.keyPassword == null) {
                collector.fatal(this.getClass(), "Property \"key-password\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER vaultManagementEndpoint(Optional<? extends URI> vaultManagementEndpoint) {
            Objects.requireNonNull(vaultManagementEndpoint);
            this.vaultManagementEndpoint = vaultManagementEndpoint.orElse(null);
            return this.self();
        }

        BUILDER compartmentOcid(Optional<? extends String> compartmentOcid) {
            Objects.requireNonNull(compartmentOcid);
            this.compartmentOcid = compartmentOcid.orElse(null);
            return this.self();
        }

        protected static class OciCertificatesTlsManagerConfigImpl
        implements OciCertificatesTlsManagerConfig,
        Supplier<OciCertificatesTlsManager> {
            private final Optional<String> compartmentOcid;
            private final Optional<URI> vaultManagementEndpoint;
            private final String caOcid;
            private final String certOcid;
            private final String keyOcid;
            private final String schedule;
            private final Supplier<char[]> keyPassword;
            private final URI vaultCryptoEndpoint;

            protected OciCertificatesTlsManagerConfigImpl(BuilderBase<?, ?> builder) {
                this.schedule = builder.schedule().get();
                this.vaultCryptoEndpoint = builder.vaultCryptoEndpoint().get();
                this.vaultManagementEndpoint = builder.vaultManagementEndpoint();
                this.compartmentOcid = builder.compartmentOcid();
                this.caOcid = builder.caOcid().get();
                this.certOcid = builder.certOcid().get();
                this.keyOcid = builder.keyOcid().get();
                this.keyPassword = builder.keyPassword().get();
            }

            public OciCertificatesTlsManager build() {
                return OciCertificatesTlsManager.create(this);
            }

            @Override
            public OciCertificatesTlsManager get() {
                return this.build();
            }

            @Override
            public String schedule() {
                return this.schedule;
            }

            @Override
            public URI vaultCryptoEndpoint() {
                return this.vaultCryptoEndpoint;
            }

            @Override
            public Optional<URI> vaultManagementEndpoint() {
                return this.vaultManagementEndpoint;
            }

            @Override
            public Optional<String> compartmentOcid() {
                return this.compartmentOcid;
            }

            @Override
            public String caOcid() {
                return this.caOcid;
            }

            @Override
            public String certOcid() {
                return this.certOcid;
            }

            @Override
            public String keyOcid() {
                return this.keyOcid;
            }

            @Override
            public Supplier<char[]> keyPassword() {
                return this.keyPassword;
            }

            public String toString() {
                return "OciCertificatesTlsManagerConfig{schedule=" + this.schedule + ",vaultCryptoEndpoint=" + this.vaultCryptoEndpoint + ",vaultManagementEndpoint=" + this.vaultManagementEndpoint + ",compartmentOcid=" + this.compartmentOcid + ",caOcid=" + this.caOcid + ",certOcid=" + this.certOcid + ",keyOcid=" + this.keyOcid + ",keyPassword=" + (this.keyPassword == null ? "null" : "****") + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OciCertificatesTlsManagerConfig)) {
                    return false;
                }
                OciCertificatesTlsManagerConfig other = (OciCertificatesTlsManagerConfig)o;
                return Objects.equals(this.schedule, other.schedule()) && Objects.equals(this.vaultCryptoEndpoint, other.vaultCryptoEndpoint()) && Objects.equals(this.vaultManagementEndpoint, other.vaultManagementEndpoint()) && Objects.equals(this.compartmentOcid, other.compartmentOcid()) && Objects.equals(this.caOcid, other.caOcid()) && Objects.equals(this.certOcid, other.certOcid()) && Objects.equals(this.keyOcid, other.keyOcid()) && Objects.equals(this.keyPassword, other.keyPassword());
            }

            public int hashCode() {
                return Objects.hash(this.schedule, this.vaultCryptoEndpoint, this.vaultManagementEndpoint, this.compartmentOcid, this.caOcid, this.certOcid, this.keyOcid, this.keyPassword);
            }
        }
    }
}

