/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.oci.tls.certificates;

import io.helidon.common.serviceloader.HelidonServiceLoader;
import jakarta.inject.Provider;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;

class InjectionServices {
    private InjectionServices() {
    }

    static Services realizedServices() {
        return new Services();
    }

    static class Services {
        Services() {
        }

        public <T> Provider<T> lookupFirst(Class<T> serviceProviderType) {
            return this.lookupFirst(serviceProviderType, true).orElseThrow();
        }

        public <T> Optional<Provider<T>> lookupFirst(Class<T> serviceProviderType, boolean expected) {
            List exemplarServices = HelidonServiceLoader.create(ServiceLoader.load(serviceProviderType)).asList();
            if (exemplarServices.isEmpty()) {
                if (expected) {
                    throw new IllegalStateException("Expected to find a service provider of type: " + serviceProviderType);
                }
                return Optional.empty();
            }
            return Optional.of(new SingletonProvider(exemplarServices.get(0)));
        }
    }

    static class SingletonProvider<T>
    implements Provider<T> {
        private final T instance;

        SingletonProvider(T instance) {
            this.instance = instance;
        }

        public T get() {
            return this.instance;
        }
    }
}

