/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.oci.tls.certificates;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.keymanagement.KmsCryptoClient;
import com.oracle.bmc.keymanagement.KmsCryptoClientBuilder;
import com.oracle.bmc.keymanagement.model.ExportKeyDetails;
import com.oracle.bmc.keymanagement.requests.ExportKeyRequest;
import com.oracle.bmc.keymanagement.responses.ExportKeyResponse;
import io.helidon.common.Prioritized;
import io.helidon.integrations.oci.sdk.runtime.OciExtension;
import io.helidon.integrations.oci.tls.certificates.spi.OciPrivateKeyDownloader;
import jakarta.inject.Singleton;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.MGF1ParameterSpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;

@Singleton
public class DefaultOciPrivateKeyDownloader
implements OciPrivateKeyDownloader,
Prioritized {
    private final PrivateKey wrappingPrivateKey;
    private final String wrappingPublicKeyPem;

    @Deprecated
    public DefaultOciPrivateKeyDownloader() {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(2048);
            KeyPair wrappingKeyPair = generator.generateKeyPair();
            this.wrappingPrivateKey = wrappingKeyPair.getPrivate();
            PublicKey wrappingPublicKey = wrappingKeyPair.getPublic();
            String pubBase64 = Base64.getEncoder().encodeToString(wrappingPublicKey.getEncoded());
            this.wrappingPublicKeyPem = "-----BEGIN PUBLIC KEY-----" + pubBase64 + "-----END PUBLIC KEY-----";
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PrivateKey loadKey(String keyOcid, URI vaultCryptoEndpoint) {
        PrivateKey privateKey;
        block8: {
            Objects.requireNonNull(keyOcid);
            Objects.requireNonNull(vaultCryptoEndpoint);
            KmsCryptoClient client = ((KmsCryptoClientBuilder)KmsCryptoClient.builder().endpoint(vaultCryptoEndpoint.toString())).build((AbstractAuthenticationDetailsProvider)OciExtension.ociAuthenticationProvider().get());
            try {
                ExportKeyResponse exportKeyResponse = client.exportKey(ExportKeyRequest.builder().exportKeyDetails(ExportKeyDetails.builder().keyId(keyOcid).publicKey(this.wrappingPublicKeyPem).algorithm(ExportKeyDetails.Algorithm.RsaOaepAesSha256).build()).build());
                String encryptedKey = exportKeyResponse.getExportedKeyData().getEncryptedKey();
                privateKey = this.decode(encryptedKey);
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (GeneralSecurityException e) {
                    throw new IllegalStateException("Problem encountered loading key: " + keyOcid + " from: " + vaultCryptoEndpoint, e);
                }
            }
            client.close();
        }
        return privateKey;
    }

    PrivateKey decode(String encryptedKey) throws GeneralSecurityException {
        byte[] encryptedMaterial = Base64.getDecoder().decode(encryptedKey);
        byte[] tmpAes = this.decryptAesKey(Arrays.copyOf(encryptedMaterial, 256));
        byte[] wrappedSecretKey = Arrays.copyOfRange(encryptedMaterial, 256, encryptedMaterial.length);
        return (PrivateKey)this.unwrapRSA(wrappedSecretKey, tmpAes);
    }

    Key unwrapRSA(byte[] in, byte[] keyBytes) throws GeneralSecurityException {
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        Cipher c = Cipher.getInstance("AESWrapPad");
        c.init(4, key);
        return c.unwrap(in, "RSA", 2);
    }

    byte[] decryptAesKey(byte[] in) throws GeneralSecurityException {
        Cipher decrypt = Cipher.getInstance("RSA/ECB/OAEPWithSHA-256andMGF1Padding");
        decrypt.init(2, (Key)this.wrappingPrivateKey, new OAEPParameterSpec("SHA-256", "MGF1", new MGF1ParameterSpec("SHA-256"), PSource.PSpecified.DEFAULT));
        return decrypt.doFinal(in);
    }

    public int priority() {
        return 5000;
    }
}

