/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.oci.tls.certificates;

import io.helidon.config.Config;
import io.helidon.faulttolerance.Async;
import io.helidon.integrations.oci.tls.certificates.InjectionServices;
import io.helidon.integrations.oci.tls.certificates.LifecycleHook;
import io.helidon.integrations.oci.tls.certificates.OciCertificatesTlsManager;
import io.helidon.integrations.oci.tls.certificates.OciCertificatesTlsManagerConfig;
import io.helidon.integrations.oci.tls.certificates.spi.OciCertificatesDownloader;
import io.helidon.integrations.oci.tls.certificates.spi.OciPrivateKeyDownloader;
import io.helidon.scheduling.Scheduling;
import io.helidon.webserver.ConfiguredTlsManager;
import io.helidon.webserver.WebServerTls;
import jakarta.inject.Provider;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

class DefaultOciCertificatesTlsManager
extends ConfiguredTlsManager
implements OciCertificatesTlsManager {
    static final String TYPE = "oci-certificates-tls-manager";
    private static final System.Logger LOGGER = System.getLogger(DefaultOciCertificatesTlsManager.class.getName());
    private final OciCertificatesTlsManagerConfig cfg;
    private final AtomicReference<String> lastVersionDownloaded = new AtomicReference<String>("");
    private Provider<OciPrivateKeyDownloader> pkDownloader;
    private Provider<OciCertificatesDownloader> certDownloader;
    private ScheduledExecutorService asyncExecutor;
    private Async async;
    private WebServerTls tlsConfig;

    DefaultOciCertificatesTlsManager(OciCertificatesTlsManagerConfig cfg) {
        this(cfg, "@default", null);
    }

    DefaultOciCertificatesTlsManager(OciCertificatesTlsManagerConfig cfg, String name, Config config) {
        super(name, TYPE);
        this.cfg = Objects.requireNonNull(cfg);
        if (config != null) {
            config.onChange(this::config);
        }
    }

    public void init(WebServerTls tls) {
        this.tlsConfig = tls;
        InjectionServices.Services services = InjectionServices.realizedServices();
        this.pkDownloader = services.lookupFirst(OciPrivateKeyDownloader.class);
        this.certDownloader = services.lookupFirst(OciCertificatesDownloader.class);
        this.asyncExecutor = Executors.newSingleThreadScheduledExecutor();
        this.async = Async.builder().executor((ExecutorService)this.asyncExecutor).build();
        this.loadContext(true);
        Optional<Provider<LifecycleHook>> shutdownHook = services.lookupFirst(LifecycleHook.class, false);
        shutdownHook.ifPresent(sp -> ((LifecycleHook)sp.get()).registerShutdownConsumer(this::shutdown));
        String taskIntervalDescription = Scheduling.cronBuilder().executor(this.asyncExecutor).expression(this.cfg.schedule()).task(inv -> this.maybeReload()).build().description();
        LOGGER.log(System.Logger.Level.DEBUG, () -> OciCertificatesTlsManagerConfig.class.getSimpleName() + " scheduled: " + taskIntervalDescription);
    }

    private void shutdown(Object event) {
        try {
            LOGGER.log(System.Logger.Level.DEBUG, "Shutting down");
            this.asyncExecutor.shutdownNow();
        }
        catch (Exception e) {
            LOGGER.log(System.Logger.Level.WARNING, "Shut down failed", (Throwable)e);
        }
    }

    private void maybeReload() {
        if (this.loadContext(false)) {
            LOGGER.log(System.Logger.Level.DEBUG, "Certificates were downloaded and dynamically updated");
        }
    }

    void config(Config config) {
        Objects.requireNonNull(config);
        this.maybeReload();
    }

    boolean loadContext(boolean initialLoad) {
        try {
            TrustManagerFactory tmf;
            OciCertificatesDownloader cd = (OciCertificatesDownloader)this.certDownloader.get();
            OciCertificatesDownloader.Certificates certificates = cd.loadCertificates(this.cfg.certOcid());
            if (this.lastVersionDownloaded.get().equals(certificates.version())) {
                assert (!initialLoad);
                return false;
            }
            X509Certificate ca = cd.loadCACertificate(this.cfg.caOcid());
            OciPrivateKeyDownloader pd = (OciPrivateKeyDownloader)this.pkDownloader.get();
            PrivateKey key = pd.loadKey(this.cfg.keyOcid(), this.cfg.vaultCryptoEndpoint());
            SecureRandom secureRandom = this.secureRandom(this.tlsConfig);
            KeyManagerFactory kmf = this.buildKmf(this.tlsConfig, secureRandom, key, certificates.certificates());
            if (this.tlsConfig.trustAll()) {
                tmf = this.trustAllTmf();
            } else {
                tmf = this.createTmf(this.tlsConfig);
                KeyStore keyStore = this.internalKeystore(this.tlsConfig);
                keyStore.setCertificateEntry("trust-ca", ca);
                tmf.init(keyStore);
            }
            Optional<X509KeyManager> keyManager = Arrays.stream(kmf.getKeyManagers()).filter(m -> m instanceof X509KeyManager).map(X509KeyManager.class::cast).findFirst();
            if (keyManager.isEmpty()) {
                throw new RuntimeException("Unable to find X.509 key manager in download: " + this.cfg.certOcid());
            }
            Optional<X509TrustManager> trustManager = Arrays.stream(tmf.getTrustManagers()).filter(m -> m instanceof X509TrustManager).map(X509TrustManager.class::cast).findFirst();
            if (trustManager.isEmpty()) {
                throw new RuntimeException("Unable to find X.509 trust manager in download: " + this.cfg.certOcid());
            }
            if (initialLoad) {
                this.initSslContext(this.tlsConfig, kmf.getKeyManagers(), tmf.getTrustManagers());
            } else {
                this.reload(this.tlsConfig, kmf.getKeyManagers(), tmf.getTrustManagers());
            }
            return true;
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Error while loading context from OCI", e);
        }
    }

    private KeyManagerFactory buildKmf(WebServerTls target, SecureRandom secureRandom, PrivateKey privateKey, Certificate[] certificates) {
        byte[] passwordBytes = new byte[64];
        secureRandom.nextBytes(passwordBytes);
        char[] password = Base64.getEncoder().encodeToString(passwordBytes).toCharArray();
        try {
            KeyStore ks = this.internalKeystore(target);
            ks.setKeyEntry("key", privateKey, password, certificates);
            KeyManagerFactory kmf = this.kmf(target);
            kmf.init(ks, password);
            return kmf;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new IllegalArgumentException("Invalid configuration for key management factory, cannot create factory", e);
        }
    }

    KeyManagerFactory kmf(WebServerTls tlsConfig) {
        try {
            String algorithm = KeyManagerFactory.getDefaultAlgorithm();
            return KeyManagerFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Invalid configuration of key manager factory.", e);
        }
    }

    private KeyStore internalKeystore(WebServerTls tlsConfig) {
        try {
            String type = KeyStore.getDefaultType();
            KeyStore ks = KeyStore.getInstance(type);
            ks.load(null, null);
            return ks;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException("Invalid configuration of internal keystores", e);
        }
    }
}

