/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.oci.tls.certificates;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.certificates.CertificatesClient;
import com.oracle.bmc.certificates.requests.GetCertificateAuthorityBundleRequest;
import com.oracle.bmc.certificates.requests.GetCertificateBundleRequest;
import com.oracle.bmc.certificates.responses.GetCertificateAuthorityBundleResponse;
import com.oracle.bmc.certificates.responses.GetCertificateBundleResponse;
import io.helidon.common.Prioritized;
import io.helidon.common.pki.PemReader;
import io.helidon.integrations.oci.sdk.runtime.OciExtension;
import io.helidon.integrations.oci.tls.certificates.spi.OciCertificatesDownloader;
import jakarta.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@Singleton
public class DefaultOciCertificatesDownloader
implements OciCertificatesDownloader,
Prioritized {
    @Deprecated
    public DefaultOciCertificatesDownloader() {
    }

    @Override
    public OciCertificatesDownloader.Certificates loadCertificates(String certOcid) {
        Objects.requireNonNull(certOcid);
        try {
            return DefaultOciCertificatesDownloader.loadCerts(certOcid);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Failed to load certificate ocid: " + certOcid, e);
        }
    }

    @Override
    public X509Certificate loadCACertificate(String caCertOcid) {
        Objects.requireNonNull(caCertOcid);
        try {
            return DefaultOciCertificatesDownloader.loadCACert(caCertOcid);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Failed to load ca certificate ocid: " + caCertOcid, e);
        }
    }

    static OciCertificatesDownloader.Certificates loadCerts(String certOcid) {
        try (CertificatesClient client = CertificatesClient.builder().build((AbstractAuthenticationDetailsProvider)OciExtension.ociAuthenticationProvider().get());){
            GetCertificateBundleResponse res = client.getCertificateBundle(GetCertificateBundleRequest.builder().certificateId(certOcid).build());
            ByteArrayInputStream chainIs = new ByteArrayInputStream(res.getCertificateBundle().getCertChainPem().getBytes(StandardCharsets.US_ASCII));
            ByteArrayInputStream certIs = new ByteArrayInputStream(res.getCertificateBundle().getCertificatePem().getBytes(StandardCharsets.US_ASCII));
            Certificate[] certs = DefaultOciCertificatesDownloader.toCertificates(chainIs, certIs);
            String version = DefaultOciCertificatesDownloader.toVersion(res.getEtag(), certs);
            OciCertificatesDownloader.Certificates certificates = OciCertificatesDownloader.create(version, (X509Certificate[])certs);
            return certificates;
        }
    }

    static X509Certificate loadCACert(String caCertOcid) {
        try (CertificatesClient client = CertificatesClient.builder().build((AbstractAuthenticationDetailsProvider)OciExtension.ociAuthenticationProvider().get());){
            GetCertificateAuthorityBundleResponse res = client.getCertificateAuthorityBundle(GetCertificateAuthorityBundleRequest.builder().certificateAuthorityId(caCertOcid).build());
            ByteArrayInputStream certIs = new ByteArrayInputStream(res.getCertificateAuthorityBundle().getCertificatePem().getBytes(StandardCharsets.US_ASCII));
            X509Certificate x509Certificate = DefaultOciCertificatesDownloader.toCertificate(certIs);
            return x509Certificate;
        }
    }

    static X509Certificate[] toCertificates(InputStream chainIs, InputStream certIs) {
        ArrayList chain = new ArrayList();
        chain.addAll(PemReader.readCertificates((InputStream)certIs));
        chain.addAll(PemReader.readCertificates((InputStream)chainIs));
        return chain.toArray(new X509Certificate[0]);
    }

    static X509Certificate toCertificate(InputStream certIs) {
        List certs = PemReader.readCertificates((InputStream)certIs);
        if (certs.size() != 1) {
            throw new IllegalStateException("Expected a single certificate in stream but found: " + certs.size());
        }
        return (X509Certificate)certs.get(0);
    }

    static String toVersion(String eTag, Certificate[] certs) {
        if (eTag != null && !eTag.isBlank()) {
            return eTag;
        }
        return String.valueOf(Arrays.hashCode(certs));
    }

    public int priority() {
        return 5000;
    }
}

