/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.testing;

import io.helidon.common.LazyValue;
import io.helidon.config.Config;
import io.helidon.config.ConfigSources;
import io.helidon.inject.api.Bootstrap;
import io.helidon.inject.api.InjectionServices;
import io.helidon.inject.api.InjectionServicesHolder;
import io.helidon.inject.api.ServiceProvider;
import io.helidon.inject.runtime.ServiceBinderDefault;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@Deprecated(forRemoval=true, since="4.0.8")
public class InjectionTestingSupport {
    private static LazyValue<InjectionServices> instance = InjectionTestingSupport.lazyCreate(InjectionTestingSupport.basicTestableConfig());

    private InjectionTestingSupport() {
    }

    public static void resetAll() {
        Internal.reset();
    }

    public static void bind(InjectionServices injectionServices, ServiceProvider<?> serviceProvider) {
        ServiceBinderDefault binder = ServiceBinderDefault.create((InjectionServices)injectionServices, (String)InjectionTestingSupport.class.getSimpleName(), (boolean)true);
        binder.bind(serviceProvider);
    }

    public static InjectionServices testableServices() {
        return (InjectionServices)instance.get();
    }

    public static InjectionServices testableServices(Config config) {
        return (InjectionServices)InjectionTestingSupport.lazyCreate(config).get();
    }

    public static Config basicTestableConfig() {
        return Config.builder((Supplier[])new Supplier[]{ConfigSources.create(Map.of("inject.permits-dynamic", "true", "inject.service-lookup-caching", "true"), (String)"config-1")}).disableEnvironmentVariablesSource().disableSystemPropertiesSource().build();
    }

    public static String toDescription(Object providerOrInstance) {
        if (providerOrInstance instanceof Optional) {
            providerOrInstance = ((Optional)providerOrInstance).orElse(null);
        }
        if (providerOrInstance instanceof ServiceProvider) {
            return ((ServiceProvider)providerOrInstance).description();
        }
        return String.valueOf(providerOrInstance);
    }

    public static List<String> toDescriptions(Collection<?> coll) {
        return coll.stream().map(InjectionTestingSupport::toDescription).collect(Collectors.toList());
    }

    private static LazyValue<InjectionServices> lazyCreate(Config config) {
        return LazyValue.create(() -> {
            InjectionServices.globalBootstrap((Bootstrap)((Bootstrap.Builder)Bootstrap.builder().config((io.helidon.common.config.Config)config)).build());
            return (InjectionServices)InjectionServices.injectionServices().orElseThrow();
        });
    }

    private static class Internal
    extends InjectionServicesHolder {
        private Internal() {
        }

        public static void reset() {
            InjectionServicesHolder.reset();
            instance = InjectionTestingSupport.lazyCreate(InjectionTestingSupport.basicTestableConfig());
        }
    }
}

