/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.testing;

import io.helidon.common.types.TypeName;
import io.helidon.inject.api.ServiceInfo;
import io.helidon.inject.api.ServiceInfoBasics;
import io.helidon.inject.api.ServiceProvider;
import io.helidon.inject.api.ServiceProviderInjectionException;
import io.helidon.inject.runtime.AbstractServiceProvider;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Objects;

public class ReflectionBasedSingletonServiceProvider<T>
extends AbstractServiceProvider<T> {
    private final Class<T> serviceType;

    private ReflectionBasedSingletonServiceProvider(Class<T> serviceType, ServiceInfo serviceInfo) {
        this.serviceType = serviceType;
        this.serviceInfo(serviceInfo);
    }

    public static <T> ReflectionBasedSingletonServiceProvider<T> create(Class<T> serviceType, ServiceInfoBasics siBasics) {
        Objects.requireNonNull(serviceType);
        Objects.requireNonNull(siBasics);
        if (!TypeName.create(serviceType).equals((Object)siBasics.serviceTypeName())) {
            throw new IllegalArgumentException("Mismatch in service types: " + serviceType.getName());
        }
        return new ReflectionBasedSingletonServiceProvider<T>(serviceType, ServiceInfo.builder((ServiceInfoBasics)siBasics).build());
    }

    public boolean isCustom() {
        return true;
    }

    protected T createServiceProvider(Map<String, Object> deps) {
        try {
            Constructor<T> ctor = this.serviceType.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            return ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ServiceProviderInjectionException("Failed to fully create instance: " + String.valueOf((Object)this), (Throwable)e, (ServiceProvider)this);
        }
    }

    public Class<T> serviceType() {
        return this.serviceType;
    }
}

