/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.processor;

import io.helidon.inject.tools.ToolsException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;

class ProcessingTracker
implements AutoCloseable {
    static final String DEFAULT_SCRATCH_FILE_NAME = "activators.lst";
    private final Path path;
    private final Set<String> allTypeNames;
    private final TypeElementFinder typeElementFinder;
    private final Set<String> foundOrProcessed = new LinkedHashSet<String>();

    ProcessingTracker(Path persistentScratchPath, List<String> allLines, TypeElementFinder typeElementFinder) {
        this.path = persistentScratchPath;
        this.allTypeNames = new LinkedHashSet<String>(allLines);
        this.typeElementFinder = typeElementFinder;
    }

    public static ProcessingTracker initializeFrom(Path persistentScratchPath, ProcessingEnvironment processingEnv) {
        List<String> allLines = List.of();
        File file = persistentScratchPath.toFile();
        if (file.exists() && file.canRead()) {
            try {
                allLines = Files.readAllLines(persistentScratchPath, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new ToolsException(e.getMessage(), (Throwable)e);
            }
        }
        return new ProcessingTracker(persistentScratchPath, allLines, ProcessingTracker.toTypeElementFinder(processingEnv));
    }

    public ProcessingTracker processing(String typeName) {
        this.foundOrProcessed.add(Objects.requireNonNull(typeName));
        return this;
    }

    public Set<String> allTypeNamesFromInitialization() {
        return this.allTypeNames;
    }

    public Set<String> removedTypeNames() {
        LinkedHashSet<String> typeNames = new LinkedHashSet<String>(this.allTypeNamesFromInitialization());
        typeNames.removeAll(this.remainingTypeNames());
        return typeNames;
    }

    public Set<String> remainingTypeNames() {
        LinkedHashSet<String> typeNames = new LinkedHashSet<String>(this.allTypeNamesFromInitialization());
        typeNames.addAll(this.foundOrProcessed);
        typeNames.removeIf(typeName -> !this.found((String)typeName));
        return typeNames;
    }

    @Override
    public void close() throws IOException {
        Path parent = this.path.getParent();
        if (parent == null) {
            throw new ToolsException("bad path: " + String.valueOf(this.path));
        }
        Files.createDirectories(parent, new FileAttribute[0]);
        Files.write(this.path, this.remainingTypeNames(), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private boolean found(String typeName) {
        return this.typeElementFinder.apply(typeName) != null;
    }

    private static TypeElementFinder toTypeElementFinder(ProcessingEnvironment processingEnv) {
        return typeName -> processingEnv.getElementUtils().getTypeElement((CharSequence)typeName);
    }

    @FunctionalInterface
    static interface TypeElementFinder
    extends Function<CharSequence, TypeElement> {
    }
}

