/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.processor;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.inject.processor.ProcessingEventBlueprint;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.inject.processor.ProcessingEventBlueprint")
public interface ProcessingEvent
extends ProcessingEventBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ProcessingEvent instance) {
        return (Builder)ProcessingEvent.builder().from(instance);
    }

    public static ProcessingEvent create() {
        return ProcessingEvent.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, ProcessingEvent>
    implements io.helidon.common.Builder<Builder, ProcessingEvent> {
        private Builder() {
        }

        public ProcessingEvent buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ProcessingEventImpl(this);
        }

        public ProcessingEvent build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ProcessingEvent>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final Set<TypedElementInfo> elementsOfInterest = new LinkedHashSet<TypedElementInfo>();
        private ProcessingEnvironment processingEnvironment;

        protected BuilderBase() {
        }

        public BUILDER from(ProcessingEvent prototype) {
            this.processingEnvironment(prototype.processingEnvironment());
            this.addElementsOfInterest(prototype.elementsOfInterest());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.processingEnvironment().ifPresent(this::processingEnvironment);
            this.addElementsOfInterest(builder.elementsOfInterest());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearProcessingEnvironment() {
            this.processingEnvironment = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER processingEnvironment(ProcessingEnvironment processingEnvironment) {
            Objects.requireNonNull(processingEnvironment);
            this.processingEnvironment = processingEnvironment;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER elementsOfInterest(Set<? extends TypedElementInfo> elementsOfInterest) {
            Objects.requireNonNull(elementsOfInterest);
            this.elementsOfInterest.clear();
            this.elementsOfInterest.addAll(elementsOfInterest);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addElementsOfInterest(Set<? extends TypedElementInfo> elementsOfInterest) {
            Objects.requireNonNull(elementsOfInterest);
            this.elementsOfInterest.addAll(elementsOfInterest);
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<ProcessingEnvironment> processingEnvironment() {
            return Optional.ofNullable(this.processingEnvironment);
        }

        public Set<TypedElementInfo> elementsOfInterest() {
            return this.elementsOfInterest;
        }

        public String toString() {
            return "ProcessingEventBuilder{processingEnvironment=" + String.valueOf(this.processingEnvironment) + ",elementsOfInterest=" + String.valueOf(this.elementsOfInterest) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        BUILDER processingEnvironment(Optional<? extends ProcessingEnvironment> processingEnvironment) {
            Objects.requireNonNull(processingEnvironment);
            this.processingEnvironment = processingEnvironment.orElse(null);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class ProcessingEventImpl
        implements ProcessingEvent {
            private final Optional<ProcessingEnvironment> processingEnvironment;
            private final Set<TypedElementInfo> elementsOfInterest;

            protected ProcessingEventImpl(BuilderBase<?, ?> builder) {
                this.processingEnvironment = builder.processingEnvironment();
                this.elementsOfInterest = Collections.unmodifiableSet(new LinkedHashSet<TypedElementInfo>(builder.elementsOfInterest()));
            }

            @Override
            public Optional<ProcessingEnvironment> processingEnvironment() {
                return this.processingEnvironment;
            }

            @Override
            public Set<TypedElementInfo> elementsOfInterest() {
                return this.elementsOfInterest;
            }

            public String toString() {
                return "ProcessingEvent{processingEnvironment=" + String.valueOf(this.processingEnvironment) + ",elementsOfInterest=" + String.valueOf(this.elementsOfInterest) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ProcessingEvent)) {
                    return false;
                }
                ProcessingEvent other = (ProcessingEvent)o;
                return Objects.equals(this.processingEnvironment, other.processingEnvironment()) && Objects.equals(this.elementsOfInterest, other.elementsOfInterest());
            }

            public int hashCode() {
                return Objects.hash(this.processingEnvironment, this.elementsOfInterest);
            }
        }
    }
}

