/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.processor;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.processor.TypeFactory;
import io.helidon.common.processor.TypeInfoFactory;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.inject.api.Activator;
import io.helidon.inject.api.Contract;
import io.helidon.inject.api.DependenciesInfo;
import io.helidon.inject.api.ElementKind;
import io.helidon.inject.api.ExternalContracts;
import io.helidon.inject.api.Qualifier;
import io.helidon.inject.api.ServiceInfoBasics;
import io.helidon.inject.processor.BaseAnnotationProcessor;
import io.helidon.inject.processor.CreatorHandler;
import io.helidon.inject.processor.GeneralProcessorUtils;
import io.helidon.inject.processor.ProcessingEvent;
import io.helidon.inject.processor.ProcessingTracker;
import io.helidon.inject.processor.spi.InjectionAnnotationProcessorObserver;
import io.helidon.inject.runtime.Dependencies;
import io.helidon.inject.tools.ActivatorCreatorCodeGen;
import io.helidon.inject.tools.ActivatorCreatorConfigOptions;
import io.helidon.inject.tools.ActivatorCreatorDefault;
import io.helidon.inject.tools.ActivatorCreatorRequest;
import io.helidon.inject.tools.ActivatorCreatorResponse;
import io.helidon.inject.tools.CodeGenFiler;
import io.helidon.inject.tools.InterceptorCreatorProvider;
import io.helidon.inject.tools.Messager;
import io.helidon.inject.tools.Options;
import io.helidon.inject.tools.ServicesToProcess;
import io.helidon.inject.tools.ToolsException;
import io.helidon.inject.tools.TypeNames;
import io.helidon.inject.tools.TypeTools;
import io.helidon.inject.tools.spi.ActivatorCreator;
import io.helidon.inject.tools.spi.InterceptorCreator;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public class InjectionAnnotationProcessor
extends BaseAnnotationProcessor {
    private static final Set<String> SUPPORTED_SERVICE_CLASS_TARGET_ANNOTATIONS = Set.of("jakarta.inject.Singleton", "javax.inject.Singleton", "jakarta.enterprise.context.ApplicationScoped", "javax.enterprise.context.ApplicationScoped", "io.helidon.inject.api.ExternalContracts", "io.helidon.inject.api.Intercepted");
    private static final Set<String> SUPPORTED_CONTRACT_CLASS_TARGET_ANNOTATIONS = Set.of("io.helidon.inject.api.Contract");
    private static final Set<String> SUPPORTED_ELEMENT_TARGET_ANNOTATIONS = Set.of("jakarta.inject.Inject", "javax.inject.Inject", "jakarta.annotation.PreDestroy", "jakarta.annotation.PostConstruct", "javax.annotation.PreDestroy", "javax.annotation.PostConstruct");
    private static final Set<TypeName> SERVICE_DEFINING_ANNOTATIONS = Set.of(TypeName.create((String)"jakarta.inject.Singleton"), TypeName.create((String)"jakarta.enterprise.context.ApplicationScoped"));
    private static boolean disableBaseProcessing;
    private final Set<TypeName> alreadyProcessed = new LinkedHashSet<TypeName>();
    private final Set<TypedElementInfo> allElementsOfInterestInThisModule = new LinkedHashSet<TypedElementInfo>();
    private final Map<TypeName, TypeInfo> typeInfoToCreateActivatorsForInThisModule = new LinkedHashMap<TypeName, TypeInfo>();
    private ProcessingTracker tracker;
    private CreatorHandler creator;
    private boolean autoAddInterfaces;

    @Deprecated
    public InjectionAnnotationProcessor() {
    }

    protected InjectionAnnotationProcessor(boolean disableBaseProcessing) {
        if (disableBaseProcessing) {
            InjectionAnnotationProcessor.disableBaseProcessing = true;
        }
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Stream.of(this.supportedServiceClassTargetAnnotations(), this.supportedContractClassTargetAnnotations(), this.supportedElementTargetAnnotations()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.autoAddInterfaces = Options.isOptionEnabled((String)"inject.autoAddNonContractInterfaces");
        this.creator = new CreatorHandler(this.getClass().getSimpleName(), processingEnv, this.utils());
        this.tracker = ProcessingTracker.initializeFrom(this.trackerStatePath(), processingEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Thread thread = Thread.currentThread();
        ClassLoader previousClassloader = thread.getContextClassLoader();
        thread.setContextClassLoader(InjectionAnnotationProcessor.class.getClassLoader());
        try {
            boolean bl = this.doProcess(annotations, roundEnv);
            return bl;
        }
        finally {
            thread.setContextClassLoader(previousClassloader);
        }
    }

    private boolean doProcess(Set<? extends TypeElement> ignoredAnnotations, RoundEnvironment roundEnv) {
        this.utils().roundEnv(roundEnv);
        if (disableBaseProcessing && this.getClass() == InjectionAnnotationProcessor.class) {
            return false;
        }
        ServicesToProcess.onBeginProcessing((Messager)this.utils(), this.getSupportedAnnotationTypes(), (RoundEnvironment)roundEnv);
        try {
            Set<TypedElementInfo> elementsOfInterestInThisRound = this.gatherElementsOfInterestInThisModule();
            this.validate(elementsOfInterestInThisRound);
            this.allElementsOfInterestInThisModule.addAll(elementsOfInterestInThisRound);
            this.gatherTypeInfosToProcessInThisModule(this.typeInfoToCreateActivatorsForInThisModule, this.allElementsOfInterestInThisModule);
            Set<TypeInfo> filtered = new LinkedHashSet<TypeInfo>(this.typeInfoToCreateActivatorsForInThisModule.values());
            filtered = this.interceptAndValidate(filtered);
            ServicesToProcess services = this.toServicesToProcess(filtered, this.allElementsOfInterestInThisModule);
            this.doFiler(services);
            this.notifyObservers();
            if (roundEnv.processingOver()) {
                this.alreadyProcessed.clear();
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable t) {
            ToolsException exc = new ToolsException("Error while processing: " + String.valueOf(t) + " @ " + String.valueOf(GeneralProcessorUtils.rootStackTraceElementOf(t)) + " in " + this.getClass().getSimpleName(), t);
            this.utils().error(exc.getMessage(), t);
            throw exc;
        }
        finally {
            ServicesToProcess.onEndProcessing((Messager)this.utils(), this.getSupportedAnnotationTypes(), (RoundEnvironment)roundEnv);
            if (roundEnv.processingOver()) {
                this.allElementsOfInterestInThisModule.clear();
                this.typeInfoToCreateActivatorsForInThisModule.clear();
            }
            this.utils().roundEnv(null);
        }
    }

    protected ActivatorCreator activatorCreator() {
        return this.creator;
    }

    protected Set<String> supportedServiceClassTargetAnnotations() {
        return SUPPORTED_SERVICE_CLASS_TARGET_ANNOTATIONS;
    }

    protected Set<String> supportedContractClassTargetAnnotations() {
        return SUPPORTED_CONTRACT_CLASS_TARGET_ANNOTATIONS;
    }

    protected Set<String> supportedElementTargetAnnotations() {
        return SUPPORTED_ELEMENT_TARGET_ANNOTATIONS;
    }

    protected void doFiler(ServicesToProcess services) {
        ActivatorCreatorResponse res;
        ActivatorCreatorCodeGen codeGen = ActivatorCreatorDefault.createActivatorCreatorCodeGen((ServicesToProcess)services).orElse(null);
        if (codeGen == null) {
            return;
        }
        boolean processingOver = this.utils().roundEnv().processingOver();
        ActivatorCreatorConfigOptions configOptions = ((ActivatorCreatorConfigOptions.Builder)((ActivatorCreatorConfigOptions.Builder)ActivatorCreatorConfigOptions.builder().applicationPreCreated(Options.isOptionEnabled((String)"inject.application.pre.create"))).moduleCreated(processingOver)).build();
        ActivatorCreatorRequest req = ActivatorCreatorDefault.createActivatorCreatorRequest((ServicesToProcess)services, (ActivatorCreatorCodeGen)codeGen, (ActivatorCreatorConfigOptions)configOptions, (CodeGenFiler)this.creator.filer(), (boolean)false);
        Set allActivatorTypeNames = this.tracker.remainingTypeNames().stream().map(TypeName::create).collect(Collectors.toSet());
        if (!allActivatorTypeNames.isEmpty()) {
            req = ((ActivatorCreatorRequest.Builder)ActivatorCreatorRequest.builder((ActivatorCreatorRequest)req).codeGen(((ActivatorCreatorCodeGen.Builder)ActivatorCreatorCodeGen.builder((ActivatorCreatorCodeGen)req.codeGen()).allModuleActivatorTypeNames(allActivatorTypeNames)).build())).build();
        }
        if ((res = this.creator.createModuleActivators(req)).success()) {
            res.activatorTypeNamesPutInComponentModule().forEach(it -> this.tracker.processing(it.name()));
            if (processingOver) {
                try {
                    this.tracker.close();
                }
                catch (IOException e) {
                    throw new ToolsException(e.getMessage(), (Throwable)e);
                }
            }
        } else {
            ToolsException exc = new ToolsException("Error during codegen", (Throwable)res.error().orElse(null));
            this.utils().error(exc.getMessage(), (Throwable)exc);
            throw exc;
        }
    }

    protected void validate(Collection<TypedElementInfo> elementsOfInterest) {
        this.validatePerClass(elementsOfInterest, "There can be max of one injectable constructor per class", 1, it -> it.elementTypeKind().equals("CONSTRUCTOR") && it.hasAnnotation(TypeNames.JAKARTA_INJECT_TYPE));
        this.validatePerClass(elementsOfInterest, "There can be max of one PostConstruct method per class", 1, it -> it.elementTypeKind().equals("METHOD") && it.hasAnnotation(TypeNames.JAKARTA_POST_CONSTRUCT_TYPE));
        this.validatePerClass(elementsOfInterest, "There can be max of one PreDestroy method per class", 1, it -> it.elementTypeKind().equals("METHOD") && it.hasAnnotation(TypeNames.JAKARTA_PRE_DESTROY_TYPE));
        this.validatePerClass(elementsOfInterest, "Injection does not currently support static or private elements", 0, it -> it.modifiers().contains("private") || it.modifiers().contains("static"));
    }

    protected Set<TypeInfo> interceptAndValidate(Collection<TypeInfo> typesToCreateActivatorsFor) {
        return new LinkedHashSet<TypeInfo>(Objects.requireNonNull(typesToCreateActivatorsFor));
    }

    protected void process(ServicesToProcess services, TypeInfo service, Set<TypeName> serviceTypeNamesToCodeGenerate, Collection<TypedElementInfo> allElementsOfInterest) {
        this.utils().debug("Code generating" + Activator.class.getSimpleName() + " for: " + String.valueOf(service.typeName()));
        this.processBasics(services, service, serviceTypeNamesToCodeGenerate, allElementsOfInterest);
        this.processInterceptors(services, service, serviceTypeNamesToCodeGenerate, allElementsOfInterest);
        this.processExtensions(services, service, serviceTypeNamesToCodeGenerate, allElementsOfInterest);
    }

    protected void processBasics(ServicesToProcess services, TypeInfo service, Set<TypeName> serviceTypeNamesToCodeGenerate, Collection<TypedElementInfo> allElementsOfInterest) {
        TypeName serviceTypeName = service.typeName();
        TypeInfo superTypeInfo = service.superTypeInfo().orElse(null);
        if (superTypeInfo != null) {
            Optional<TypeName> serviceProvider = this.findServiceProviderInHierarchy(superTypeInfo, new HashSet<TypeName>());
            if (serviceProvider.isPresent()) {
                services.addParentServiceType(serviceTypeName, serviceProvider.get());
            } else {
                Optional<TypeName> activatedType = this.findActivatedInHierarchy(superTypeInfo, new HashSet<TypeName>());
                if (activatedType.isPresent()) {
                    TypeName typeName = activatedType.get();
                    services.addParentServiceType(serviceTypeName, ((TypeName.Builder)((TypeName.Builder)TypeName.builder((TypeName)typeName.genericTypeName()).className(typeName.classNameWithEnclosingNames().replace('.', '$') + "$$Injection$$Activator")).enclosingNames(List.of())).build());
                } else {
                    services.addParentServiceType(serviceTypeName, ((TypeName.Builder)TypeName.builder((TypeName)TypeNames.ABSTRACT_SERVICE_PROVIDER_TYPE).addTypeArgument(serviceTypeName)).build());
                }
            }
        }
        Set<String> modifierNames = InjectionAnnotationProcessor.toModifierNames(service.modifiers());
        GeneralProcessorUtils.toRunLevel(service).ifPresent(it -> services.addDeclaredRunLevel(serviceTypeName, it));
        GeneralProcessorUtils.toWeight(service).ifPresent(it -> services.addDeclaredWeight(serviceTypeName, it));
        GeneralProcessorUtils.toScopeNames(service).forEach(it -> services.addScopeTypeName(serviceTypeName, it));
        GeneralProcessorUtils.toPostConstructMethod(service).ifPresent(it -> services.addPostConstructMethod(serviceTypeName, it));
        GeneralProcessorUtils.toPreDestroyMethod(service).ifPresent(it -> services.addPreDestroyMethod(serviceTypeName, it));
        this.toInjectionDependencies(service, allElementsOfInterest).ifPresent(arg_0 -> ((ServicesToProcess)services).addDependencies(arg_0));
        services.addAccessLevel(serviceTypeName, TypeTools.toAccess(modifierNames));
        services.addIsAbstract(serviceTypeName, modifierNames.contains("abstract"));
        services.addServiceTypeHierarchy(serviceTypeName, GeneralProcessorUtils.toServiceTypeHierarchy(service));
        services.addQualifiers(serviceTypeName, GeneralProcessorUtils.toQualifiers(service));
        this.gatherContractsIntoServicesToProcess(services, service);
    }

    protected Set<TypeName> serviceDefiningAnnotations() {
        return SERVICE_DEFINING_ANNOTATIONS;
    }

    protected void processExtensions(ServicesToProcess services, TypeInfo service, Set<TypeName> serviceTypeNamesToCodeGenerate, Collection<TypedElementInfo> allElementsOfInterest) {
    }

    private static void gatherInjectionPoints(Dependencies.BuilderContinuation builder, TypedElementInfo typedElement, TypeInfo service, Set<String> modifierNames) {
        boolean isField;
        String elemName = typedElement.elementName();
        AccessModifier access = TypeTools.toAccess(modifierNames);
        ElementKind elemKind = ElementKind.valueOf((String)typedElement.elementTypeKind());
        boolean bl = isField = elemKind == ElementKind.FIELD;
        if (isField) {
            TypeName typeName = typedElement.typeName();
            boolean isOptional = typeName.isOptional();
            typeName = isOptional ? (TypeName)typeName.typeArguments().get(0) : typeName;
            boolean isList = typeName.isList();
            typeName = isList ? (TypeName)typeName.typeArguments().get(0) : typeName;
            boolean isProviderType = GeneralProcessorUtils.isProviderType(typeName);
            typeName = isProviderType ? (TypeName)typeName.typeArguments().get(0) : typeName;
            Set<Qualifier> qualifiers = GeneralProcessorUtils.toQualifiers(typedElement, service);
            builder.add(service.typeName(), elemName, typeName, elemKind, 0, access).ipName(elemName).ipType(typedElement.typeName()).qualifiers(qualifiers).listWrapped(isList).providerWrapped(isProviderType).optionalWrapped(isOptional);
        } else {
            int elemArgs = typedElement.parameterArguments().size();
            AtomicInteger elemOffset = new AtomicInteger();
            typedElement.parameterArguments().forEach(it -> {
                TypeName typeName = it.typeName();
                boolean isOptional = typeName.isOptional();
                typeName = isOptional ? (TypeName)typeName.typeArguments().get(0) : typeName;
                boolean isList = typeName.isList();
                typeName = isList ? (TypeName)typeName.typeArguments().get(0) : typeName;
                boolean isProviderType = GeneralProcessorUtils.isProviderType(typeName);
                typeName = isProviderType ? (TypeName)typeName.typeArguments().get(0) : typeName;
                int pos = elemOffset.incrementAndGet();
                Set<Qualifier> qualifiers = GeneralProcessorUtils.toQualifiers(it, service);
                builder.add(service.typeName(), elemName, typeName, elemKind, elemArgs, access).ipName(it.elementName()).ipType(it.typeName()).qualifiers(qualifiers).elemOffset(pos).listWrapped(isList).providerWrapped(isProviderType).optionalWrapped(isOptional);
            });
        }
    }

    private static Set<String> toModifierNames(Set<String> names) {
        return names.stream().map(String::toLowerCase).collect(Collectors.toSet());
    }

    private static ServiceLoader<InjectionAnnotationProcessorObserver> observerLoader() {
        try {
            return ServiceLoader.load(InjectionAnnotationProcessorObserver.class, InjectionAnnotationProcessorObserver.class.getClassLoader());
        }
        catch (ServiceConfigurationError e) {
            System.getLogger(InjectionAnnotationProcessorObserver.class.getName()).log(System.Logger.Level.WARNING, e.getMessage(), (Throwable)e);
            return ServiceLoader.load(InjectionAnnotationProcessorObserver.class);
        }
    }

    private Optional<TypeName> findActivatedInHierarchy(TypeInfo superTypeInfo, Set<TypeName> processed) {
        if (!processed.add(superTypeInfo.typeName())) {
            return Optional.empty();
        }
        Set<TypeName> serviceDefining = this.serviceDefiningAnnotations();
        for (Annotation annotation : superTypeInfo.annotations()) {
            if (!serviceDefining.contains(annotation.typeName())) continue;
            return Optional.of(superTypeInfo.typeName());
        }
        Set<String> kindsOfInterest = Set.of("CONSTRUCTOR", "FIELD", "METHOD");
        if (Stream.concat(superTypeInfo.elementInfo().stream(), superTypeInfo.otherElementInfo().stream()).filter(it -> kindsOfInterest.contains(it.elementTypeKind())).anyMatch(it -> it.hasAnnotation(TypeNames.JAKARTA_INJECT_TYPE) || it.hasAnnotation(TypeNames.JAVAX_INJECT_TYPE))) {
            return Optional.of(superTypeInfo.typeName());
        }
        return superTypeInfo.superTypeInfo().flatMap(it -> this.findActivatedInHierarchy((TypeInfo)it, processed));
    }

    private Optional<TypeName> findServiceProviderInHierarchy(TypeInfo superTypeInfo, Set<TypeName> processed) {
        if (!processed.add(superTypeInfo.typeName())) {
            return Optional.empty();
        }
        for (TypeInfo typeInfo : superTypeInfo.interfaceTypeInfo()) {
            Optional<TypeName> maybe = this.findServiceProviderInHierarchy(superTypeInfo, typeInfo, processed);
            if (!maybe.isPresent()) continue;
            return maybe;
        }
        return superTypeInfo.superTypeInfo().flatMap(it -> this.findServiceProviderInHierarchy((TypeInfo)it, processed));
    }

    private Optional<TypeName> findServiceProviderInHierarchy(TypeInfo classInfo, TypeInfo interfaceInfo, Set<TypeName> processed) {
        if (!processed.add(interfaceInfo.typeName())) {
            return Optional.empty();
        }
        if (TypeNames.SERVICE_PROVIDER_TYPE.equals((Object)interfaceInfo.typeName())) {
            return Optional.of(classInfo.typeName());
        }
        for (TypeInfo typeInfo : interfaceInfo.interfaceTypeInfo()) {
            Optional<TypeName> maybe = this.findServiceProviderInHierarchy(classInfo, typeInfo, processed);
            if (!maybe.isPresent()) continue;
            return maybe;
        }
        return Optional.empty();
    }

    private void validatePerClass(Collection<TypedElementInfo> elementsOfInterest, String msg, int maxAllowed, Predicate<TypedElementInfo> matcher) {
        LinkedHashMap allTypeNamesToMatchingElements = new LinkedHashMap();
        elementsOfInterest.stream().filter(matcher).forEach(it -> allTypeNamesToMatchingElements.computeIfAbsent((TypeName)it.enclosingType().orElseThrow(), n -> new ArrayList()).add(it));
        allTypeNamesToMatchingElements.values().stream().filter(list -> list.size() > maxAllowed).forEach(it -> this.utils().error(msg + " for " + String.valueOf(((TypedElementInfo)it.get(0)).enclosingType()), null));
    }

    private void processInterceptors(ServicesToProcess services, TypeInfo service, Set<TypeName> serviceTypeNamesToCodeGenerate, Collection<TypedElementInfo> allElementsOfInterest) {
        ServiceInfoBasics interceptedServiceInfo;
        TypeName serviceTypeName = service.typeName();
        InterceptorCreator interceptorCreator = InterceptorCreatorProvider.instance();
        InterceptorCreator.InterceptorProcessor processor = interceptorCreator.createInterceptorProcessor(interceptedServiceInfo = GeneralProcessorUtils.toBasicServiceInfo(service), interceptorCreator, this.processingEnv);
        Set annotationTypeTriggers = processor.allAnnotationTypeTriggers();
        if (annotationTypeTriggers.isEmpty()) {
            services.addInterceptorPlanFor(serviceTypeName, Optional.empty());
            return;
        }
        Optional plan = processor.createInterceptorPlan(annotationTypeTriggers);
        if (plan.isEmpty()) {
            this.utils().log("unable to produce an interception plan for: " + String.valueOf(serviceTypeName));
        }
        services.addInterceptorPlanFor(serviceTypeName, plan);
    }

    private ServicesToProcess toServicesToProcess(Set<TypeInfo> typesToCodeGenerate, Collection<TypedElementInfo> allElementsOfInterest) {
        ServicesToProcess services = ServicesToProcess.create();
        this.utils().relayModuleInfoToServicesToProcess(services);
        Set typesNamesToCodeGenerate = typesToCodeGenerate.stream().map(rec$ -> ((TypeInfo)rec$).typeName()).collect(Collectors.toSet());
        typesToCodeGenerate.forEach(service -> {
            try {
                this.process(services, (TypeInfo)service, typesNamesToCodeGenerate, allElementsOfInterest);
            }
            catch (Throwable t) {
                throw new ToolsException("Error while processing: " + String.valueOf(service.typeName()), t);
            }
        });
        typesNamesToCodeGenerate.removeAll(this.alreadyProcessed);
        services.generatedServiceTypeNames(typesNamesToCodeGenerate);
        this.alreadyProcessed.addAll(typesNamesToCodeGenerate);
        return services;
    }

    private void gatherContractsIntoServicesToProcess(ServicesToProcess services, TypeInfo service) {
        LinkedHashSet<TypeName> contracts = new LinkedHashSet<TypeName>();
        LinkedHashSet<TypeName> externalContracts = new LinkedHashSet<TypeName>();
        LinkedHashSet<TypeName> providerForSet = new LinkedHashSet<TypeName>();
        LinkedHashSet<String> externalModuleNames = new LinkedHashSet<String>();
        this.gatherContracts(contracts, externalContracts, providerForSet, externalModuleNames, service, false);
        TypeName serviceTypeName = service.typeName();
        contracts.forEach(it -> services.addTypeForContract(serviceTypeName, it, false));
        externalContracts.forEach(it -> services.addTypeForContract(serviceTypeName, it, true));
        services.addProviderFor(serviceTypeName, providerForSet);
        services.addExternalRequiredModules(serviceTypeName, externalModuleNames);
        this.utils().debug(String.valueOf(serviceTypeName) + ": contracts=" + String.valueOf(contracts) + ", providers=" + String.valueOf(providerForSet) + ", externalContracts=" + String.valueOf(externalContracts) + ", externalModuleNames=" + String.valueOf(externalModuleNames));
    }

    private void gatherContracts(Set<TypeName> contracts, Set<TypeName> externalContracts, Set<TypeName> providerForSet, Set<String> externalModuleNamesRequired, TypeInfo typeInfo, boolean isThisTypeEligibleToBeAContract) {
        Annotation externalContractAnno;
        TypeName fqTypeName = typeInfo.typeName();
        TypeName fqProviderTypeName = null;
        if (GeneralProcessorUtils.isProviderType(fqTypeName)) {
            fqProviderTypeName = fqTypeName.genericTypeName();
            fqTypeName = Objects.requireNonNull((TypeName)fqTypeName.typeArguments().get(0), fqTypeName.toString());
        }
        TypeName genericTypeName = fqTypeName.genericTypeName();
        if (isThisTypeEligibleToBeAContract && !genericTypeName.wildcard()) {
            if (fqProviderTypeName != null) {
                if (!fqTypeName.generic()) {
                    providerForSet.add(genericTypeName);
                    this.extractModuleAndContract(contracts, externalContracts, externalModuleNamesRequired, typeInfo, genericTypeName);
                }
                TypeName genericProviderTypeName = fqProviderTypeName.genericTypeName();
                externalContracts.add(genericProviderTypeName);
                this.filterModuleName(typeInfo.moduleNameOf(genericProviderTypeName)).ifPresent(externalModuleNamesRequired::add);
                if (genericProviderTypeName.name().equals("io.helidon.inject.api.InjectionPointProvider")) {
                    TypeName jakartaProviderTypeName = TypeName.create((String)"jakarta.inject.Provider");
                    externalContracts.add(jakartaProviderTypeName);
                    this.filterModuleName(typeInfo.moduleNameOf(jakartaProviderTypeName)).ifPresent(externalModuleNamesRequired::add);
                }
            } else {
                boolean isTypeAContract;
                boolean isTypeAnInterface = typeInfo.typeKind().equals("INTERFACE");
                boolean bl = isTypeAContract = this.autoAddInterfaces || !isTypeAnInterface || Annotations.findFirst(Contract.class, (Collection)typeInfo.annotations()).isPresent();
                if (isTypeAContract) {
                    this.extractModuleAndContract(contracts, externalContracts, externalModuleNamesRequired, typeInfo, genericTypeName);
                }
            }
        }
        if ((externalContractAnno = (Annotation)Annotations.findFirst(ExternalContracts.class, (Collection)typeInfo.annotations()).orElse(null)) != null) {
            List externalContractNames = externalContractAnno.stringValues().orElseGet(List::of);
            for (String externalContractName : externalContractNames) {
                TypeName externalContractTypeName = TypeName.create((String)externalContractName);
                externalContracts.add(externalContractTypeName);
                this.filterModuleName(typeInfo.moduleNameOf(externalContractTypeName)).ifPresent(externalModuleNamesRequired::add);
            }
            List moduleNames = externalContractAnno.stringValues("moduleNames").orElseGet(List::of);
            for (String externalModuleName : moduleNames) {
                if (externalModuleName.isBlank()) continue;
                externalModuleNamesRequired.add(externalModuleName);
            }
        }
        typeInfo.superTypeInfo().ifPresent(it -> this.gatherContracts(contracts, externalContracts, providerForSet, externalModuleNamesRequired, (TypeInfo)it, true));
        typeInfo.interfaceTypeInfo().forEach(it -> this.gatherContracts(contracts, externalContracts, providerForSet, externalModuleNamesRequired, (TypeInfo)it, true));
    }

    private void extractModuleAndContract(Set<TypeName> contracts, Set<TypeName> externalContracts, Set<String> externalModuleNamesRequired, TypeInfo typeInfo, TypeName genericTypeName) {
        Optional<String> moduleName = this.filterModuleName(typeInfo.moduleNameOf(genericTypeName));
        moduleName.ifPresent(externalModuleNamesRequired::add);
        if (moduleName.isPresent() || TypeInfoFactory.isBuiltInJavaType((TypeName)genericTypeName)) {
            externalContracts.add(genericTypeName);
        } else {
            contracts.add(genericTypeName);
        }
    }

    private Optional<String> filterModuleName(Optional<String> moduleName) {
        String name = moduleName.orElse(null);
        if (name != null && (name.startsWith("java.") || name.startsWith("jdk"))) {
            return Optional.empty();
        }
        return moduleName;
    }

    private Optional<DependenciesInfo> toInjectionDependencies(TypeInfo service, Collection<TypedElementInfo> allElementsOfInterest) {
        Dependencies.BuilderContinuation builder = Dependencies.builder((TypeName)service.typeName());
        this.gatherInjectionPoints(builder, service, allElementsOfInterest);
        DependenciesInfo deps = builder.build();
        return deps.serviceInfoDependencies().isEmpty() ? Optional.empty() : Optional.of(deps);
    }

    private void gatherInjectionPoints(Dependencies.BuilderContinuation builder, TypeInfo service, Collection<TypedElementInfo> allElementsOfInterest) {
        List<TypedElementInfo> injectableElementsForThisService = allElementsOfInterest.stream().filter(it -> it.hasAnnotation(TypeNames.JAKARTA_INJECT_TYPE)).filter(it -> service.typeName().equals(it.enclosingType().orElseThrow())).toList();
        injectableElementsForThisService.forEach(elem -> InjectionAnnotationProcessor.gatherInjectionPoints(builder, elem, service, InjectionAnnotationProcessor.toModifierNames(elem.modifiers())));
    }

    private Set<TypedElementInfo> gatherElementsOfInterestInThisModule() {
        LinkedHashSet<TypedElementInfo> result = new LinkedHashSet<TypedElementInfo>();
        Elements elementUtils = this.processingEnv.getElementUtils();
        for (String annoType : this.supportedElementTargetAnnotations()) {
            TypeElement annoTypeElement = elementUtils.getTypeElement(annoType);
            if (annoTypeElement == null) continue;
            Set<? extends Element> typesToProcess = this.utils().roundEnv().getElementsAnnotatedWith(annoTypeElement);
            typesToProcess.forEach(it -> result.add((TypedElementInfo)TypeInfoFactory.createTypedElementInfoFromElement((ProcessingEnvironment)this.processingEnv, (Element)it, (Elements)elementUtils).orElseThrow()));
        }
        return result;
    }

    private void gatherTypeInfosToProcessInThisModule(Map<TypeName, TypeInfo> result, Collection<TypedElementInfo> elementsOfInterest) {
        for (String annoType : this.supportedServiceClassTargetAnnotations()) {
            Elements elements = this.processingEnv.getElementUtils();
            TypeElement annoTypeElement = elements.getTypeElement(annoType);
            if (annoTypeElement == null) continue;
            Set<? extends Element> typesToProcess = this.utils().roundEnv().getElementsAnnotatedWith(annoTypeElement);
            typesToProcess.forEach(it -> {
                TypeName typeName = ((TypeName)TypeFactory.createTypeName((Element)it).orElseThrow()).genericTypeName();
                if (!result.containsKey(typeName)) {
                    TypeElement typeElement = (TypeElement)it;
                    Optional<TypeInfo> typeInfo = this.utils().toTypeInfo(typeElement, elementsOfInterest::contains);
                    typeInfo.ifPresent(it2 -> result.put(typeName, (TypeInfo)it2));
                }
            });
        }
        Set<TypeName> enclosingElementsOfInterest = elementsOfInterest.stream().map(rec$ -> ((TypedElementInfo)rec$).enclosingType()).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        enclosingElementsOfInterest.removeAll(result.keySet());
        Elements elementUtils = this.processingEnv.getElementUtils();
        enclosingElementsOfInterest.forEach(it -> {
            TypeName typeName = it.genericTypeName();
            if (!result.containsKey(typeName)) {
                TypeElement element = Objects.requireNonNull(elementUtils.getTypeElement(it.name()), it.name());
                result.put(this.creator.toActivatorImplTypeName(typeName), this.utils().toTypeInfo(element, elementsOfInterest::contains).orElseThrow());
            }
        });
    }

    private void notifyObservers() {
        List observers = HelidonServiceLoader.create(InjectionAnnotationProcessor.observerLoader()).asList();
        if (!observers.isEmpty()) {
            ProcessingEvent event = ((ProcessingEvent.Builder)((ProcessingEvent.Builder)ProcessingEvent.builder().processingEnvironment(this.processingEnv)).elementsOfInterest(this.allElementsOfInterestInThisModule)).build();
            observers.forEach(it -> it.onProcessingEvent(event));
        }
    }

    private Path trackerStatePath() {
        return CodeGenFiler.scratchClassOutputPath((Path)CodeGenFiler.targetClassOutputPath((Filer)this.processingEnv.getFiler())).resolve("activators.lst");
    }
}

