/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.processor;

import io.helidon.common.processor.TypeFactory;
import io.helidon.common.types.TypeName;
import io.helidon.inject.processor.MessagerToLogAdapter;
import io.helidon.inject.tools.CustomAnnotationTemplateRequest;
import io.helidon.inject.tools.CustomAnnotationTemplateResponse;
import io.helidon.inject.tools.GenericTemplateCreator;
import io.helidon.inject.tools.GenericTemplateCreatorRequest;
import io.helidon.inject.tools.Messager;
import io.helidon.inject.tools.TemplateHelper;
import io.helidon.inject.tools.ToolsException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

class GenericTemplateCreatorDefault
implements GenericTemplateCreator {
    private final Class<?> generator;
    private final Messager messager;

    GenericTemplateCreatorDefault(Class<?> generator) {
        this(generator, new MessagerToLogAdapter(System.getLogger(GenericTemplateCreatorDefault.class.getName())));
    }

    GenericTemplateCreatorDefault(Class<?> generator, Messager messager) {
        this.generator = Objects.requireNonNull(generator);
        this.messager = messager;
    }

    public Optional<CustomAnnotationTemplateResponse> create(GenericTemplateCreatorRequest req) {
        Objects.requireNonNull(req);
        if (!TypeFactory.isFqn((TypeName)req.generatedTypeName())) {
            this.messager.debug("skipping custom template production for: " + String.valueOf(req.generatedTypeName()) + " = " + String.valueOf(req));
            return Optional.empty();
        }
        TemplateHelper templateHelper = TemplateHelper.create();
        Map<String, Object> substitutions = this.gatherSubstitutions(req, templateHelper);
        String javaBody = templateHelper.applySubstitutions(req.template(), substitutions, true);
        return Optional.of(((CustomAnnotationTemplateResponse.Builder)((CustomAnnotationTemplateResponse.Builder)CustomAnnotationTemplateResponse.builder().request(req.customAnnotationTemplateRequest())).putGeneratedSourceCode(req.generatedTypeName(), javaBody)).build());
    }

    CharSequence supplyFromResources(String templateProfile, String templateName) {
        TemplateHelper templateHelper = TemplateHelper.create();
        String template = templateHelper.loadTemplate(templateProfile, templateName);
        if (template == null) {
            ToolsException te = new ToolsException("Unable to find template " + templateProfile + "/" + templateName);
            this.messager.error(te.getMessage(), (Throwable)te);
            throw te;
        }
        return template;
    }

    Map<String, Object> gatherSubstitutions(GenericTemplateCreatorRequest genericRequest, TemplateHelper templateHelper) {
        CustomAnnotationTemplateRequest req = genericRequest.customAnnotationTemplateRequest();
        TypeName generatedTypeName = genericRequest.generatedTypeName();
        HashMap<String, Object> substitutions = new HashMap<String, Object>();
        TypeName generatorType = TypeName.create(this.generator);
        TypeName serviceType = req.serviceInfo().serviceTypeName();
        substitutions.put("generatedSticker", templateHelper.generatedStickerFor(generatorType, serviceType, generatedTypeName));
        substitutions.put("annoTypeName", req.annoTypeName());
        substitutions.put("generatedTypeName", generatedTypeName);
        substitutions.put("packageName", generatedTypeName.packageName());
        substitutions.put("className", generatedTypeName.className());
        substitutions.put("enclosingClassTypeName", req.enclosingTypeInfo().typeName());
        substitutions.put("enclosingAnnotations", req.enclosingTypeInfo().annotations());
        substitutions.put("basicServiceInfo", req.serviceInfo());
        substitutions.put("weight", req.serviceInfo().realizedWeight());
        substitutions.put("runLevel", req.serviceInfo().realizedRunLevel());
        substitutions.put("elementKind", req.targetElement().elementTypeKind());
        substitutions.put("elementName", req.targetElement().elementName());
        substitutions.put("elementAnnotations", req.targetElement().annotations());
        substitutions.put("elementEnclosingTypeName", req.targetElement().typeName());
        substitutions.putAll(genericRequest.overrideProperties());
        return substitutions;
    }
}

