/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.processor;

import io.helidon.common.Weight;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.inject.api.Qualifier;
import io.helidon.inject.api.RunLevel;
import io.helidon.inject.api.ServiceInfo;
import io.helidon.inject.api.ServiceInfoBasics;
import io.helidon.inject.tools.Options;
import io.helidon.inject.tools.TypeNames;
import io.helidon.inject.tools.TypeTools;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class GeneralProcessorUtils {
    private GeneralProcessorUtils() {
    }

    static StackTraceElement rootStackTraceElementOf(Throwable t) {
        while (t.getCause() != null && t.getCause() != t) {
            t = t.getCause();
        }
        return t.getStackTrace()[0];
    }

    static Optional<Path> toPath(URI uri) {
        if (uri.getHost() != null) {
            return Optional.empty();
        }
        return Optional.of(Paths.get(uri));
    }

    static Optional<Integer> toRunLevel(TypeInfo service) {
        Annotation runLevelAnno = Annotations.findFirst(RunLevel.class, (Collection)service.annotations()).orElse(null);
        if (runLevelAnno != null) {
            return Optional.of(Integer.valueOf((String)runLevelAnno.value().orElseThrow()));
        }
        return Optional.empty();
    }

    static Optional<Double> toWeight(TypeInfo service) {
        Annotation weightAnno = Annotations.findFirst(Weight.class, (Collection)service.annotations()).orElse(null);
        if (weightAnno != null) {
            return Optional.of(Double.valueOf((String)weightAnno.value().orElseThrow()));
        }
        return Optional.empty();
    }

    static Optional<String> toPostConstructMethod(TypeInfo service) {
        List<String> postConstructs = service.elementInfo().stream().filter(it -> it.hasAnnotation(TypeNames.JAKARTA_POST_CONSTRUCT_TYPE)).map(rec$ -> ((TypedElementInfo)rec$).elementName()).toList();
        if (postConstructs.size() == 1) {
            return Optional.of(postConstructs.get(0));
        }
        if (postConstructs.size() > 1) {
            throw new IllegalStateException("There can be at most one jakarta.annotation.PostConstruct annotated method per type: " + String.valueOf(service.typeName()));
        }
        return Optional.empty();
    }

    static Optional<String> toPreDestroyMethod(TypeInfo service) {
        List<String> preDestroys = service.elementInfo().stream().filter(it -> it.hasAnnotation(TypeNames.JAKARTA_PRE_DESTROY_TYPE)).map(rec$ -> ((TypedElementInfo)rec$).elementName()).toList();
        if (preDestroys.size() == 1) {
            return Optional.of(preDestroys.get(0));
        }
        if (preDestroys.size() > 1) {
            throw new IllegalStateException("There can be at most one jakarta.annotation.PreDestroy annotated method per type: " + String.valueOf(service.typeName()));
        }
        return Optional.empty();
    }

    static Set<TypeName> toScopeNames(TypeInfo service) {
        boolean hasApplicationScope;
        LinkedHashSet<TypeName> scopeAnnotations = new LinkedHashSet<TypeName>();
        service.referencedTypeNamesToAnnotations().forEach((typeName, listOfAnnotations) -> {
            if (listOfAnnotations.stream().map(rec$ -> ((Annotation)rec$).typeName()).anyMatch(arg_0 -> ((TypeName)TypeNames.JAKARTA_SCOPE_TYPE).equals(arg_0))) {
                scopeAnnotations.add((TypeName)typeName);
            }
        });
        if (Options.isOptionEnabled((String)"inject.mapApplicationToSingletonScope") && (hasApplicationScope = service.hasAnnotation(TypeNames.JAKARTA_APPLICATION_SCOPED_TYPE))) {
            scopeAnnotations.add(TypeNames.JAKARTA_SINGLETON_TYPE);
            scopeAnnotations.add(TypeNames.JAKARTA_APPLICATION_SCOPED_TYPE);
        }
        return scopeAnnotations;
    }

    static List<TypeName> toServiceTypeHierarchy(TypeInfo service) {
        ArrayList<TypeName> result = new ArrayList<TypeName>();
        result.add(service.typeName());
        service.superTypeInfo().ifPresent(it -> result.addAll(GeneralProcessorUtils.toServiceTypeHierarchy(it)));
        return result;
    }

    static Set<Qualifier> toQualifiers(TypeInfo service) {
        LinkedHashSet<Qualifier> result = new LinkedHashSet<Qualifier>();
        for (Annotation anno : service.annotations()) {
            List metaAnnotations = (List)service.referencedTypeNamesToAnnotations().get(anno.typeName());
            Optional<? extends Annotation> qual = GeneralProcessorUtils.findFirst("jakarta.inject.Qualifier", metaAnnotations);
            if (!qual.isPresent()) continue;
            result.add(Qualifier.create((Annotation)anno));
        }
        return result;
    }

    static Set<Qualifier> toQualifiers(TypedElementInfo element, TypeInfo service) {
        LinkedHashSet<Qualifier> result = new LinkedHashSet<Qualifier>();
        for (Annotation anno : element.annotations()) {
            List metaAnnotations = (List)service.referencedTypeNamesToAnnotations().get(anno.typeName());
            Optional<Object> qual = metaAnnotations == null ? Optional.empty() : GeneralProcessorUtils.findFirst("jakarta.inject.Qualifier", metaAnnotations);
            if (!qual.isPresent()) continue;
            result.add(Qualifier.create((Annotation)anno));
        }
        return result;
    }

    public static boolean isProviderType(TypeName typeName) {
        String name = typeName.name();
        return name.equals("jakarta.inject.Provider") || name.equals("javax.inject.Provider") || name.equals("io.helidon.inject.api.InjectionPointProvider") || "io.helidon.inject.api.ServiceProvider".equals(name);
    }

    static boolean hasValue(String val) {
        return val != null && !val.isBlank();
    }

    static Optional<? extends Annotation> findFirst(String annoType, Collection<? extends Annotation> annotations) {
        if (annotations == null) {
            return Optional.empty();
        }
        Optional anno = Annotations.findFirst((String)annoType, annotations);
        if (anno.isPresent()) {
            return anno;
        }
        return Annotations.findFirst((String)TypeTools.oppositeOf((String)annoType), annotations);
    }

    static ServiceInfoBasics toBasicServiceInfo(TypeInfo service) {
        return ((ServiceInfo.Builder)((ServiceInfo.Builder)((ServiceInfo.Builder)((ServiceInfo.Builder)ServiceInfo.builder().serviceTypeName(service.typeName())).update(it -> GeneralProcessorUtils.toWeight(service).ifPresent(arg_0 -> ((ServiceInfo.Builder)it).declaredWeight(arg_0)))).update(it -> GeneralProcessorUtils.toRunLevel(service).ifPresent(arg_0 -> ((ServiceInfo.Builder)it).declaredRunLevel(arg_0)))).scopeTypeNames(GeneralProcessorUtils.toScopeNames(service))).build();
    }
}

