/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.processor;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.processor.TypeFactory;
import io.helidon.common.processor.TypeInfoFactory;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.inject.api.ServiceInfoBasics;
import io.helidon.inject.processor.BaseAnnotationProcessor;
import io.helidon.inject.processor.GeneralProcessorUtils;
import io.helidon.inject.processor.GenericTemplateCreatorDefault;
import io.helidon.inject.tools.AbstractFilerMessager;
import io.helidon.inject.tools.CodeGenFiler;
import io.helidon.inject.tools.CustomAnnotationTemplateRequest;
import io.helidon.inject.tools.CustomAnnotationTemplateResponse;
import io.helidon.inject.tools.CustomAnnotationTemplateResponses;
import io.helidon.inject.tools.GenericTemplateCreator;
import io.helidon.inject.tools.Messager;
import io.helidon.inject.tools.ToolsException;
import io.helidon.inject.tools.TypeTools;
import io.helidon.inject.tools.spi.CustomAnnotationTemplateCreator;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public class CustomAnnotationProcessor
extends BaseAnnotationProcessor {
    private static final Map<TypeName, Set<CustomAnnotationTemplateCreator>> PRODUCERS_BY_ANNOTATION = new ConcurrentHashMap<TypeName, Set<CustomAnnotationTemplateCreator>>();
    private static final Set<String> ALL_ANNO_TYPES_HANDLED = new CopyOnWriteArraySet<String>();
    private static final List<CustomAnnotationTemplateCreator> PRODUCERS = CustomAnnotationProcessor.initialize();
    private static final Set<TypeName> ALREADY_PROCESSED = new CopyOnWriteArraySet<TypeName>();

    @Deprecated
    public CustomAnnotationProcessor() {
    }

    static List<CustomAnnotationTemplateCreator> initialize() {
        List creators = HelidonServiceLoader.create(CustomAnnotationProcessor.loader()).asList();
        creators.forEach(creator -> {
            try {
                Set annoTypes = creator.annoTypes();
                annoTypes.forEach(annoType -> PRODUCERS_BY_ANNOTATION.compute((TypeName)annoType, (k, v) -> {
                    if (v == null) {
                        v = new LinkedHashSet<CustomAnnotationTemplateCreator>();
                    }
                    v.add(creator);
                    return v;
                }));
                ALL_ANNO_TYPES_HANDLED.addAll(annoTypes.stream().map(rec$ -> ((TypeName)rec$).fqName()).toList());
            }
            catch (Throwable t) {
                System.Logger logger = System.getLogger(CustomAnnotationProcessor.class.getName());
                ToolsException te = new ToolsException("Failed to initialize: " + String.valueOf(creator), t);
                logger.log(System.Logger.Level.ERROR, te.getMessage(), (Throwable)te);
                throw te;
            }
        });
        return creators;
    }

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.logger().log(System.Logger.Level.DEBUG, CustomAnnotationTemplateCreator.class.getSimpleName() + "s: " + String.valueOf(PRODUCERS));
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            if (roundEnv.processingOver()) {
                ALREADY_PROCESSED.clear();
            } else {
                for (String annoType : this.getSupportedAnnotationTypes()) {
                    TypeName annoName = TypeName.create((String)annoType);
                    Optional<TypeElement> annoElement = this.toTypeElement(annoName);
                    if (annoElement.isEmpty()) continue;
                    Set<? extends Element> typesToProcess = roundEnv.getElementsAnnotatedWith(annoElement.get());
                    this.doInner(annoName, typesToProcess);
                }
            }
            return false;
        }
        catch (Throwable t) {
            this.utils().error(this.getClass().getSimpleName() + " error during processing; " + String.valueOf(t) + " @ " + String.valueOf(GeneralProcessorUtils.rootStackTraceElementOf(t)), t);
            throw new ToolsException("Error while processing: " + String.valueOf(t) + " @ " + String.valueOf(GeneralProcessorUtils.rootStackTraceElementOf(t)), t);
        }
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Set.copyOf(ALL_ANNO_TYPES_HANDLED);
    }

    Set<CustomAnnotationTemplateCreator> producersForType(TypeName annoTypeName) {
        Set<CustomAnnotationTemplateCreator> set = PRODUCERS_BY_ANNOTATION.get(annoTypeName);
        return set == null ? Set.of() : Set.copyOf(set);
    }

    void doInner(TypeName annoTypeName, Set<? extends Element> typesToProcess) {
        if (typesToProcess.isEmpty()) {
            return;
        }
        Set<CustomAnnotationTemplateCreator> producers = this.producersForType(annoTypeName);
        if (producers.isEmpty()) {
            return;
        }
        for (Element element : typesToProcess) {
            try {
                CustomAnnotationTemplateRequest.Builder req = this.toRequestBuilder(annoTypeName, element);
                if (req == null) continue;
                CustomAnnotationTemplateResponse.Builder res = CustomAnnotationTemplateResponse.builder();
                for (CustomAnnotationTemplateCreator producer : producers) {
                    req.genericTemplateCreator((GenericTemplateCreator)new GenericTemplateCreatorDefault(producer.getClass(), this.utils()));
                    CustomAnnotationTemplateRequest request = req.build();
                    res.request(request);
                    CustomAnnotationTemplateResponse producerResponse = this.process(producer, request);
                    if (producerResponse == null) continue;
                    res = CustomAnnotationTemplateResponses.aggregate((CustomAnnotationTemplateRequest)request, (CustomAnnotationTemplateResponse[])new CustomAnnotationTemplateResponse[]{res.build(), producerResponse});
                }
                CustomAnnotationTemplateResponse response = res.build();
                if (!req.isFilerEnabled()) continue;
                this.doFiler(response);
            }
            catch (Throwable t) {
                throw new ToolsException("Error while processing: " + String.valueOf(typesToProcess) + String.valueOf(t), t);
            }
        }
    }

    void doFiler(CustomAnnotationTemplateResponse response) {
        AbstractFilerMessager filer = AbstractFilerMessager.createAnnotationBasedFiler((ProcessingEnvironment)this.processingEnv, (Messager)this.utils());
        CodeGenFiler codegen = CodeGenFiler.create((AbstractFilerMessager)filer);
        response.generatedSourceCode().forEach((typeName, srcBody) -> {
            if (ALREADY_PROCESSED.add((TypeName)typeName)) {
                codegen.codegenJavaFilerOut(typeName, srcBody);
            }
        });
        response.generatedResources().forEach((typedElementName, resourceBody) -> {
            String fileType = typedElementName.elementName();
            if (!GeneralProcessorUtils.hasValue(fileType)) {
                fileType = ".generated";
            }
            codegen.codegenResourceFilerOut(TypeTools.toFilePath((TypeName)typedElementName.typeName(), (String)fileType), resourceBody);
        });
    }

    CustomAnnotationTemplateResponse process(CustomAnnotationTemplateCreator producer, CustomAnnotationTemplateRequest req) {
        if (producer == null) {
            return null;
        }
        try {
            CustomAnnotationTemplateResponse res = producer.create(req).orElse(null);
            if (res != null && req.isFilerEnabled() && !res.generatedSourceCode().isEmpty()) {
                res.generatedSourceCode().entrySet().forEach(entry -> {
                    TypeFactory.ensureIsFqn((TypeName)((TypeName)entry.getKey()));
                    if (!GeneralProcessorUtils.hasValue((String)entry.getValue())) {
                        throw new ToolsException("Expected to have valid code for: " + String.valueOf(req) + " for " + String.valueOf(entry));
                    }
                });
            }
            return res;
        }
        catch (Throwable t) {
            throw new ToolsException("Failed in producer: " + String.valueOf(producer) + "; " + String.valueOf(t), t);
        }
    }

    CustomAnnotationTemplateRequest.Builder toRequestBuilder(TypeName annoTypeName, Element typeToProcess) {
        TypeElement enclosingClassType = CustomAnnotationProcessor.toEnclosingClassTypeElement(typeToProcess);
        TypeName enclosingClassTypeName = TypeFactory.createTypeName((Element)enclosingClassType).orElse(null);
        if (enclosingClassTypeName == null) {
            return null;
        }
        TypeInfo enclosingClassTypeInfo = this.utils().toTypeInfo(enclosingClassType, typedElement -> true).orElseThrow();
        ServiceInfoBasics siInfo = GeneralProcessorUtils.toBasicServiceInfo(enclosingClassTypeInfo);
        if (siInfo == null) {
            return null;
        }
        Elements elements = this.processingEnv.getElementUtils();
        return (CustomAnnotationTemplateRequest.Builder)((CustomAnnotationTemplateRequest.Builder)((CustomAnnotationTemplateRequest.Builder)((CustomAnnotationTemplateRequest.Builder)((CustomAnnotationTemplateRequest.Builder)((CustomAnnotationTemplateRequest.Builder)((CustomAnnotationTemplateRequest.Builder)((CustomAnnotationTemplateRequest.Builder)CustomAnnotationTemplateRequest.builder().isFilerEnabled(true)).annoTypeName(annoTypeName)).serviceInfo(siInfo)).targetElement((TypedElementInfo)TypeInfoFactory.createTypedElementInfoFromElement((ProcessingEnvironment)this.processingEnv, (Element)typeToProcess, (Elements)elements).orElseThrow())).enclosingTypeInfo(enclosingClassTypeInfo)).targetElementArgs(this.toArgs(typeToProcess))).targetElementAccess(TypeTools.toAccess((Element)typeToProcess))).isElementStatic(TypeTools.isStatic((Element)typeToProcess));
    }

    List<TypedElementInfo> toArgs(Element typeToProcess) {
        if (!(typeToProcess instanceof ExecutableElement)) {
            return List.of();
        }
        ExecutableElement executableElement = (ExecutableElement)typeToProcess;
        Elements elements = this.processingEnv.getElementUtils();
        ArrayList<TypedElementInfo> result = new ArrayList<TypedElementInfo>();
        executableElement.getParameters().forEach(v -> result.add((TypedElementInfo)TypeInfoFactory.createTypedElementInfoFromElement((ProcessingEnvironment)this.processingEnv, (Element)v, (Elements)elements).orElseThrow()));
        return result;
    }

    private static ServiceLoader<CustomAnnotationTemplateCreator> loader() {
        try {
            return ServiceLoader.load(CustomAnnotationTemplateCreator.class, CustomAnnotationTemplateCreator.class.getClassLoader());
        }
        catch (ServiceConfigurationError e) {
            System.getLogger(CustomAnnotationProcessor.class.getName()).log(System.Logger.Level.WARNING, e.getMessage(), (Throwable)e);
            return ServiceLoader.load(CustomAnnotationTemplateCreator.class);
        }
    }

    private static TypeElement toEnclosingClassTypeElement(Element typeToProcess) {
        while (typeToProcess != null && !(typeToProcess instanceof TypeElement)) {
            typeToProcess = typeToProcess.getEnclosingElement();
        }
        return typeToProcess == null ? null : (TypeElement)typeToProcess;
    }
}

