/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.processor;

import io.helidon.common.types.TypeName;
import io.helidon.inject.tools.AbstractFilerMessager;
import io.helidon.inject.tools.ActivatorCreatorProvider;
import io.helidon.inject.tools.ActivatorCreatorRequest;
import io.helidon.inject.tools.ActivatorCreatorResponse;
import io.helidon.inject.tools.CodeGenFiler;
import io.helidon.inject.tools.CodeGenInterceptorRequest;
import io.helidon.inject.tools.InterceptorCreatorResponse;
import io.helidon.inject.tools.Messager;
import io.helidon.inject.tools.spi.ActivatorCreator;
import java.util.Objects;
import javax.annotation.processing.ProcessingEnvironment;

class CreatorHandler
implements ActivatorCreator {
    private final String name;
    private final CodeGenFiler filer;
    private final Messager messager;

    CreatorHandler(String name, ProcessingEnvironment processingEnv, Messager messager) {
        this.name = Objects.requireNonNull(name);
        this.filer = CodeGenFiler.create((AbstractFilerMessager)AbstractFilerMessager.createAnnotationBasedFiler((ProcessingEnvironment)processingEnv, (Messager)messager));
        this.messager = Objects.requireNonNull(messager);
    }

    public ActivatorCreatorResponse createModuleActivators(ActivatorCreatorRequest request) {
        this.messager.debug(this.name + ": createModuleActivators: " + String.valueOf(request));
        return ActivatorCreatorProvider.instance().createModuleActivators(request);
    }

    public InterceptorCreatorResponse codegenInterceptors(CodeGenInterceptorRequest request) {
        this.messager.debug(this.name + ": codegenInterceptors(): " + String.valueOf(request));
        return ActivatorCreatorProvider.instance().codegenInterceptors(request);
    }

    public TypeName toActivatorImplTypeName(TypeName activatorTypeName) {
        return ActivatorCreatorProvider.instance().toActivatorImplTypeName(activatorTypeName);
    }

    CodeGenFiler filer() {
        return this.filer;
    }
}

