/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.processor;

import io.helidon.common.types.TypeName;
import io.helidon.inject.processor.ActiveProcessorUtils;
import io.helidon.inject.tools.Options;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

abstract class BaseAnnotationProcessor
extends AbstractProcessor {
    private static final AtomicBoolean LOGGED_WARNING = new AtomicBoolean();
    private final System.Logger logger = System.getLogger(this.getClass().getName());
    private ActiveProcessorUtils utils;

    @Deprecated
    protected BaseAnnotationProcessor() {
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        this.utils = new ActiveProcessorUtils(this, processingEnv);
        super.init(processingEnv);
        if (!Options.isOptionEnabled((String)"inject.acceptPreview") && LOGGED_WARNING.compareAndSet(false, true)) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Helidon Inject is preview feature, and the API and SPI may be modified in a future revision. It is considered a production feature. This warning can be disabled by compiler argument -Ainject.acceptPreview=true");
        }
    }

    @Override
    public abstract Set<String> getSupportedAnnotationTypes();

    System.Logger logger() {
        return this.logger;
    }

    ActiveProcessorUtils utils() {
        return Objects.requireNonNull(this.utils);
    }

    Optional<TypeElement> toTypeElement(TypeName typeName) {
        return Optional.ofNullable(this.processingEnv.getElementUtils().getTypeElement(typeName.resolvedName()));
    }
}

