/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.processor;

import io.helidon.common.processor.TypeInfoFactory;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.inject.processor.GeneralProcessorUtils;
import io.helidon.inject.tools.Messager;
import io.helidon.inject.tools.ModuleInfoDescriptor;
import io.helidon.inject.tools.ModuleInfoOrdering;
import io.helidon.inject.tools.ModuleUtils;
import io.helidon.inject.tools.Options;
import io.helidon.inject.tools.ServicesToProcess;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

final class ActiveProcessorUtils
implements Messager {
    static final boolean MAYBE_ANNOTATIONS_CLAIMED_BY_THIS_PROCESSOR = false;
    static final String TARGET_DIR = "/target/";
    static final String SRC_MAIN_JAVA_DIR = "/src/main/java";
    private final System.Logger logger;
    private final ProcessingEnvironment processingEnv;
    private RoundEnvironment roundEnv;

    ActiveProcessorUtils(AbstractProcessor processor, ProcessingEnvironment processingEnv) {
        this.logger = System.getLogger(processor.getClass().getName());
        this.processingEnv = Objects.requireNonNull(processingEnv);
        Options.init((ProcessingEnvironment)processingEnv);
        this.debug("*** Processing " + processor.getClass().getSimpleName() + " ***");
    }

    public void debug(String message, Throwable t) {
        if (Options.isOptionEnabled((String)"inject.debug")) {
            this.out(System.Logger.Level.DEBUG, Diagnostic.Kind.OTHER, message, t);
        }
    }

    public void debug(String message) {
        if (Options.isOptionEnabled((String)"inject.debug")) {
            this.out(System.Logger.Level.DEBUG, Diagnostic.Kind.OTHER, message, null);
        }
    }

    public void log(String message) {
        if (Options.isOptionEnabled((String)"inject.debug")) {
            this.out(System.Logger.Level.INFO, Diagnostic.Kind.NOTE, message, null);
        }
    }

    public void warn(String message, Throwable t) {
        this.out(System.Logger.Level.WARNING, Diagnostic.Kind.WARNING, message, t);
    }

    public void warn(String message) {
        this.out(System.Logger.Level.WARNING, Diagnostic.Kind.WARNING, message, null);
    }

    public void error(String message, Throwable t) {
        this.out(System.Logger.Level.ERROR, Diagnostic.Kind.ERROR, message, null);
    }

    void out(System.Logger.Level level, Diagnostic.Kind kind, String message, Throwable t) {
        if (this.logger.isLoggable(level)) {
            this.logger.log(level, this.getClass().getSimpleName() + ": " + message, t);
        }
        if (this.processingEnv != null && this.processingEnv.getMessager() != null) {
            this.processingEnv.getMessager().printMessage(kind, message);
        }
    }

    Optional<ModuleInfoDescriptor> thisModuleDescriptor(AtomicReference<String> typeSuffix, AtomicReference<File> moduleInfoFile, AtomicReference<File> srcPath) {
        return this.tryFindModuleInfoTheConventionalWay(StandardLocation.SOURCE_OUTPUT, typeSuffix, moduleInfoFile, srcPath).or(() -> this.tryFindModuleInfoTheConventionalWay(StandardLocation.SOURCE_PATH, typeSuffix, moduleInfoFile, srcPath)).or(() -> this.tryFindModuleInfoTheUnconventionalWayFromSourceMain(moduleInfoFile, srcPath));
    }

    void relayModuleInfoToServicesToProcess(ServicesToProcess servicesToProcess) {
        AtomicReference<String> typeSuffix = new AtomicReference<String>();
        AtomicReference<File> moduleInfoFile = new AtomicReference<File>();
        AtomicReference<File> srcPath = new AtomicReference<File>();
        ModuleInfoDescriptor thisModuleDescriptor = this.thisModuleDescriptor(typeSuffix, moduleInfoFile, srcPath).orElse(null);
        if (thisModuleDescriptor != null) {
            servicesToProcess.lastKnownModuleInfoDescriptor(thisModuleDescriptor);
        } else {
            String thisModuleName = Options.getOption((String)"modulename").orElse(null);
            if (thisModuleName == null) {
                servicesToProcess.clearModuleName();
            } else {
                servicesToProcess.moduleName(thisModuleName);
            }
        }
        if (typeSuffix.get() != null) {
            servicesToProcess.lastKnownTypeSuffix(typeSuffix.get());
        }
        if (srcPath.get() != null) {
            servicesToProcess.lastKnownSourcePathBeingProcessed(srcPath.get().toPath());
        }
        if (moduleInfoFile.get() != null) {
            servicesToProcess.lastKnownModuleInfoFilePath(moduleInfoFile.get().toPath());
        }
    }

    Optional<TypeInfo> toTypeInfo(TypeElement element, Predicate<TypedElementInfo> isOneWeCareAbout) {
        return TypeInfoFactory.create((ProcessingEnvironment)this.processingEnv, (TypeElement)element, isOneWeCareAbout);
    }

    System.Logger.Level loggerLevel() {
        return Options.isOptionEnabled((String)"inject.debug") ? System.Logger.Level.INFO : System.Logger.Level.DEBUG;
    }

    RoundEnvironment roundEnv() {
        return this.roundEnv;
    }

    void roundEnv(RoundEnvironment roundEnv) {
        this.roundEnv = roundEnv;
    }

    private Optional<ModuleInfoDescriptor> tryFindModuleInfoTheUnconventionalWayFromSourceMain(AtomicReference<File> moduleInfoFile, AtomicReference<File> srcPath) {
        block4: {
            if (srcPath != null && srcPath.get() != null && srcPath.get().getPath().contains(TARGET_DIR)) {
                String path = srcPath.get().getPath();
                int pos = path.indexOf(TARGET_DIR);
                File srcRoot = new File(path = path.substring(0, pos), SRC_MAIN_JAVA_DIR);
                File file = new File(srcRoot, "module-info.java");
                if (file.exists()) {
                    try {
                        return Optional.of(ModuleInfoDescriptor.create((Path)file.toPath(), (ModuleInfoOrdering)ModuleInfoOrdering.NATURAL_PRESERVE_COMMENTS));
                    }
                    catch (Exception e) {
                        this.debug("unable to read source module-info.java from: " + String.valueOf(srcRoot) + "; " + e.getMessage(), e);
                        if (moduleInfoFile == null) break block4;
                        moduleInfoFile.set(file);
                    }
                }
            }
        }
        this.debug("unable to find module-info.java from: " + String.valueOf(srcPath));
        return Optional.empty();
    }

    private Optional<ModuleInfoDescriptor> tryFindModuleInfoTheConventionalWay(StandardLocation location, AtomicReference<String> typeSuffix, AtomicReference<File> moduleInfoFile, AtomicReference<File> srcPath) {
        Filer filer = this.processingEnv.getFiler();
        try {
            FileObject f = filer.getResource(location, "", "module-info.java");
            URI uri = f.toUri();
            Path filePath = GeneralProcessorUtils.toPath(uri).orElse(null);
            if (filePath != null) {
                Path parent = filePath.getParent();
                if (srcPath != null) {
                    srcPath.set(parent.toFile());
                }
                if (typeSuffix != null) {
                    String type = ModuleUtils.inferSourceOrTest((Path)parent);
                    typeSuffix.set(type);
                }
                if (filePath.toFile().exists()) {
                    if (moduleInfoFile != null) {
                        moduleInfoFile.set(filePath.toFile());
                    }
                    return Optional.of(ModuleInfoDescriptor.create((Path)filePath));
                }
            }
        }
        catch (Exception e) {
            this.debug("unable to retrieve " + String.valueOf(location) + " from filer: " + e.getMessage());
        }
        return Optional.empty();
    }
}

