/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.types.TypeName;
import io.helidon.inject.api.Qualifier;
import io.helidon.inject.api.ServiceInfoCriteriaBlueprint;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.inject.api.ServiceInfoCriteriaBlueprint")
public interface ServiceInfoCriteria
extends ServiceInfoCriteriaBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ServiceInfoCriteria instance) {
        return (Builder)ServiceInfoCriteria.builder().from(instance);
    }

    public static ServiceInfoCriteria create() {
        return ServiceInfoCriteria.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, ServiceInfoCriteria>
    implements io.helidon.common.Builder<Builder, ServiceInfoCriteria> {
        private Builder() {
        }

        public ServiceInfoCriteria buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ServiceInfoCriteriaImpl(this);
        }

        public ServiceInfoCriteria build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ServiceInfoCriteria>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final Set<Qualifier> qualifiers = new LinkedHashSet<Qualifier>();
        private final Set<TypeName> contractsImplemented = new LinkedHashSet<TypeName>();
        private final Set<TypeName> externalContractsImplemented = new LinkedHashSet<TypeName>();
        private final Set<TypeName> scopeTypeNames = new LinkedHashSet<TypeName>();
        private boolean includeIntercepted = false;
        private Double weight;
        private Integer runLevel;
        private String moduleName;
        private TypeName activatorTypeName;
        private TypeName serviceTypeName;

        protected BuilderBase() {
        }

        public BUILDER from(ServiceInfoCriteria prototype) {
            this.serviceTypeName(prototype.serviceTypeName());
            this.addScopeTypeNames(prototype.scopeTypeNames());
            this.addQualifiers(prototype.qualifiers());
            this.addContractsImplemented(prototype.contractsImplemented());
            this.runLevel(prototype.runLevel());
            this.weight(prototype.weight());
            this.addExternalContractsImplemented(prototype.externalContractsImplemented());
            this.activatorTypeName(prototype.activatorTypeName());
            this.moduleName(prototype.moduleName());
            this.includeIntercepted(prototype.includeIntercepted());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.serviceTypeName().ifPresent(this::serviceTypeName);
            this.addScopeTypeNames(builder.scopeTypeNames());
            this.addQualifiers(builder.qualifiers());
            this.addContractsImplemented(builder.contractsImplemented());
            builder.runLevel().ifPresent(this::runLevel);
            builder.weight().ifPresent(this::weight);
            this.addExternalContractsImplemented(builder.externalContractsImplemented());
            builder.activatorTypeName().ifPresent(this::activatorTypeName);
            builder.moduleName().ifPresent(this::moduleName);
            this.includeIntercepted(builder.includeIntercepted());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addContractImplemented(Class<?> contract) {
            ServiceInfoCriteriaBlueprint.CustomMethods.addContractImplemented(this, contract);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearServiceTypeName() {
            this.serviceTypeName = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceTypeName(TypeName serviceTypeName) {
            Objects.requireNonNull(serviceTypeName);
            this.serviceTypeName = serviceTypeName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceTypeName(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.serviceTypeName(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER scopeTypeNames(Set<? extends TypeName> scopeTypeNames) {
            Objects.requireNonNull(scopeTypeNames);
            this.scopeTypeNames.clear();
            this.scopeTypeNames.addAll(scopeTypeNames);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addScopeTypeNames(Set<? extends TypeName> scopeTypeNames) {
            Objects.requireNonNull(scopeTypeNames);
            this.scopeTypeNames.addAll(scopeTypeNames);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addScopeTypeName(TypeName scopeTypeName) {
            Objects.requireNonNull(scopeTypeName);
            this.scopeTypeNames.add(scopeTypeName);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addScopeTypeName(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.scopeTypeNames.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER qualifiers(Set<? extends Qualifier> qualifiers) {
            Objects.requireNonNull(qualifiers);
            this.qualifiers.clear();
            this.qualifiers.addAll(qualifiers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addQualifiers(Set<? extends Qualifier> qualifiers) {
            Objects.requireNonNull(qualifiers);
            this.qualifiers.addAll(qualifiers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addQualifier(Qualifier qualifier) {
            Objects.requireNonNull(qualifier);
            this.qualifiers.add(qualifier);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addQualifier(Consumer<Qualifier.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Qualifier.Builder builder = Qualifier.builder();
            consumer.accept(builder);
            this.qualifiers.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER contractsImplemented(Set<? extends TypeName> contractsImplemented) {
            Objects.requireNonNull(contractsImplemented);
            this.contractsImplemented.clear();
            this.contractsImplemented.addAll(contractsImplemented);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addContractsImplemented(Set<? extends TypeName> contractsImplemented) {
            Objects.requireNonNull(contractsImplemented);
            this.contractsImplemented.addAll(contractsImplemented);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addContractImplemented(TypeName contractImplemented) {
            Objects.requireNonNull(contractImplemented);
            this.contractsImplemented.add(contractImplemented);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addContractImplemented(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.contractsImplemented.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearRunLevel() {
            this.runLevel = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER runLevel(int runLevel) {
            Objects.requireNonNull(runLevel);
            this.runLevel = runLevel;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearWeight() {
            this.weight = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER weight(double weight) {
            Objects.requireNonNull(weight);
            this.weight = weight;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER externalContractsImplemented(Set<? extends TypeName> externalContractsImplemented) {
            Objects.requireNonNull(externalContractsImplemented);
            this.externalContractsImplemented.clear();
            this.externalContractsImplemented.addAll(externalContractsImplemented);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addExternalContractsImplemented(Set<? extends TypeName> externalContractsImplemented) {
            Objects.requireNonNull(externalContractsImplemented);
            this.externalContractsImplemented.addAll(externalContractsImplemented);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addExternalContractImplemented(TypeName externalContractImplemented) {
            Objects.requireNonNull(externalContractImplemented);
            this.externalContractsImplemented.add(externalContractImplemented);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addExternalContractImplemented(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.externalContractsImplemented.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearActivatorTypeName() {
            this.activatorTypeName = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER activatorTypeName(TypeName activatorTypeName) {
            Objects.requireNonNull(activatorTypeName);
            this.activatorTypeName = activatorTypeName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER activatorTypeName(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.activatorTypeName(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearModuleName() {
            this.moduleName = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER moduleName(String moduleName) {
            Objects.requireNonNull(moduleName);
            this.moduleName = moduleName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER includeIntercepted(boolean includeIntercepted) {
            this.includeIntercepted = includeIntercepted;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<TypeName> serviceTypeName() {
            return Optional.ofNullable(this.serviceTypeName);
        }

        public Set<TypeName> scopeTypeNames() {
            return this.scopeTypeNames;
        }

        public Set<Qualifier> qualifiers() {
            return this.qualifiers;
        }

        public Set<TypeName> contractsImplemented() {
            return this.contractsImplemented;
        }

        public Optional<Integer> runLevel() {
            return Optional.ofNullable(this.runLevel);
        }

        public Optional<Double> weight() {
            return Optional.ofNullable(this.weight);
        }

        public Set<TypeName> externalContractsImplemented() {
            return this.externalContractsImplemented;
        }

        public Optional<TypeName> activatorTypeName() {
            return Optional.ofNullable(this.activatorTypeName);
        }

        public Optional<String> moduleName() {
            return Optional.ofNullable(this.moduleName);
        }

        public boolean includeIntercepted() {
            return this.includeIntercepted;
        }

        public String toString() {
            return "ServiceInfoCriteriaBuilder{serviceTypeName=" + String.valueOf(this.serviceTypeName) + ",scopeTypeNames=" + String.valueOf(this.scopeTypeNames) + ",qualifiers=" + String.valueOf(this.qualifiers) + ",contractsImplemented=" + String.valueOf(this.contractsImplemented) + ",runLevel=" + this.runLevel + ",weight=" + this.weight + ",externalContractsImplemented=" + String.valueOf(this.externalContractsImplemented) + ",activatorTypeName=" + String.valueOf(this.activatorTypeName) + ",moduleName=" + this.moduleName + ",includeIntercepted=" + this.includeIntercepted + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        BUILDER serviceTypeName(Optional<? extends TypeName> serviceTypeName) {
            Objects.requireNonNull(serviceTypeName);
            this.serviceTypeName = serviceTypeName.map(TypeName.class::cast).orElse(this.serviceTypeName);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER runLevel(Optional<Integer> runLevel) {
            Objects.requireNonNull(runLevel);
            this.runLevel = runLevel.map(Integer.class::cast).orElse(this.runLevel);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER weight(Optional<Double> weight) {
            Objects.requireNonNull(weight);
            this.weight = weight.map(Double.class::cast).orElse(this.weight);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER activatorTypeName(Optional<? extends TypeName> activatorTypeName) {
            Objects.requireNonNull(activatorTypeName);
            this.activatorTypeName = activatorTypeName.map(TypeName.class::cast).orElse(this.activatorTypeName);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER moduleName(Optional<String> moduleName) {
            Objects.requireNonNull(moduleName);
            this.moduleName = moduleName.map(String.class::cast).orElse(this.moduleName);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class ServiceInfoCriteriaImpl
        implements ServiceInfoCriteria {
            private final boolean includeIntercepted;
            private final Optional<TypeName> activatorTypeName;
            private final Optional<TypeName> serviceTypeName;
            private final Optional<Double> weight;
            private final Optional<Integer> runLevel;
            private final Optional<String> moduleName;
            private final Set<Qualifier> qualifiers;
            private final Set<TypeName> contractsImplemented;
            private final Set<TypeName> externalContractsImplemented;
            private final Set<TypeName> scopeTypeNames;

            protected ServiceInfoCriteriaImpl(BuilderBase<?, ?> builder) {
                this.serviceTypeName = builder.serviceTypeName();
                this.scopeTypeNames = Collections.unmodifiableSet(new LinkedHashSet<TypeName>(builder.scopeTypeNames()));
                this.qualifiers = Collections.unmodifiableSet(new LinkedHashSet<Qualifier>(builder.qualifiers()));
                this.contractsImplemented = Collections.unmodifiableSet(new LinkedHashSet<TypeName>(builder.contractsImplemented()));
                this.runLevel = builder.runLevel();
                this.weight = builder.weight();
                this.externalContractsImplemented = Collections.unmodifiableSet(new LinkedHashSet<TypeName>(builder.externalContractsImplemented()));
                this.activatorTypeName = builder.activatorTypeName();
                this.moduleName = builder.moduleName();
                this.includeIntercepted = builder.includeIntercepted();
            }

            @Override
            public Optional<TypeName> serviceTypeName() {
                return this.serviceTypeName;
            }

            @Override
            public Set<TypeName> scopeTypeNames() {
                return this.scopeTypeNames;
            }

            @Override
            public Set<Qualifier> qualifiers() {
                return this.qualifiers;
            }

            @Override
            public Set<TypeName> contractsImplemented() {
                return this.contractsImplemented;
            }

            @Override
            public Optional<Integer> runLevel() {
                return this.runLevel;
            }

            @Override
            public Optional<Double> weight() {
                return this.weight;
            }

            @Override
            public Set<TypeName> externalContractsImplemented() {
                return this.externalContractsImplemented;
            }

            @Override
            public Optional<TypeName> activatorTypeName() {
                return this.activatorTypeName;
            }

            @Override
            public Optional<String> moduleName() {
                return this.moduleName;
            }

            @Override
            public boolean includeIntercepted() {
                return this.includeIntercepted;
            }

            public String toString() {
                return "ServiceInfoCriteria{serviceTypeName=" + String.valueOf(this.serviceTypeName) + ",scopeTypeNames=" + String.valueOf(this.scopeTypeNames) + ",qualifiers=" + String.valueOf(this.qualifiers) + ",contractsImplemented=" + String.valueOf(this.contractsImplemented) + ",runLevel=" + String.valueOf(this.runLevel) + ",weight=" + String.valueOf(this.weight) + ",externalContractsImplemented=" + String.valueOf(this.externalContractsImplemented) + ",activatorTypeName=" + String.valueOf(this.activatorTypeName) + ",moduleName=" + String.valueOf(this.moduleName) + ",includeIntercepted=" + this.includeIntercepted + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ServiceInfoCriteria)) {
                    return false;
                }
                ServiceInfoCriteria other = (ServiceInfoCriteria)o;
                return Objects.equals(this.serviceTypeName, other.serviceTypeName()) && Objects.equals(this.scopeTypeNames, other.scopeTypeNames()) && Objects.equals(this.qualifiers, other.qualifiers()) && Objects.equals(this.contractsImplemented, other.contractsImplemented()) && Objects.equals(this.runLevel, other.runLevel()) && Objects.equals(this.weight, other.weight()) && Objects.equals(this.externalContractsImplemented, other.externalContractsImplemented()) && Objects.equals(this.activatorTypeName, other.activatorTypeName()) && Objects.equals(this.moduleName, other.moduleName()) && this.includeIntercepted == other.includeIntercepted();
            }

            public int hashCode() {
                return Objects.hash(this.serviceTypeName, this.scopeTypeNames, this.qualifiers, this.contractsImplemented, this.runLevel, this.weight, this.externalContractsImplemented, this.activatorTypeName, this.moduleName, this.includeIntercepted);
            }
        }
    }
}

