/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.inject.api.Bootstrap;
import io.helidon.inject.api.CallingContext;
import io.helidon.inject.api.InternalBootstrapBlueprint;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.inject.api.InternalBootstrapBlueprint")
public interface InternalBootstrap
extends InternalBootstrapBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(InternalBootstrap instance) {
        return (Builder)InternalBootstrap.builder().from(instance);
    }

    public static InternalBootstrap create() {
        return InternalBootstrap.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, InternalBootstrap>
    implements io.helidon.common.Builder<Builder, InternalBootstrap> {
        private Builder() {
        }

        public InternalBootstrap buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.InternalBootstrapImpl(this);
        }

        public InternalBootstrap build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends InternalBootstrap>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private Bootstrap bootStrap;
        private CallingContext callingContext;

        protected BuilderBase() {
        }

        public BUILDER from(InternalBootstrap prototype) {
            this.bootStrap(prototype.bootStrap());
            this.callingContext(prototype.callingContext());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.bootStrap().ifPresent(this::bootStrap);
            builder.callingContext().ifPresent(this::callingContext);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearBootStrap() {
            this.bootStrap = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER bootStrap(Bootstrap bootStrap) {
            Objects.requireNonNull(bootStrap);
            this.bootStrap = bootStrap;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER bootStrap(Consumer<Bootstrap.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Bootstrap.Builder builder = Bootstrap.builder();
            consumer.accept(builder);
            this.bootStrap(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearCallingContext() {
            this.callingContext = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER callingContext(CallingContext callingContext) {
            Objects.requireNonNull(callingContext);
            this.callingContext = callingContext;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER callingContext(Consumer<CallingContext.Builder> consumer) {
            Objects.requireNonNull(consumer);
            CallingContext.Builder builder = CallingContext.builder();
            consumer.accept(builder);
            this.callingContext(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<Bootstrap> bootStrap() {
            return Optional.ofNullable(this.bootStrap);
        }

        public Optional<CallingContext> callingContext() {
            return Optional.ofNullable(this.callingContext);
        }

        public String toString() {
            return "InternalBootstrapBuilder{bootStrap=" + String.valueOf(this.bootStrap) + ",callingContext=" + String.valueOf(this.callingContext) + "}";
        }

        protected void preBuildPrototype() {
            new InternalBootstrapBlueprint.BuilderDecorator().decorate(this);
        }

        protected void validatePrototype() {
        }

        BUILDER bootStrap(Optional<? extends Bootstrap> bootStrap) {
            Objects.requireNonNull(bootStrap);
            this.bootStrap = bootStrap.map(Bootstrap.class::cast).orElse(this.bootStrap);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER callingContext(Optional<? extends CallingContext> callingContext) {
            Objects.requireNonNull(callingContext);
            this.callingContext = callingContext.map(CallingContext.class::cast).orElse(this.callingContext);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class InternalBootstrapImpl
        implements InternalBootstrap {
            private final Optional<Bootstrap> bootStrap;
            private final Optional<CallingContext> callingContext;

            protected InternalBootstrapImpl(BuilderBase<?, ?> builder) {
                this.bootStrap = builder.bootStrap();
                this.callingContext = builder.callingContext();
            }

            @Override
            public Optional<Bootstrap> bootStrap() {
                return this.bootStrap;
            }

            @Override
            public Optional<CallingContext> callingContext() {
                return this.callingContext;
            }

            public String toString() {
                return "InternalBootstrap{bootStrap=" + String.valueOf(this.bootStrap) + ",callingContext=" + String.valueOf(this.callingContext) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InternalBootstrap)) {
                    return false;
                }
                InternalBootstrap other = (InternalBootstrap)o;
                return Objects.equals(this.bootStrap, other.bootStrap()) && Objects.equals(this.callingContext, other.callingContext());
            }

            public int hashCode() {
                return Objects.hash(this.bootStrap, this.callingContext);
            }
        }
    }
}

