/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.inject.api.CallingContextBlueprint;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.inject.api.CallingContextBlueprint")
public interface CallingContext
extends CallingContextBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CallingContext instance) {
        return (Builder)CallingContext.builder().from(instance);
    }

    public static CallingContext create() {
        return CallingContext.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, CallingContext>
    implements io.helidon.common.Builder<Builder, CallingContext> {
        private Builder() {
        }

        public CallingContext buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.CallingContextImpl(this);
        }

        public CallingContext build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends CallingContext>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private StackTraceElement[] stackTrace;
        private String moduleName;
        private String threadName;

        protected BuilderBase() {
        }

        public BUILDER from(CallingContext prototype) {
            this.stackTrace(prototype.stackTrace());
            this.moduleName(prototype.moduleName());
            this.threadName(prototype.threadName());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.stackTrace().ifPresent(this::stackTrace);
            builder.moduleName().ifPresent(this::moduleName);
            builder.threadName().ifPresent(this::threadName);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearStackTrace() {
            this.stackTrace = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER stackTrace(StackTraceElement[] stackTrace) {
            Objects.requireNonNull(stackTrace);
            this.stackTrace = stackTrace;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearModuleName() {
            this.moduleName = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER moduleName(String moduleName) {
            Objects.requireNonNull(moduleName);
            this.moduleName = moduleName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER threadName(String threadName) {
            Objects.requireNonNull(threadName);
            this.threadName = threadName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<StackTraceElement[]> stackTrace() {
            return Optional.ofNullable(this.stackTrace);
        }

        public Optional<String> moduleName() {
            return Optional.ofNullable(this.moduleName);
        }

        public Optional<String> threadName() {
            return Optional.ofNullable(this.threadName);
        }

        public String toString() {
            return "CallingContextBuilder{stackTrace=" + String.valueOf(this.stackTrace) + ",moduleName=" + this.moduleName + ",threadName=" + this.threadName + "}";
        }

        protected void preBuildPrototype() {
            new CallingContextBlueprint.BuilderDecorator().decorate(this);
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.threadName == null) {
                collector.fatal(this.getClass(), "Property \"threadName\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER stackTrace(Optional<StackTraceElement[]> stackTrace) {
            Objects.requireNonNull(stackTrace);
            this.stackTrace = stackTrace.map(StackTraceElement[].class::cast).orElse(this.stackTrace);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER moduleName(Optional<String> moduleName) {
            Objects.requireNonNull(moduleName);
            this.moduleName = moduleName.map(String.class::cast).orElse(this.moduleName);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class CallingContextImpl
        implements CallingContext {
            private final Optional<StackTraceElement[]> stackTrace;
            private final Optional<String> moduleName;
            private final String threadName;

            protected CallingContextImpl(BuilderBase<?, ?> builder) {
                this.stackTrace = builder.stackTrace();
                this.moduleName = builder.moduleName();
                this.threadName = builder.threadName().get();
            }

            @Override
            public Optional<StackTraceElement[]> stackTrace() {
                return this.stackTrace;
            }

            @Override
            public Optional<String> moduleName() {
                return this.moduleName;
            }

            @Override
            public String threadName() {
                return this.threadName;
            }

            public String toString() {
                return "CallingContext{stackTrace=" + String.valueOf(this.stackTrace) + ",moduleName=" + String.valueOf(this.moduleName) + ",threadName=" + this.threadName + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CallingContext)) {
                    return false;
                }
                CallingContext other = (CallingContext)o;
                return Objects.equals(this.stackTrace, other.stackTrace()) && Objects.equals(this.moduleName, other.moduleName()) && Objects.equals(this.threadName, other.threadName());
            }

            public int hashCode() {
                return Objects.hash(this.stackTrace, this.moduleName, this.threadName);
            }
        }
    }
}

