/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.builder.api.Prototype;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.inject.api.ActivationStatus;
import io.helidon.inject.api.Phase;
import io.helidon.inject.api.ServiceProvider;
import io.helidon.inject.spi.InjectionPlan;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;

@Prototype.Blueprint
interface ActivationResultBlueprint {
    public ServiceProvider<?> serviceProvider();

    public Optional<Future<ActivationResultBlueprint>> finishedActivationResult();

    @ConfiguredOption(value="INIT")
    public Phase startingActivationPhase();

    @ConfiguredOption(value="INIT")
    public Phase targetActivationPhase();

    public Phase finishingActivationPhase();

    public Optional<ActivationStatus> finishingStatus();

    public Map<String, InjectionPlan> injectionPlans();

    public Map<String, Object> resolvedDependencies();

    @ConfiguredOption(value="false")
    public boolean wasResolved();

    public Optional<Throwable> error();

    default public boolean finished() {
        Future f = this.finishedActivationResult().orElse(null);
        return f == null || f.isDone();
    }

    default public boolean success() {
        return this.finishingStatus().orElse(null) != ActivationStatus.FAILURE;
    }

    default public boolean failure() {
        return !this.success();
    }
}

