/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.spi;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.inject.api.InjectionPointInfo;
import io.helidon.inject.api.ServiceProvider;
import io.helidon.inject.spi.InjectionPlanBlueprint;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.inject.spi.InjectionPlanBlueprint")
public interface InjectionPlan
extends InjectionPlanBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(InjectionPlan instance) {
        return (Builder)InjectionPlan.builder().from(instance);
    }

    public static InjectionPlan create() {
        return InjectionPlan.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, InjectionPlan>
    implements io.helidon.common.Builder<Builder, InjectionPlan> {
        private Builder() {
        }

        public InjectionPlan buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.InjectionPlanImpl(this);
        }

        public InjectionPlan build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends InjectionPlan>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final List<ServiceProvider<?>> injectionPointQualifiedServiceProviders = new ArrayList();
        private boolean wasResolved = false;
        private InjectionPointInfo injectionPointInfo;
        private Object resolved;
        private ServiceProvider<?> serviceProvider;

        protected BuilderBase() {
        }

        public BUILDER from(InjectionPlan prototype) {
            this.serviceProvider(prototype.serviceProvider());
            this.injectionPointInfo(prototype.injectionPointInfo());
            this.addInjectionPointQualifiedServiceProviders(prototype.injectionPointQualifiedServiceProviders());
            this.wasResolved(prototype.wasResolved());
            this.resolved(prototype.resolved());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.serviceProvider().ifPresent(this::serviceProvider);
            builder.injectionPointInfo().ifPresent(this::injectionPointInfo);
            this.addInjectionPointQualifiedServiceProviders(builder.injectionPointQualifiedServiceProviders());
            this.wasResolved(builder.wasResolved());
            builder.resolved().ifPresent(this::resolved);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceProvider(ServiceProvider<?> serviceProvider) {
            Objects.requireNonNull(serviceProvider);
            this.serviceProvider = serviceProvider;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER injectionPointInfo(InjectionPointInfo injectionPointInfo) {
            Objects.requireNonNull(injectionPointInfo);
            this.injectionPointInfo = injectionPointInfo;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER injectionPointInfo(Consumer<InjectionPointInfo.Builder> consumer) {
            Objects.requireNonNull(consumer);
            InjectionPointInfo.Builder builder = InjectionPointInfo.builder();
            consumer.accept(builder);
            this.injectionPointInfo(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER injectionPointInfo(Supplier<? extends InjectionPointInfo> supplier) {
            Objects.requireNonNull(supplier);
            this.injectionPointInfo(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER injectionPointQualifiedServiceProviders(List<ServiceProvider<?>> injectionPointQualifiedServiceProviders) {
            Objects.requireNonNull(injectionPointQualifiedServiceProviders);
            this.injectionPointQualifiedServiceProviders.clear();
            this.injectionPointQualifiedServiceProviders.addAll(injectionPointQualifiedServiceProviders);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInjectionPointQualifiedServiceProviders(List<ServiceProvider<?>> injectionPointQualifiedServiceProviders) {
            Objects.requireNonNull(injectionPointQualifiedServiceProviders);
            this.injectionPointQualifiedServiceProviders.addAll(injectionPointQualifiedServiceProviders);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInjectionPointQualifiedServiceProvider(ServiceProvider<?> injectionPointQualifiedServiceProvider) {
            Objects.requireNonNull(injectionPointQualifiedServiceProvider);
            this.injectionPointQualifiedServiceProviders.add(injectionPointQualifiedServiceProvider);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER wasResolved(boolean wasResolved) {
            this.wasResolved = wasResolved;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearResolved() {
            this.resolved = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER resolved(Object resolved) {
            Objects.requireNonNull(resolved);
            this.resolved = resolved;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<ServiceProvider<?>> serviceProvider() {
            return Optional.ofNullable(this.serviceProvider);
        }

        public Optional<InjectionPointInfo> injectionPointInfo() {
            return Optional.ofNullable(this.injectionPointInfo);
        }

        public List<ServiceProvider<?>> injectionPointQualifiedServiceProviders() {
            return this.injectionPointQualifiedServiceProviders;
        }

        public boolean wasResolved() {
            return this.wasResolved;
        }

        public Optional<Object> resolved() {
            return Optional.ofNullable(this.resolved);
        }

        public String toString() {
            return "InjectionPlanBuilder{serviceProvider=" + String.valueOf(this.serviceProvider) + ",injectionPointInfo=" + String.valueOf(this.injectionPointInfo) + ",injectionPointQualifiedServiceProviders=" + String.valueOf(this.injectionPointQualifiedServiceProviders) + ",wasResolved=" + this.wasResolved + ",resolved=" + String.valueOf(this.resolved) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.serviceProvider == null) {
                collector.fatal(this.getClass(), "Property \"serviceProvider\" must not be null, but not set");
            }
            if (this.injectionPointInfo == null) {
                collector.fatal(this.getClass(), "Property \"injectionPointInfo\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER resolved(Optional<?> resolved) {
            Objects.requireNonNull(resolved);
            this.resolved = resolved.map(Object.class::cast).orElse(this.resolved);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class InjectionPlanImpl
        implements InjectionPlan {
            private final boolean wasResolved;
            private final InjectionPointInfo injectionPointInfo;
            private final List<ServiceProvider<?>> injectionPointQualifiedServiceProviders;
            private final Optional<Object> resolved;
            private final ServiceProvider<?> serviceProvider;

            protected InjectionPlanImpl(BuilderBase<?, ?> builder) {
                this.serviceProvider = builder.serviceProvider().get();
                this.injectionPointInfo = builder.injectionPointInfo().get();
                this.injectionPointQualifiedServiceProviders = List.copyOf(builder.injectionPointQualifiedServiceProviders());
                this.wasResolved = builder.wasResolved();
                this.resolved = builder.resolved();
            }

            @Override
            public ServiceProvider<?> serviceProvider() {
                return this.serviceProvider;
            }

            @Override
            public InjectionPointInfo injectionPointInfo() {
                return this.injectionPointInfo;
            }

            @Override
            public List<ServiceProvider<?>> injectionPointQualifiedServiceProviders() {
                return this.injectionPointQualifiedServiceProviders;
            }

            @Override
            public boolean wasResolved() {
                return this.wasResolved;
            }

            @Override
            public Optional<Object> resolved() {
                return this.resolved;
            }

            public String toString() {
                return "InjectionPlan{serviceProvider=" + String.valueOf(this.serviceProvider) + ",injectionPointInfo=" + String.valueOf(this.injectionPointInfo) + ",injectionPointQualifiedServiceProviders=" + String.valueOf(this.injectionPointQualifiedServiceProviders) + ",wasResolved=" + this.wasResolved + ",resolved=" + String.valueOf(this.resolved) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InjectionPlan)) {
                    return false;
                }
                InjectionPlan other = (InjectionPlan)o;
                return Objects.equals(this.serviceProvider, other.serviceProvider()) && Objects.equals(this.injectionPointInfo, other.injectionPointInfo()) && Objects.equals(this.injectionPointQualifiedServiceProviders, other.injectionPointQualifiedServiceProviders()) && this.wasResolved == other.wasResolved() && Objects.equals(this.resolved, other.resolved());
            }

            public int hashCode() {
                return Objects.hash(this.serviceProvider, this.injectionPointInfo, this.injectionPointQualifiedServiceProviders, this.wasResolved, this.resolved);
            }
        }
    }
}

