/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.common.types.TypeName;
import io.helidon.inject.api.InjectionServices;
import io.helidon.inject.api.Qualifiers;
import io.helidon.inject.api.ServiceInfo;
import io.helidon.inject.api.ServiceInfoBasics;
import io.helidon.inject.api.ServiceInfoBasicsBlueprint;
import io.helidon.inject.api.ServiceInfoBuildDecorator;
import io.helidon.inject.api.ServiceInfoCriteria;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Prototype.Blueprint(decorator=ServiceInfoBuildDecorator.class)
@Prototype.CustomMethods(value=CustomMethods.class)
interface ServiceInfoBlueprint
extends ServiceInfoBasicsBlueprint,
ServiceInfoBasics {
    @Option.Singular(value="externalContractImplemented")
    public Set<TypeName> externalContractsImplemented();

    public Optional<TypeName> activatorTypeName();

    public Optional<String> moduleName();

    default public boolean matches(ServiceInfoCriteria criteria) {
        if (criteria == InjectionServices.EMPTY_CRITERIA) {
            return true;
        }
        boolean matches = ServiceInfoBlueprint.matches(this.serviceTypeName(), criteria.serviceTypeName());
        if (matches && criteria.serviceTypeName().isEmpty()) {
            matches = this.contractsImplemented().containsAll(criteria.contractsImplemented()) || criteria.contractsImplemented().contains(this.serviceTypeName());
        }
        return matches && this.scopeTypeNames().containsAll(criteria.scopeTypeNames()) && Qualifiers.matchesQualifiers(this.qualifiers(), criteria.qualifiers()) && ServiceInfoBlueprint.matches(this.activatorTypeName(), criteria.activatorTypeName()) && ServiceInfoBlueprint.matchesWeight(this, criteria) && ServiceInfoBlueprint.matches(this.realizedRunLevel(), criteria.runLevel()) && ServiceInfoBlueprint.matches(this.moduleName(), criteria.moduleName());
    }

    private static boolean matches(Object src, Optional<?> criteria) {
        if (criteria.isEmpty()) {
            return true;
        }
        return Objects.equals(src, criteria.get());
    }

    private static boolean matchesWeight(ServiceInfoBasics src, ServiceInfoCriteria criteria) {
        if (criteria.weight().isEmpty()) {
            return true;
        }
        Double srcWeight = src.realizedWeight();
        return srcWeight.compareTo(criteria.weight().get()) <= 0;
    }

    public static final class CustomMethods {
        private CustomMethods() {
        }

        @Prototype.FactoryMethod
        static ServiceInfo.Builder builder(ServiceInfoBasics prototype) {
            Objects.requireNonNull(prototype);
            if (prototype instanceof ServiceInfo) {
                ServiceInfo serviceInfo = (ServiceInfo)prototype;
                return ServiceInfo.builder(serviceInfo);
            }
            return (ServiceInfo.Builder)((ServiceInfo.Builder)((ServiceInfo.Builder)((ServiceInfo.Builder)((ServiceInfo.Builder)((ServiceInfo.Builder)ServiceInfo.builder().serviceTypeName(prototype.serviceTypeName())).scopeTypeNames(prototype.scopeTypeNames())).qualifiers(prototype.qualifiers())).contractsImplemented(prototype.contractsImplemented())).declaredRunLevel(prototype.declaredRunLevel())).declaredWeight(prototype.declaredWeight());
        }

        @Prototype.BuilderMethod
        static void addExternalContractImplemented(ServiceInfo.BuilderBase<?, ?> builder, Class<?> type) {
            builder.addExternalContractImplemented(TypeName.create(type));
        }

        @Prototype.BuilderMethod
        static void activatorTypeName(ServiceInfo.BuilderBase<?, ?> builder, Class<?> type) {
            builder.activatorTypeName(TypeName.create(type));
        }

        @Prototype.BuilderMethod
        static void addScopeTypeName(ServiceInfo.BuilderBase<?, ?> builder, Class<?> type) {
            builder.addScopeTypeName(TypeName.create(type));
        }
    }
}

