/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.inject.api.MetricsBlueprint;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.inject.api.MetricsBlueprint")
public interface Metrics
extends MetricsBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Metrics instance) {
        return (Builder)Metrics.builder().from(instance);
    }

    public static Metrics create() {
        return Metrics.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, Metrics>
    implements io.helidon.common.Builder<Builder, Metrics> {
        private Builder() {
        }

        public Metrics buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.MetricsImpl(this);
        }

        public Metrics build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends Metrics>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private Integer cacheHitCount;
        private Integer cacheLookupCount;
        private Integer lookupCount;
        private Integer serviceCount;

        protected BuilderBase() {
        }

        public BUILDER from(Metrics prototype) {
            this.serviceCount(prototype.serviceCount());
            this.lookupCount(prototype.lookupCount());
            this.cacheLookupCount(prototype.cacheLookupCount());
            this.cacheHitCount(prototype.cacheHitCount());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.serviceCount().ifPresent(this::serviceCount);
            builder.lookupCount().ifPresent(this::lookupCount);
            builder.cacheLookupCount().ifPresent(this::cacheLookupCount);
            builder.cacheHitCount().ifPresent(this::cacheHitCount);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearServiceCount() {
            this.serviceCount = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceCount(int serviceCount) {
            Objects.requireNonNull(serviceCount);
            this.serviceCount = serviceCount;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearLookupCount() {
            this.lookupCount = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER lookupCount(int lookupCount) {
            Objects.requireNonNull(lookupCount);
            this.lookupCount = lookupCount;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearCacheLookupCount() {
            this.cacheLookupCount = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER cacheLookupCount(int cacheLookupCount) {
            Objects.requireNonNull(cacheLookupCount);
            this.cacheLookupCount = cacheLookupCount;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearCacheHitCount() {
            this.cacheHitCount = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER cacheHitCount(int cacheHitCount) {
            Objects.requireNonNull(cacheHitCount);
            this.cacheHitCount = cacheHitCount;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<Integer> serviceCount() {
            return Optional.ofNullable(this.serviceCount);
        }

        public Optional<Integer> lookupCount() {
            return Optional.ofNullable(this.lookupCount);
        }

        public Optional<Integer> cacheLookupCount() {
            return Optional.ofNullable(this.cacheLookupCount);
        }

        public Optional<Integer> cacheHitCount() {
            return Optional.ofNullable(this.cacheHitCount);
        }

        public String toString() {
            return "MetricsBuilder{serviceCount=" + this.serviceCount + ",lookupCount=" + this.lookupCount + ",cacheLookupCount=" + this.cacheLookupCount + ",cacheHitCount=" + this.cacheHitCount + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        BUILDER serviceCount(Optional<Integer> serviceCount) {
            Objects.requireNonNull(serviceCount);
            this.serviceCount = serviceCount.map(Integer.class::cast).orElse(this.serviceCount);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER lookupCount(Optional<Integer> lookupCount) {
            Objects.requireNonNull(lookupCount);
            this.lookupCount = lookupCount.map(Integer.class::cast).orElse(this.lookupCount);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER cacheLookupCount(Optional<Integer> cacheLookupCount) {
            Objects.requireNonNull(cacheLookupCount);
            this.cacheLookupCount = cacheLookupCount.map(Integer.class::cast).orElse(this.cacheLookupCount);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER cacheHitCount(Optional<Integer> cacheHitCount) {
            Objects.requireNonNull(cacheHitCount);
            this.cacheHitCount = cacheHitCount.map(Integer.class::cast).orElse(this.cacheHitCount);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class MetricsImpl
        implements Metrics {
            private final Optional<Integer> cacheHitCount;
            private final Optional<Integer> cacheLookupCount;
            private final Optional<Integer> lookupCount;
            private final Optional<Integer> serviceCount;

            protected MetricsImpl(BuilderBase<?, ?> builder) {
                this.serviceCount = builder.serviceCount();
                this.lookupCount = builder.lookupCount();
                this.cacheLookupCount = builder.cacheLookupCount();
                this.cacheHitCount = builder.cacheHitCount();
            }

            @Override
            public Optional<Integer> serviceCount() {
                return this.serviceCount;
            }

            @Override
            public Optional<Integer> lookupCount() {
                return this.lookupCount;
            }

            @Override
            public Optional<Integer> cacheLookupCount() {
                return this.cacheLookupCount;
            }

            @Override
            public Optional<Integer> cacheHitCount() {
                return this.cacheHitCount;
            }

            public String toString() {
                return "Metrics{serviceCount=" + String.valueOf(this.serviceCount) + ",lookupCount=" + String.valueOf(this.lookupCount) + ",cacheLookupCount=" + String.valueOf(this.cacheLookupCount) + ",cacheHitCount=" + String.valueOf(this.cacheHitCount) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Metrics)) {
                    return false;
                }
                Metrics other = (Metrics)o;
                return Objects.equals(this.serviceCount, other.serviceCount()) && Objects.equals(this.lookupCount, other.lookupCount()) && Objects.equals(this.cacheLookupCount, other.cacheLookupCount()) && Objects.equals(this.cacheHitCount, other.cacheHitCount());
            }

            public int hashCode() {
                return Objects.hash(this.serviceCount, this.lookupCount, this.cacheLookupCount, this.cacheHitCount);
            }
        }
    }
}

