/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.inject.api.Bootstrap;
import io.helidon.inject.api.CallingContext;
import io.helidon.inject.api.InjectionException;
import io.helidon.inject.api.InjectionServices;
import io.helidon.inject.api.InternalBootstrap;
import io.helidon.inject.api.InternalBootstrapBlueprint;
import io.helidon.inject.api.Resettable;
import io.helidon.inject.spi.InjectionServicesProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class InjectionServicesHolder {
    public static final String DEBUG_HINT = "use the (-D and/or -A) tag 'inject.debug=true' to see full trace output.";
    private static final AtomicReference<InternalBootstrap> BOOTSTRAP = new AtomicReference();
    private static final AtomicReference<ProviderAndServicesTuple> INSTANCE = new AtomicReference();
    private static final List<Resettable> RESETTABLES = new ArrayList<Resettable>();
    private static final Lock RESETTABLES_LOCK = new ReentrantLock();

    @Deprecated
    protected InjectionServicesHolder() {
    }

    static Optional<InjectionServices> injectionServices() {
        if (INSTANCE.get() == null) {
            INSTANCE.compareAndSet(null, new ProviderAndServicesTuple(InjectionServicesHolder.load()));
            if (InjectionServicesHolder.INSTANCE.get().injectionServices == null) {
                System.getLogger(InjectionServices.class.getName()).log(System.Logger.Level.WARNING, "Injection runtime services not detected on the classpath");
            }
        }
        return Optional.ofNullable(InjectionServicesHolder.INSTANCE.get().injectionServices);
    }

    protected static void reset() {
        ProviderAndServicesTuple instance = INSTANCE.get();
        if (instance != null) {
            instance.reset();
        }
        try {
            RESETTABLES_LOCK.lock();
            RESETTABLES.forEach(it -> it.reset(true));
            RESETTABLES.clear();
        }
        finally {
            RESETTABLES_LOCK.unlock();
        }
        INSTANCE.set(null);
        BOOTSTRAP.set(null);
    }

    protected static void addResettable(Resettable instance) {
        try {
            RESETTABLES_LOCK.lock();
            RESETTABLES.add(instance);
        }
        finally {
            RESETTABLES_LOCK.unlock();
        }
    }

    static void bootstrap(Bootstrap bootstrap) {
        Objects.requireNonNull(bootstrap);
        InternalBootstrap iBootstrap = ((InternalBootstrap.Builder)InternalBootstrap.builder().bootStrap(bootstrap)).build();
        InternalBootstrap existing = BOOTSTRAP.compareAndExchange(null, iBootstrap);
        if (existing != null) {
            StackTraceElement[] trace;
            CallingContext callingContext = existing.callingContext().orElse(null);
            StackTraceElement[] stackTraceElementArray = trace = callingContext == null ? new StackTraceElement[]{} : (StackTraceElement[])callingContext.stackTrace().orElse(null);
            if (trace != null && trace.length > 0) {
                throw new IllegalStateException("bootstrap was previously set from this code path:\n" + InjectionServicesHolder.prettyPrintStackTraceOf(trace) + "; module name is '" + callingContext.moduleName().orElse("undefined") + "'");
            }
            throw new IllegalStateException("The bootstrap has already been set - use the (-D and/or -A) tag 'inject.debug=true' to see full trace output.");
        }
    }

    static Optional<Bootstrap> bootstrap(boolean assignIfNeeded) {
        InternalBootstrap iBootstrap;
        if (assignIfNeeded) {
            iBootstrap = InternalBootstrap.create();
            BOOTSTRAP.compareAndSet(null, iBootstrap);
        }
        iBootstrap = BOOTSTRAP.get();
        return Optional.ofNullable(iBootstrap).flatMap(InternalBootstrapBlueprint::bootStrap);
    }

    static List<String> stackTraceOf(StackTraceElement[] trace) {
        ArrayList<String> result = new ArrayList<String>();
        for (StackTraceElement e : trace) {
            result.add(e.toString());
        }
        return result;
    }

    static String prettyPrintStackTraceOf(StackTraceElement[] trace) {
        return String.join((CharSequence)"\n", InjectionServicesHolder.stackTraceOf(trace));
    }

    private static Optional<InjectionServicesProvider> load() {
        return HelidonServiceLoader.create(ServiceLoader.load(InjectionServicesProvider.class, InjectionServicesProvider.class.getClassLoader())).asList().stream().findFirst();
    }

    private static class ProviderAndServicesTuple {
        private final InjectionServicesProvider provider;
        private final InjectionServices injectionServices;

        private ProviderAndServicesTuple(Optional<InjectionServicesProvider> provider) {
            this.provider = provider.orElse(null);
            this.injectionServices = provider.isPresent() ? this.provider.services(InjectionServicesHolder.bootstrap(true).orElseThrow(() -> new InjectionException("Failed to assign bootstrap"))) : null;
        }

        private void reset() {
            if (this.provider instanceof Resettable) {
                ((Resettable)((Object)this.provider)).reset(true);
            } else if (this.injectionServices instanceof Resettable) {
                ((Resettable)((Object)this.injectionServices)).reset(true);
            }
        }
    }
}

