/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.inject.api.InjectionServicesConfigBlueprint;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.inject.api.InjectionServicesConfigBlueprint")
public interface InjectionServicesConfig
extends InjectionServicesConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(InjectionServicesConfig instance) {
        return (Builder)InjectionServicesConfig.builder().from(instance);
    }

    public static InjectionServicesConfig create(Config config) {
        return ((Builder)InjectionServicesConfig.builder().config(config)).buildPrototype();
    }

    public static InjectionServicesConfig create() {
        return InjectionServicesConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, InjectionServicesConfig>
    implements io.helidon.common.Builder<Builder, InjectionServicesConfig> {
        private Builder() {
        }

        public InjectionServicesConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.InjectionServicesConfigImpl(this);
        }

        public InjectionServicesConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends InjectionServicesConfig>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private Boolean debug;
        private boolean activationLogs = false;
        private boolean permitsDynamic = false;
        private boolean permitsReflection = false;
        private boolean serviceLookupCaching = false;
        private boolean supportsCompileTime = true;
        private boolean supportsContextualLookup = false;
        private boolean supportsDynamic = true;
        private boolean supportsJsr330 = true;
        private boolean supportsJsr330Privates = false;
        private boolean supportsJsr330Statics = false;
        private boolean supportsReflection = false;
        private boolean usesCompileTimeApplications = true;
        private boolean usesCompileTimeModules = true;
        private boolean usesJsr330 = false;
        private Config config;
        private Duration activationDeadlockDetectionTimeout = Duration.parse("PT10S");
        private Duration shutdownTimeout = Duration.parse("PT10S");
        private String providerName;
        private String providerVersion;

        protected BuilderBase() {
        }

        public BUILDER from(InjectionServicesConfig prototype) {
            this.providerName(prototype.providerName());
            this.providerVersion(prototype.providerVersion());
            this.activationDeadlockDetectionTimeout(prototype.activationDeadlockDetectionTimeout());
            this.shutdownTimeout(prototype.shutdownTimeout());
            this.activationLogs(prototype.activationLogs());
            this.serviceLookupCaching(prototype.serviceLookupCaching());
            this.permitsDynamic(prototype.permitsDynamic());
            this.supportsDynamic(prototype.supportsDynamic());
            this.permitsReflection(prototype.permitsReflection());
            this.supportsReflection(prototype.supportsReflection());
            this.usesCompileTimeApplications(prototype.usesCompileTimeApplications());
            this.usesCompileTimeModules(prototype.usesCompileTimeModules());
            this.supportsCompileTime(prototype.supportsCompileTime());
            this.usesJsr330(prototype.usesJsr330());
            this.supportsJsr330(prototype.supportsJsr330());
            this.supportsJsr330Statics(prototype.supportsJsr330Statics());
            this.supportsJsr330Privates(prototype.supportsJsr330Privates());
            this.supportsContextualLookup(prototype.supportsContextualLookup());
            this.debug(prototype.debug());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.providerName().ifPresent(this::providerName);
            builder.providerVersion().ifPresent(this::providerVersion);
            this.activationDeadlockDetectionTimeout(builder.activationDeadlockDetectionTimeout());
            this.shutdownTimeout(builder.shutdownTimeout());
            this.activationLogs(builder.activationLogs());
            this.serviceLookupCaching(builder.serviceLookupCaching());
            this.permitsDynamic(builder.permitsDynamic());
            this.supportsDynamic(builder.supportsDynamic());
            this.permitsReflection(builder.permitsReflection());
            this.supportsReflection(builder.supportsReflection());
            this.usesCompileTimeApplications(builder.usesCompileTimeApplications());
            this.usesCompileTimeModules(builder.usesCompileTimeModules());
            this.supportsCompileTime(builder.supportsCompileTime());
            this.usesJsr330(builder.usesJsr330());
            this.supportsJsr330(builder.supportsJsr330());
            this.supportsJsr330Statics(builder.supportsJsr330Statics());
            this.supportsJsr330Privates(builder.supportsJsr330Privates());
            this.supportsContextualLookup(builder.supportsContextualLookup());
            builder.debug().ifPresent(this::debug);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("provider-name").as(String.class).ifPresent(this::providerName);
            config.get("provider-version").as(String.class).ifPresent(this::providerVersion);
            config.get("activation-deadlock-detection-timeout").as(Duration.class).ifPresent(this::activationDeadlockDetectionTimeout);
            config.get("shutdown-timeout").as(Duration.class).ifPresent(this::shutdownTimeout);
            config.get("activation-logs").as(Boolean.class).ifPresent(this::activationLogs);
            config.get("service-lookup-caching").as(Boolean.class).ifPresent(this::serviceLookupCaching);
            config.get("permits-dynamic").as(Boolean.class).ifPresent(this::permitsDynamic);
            config.get("supports-dynamic").as(Boolean.class).ifPresent(this::supportsDynamic);
            config.get("permits-reflection").as(Boolean.class).ifPresent(this::permitsReflection);
            config.get("supports-reflection").as(Boolean.class).ifPresent(this::supportsReflection);
            config.get("uses-compile-time-applications").as(Boolean.class).ifPresent(this::usesCompileTimeApplications);
            config.get("uses-compile-time-modules").as(Boolean.class).ifPresent(this::usesCompileTimeModules);
            config.get("supports-compile-time").as(Boolean.class).ifPresent(this::supportsCompileTime);
            config.get("uses-jsr330").as(Boolean.class).ifPresent(this::usesJsr330);
            config.get("supports-jsr330").as(Boolean.class).ifPresent(this::supportsJsr330);
            config.get("supports-jsr330-statics").as(Boolean.class).ifPresent(this::supportsJsr330Statics);
            config.get("supports-jsr330-privates").as(Boolean.class).ifPresent(this::supportsJsr330Privates);
            config.get("supports-contextual-lookup").as(Boolean.class).ifPresent(this::supportsContextualLookup);
            config.get("debug").as(Boolean.class).ifPresent(this::debug);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearProviderName() {
            this.providerName = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER providerName(String providerName) {
            Objects.requireNonNull(providerName);
            this.providerName = providerName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearProviderVersion() {
            this.providerVersion = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER providerVersion(String providerVersion) {
            Objects.requireNonNull(providerVersion);
            this.providerVersion = providerVersion;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER activationDeadlockDetectionTimeout(Duration activationDeadlockDetectionTimeout) {
            Objects.requireNonNull(activationDeadlockDetectionTimeout);
            this.activationDeadlockDetectionTimeout = activationDeadlockDetectionTimeout;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER shutdownTimeout(Duration shutdownTimeout) {
            Objects.requireNonNull(shutdownTimeout);
            this.shutdownTimeout = shutdownTimeout;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER activationLogs(boolean activationLogs) {
            this.activationLogs = activationLogs;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceLookupCaching(boolean serviceLookupCaching) {
            this.serviceLookupCaching = serviceLookupCaching;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER permitsDynamic(boolean permitsDynamic) {
            this.permitsDynamic = permitsDynamic;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER supportsDynamic(boolean supportsDynamic) {
            this.supportsDynamic = supportsDynamic;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER permitsReflection(boolean permitsReflection) {
            this.permitsReflection = permitsReflection;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER supportsReflection(boolean supportsReflection) {
            this.supportsReflection = supportsReflection;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER usesCompileTimeApplications(boolean usesCompileTimeApplications) {
            this.usesCompileTimeApplications = usesCompileTimeApplications;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER usesCompileTimeModules(boolean usesCompileTimeModules) {
            this.usesCompileTimeModules = usesCompileTimeModules;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER supportsCompileTime(boolean supportsCompileTime) {
            this.supportsCompileTime = supportsCompileTime;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER usesJsr330(boolean usesJsr330) {
            this.usesJsr330 = usesJsr330;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER supportsJsr330(boolean supportsJsr330) {
            this.supportsJsr330 = supportsJsr330;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER supportsJsr330Statics(boolean supportsJsr330Statics) {
            this.supportsJsr330Statics = supportsJsr330Statics;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER supportsJsr330Privates(boolean supportsJsr330Privates) {
            this.supportsJsr330Privates = supportsJsr330Privates;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER supportsContextualLookup(boolean supportsContextualLookup) {
            this.supportsContextualLookup = supportsContextualLookup;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDebug() {
            this.debug = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER debug(boolean debug) {
            Objects.requireNonNull(debug);
            this.debug = debug;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> providerName() {
            return Optional.ofNullable(this.providerName);
        }

        public Optional<String> providerVersion() {
            return Optional.ofNullable(this.providerVersion);
        }

        public Duration activationDeadlockDetectionTimeout() {
            return this.activationDeadlockDetectionTimeout;
        }

        public Duration shutdownTimeout() {
            return this.shutdownTimeout;
        }

        public boolean activationLogs() {
            return this.activationLogs;
        }

        public boolean serviceLookupCaching() {
            return this.serviceLookupCaching;
        }

        public boolean permitsDynamic() {
            return this.permitsDynamic;
        }

        public boolean supportsDynamic() {
            return this.supportsDynamic;
        }

        public boolean permitsReflection() {
            return this.permitsReflection;
        }

        public boolean supportsReflection() {
            return this.supportsReflection;
        }

        public boolean usesCompileTimeApplications() {
            return this.usesCompileTimeApplications;
        }

        public boolean usesCompileTimeModules() {
            return this.usesCompileTimeModules;
        }

        public boolean supportsCompileTime() {
            return this.supportsCompileTime;
        }

        public boolean usesJsr330() {
            return this.usesJsr330;
        }

        public boolean supportsJsr330() {
            return this.supportsJsr330;
        }

        public boolean supportsJsr330Statics() {
            return this.supportsJsr330Statics;
        }

        public boolean supportsJsr330Privates() {
            return this.supportsJsr330Privates;
        }

        public boolean supportsContextualLookup() {
            return this.supportsContextualLookup;
        }

        public Optional<Boolean> debug() {
            return Optional.ofNullable(this.debug);
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "InjectionServicesConfigBuilder{providerName=" + this.providerName + ",providerVersion=" + this.providerVersion + ",activationDeadlockDetectionTimeout=" + String.valueOf(this.activationDeadlockDetectionTimeout) + ",shutdownTimeout=" + String.valueOf(this.shutdownTimeout) + ",activationLogs=" + this.activationLogs + ",serviceLookupCaching=" + this.serviceLookupCaching + ",permitsDynamic=" + this.permitsDynamic + ",supportsDynamic=" + this.supportsDynamic + ",permitsReflection=" + this.permitsReflection + ",supportsReflection=" + this.supportsReflection + ",usesCompileTimeApplications=" + this.usesCompileTimeApplications + ",usesCompileTimeModules=" + this.usesCompileTimeModules + ",supportsCompileTime=" + this.supportsCompileTime + ",usesJsr330=" + this.usesJsr330 + ",supportsJsr330=" + this.supportsJsr330 + ",supportsJsr330Statics=" + this.supportsJsr330Statics + ",supportsJsr330Privates=" + this.supportsJsr330Privates + ",supportsContextualLookup=" + this.supportsContextualLookup + ",debug=" + this.debug + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        BUILDER providerName(Optional<String> providerName) {
            Objects.requireNonNull(providerName);
            this.providerName = providerName.map(String.class::cast).orElse(this.providerName);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER providerVersion(Optional<String> providerVersion) {
            Objects.requireNonNull(providerVersion);
            this.providerVersion = providerVersion.map(String.class::cast).orElse(this.providerVersion);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER debug(Optional<Boolean> debug) {
            Objects.requireNonNull(debug);
            this.debug = debug.map(Boolean.class::cast).orElse(this.debug);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class InjectionServicesConfigImpl
        implements InjectionServicesConfig {
            private final boolean activationLogs;
            private final boolean permitsDynamic;
            private final boolean permitsReflection;
            private final boolean serviceLookupCaching;
            private final boolean supportsCompileTime;
            private final boolean supportsContextualLookup;
            private final boolean supportsDynamic;
            private final boolean supportsJsr330;
            private final boolean supportsJsr330Privates;
            private final boolean supportsJsr330Statics;
            private final boolean supportsReflection;
            private final boolean usesCompileTimeApplications;
            private final boolean usesCompileTimeModules;
            private final boolean usesJsr330;
            private final Duration activationDeadlockDetectionTimeout;
            private final Duration shutdownTimeout;
            private final Optional<Boolean> debug;
            private final Optional<String> providerName;
            private final Optional<String> providerVersion;

            protected InjectionServicesConfigImpl(BuilderBase<?, ?> builder) {
                this.providerName = builder.providerName();
                this.providerVersion = builder.providerVersion();
                this.activationDeadlockDetectionTimeout = builder.activationDeadlockDetectionTimeout();
                this.shutdownTimeout = builder.shutdownTimeout();
                this.activationLogs = builder.activationLogs();
                this.serviceLookupCaching = builder.serviceLookupCaching();
                this.permitsDynamic = builder.permitsDynamic();
                this.supportsDynamic = builder.supportsDynamic();
                this.permitsReflection = builder.permitsReflection();
                this.supportsReflection = builder.supportsReflection();
                this.usesCompileTimeApplications = builder.usesCompileTimeApplications();
                this.usesCompileTimeModules = builder.usesCompileTimeModules();
                this.supportsCompileTime = builder.supportsCompileTime();
                this.usesJsr330 = builder.usesJsr330();
                this.supportsJsr330 = builder.supportsJsr330();
                this.supportsJsr330Statics = builder.supportsJsr330Statics();
                this.supportsJsr330Privates = builder.supportsJsr330Privates();
                this.supportsContextualLookup = builder.supportsContextualLookup();
                this.debug = builder.debug();
            }

            @Override
            public Optional<String> providerName() {
                return this.providerName;
            }

            @Override
            public Optional<String> providerVersion() {
                return this.providerVersion;
            }

            @Override
            public Duration activationDeadlockDetectionTimeout() {
                return this.activationDeadlockDetectionTimeout;
            }

            @Override
            public Duration shutdownTimeout() {
                return this.shutdownTimeout;
            }

            @Override
            public boolean activationLogs() {
                return this.activationLogs;
            }

            @Override
            public boolean serviceLookupCaching() {
                return this.serviceLookupCaching;
            }

            @Override
            public boolean permitsDynamic() {
                return this.permitsDynamic;
            }

            @Override
            public boolean supportsDynamic() {
                return this.supportsDynamic;
            }

            @Override
            public boolean permitsReflection() {
                return this.permitsReflection;
            }

            @Override
            public boolean supportsReflection() {
                return this.supportsReflection;
            }

            @Override
            public boolean usesCompileTimeApplications() {
                return this.usesCompileTimeApplications;
            }

            @Override
            public boolean usesCompileTimeModules() {
                return this.usesCompileTimeModules;
            }

            @Override
            public boolean supportsCompileTime() {
                return this.supportsCompileTime;
            }

            @Override
            public boolean usesJsr330() {
                return this.usesJsr330;
            }

            @Override
            public boolean supportsJsr330() {
                return this.supportsJsr330;
            }

            @Override
            public boolean supportsJsr330Statics() {
                return this.supportsJsr330Statics;
            }

            @Override
            public boolean supportsJsr330Privates() {
                return this.supportsJsr330Privates;
            }

            @Override
            public boolean supportsContextualLookup() {
                return this.supportsContextualLookup;
            }

            @Override
            public Optional<Boolean> debug() {
                return this.debug;
            }

            public String toString() {
                return "InjectionServicesConfig{providerName=" + String.valueOf(this.providerName) + ",providerVersion=" + String.valueOf(this.providerVersion) + ",activationDeadlockDetectionTimeout=" + String.valueOf(this.activationDeadlockDetectionTimeout) + ",shutdownTimeout=" + String.valueOf(this.shutdownTimeout) + ",activationLogs=" + this.activationLogs + ",serviceLookupCaching=" + this.serviceLookupCaching + ",permitsDynamic=" + this.permitsDynamic + ",supportsDynamic=" + this.supportsDynamic + ",permitsReflection=" + this.permitsReflection + ",supportsReflection=" + this.supportsReflection + ",usesCompileTimeApplications=" + this.usesCompileTimeApplications + ",usesCompileTimeModules=" + this.usesCompileTimeModules + ",supportsCompileTime=" + this.supportsCompileTime + ",usesJsr330=" + this.usesJsr330 + ",supportsJsr330=" + this.supportsJsr330 + ",supportsJsr330Statics=" + this.supportsJsr330Statics + ",supportsJsr330Privates=" + this.supportsJsr330Privates + ",supportsContextualLookup=" + this.supportsContextualLookup + ",debug=" + String.valueOf(this.debug) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InjectionServicesConfig)) {
                    return false;
                }
                InjectionServicesConfig other = (InjectionServicesConfig)o;
                return Objects.equals(this.providerName, other.providerName()) && Objects.equals(this.providerVersion, other.providerVersion()) && Objects.equals(this.activationDeadlockDetectionTimeout, other.activationDeadlockDetectionTimeout()) && Objects.equals(this.shutdownTimeout, other.shutdownTimeout()) && this.activationLogs == other.activationLogs() && this.serviceLookupCaching == other.serviceLookupCaching() && this.permitsDynamic == other.permitsDynamic() && this.supportsDynamic == other.supportsDynamic() && this.permitsReflection == other.permitsReflection() && this.supportsReflection == other.supportsReflection() && this.usesCompileTimeApplications == other.usesCompileTimeApplications() && this.usesCompileTimeModules == other.usesCompileTimeModules() && this.supportsCompileTime == other.supportsCompileTime() && this.usesJsr330 == other.usesJsr330() && this.supportsJsr330 == other.supportsJsr330() && this.supportsJsr330Statics == other.supportsJsr330Statics() && this.supportsJsr330Privates == other.supportsJsr330Privates() && this.supportsContextualLookup == other.supportsContextualLookup() && Objects.equals(this.debug, other.debug());
            }

            public int hashCode() {
                return Objects.hash(this.providerName, this.providerVersion, this.activationDeadlockDetectionTimeout, this.shutdownTimeout, this.activationLogs, this.serviceLookupCaching, this.permitsDynamic, this.supportsDynamic, this.permitsReflection, this.supportsReflection, this.usesCompileTimeApplications, this.usesCompileTimeModules, this.supportsCompileTime, this.usesJsr330, this.supportsJsr330, this.supportsJsr330Statics, this.supportsJsr330Privates, this.supportsContextualLookup, this.debug);
            }
        }
    }
}

