/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.common.types.TypeName;
import io.helidon.inject.api.ActivationLog;
import io.helidon.inject.api.ActivationRequest;
import io.helidon.inject.api.ActivationResult;
import io.helidon.inject.api.Bootstrap;
import io.helidon.inject.api.ContextualServiceQuery;
import io.helidon.inject.api.InjectionServicesConfig;
import io.helidon.inject.api.InjectionServicesConfigBlueprint;
import io.helidon.inject.api.InjectionServicesHolder;
import io.helidon.inject.api.Injector;
import io.helidon.inject.api.Metrics;
import io.helidon.inject.api.Phase;
import io.helidon.inject.api.ServiceInfoCriteria;
import io.helidon.inject.api.Services;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public interface InjectionServices {
    public static final String TAG_DEBUG = "inject.debug";
    public static final ServiceInfoCriteria EMPTY_CRITERIA = ServiceInfoCriteria.builder().build();
    public static final ContextualServiceQuery SERVICE_QUERY_REQUIRED = ((ContextualServiceQuery.Builder)((ContextualServiceQuery.Builder)ContextualServiceQuery.builder().serviceInfoCriteria(EMPTY_CRITERIA)).expected(true)).build();

    public static boolean isDebugEnabled() {
        return InjectionServices.injectionServices().map(InjectionServices::config).map(InjectionServicesConfigBlueprint::shouldDebug).orElseGet(() -> Boolean.getBoolean(TAG_DEBUG));
    }

    public Bootstrap bootstrap();

    public static Optional<Bootstrap> globalBootstrap() {
        return InjectionServicesHolder.bootstrap(false);
    }

    public static Bootstrap realizedGlobalBootStrap() {
        Optional<Bootstrap> bootstrap = InjectionServices.globalBootstrap();
        return bootstrap.orElseGet(() -> InjectionServicesHolder.bootstrap(true).orElseThrow());
    }

    public static void globalBootstrap(Bootstrap bootstrap) {
        Objects.requireNonNull(bootstrap);
        InjectionServicesHolder.bootstrap(bootstrap);
    }

    public static Optional<InjectionServices> injectionServices() {
        return InjectionServicesHolder.injectionServices();
    }

    public static Services realizedServices() {
        return InjectionServices.injectionServices().orElseThrow().services();
    }

    public static Optional<Services> unrealizedServices() {
        return InjectionServices.injectionServices().flatMap(it -> it.services(false));
    }

    default public Services services() {
        return this.services(true).orElseThrow();
    }

    public Optional<? extends Services> services(boolean var1);

    public InjectionServicesConfig config();

    public Optional<Injector> injector();

    public Optional<Map<TypeName, ActivationResult>> shutdown();

    public Optional<ActivationLog> activationLog();

    public Optional<Metrics> metrics();

    public Optional<Set<ServiceInfoCriteria>> lookups();

    public static ActivationRequest createActivationRequestDefault() {
        return ((ActivationRequest.Builder)ActivationRequest.builder().targetPhase(InjectionServices.terminalActivationPhase())).build();
    }

    public static Phase terminalActivationPhase() {
        Optional<Bootstrap> globalBootstrap = InjectionServices.globalBootstrap();
        if (globalBootstrap.isPresent()) {
            Optional<Phase> limitPhase = globalBootstrap.get().limitRuntimePhase();
            return limitPhase.orElse(Phase.ACTIVE);
        }
        return Phase.ACTIVE;
    }
}

