/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.types.TypeName;
import io.helidon.inject.api.ElementInfo;
import io.helidon.inject.api.InjectionPointInfoBlueprint;
import io.helidon.inject.api.ServiceInfoCriteria;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.inject.api.InjectionPointInfoBlueprint")
public interface InjectionPointInfo
extends InjectionPointInfoBlueprint,
Prototype.Api,
ElementInfo {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(InjectionPointInfo instance) {
        return (Builder)InjectionPointInfo.builder().from(instance);
    }

    public static InjectionPointInfo create() {
        return InjectionPointInfo.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, InjectionPointInfo>
    implements io.helidon.common.Builder<Builder, InjectionPointInfo> {
        private Builder() {
        }

        public InjectionPointInfo buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.InjectionPointInfoImpl(this);
        }

        public InjectionPointInfo build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends InjectionPointInfo>
    extends ElementInfo.BuilderBase<BUILDER, PROTOTYPE>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private boolean listWrapped = false;
        private boolean optionalWrapped = false;
        private boolean providerWrapped = false;
        private ServiceInfoCriteria dependencyToServiceInfo;
        private String baseIdentity;
        private String id;
        private String ipName;
        private TypeName ipType;

        protected BuilderBase() {
        }

        public BUILDER from(InjectionPointInfo prototype) {
            super.from(prototype);
            this.ipName(prototype.ipName());
            this.ipType(prototype.ipType());
            this.id(prototype.id());
            this.baseIdentity(prototype.baseIdentity());
            this.listWrapped(prototype.listWrapped());
            this.optionalWrapped(prototype.optionalWrapped());
            this.providerWrapped(prototype.providerWrapped());
            this.dependencyToServiceInfo(prototype.dependencyToServiceInfo());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from(builder);
            builder.ipName().ifPresent(this::ipName);
            builder.ipType().ifPresent(this::ipType);
            builder.id().ifPresent(this::id);
            builder.baseIdentity().ifPresent(this::baseIdentity);
            this.listWrapped(builder.listWrapped());
            this.optionalWrapped(builder.optionalWrapped());
            this.providerWrapped(builder.providerWrapped());
            builder.dependencyToServiceInfo().ifPresent(this::dependencyToServiceInfo);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER ipName(String ipName) {
            Objects.requireNonNull(ipName);
            this.ipName = ipName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER ipType(TypeName ipType) {
            Objects.requireNonNull(ipType);
            this.ipType = ipType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER ipType(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.ipType(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER ipType(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.ipType(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER id(String id) {
            Objects.requireNonNull(id);
            this.id = id;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER baseIdentity(String baseIdentity) {
            Objects.requireNonNull(baseIdentity);
            this.baseIdentity = baseIdentity;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER listWrapped(boolean listWrapped) {
            this.listWrapped = listWrapped;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER optionalWrapped(boolean optionalWrapped) {
            this.optionalWrapped = optionalWrapped;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER providerWrapped(boolean providerWrapped) {
            this.providerWrapped = providerWrapped;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER dependencyToServiceInfo(ServiceInfoCriteria dependencyToServiceInfo) {
            Objects.requireNonNull(dependencyToServiceInfo);
            this.dependencyToServiceInfo = dependencyToServiceInfo;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER dependencyToServiceInfo(Consumer<ServiceInfoCriteria.Builder> consumer) {
            Objects.requireNonNull(consumer);
            ServiceInfoCriteria.Builder builder = ServiceInfoCriteria.builder();
            consumer.accept(builder);
            this.dependencyToServiceInfo(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER dependencyToServiceInfo(Supplier<? extends ServiceInfoCriteria> supplier) {
            Objects.requireNonNull(supplier);
            this.dependencyToServiceInfo(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> ipName() {
            return Optional.ofNullable(this.ipName);
        }

        public Optional<TypeName> ipType() {
            return Optional.ofNullable(this.ipType);
        }

        public Optional<String> id() {
            return Optional.ofNullable(this.id);
        }

        public Optional<String> baseIdentity() {
            return Optional.ofNullable(this.baseIdentity);
        }

        public boolean listWrapped() {
            return this.listWrapped;
        }

        public boolean optionalWrapped() {
            return this.optionalWrapped;
        }

        public boolean providerWrapped() {
            return this.providerWrapped;
        }

        public Optional<ServiceInfoCriteria> dependencyToServiceInfo() {
            return Optional.ofNullable(this.dependencyToServiceInfo);
        }

        @Override
        public String toString() {
            return "InjectionPointInfoBuilder{ipName=" + this.ipName + ",ipType=" + String.valueOf(this.ipType) + ",id=" + this.id + ",baseIdentity=" + this.baseIdentity + ",listWrapped=" + this.listWrapped + ",optionalWrapped=" + this.optionalWrapped + ",providerWrapped=" + this.providerWrapped + ",dependencyToServiceInfo=" + String.valueOf(this.dependencyToServiceInfo) + "};" + super.toString();
        }

        @Override
        protected void preBuildPrototype() {
            super.preBuildPrototype();
        }

        @Override
        protected void validatePrototype() {
            super.validatePrototype();
            Errors.Collector collector = Errors.collector();
            if (this.ipName == null) {
                collector.fatal(this.getClass(), "Property \"ipName\" must not be null, but not set");
            }
            if (this.ipType == null) {
                collector.fatal(this.getClass(), "Property \"ipType\" must not be null, but not set");
            }
            if (this.id == null) {
                collector.fatal(this.getClass(), "Property \"id\" must not be null, but not set");
            }
            if (this.baseIdentity == null) {
                collector.fatal(this.getClass(), "Property \"baseIdentity\" must not be null, but not set");
            }
            if (this.dependencyToServiceInfo == null) {
                collector.fatal(this.getClass(), "Property \"dependencyToServiceInfo\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class InjectionPointInfoImpl
        extends ElementInfo.BuilderBase.ElementInfoImpl
        implements InjectionPointInfo {
            private final boolean listWrapped;
            private final boolean optionalWrapped;
            private final boolean providerWrapped;
            private final ServiceInfoCriteria dependencyToServiceInfo;
            private final String baseIdentity;
            private final String id;
            private final String ipName;
            private final TypeName ipType;

            protected InjectionPointInfoImpl(BuilderBase<?, ?> builder) {
                super(builder);
                this.ipName = builder.ipName().get();
                this.ipType = builder.ipType().get();
                this.id = builder.id().get();
                this.baseIdentity = builder.baseIdentity().get();
                this.listWrapped = builder.listWrapped();
                this.optionalWrapped = builder.optionalWrapped();
                this.providerWrapped = builder.providerWrapped();
                this.dependencyToServiceInfo = builder.dependencyToServiceInfo().get();
            }

            @Override
            public String ipName() {
                return this.ipName;
            }

            @Override
            public TypeName ipType() {
                return this.ipType;
            }

            @Override
            public String id() {
                return this.id;
            }

            @Override
            public String baseIdentity() {
                return this.baseIdentity;
            }

            @Override
            public boolean listWrapped() {
                return this.listWrapped;
            }

            @Override
            public boolean optionalWrapped() {
                return this.optionalWrapped;
            }

            @Override
            public boolean providerWrapped() {
                return this.providerWrapped;
            }

            @Override
            public ServiceInfoCriteria dependencyToServiceInfo() {
                return this.dependencyToServiceInfo;
            }

            @Override
            public String toString() {
                return "InjectionPointInfo{ipName=" + this.ipName + ",ipType=" + String.valueOf(this.ipType) + ",id=" + this.id + ",baseIdentity=" + this.baseIdentity + ",listWrapped=" + this.listWrapped + ",optionalWrapped=" + this.optionalWrapped + ",providerWrapped=" + this.providerWrapped + ",dependencyToServiceInfo=" + String.valueOf(this.dependencyToServiceInfo) + "};" + super.toString();
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InjectionPointInfo)) {
                    return false;
                }
                InjectionPointInfo other = (InjectionPointInfo)o;
                return super.equals(other) && Objects.equals(this.ipName, other.ipName()) && Objects.equals(this.ipType, other.ipType()) && Objects.equals(this.id, other.id()) && Objects.equals(this.baseIdentity, other.baseIdentity()) && this.listWrapped == other.listWrapped() && this.optionalWrapped == other.optionalWrapped() && this.providerWrapped == other.providerWrapped() && Objects.equals(this.dependencyToServiceInfo, other.dependencyToServiceInfo());
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.ipName, this.ipType, this.id, this.baseIdentity, this.listWrapped, this.optionalWrapped, this.providerWrapped, this.dependencyToServiceInfo);
            }
        }
    }
}

