/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.inject.api.ContextualServiceQueryBlueprint;
import io.helidon.inject.api.InjectionPointInfo;
import io.helidon.inject.api.ServiceInfoCriteria;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.inject.api.ContextualServiceQueryBlueprint")
public interface ContextualServiceQuery
extends ContextualServiceQueryBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ContextualServiceQuery instance) {
        return (Builder)ContextualServiceQuery.builder().from(instance);
    }

    public static ContextualServiceQuery create() {
        return ContextualServiceQuery.builder().buildPrototype();
    }

    public static ContextualServiceQuery create(InjectionPointInfo ipInfo, boolean expected) {
        return ContextualServiceQueryBlueprint.CustomMethods.create(ipInfo, expected);
    }

    public static class Builder
    extends BuilderBase<Builder, ContextualServiceQuery>
    implements io.helidon.common.Builder<Builder, ContextualServiceQuery> {
        private Builder() {
        }

        public ContextualServiceQuery buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ContextualServiceQueryImpl(this);
        }

        public ContextualServiceQuery build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ContextualServiceQuery>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private boolean expected;
        private InjectionPointInfo injectionPointInfo;
        private ServiceInfoCriteria serviceInfoCriteria;

        protected BuilderBase() {
        }

        public BUILDER from(ContextualServiceQuery prototype) {
            this.serviceInfoCriteria(prototype.serviceInfoCriteria());
            this.injectionPointInfo(prototype.injectionPointInfo());
            this.expected(prototype.expected());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.serviceInfoCriteria().ifPresent(this::serviceInfoCriteria);
            builder.injectionPointInfo().ifPresent(this::injectionPointInfo);
            this.expected(builder.expected());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceInfoCriteria(ServiceInfoCriteria serviceInfoCriteria) {
            Objects.requireNonNull(serviceInfoCriteria);
            this.serviceInfoCriteria = serviceInfoCriteria;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceInfoCriteria(Consumer<ServiceInfoCriteria.Builder> consumer) {
            Objects.requireNonNull(consumer);
            ServiceInfoCriteria.Builder builder = ServiceInfoCriteria.builder();
            consumer.accept(builder);
            this.serviceInfoCriteria(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceInfoCriteria(Supplier<? extends ServiceInfoCriteria> supplier) {
            Objects.requireNonNull(supplier);
            this.serviceInfoCriteria(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearInjectionPointInfo() {
            this.injectionPointInfo = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER injectionPointInfo(InjectionPointInfo injectionPointInfo) {
            Objects.requireNonNull(injectionPointInfo);
            this.injectionPointInfo = injectionPointInfo;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER injectionPointInfo(Consumer<InjectionPointInfo.Builder> consumer) {
            Objects.requireNonNull(consumer);
            InjectionPointInfo.Builder builder = InjectionPointInfo.builder();
            consumer.accept(builder);
            this.injectionPointInfo(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER expected(boolean expected) {
            this.expected = expected;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<ServiceInfoCriteria> serviceInfoCriteria() {
            return Optional.ofNullable(this.serviceInfoCriteria);
        }

        public Optional<InjectionPointInfo> injectionPointInfo() {
            return Optional.ofNullable(this.injectionPointInfo);
        }

        public boolean expected() {
            return this.expected;
        }

        public String toString() {
            return "ContextualServiceQueryBuilder{serviceInfoCriteria=" + String.valueOf(this.serviceInfoCriteria) + ",injectionPointInfo=" + String.valueOf(this.injectionPointInfo) + ",expected=" + this.expected + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.serviceInfoCriteria == null) {
                collector.fatal(this.getClass(), "Property \"serviceInfoCriteria\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER injectionPointInfo(Optional<? extends InjectionPointInfo> injectionPointInfo) {
            Objects.requireNonNull(injectionPointInfo);
            this.injectionPointInfo = injectionPointInfo.map(InjectionPointInfo.class::cast).orElse(this.injectionPointInfo);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class ContextualServiceQueryImpl
        implements ContextualServiceQuery {
            private final boolean expected;
            private final Optional<InjectionPointInfo> injectionPointInfo;
            private final ServiceInfoCriteria serviceInfoCriteria;

            protected ContextualServiceQueryImpl(BuilderBase<?, ?> builder) {
                this.serviceInfoCriteria = builder.serviceInfoCriteria().get();
                this.injectionPointInfo = builder.injectionPointInfo();
                this.expected = builder.expected();
            }

            @Override
            public ServiceInfoCriteria serviceInfoCriteria() {
                return this.serviceInfoCriteria;
            }

            @Override
            public Optional<InjectionPointInfo> injectionPointInfo() {
                return this.injectionPointInfo;
            }

            @Override
            public boolean expected() {
                return this.expected;
            }

            public String toString() {
                return "ContextualServiceQuery{serviceInfoCriteria=" + String.valueOf(this.serviceInfoCriteria) + ",injectionPointInfo=" + String.valueOf(this.injectionPointInfo) + ",expected=" + this.expected + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ContextualServiceQuery)) {
                    return false;
                }
                ContextualServiceQuery other = (ContextualServiceQuery)o;
                return Objects.equals(this.serviceInfoCriteria, other.serviceInfoCriteria()) && Objects.equals(this.injectionPointInfo, other.injectionPointInfo()) && this.expected == other.expected();
            }

            public int hashCode() {
                return Objects.hash(this.serviceInfoCriteria, this.injectionPointInfo, this.expected);
            }
        }
    }
}

