<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#routing" @click.native="this.scrollFix('#routing')">Routing</router-link></p>

</li>
<li>
<p><router-link to="#_request_handling" @click.native="this.scrollFix('#_request_handling')">Request Handling</router-link></p>

</li>
<li>
<p><router-link to="#_protocol_specific_routing" @click.native="this.scrollFix('#_protocol_specific_routing')">Protocol Specific Routing</router-link></p>

</li>
<li>
<p><router-link to="#_error_handling" @click.native="this.scrollFix('#_error_handling')">Error Handling</router-link></p>

</li>
<li>
<p><router-link to="#_http2_support" @click.native="this.scrollFix('#_http2_support')">Http/2 Support</router-link></p>

</li>
<li>
<p><router-link to="#_static_content_support" @click.native="this.scrollFix('#_static_content_support')">Static Content Support</router-link></p>

</li>
<li>
<p><router-link to="#_jersey_jax_rs_support" @click.native="this.scrollFix('#_jersey_jax_rs_support')">Jersey (JAX-RS) Support</router-link></p>

</li>
<li>
<p><router-link to="#_json_support" @click.native="this.scrollFix('#_json_support')">JSON Support</router-link></p>

</li>
<li>
<p><router-link to="#_json_b_support" @click.native="this.scrollFix('#_json_b_support')">JSON-B Support</router-link></p>

</li>
<li>
<p><router-link to="#_jackson_support" @click.native="this.scrollFix('#_jackson_support')">Jackson Support</router-link></p>

</li>
<li>
<p><router-link to="#_access_log" @click.native="this.scrollFix('#_access_log')">Access Log</router-link></p>

</li>
<li>
<p><router-link to="#_tls_configuration_2" @click.native="this.scrollFix('#_tls_configuration_2')">TLS configuration</router-link></p>

</li>
<li>
<p><router-link to="#_http_compression" @click.native="this.scrollFix('#_http_compression')">HTTP Compression</router-link></p>

</li>
<li>
<p><router-link to="#_quick_start" @click.native="this.scrollFix('#_quick_start')">Quick Start</router-link></p>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>WebServer provides an asynchronous and reactive API for creating web applications.
The API is inspired by popular NodeJS and Java frameworks.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable WebServer
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.reactive.webserver&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-reactive-webserver&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>Configure the WebServer either programmatically, or by the Helidon configuration framework.</p>


<h3 id="_configuring_the_webserver_in_your_code">Configuring the WebServer in your code</h3>
<div class="section">
<p>The easiest way to configure the WebServer is in your
application code.</p>

<markup
lang="java"

>WebServer webServer = WebServer.builder()
      .bindAddress(InetAddress.getLocalHost())
      .port(8080)
      .build();</markup>

</div>


<h3 id="_configuring_the_webserver_in_a_configuration_file">Configuring the WebServer in a configuration file</h3>
<div class="section">
<p>You can also define the configuration in a file.</p>

<markup
lang="yaml"
title="WebServer configuration file <code>application.yaml</code>"
>server:
  port: 8080
  bind-address: "0.0.0.0"</markup>

<p>Then, in your application code, load the configuration from that file.</p>

<markup
lang="java"
title="WebServer initialization using the <code>application.yaml</code> file located on the classpath"
>Config config = Config.create(); <span class="conum" data-value="1" />
WebServer webServer = WebServer.create(routing, config.get("server")); <span class="conum" data-value="2" /></markup>

<ul class="colist">
<li data-value="1"><code>application.yaml</code> is a default configuration source loaded when YAML support is on classpath, so we can
just use <code>Config.create()</code></li>
<li data-value="2">Server expects the configuration tree located on the node of <code>server</code></li>
</ul>

</div>


<h3 id="_configuration_options">Configuration options</h3>
<div class="section">
<p>Configuration of the HTTP server.</p>

<p>Type: <a target="_blank" href="./apidocs/io.helidon.reactive.webserver/io/helidon/reactive/webserver/WebServer.html">io.helidon.reactive.webserver.WebServer</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>server</code></p>


<h4 id="_configuration_options_2">Configuration options</h4>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>backlog</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>1024</code></td>
<td class=""><doc-view>
<p>Configures a maximum length of the queue of incoming connections on the server
 socket.</p>

<pre>Default value is #DEFAULT_BACKLOG_SIZE.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>backpressure-buffer-size</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Maximum length of the response data sending buffer can keep without flushing.
 Depends on <code>backpressure-policy</code> what happens if max buffer size is reached.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>backpressure-strategy</code></td>
<td class=""><doc-view>
<p>BackpressureStrategy (LINEAR, AUTO_FLUSH, PREFETCH, UNBOUNDED)</p>

</doc-view>
</td>
<td class=""><code>AUTO_FLUSH</code></td>
<td class=""><doc-view>
<p>Sets a backpressure strategy for the server to apply against user provided response upstream.</p>

<ul class="ulist">
<li>
<p>LINEAR - Data are requested one-by-one, in case buffer reaches watermark, no other data is requested.</p>

</li>
<li>
<p>AUTO_FLUSH - Data are requested one-by-one, in case buffer reaches watermark, no other data is requested.</p>

</li>
<li>
<p>PREFETCH - After first data chunk arrives, probable number of chunks needed to fill the buffer up to watermark is calculated and requested.</p>

</li>
<li>
<p>NONE - No backpressure is applied, Long.MAX_VALUE(unbounded) is requested from upstream.</p>

</li>
</ul>

</doc-view>
</td>
</tr>
<tr>
<td class=""><s><code>bind-address</code></s></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p><strong>Deprecated</strong> Configures local address where the server listens on with the server socket.
 If not configured, then listens an all local addresses.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>continue-immediately</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>When true WebServer answers to expect continue with 100 continue immediately,
 not waiting for user to actually request the data.</p>

<pre>Default is `false`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>enable-compression</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Enable negotiation for gzip/deflate content encodings. Clients can
 request compression using the "Accept-Encoding" header.</p>

<pre>Default is `false`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>features.print-details</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Set to <code>true</code> to print detailed feature information on startup.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>host</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>A helper method that just calls #bindAddress(String).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-header-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>16384</code></td>
<td class=""><doc-view>
<p>Maximal number of bytes of all header values combined. When a bigger value is received, a
 io.helidon.common.http.Http.Status#BAD_REQUEST_400
 is returned.</p>

<pre>Default is `16384`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-initial-line-length</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>4096</code></td>
<td class=""><doc-view>
<p>Maximal number of characters in the initial HTTP line.</p>

<pre>Default is `4096`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-payload-size</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Set a maximum payload size for a client request. Can prevent DoS
 attacks.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-upgrade-content-length</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>65536</code></td>
<td class=""><doc-view>
<p>Set a maximum length of the content of an upgrade request.</p>

<pre>Default is `64*1024`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>port</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>0</code></td>
<td class=""><doc-view>
<p>Configures a server port to listen on with the server socket. If port is
 <code>0</code> then any available ephemeral port will be used.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>receive-buffer-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configures proposed value of the TCP receive window that is advertised to the remote peer on the
 server socket.</p>

<pre>If `0` then use implementation default.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>requested-uri-discovery</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_http_RequestedUriDiscoveryContext">RequestedUriDiscoveryContext</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Requested URI discovery for the web server&#8217;s default socket.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sockets</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_reactive_webserver_SocketConfiguration">SocketConfiguration[&#93;</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Adds an additional named server socket configuration. As a result, the server will listen
 on multiple ports.</p>

<pre>An additional named server socket may have a dedicated Routing configured
through WebServer.Builder#addNamedRouting(String, Routing).</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>timeout-millis</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class=""><code>0</code></td>
<td class=""><doc-view>
<p>Socket timeout in milliseconds</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>tls</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_reactive_webserver_WebServerTls">WebServerTls</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configures SSL for this socket. When configured, the server enforces SSL
 configuration.
 If this method is called, any other method except for #tls(java.util.function.Supplier)¨
 and repeated invocation of this method would be ignored.</p>

<pre>If this method is called again, the previous configuration would be ignored.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>worker-count</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets a count of threads in pool used to process HTTP requests.
 Default value is <code>CPU_COUNT * 2</code>.</p>

<pre>Configuration key: `workers`</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>

</div>


<h2 id="routing">Routing</h2>
<div class="section">
<p>Routing lets you use request matching criteria to bind requests to a <code>handler</code> that implements
your custom business logic. Matching criteria include one or more <strong>HTTP Method(s)</strong> and, optionally,
a request <strong>path matcher</strong>. Use the <code>RequestPredicate</code> class to specify more routing
criteria.</p>


<h3 id="_basics">Basics</h3>
<div class="section">
<p>Routing also supports <em>Error Routing</em> which binds Java <code>Throwable</code> to the
handling logic.</p>

<p>Configure HTTP request routing using <code>Routing.Builder</code>.</p>

<markup
lang="java"
title="Using Routing.Builder to specify how HTTP requests are handled"
>Routing routing = Routing.builder()
                         .get("/hello", (req, res) -&gt; res.send("Hello World!")) <span class="conum" data-value="1" />
                         .build();

WebServer webServer = WebServer.create(routing); <span class="conum" data-value="2" /></markup>

<ul class="colist">
<li data-value="1">Handle all GETs to <code>/hello</code> path. Send the <code>Hello World!</code> string.</li>
<li data-value="2">Add the <code>routing</code> to the WebServer.</li>
</ul>

</div>


<h3 id="_http_method_routing">HTTP Method Routing</h3>
<div class="section">
<p><code>Routing.Builder</code> lets you specify how to handle each HTTP method. For example:</p>


<div class="table__overflow elevation-1  flex sm7
">
<table class="datatable table">
<colgroup>
<col style="width: 16.667%;">
<col style="width: 83.333%;">
</colgroup>
<thead>
<tr>
<th>HTTP Method</th>
<th>Routing.Builder example</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><strong>GET</strong></td>
<td class=""><code>.get((req, res) -&gt; { /* handler */ })</code></td>
</tr>
<tr>
<td class=""><strong>PUT</strong></td>
<td class=""><code>.put((req, res) -&gt; { /* handler */ })</code></td>
</tr>
<tr>
<td class=""><strong>POST</strong></td>
<td class=""><code>.post((req, res) -&gt; { /* handler */ })</code></td>
</tr>
<tr>
<td class=""><strong>HEAD</strong></td>
<td class=""><code>.head((req, res) -&gt; { /* handler */ })</code></td>
</tr>
<tr>
<td class=""><strong>DELETE</strong></td>
<td class=""><code>.delete((req, res) -&gt; { /* handler */ })</code></td>
</tr>
<tr>
<td class=""><strong>TRACE</strong></td>
<td class=""><code>.trace((req, res) -&gt; { /* handler */ })</code></td>
</tr>
<tr>
<td class=""><strong>OPTIONS</strong></td>
<td class=""><code>.options((req, res) -&gt; { /* handler */ })</code></td>
</tr>
<tr>
<td class=""><em>any method</em></td>
<td class=""><code>.any((req, res) -&gt; { /* handler */ })</code></td>
</tr>
<tr>
<td class=""><em>multiple methods</em></td>
<td class=""><code>.anyOf(List.of(Http.Method.GET, Http.Method.POST), (req, res) -&gt; { /* handler */ })</code></td>
</tr>
<tr>
<td class=""><em>custom method</em></td>
<td class=""><code>.anyOf(Set.of(Http.RequestMethod.create("CUSTOM")), (req, res) -&gt; { /* handler */ })</code></td>
</tr>
</tbody>
</table>
</div>

</div>


<h3 id="_path_matcher_routing">Path Matcher Routing</h3>
<div class="section">
<p>You can combine HTTP method routing with request path matching.</p>

<markup
lang="java"

>Routing.builder()
       .post("/some/path", (req, res) -&gt; { /* handler */ })</markup>

<p>You can use <strong>path pattern</strong> instead of <em>path</em> with the following syntax:</p>

<ul class="ulist">
<li>
<p><code>/foo/bar/baz</code> - Exact path match against resolved path even with non-usual characters</p>

</li>
<li>
<p><code>/foo/{}/baz</code> - <code>{}</code> Unnamed regular expression segment <code>([^/]+)</code></p>

</li>
<li>
<p><code>/foo/{var}/baz</code> - Named regular expression segment <code>([^/]+)</code></p>

</li>
<li>
<p><code>/foo/{var:\d+}</code> - Named regular expression segment with a specified expression</p>

</li>
<li>
<p><code>/foo/{:\d+}</code> - Unnamed regular expression segment with a specified expression</p>

</li>
<li>
<p><code>/foo/{+var}</code> - Convenience shortcut for {var:.+}. A matcher is not a true URI template (as defined by RFC) but this convenience is in sync with the Apiary templates</p>

</li>
<li>
<p><code>/foo/{+}</code> - Convenience shortcut for unnamed segment with regular expression {:.+}</p>

</li>
<li>
<p><code>/foo[/bar]</code> - An optional block, which translates to the <code>/foo(/bar)?</code> regular expression</p>

</li>
<li>
<p><code>/<strong></code> or <code>/foo</strong></code> - <code>*</code> Wildcard character can be matched with any number of characters.</p>

</li>
</ul>

<div class="admonition important">
<p class="admonition-inline">Path (matcher) routing is <strong>exact</strong>. For example, a <code>/foo/bar</code> request is <strong>not</strong> routed to <code>.post('/foo', &#8230;&#8203;)</code>.</p>
</div>

<div class="admonition tip">
<p class="admonition-inline">Always start <em>path</em> and <em>path patterns</em> with the <code>/</code> character.</p>
</div>

</div>


<h3 id="anchor-requestpredicate">Request Predicate</h3>
<div class="section">
<p>Use the <code>RequestPredicate</code> utility class to identify more
criteria. You can construct (build) a predicate based on typical request criteria such as
content type, or the existence of a header
or cookie. You can also construct a handler that only processes
requests accepted by the predicate. All other requests are <em>nexted</em>, meaning that they are routed to the next valid handler.</p>

<markup
lang="java"

>.post("/foo",
      RequestPredicate.create()
                      .containsHeader("my-gr8-header")
                      .accepts(MediaType.TEXT_PLAIN)
                      .and(this::isUserAuthenticated)
                      .thenApply((req, resp) -&gt; {
                           // Some logic
                      })
                      .otherwise((req, resp) -&gt; { /* Otherwise logic */ }); // Optional. Default logic is req.next()</markup>

</div>


<h3 id="_organizing_code_into_services">Organizing Code into Services</h3>
<div class="section">
<p>By implementing the <code>Service</code> interface you can organize your code into one
or more services, each with its own path prefix and set of handlers.</p>

<markup
lang="java"
title="Use <code>Routing.Builder.register</code> to register your service"
>.register("/hello", new HelloService())</markup>

<markup
lang="java"
title="Service implementation"
>public class HelloService implements Service {
    @Override
    public void update(Routing.Rules rules) {
        rules.get("/subpath", this::getHandler);
    }

    private void getHandler(ServerRequest request,
                            ServerResponse response) {
        // Some logic
    }
}</markup>

<p>In this example, the <code>GET</code> handler matches requests to <code>/hello/subpath</code>.</p>

</div>

</div>


<h2 id="_request_handling">Request Handling</h2>
<div class="section">
<p>Implement the logic to handle requests to WebServer in a <code>Handler</code>, which is a <code>FunctionalInterface</code>.
Handlers:</p>

<ul class="ulist">
<li>
<p>Process the request and <router-link to="#anchor-sending-response" @click.native="this.scrollFix('#anchor-sending-response')">send</router-link> a response.</p>

</li>
<li>
<p>Act as a filter and forward requests to downstream handlers using the <code>request.next()</code>
method.</p>

</li>
<li>
<p>Throw an exception or call <code>request.next(exception)</code> to begin
<router-link to="#_error_handling" @click.native="this.scrollFix('#_error_handling')">error handling</router-link>.</p>

</li>
</ul>


<h3 id="_process_request_and_produce_response">Process Request and Produce Response</h3>
<div class="section">
<p>Each <code>Handler</code> has two parameters. <code>ServerRequest</code> and <code>ServerResponse</code>.</p>

<ul class="ulist">
<li>
<p>Request provides access to the request method, URI, path, query parameters,
headers and entity.</p>

</li>
<li>
<p>Response provides an ability to set response code, headers, and entity.</p>

</li>
</ul>

</div>


<h3 id="anchor-filtering">Handler as a Filter</h3>
<div class="section">
<p>The handler forwards the request to the downstream handlers by
<em>nexting</em>. There are two options:</p>

<ul class="ulist">
<li>
<p>call <code>req.next()</code></p>
<markup
lang="java"

>.any("/hello", (req, res) -&gt; { <span class="conum" data-value="1" />
    // filtering logic  <span class="conum" data-value="2" />
    req.next(); <span class="conum" data-value="3" />
})</markup>

<ul class="colist">
<li data-value="1">handler for any HTTP method using the <code>/hello</code> path</li>
<li data-value="2">business logic implementation</li>
<li data-value="3">forward the current request to the downstream handler</li>
</ul>

</li>
<li>
<p>call <code>req.next(throwable)</code> to forward the handling to the
<router-link to="#_error_handling" @click.native="this.scrollFix('#_error_handling')">error handling</router-link></p>
<markup
lang="java"

>.any("/hello", (req, res) -&gt; { <span class="conum" data-value="1" />
    // filtering logic (e.g., validating parameters) <span class="conum" data-value="2" />
    if (userParametersOk()) {
        req.next(); <span class="conum" data-value="3" />
    } else {
        req.next(new IllegalArgumentException("Invalid parameters."); <span class="conum" data-value="4" />
    }
})</markup>

<ul class="colist">
<li data-value="1">handler for any HTTP method using the <code>/hello</code> path</li>
<li data-value="2">custom logic</li>
<li data-value="3">forward the current request to the downstream handler</li>
<li data-value="4">forward the request to the error handler</li>
</ul>

</li>
</ul>

<p>The handling logic can explicitly forward the execution to a different thread.
This is the reason why returning from the handler can&#8217;t automatically
trigger calling the next handler.</p>

</div>


<h3 id="anchor-sending-response">Sending a response</h3>
<div class="section">
<p>To complete the request handling, you must send a response by calling the <code>res.send()</code> method.</p>

<markup
lang="java"

>.get("/hello", (req, res) -&gt; { <span class="conum" data-value="1" />
    // terminating logic
    res.status(Http.Status.ACCEPTED_201);
    res.send("Saved!"); <span class="conum" data-value="2" />
})</markup>

<ul class="colist">
<li data-value="1">handler that terminates the request handling for any HTTP method using the <code>/hello</code> path</li>
<li data-value="2">send the response</li>
</ul>

</div>

</div>


<h2 id="_protocol_specific_routing">Protocol Specific Routing</h2>
<div class="section">
<p>Handling routes based on the protocol version is possible by registering specific routes
on routing builder.</p>

<markup
lang="java"
title="Routing based on HTTP version"
>.routing(r -&gt; r
        .get("/any-version", (req, res) -&gt; res.send("HTTP Version " + req.version()))
        .route(Http1Route.route(GET, "/version-specific", (req, res) -&gt; res.send("HTTP/1.1 route")))
        .route(Http2Route.route(GET, "/version-specific", (req, res) -&gt; res.send("HTTP/2 route")))
)</markup>

<p>While <code>Http1Route</code> for Http/1 is always available with Helidon webserver,
other routes like <code>Http2Route</code> for <router-link to="#_http2_support" @click.native="this.scrollFix('#_http2_support')">Http/2</router-link> needs to be added as additional dependency.</p>

</div>


<h2 id="_requested_uri_discovery">Requested URI Discovery</h2>
<div class="section">
<p>Proxies and reverse proxies between an HTTP client and your Helidon application mask important information (for example <code>Host</code> header, originating IP address, protocol) about the request the client sent.
Fortunately, many of these intermediary network nodes set or update either the <a target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Forwarded">standard HTTP <code>Forwarded</code> header</a> or the <a target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For">non-standard <code>X-Forwarded-*</code> family of headers</a> to preserve information about the original client request.</p>

<p>Helidon&#8217;s requested URI discovery feature allows your application&#8212;&#8203;and Helidon itself&#8212;&#8203;to reconstruct information about the original request using the <code>Forwarded</code> header and the <code>X-Forwarded-*</code> family of headers.</p>

<p>When you prepare the connections in your server you can include the following optional requested URI discovery settings:</p>

<ul class="ulist">
<li>
<p>enabled or disabled</p>

</li>
<li>
<p>which type or types of requested URI discovery to use:</p>
<ul class="ulist">
<li>
<p><code>FORWARDED</code> - uses the <code>Forwarded</code> header</p>

</li>
<li>
<p><code>X_FORWARDED</code> - uses the <code>X-Forwarded-*</code> headers</p>

</li>
<li>
<p><code>HOST</code> - uses the <code>Host</code> header</p>

</li>
</ul>

</li>
<li>
<p>what intermediate nodes to trust</p>

</li>
</ul>

<p>When your application
invokes <code>request.requestedUri()</code>
Helidon iterates through the discovery types you set up for the receiving connection, gathering information from the corresponding header(s) for that type.
If the request does not have the corresponding header(s), or your settings do not trust the intermediate nodes reflected in those headers, then Helidon tries the next discovery type you set up.
Helidon uses the <code>HOST</code> discovery type if you do not set up discovery yourself or if, for a particular request, it cannot assemble the request information using any discovery type you did set up for the socket.</p>


<h3 id="_setting_up_requested_uri_discovery_programmatically">Setting Up Requested URI Discovery Programmatically</h3>
<div class="section">
<p>To set up requested URI discovery on the default socket for your server, use the <a target="_blank" href="./apidocs/io.helidon.reactive.webserver/io/helidon/webserver/WebServer.Builder.html"><code>WebServer.Builder</code></a>:</p>

<markup
lang="java"
title="Requested URI set-up for the default server socket"
>import io.helidon.common.configurable.AllowList;
import static io.helidon.common.http.RequestedUriDiscoveryContext.RequestedUriDiscoveryType.FORWARDED;
import static io.helidon.common.http.RequestedUriDiscoveryContext.RequestedUriDiscoveryType.X_FORWARDED;

AllowList trustedProxies = AllowList.builder()
        .addAllowedPattern(Pattern.compile("lb.+\\.mycorp\\.com"))
        .addDenied("lbtest.mycorp.com")
        .build(); <span class="conum" data-value="1" />

WebServer.Builder builder = WebServer.builder()
        .defaultSocket(s -&gt; s
                .host("localhost")
                .port(0)
                .requestedUriDiscoveryTypes(List.of(FORWARDED, X_FORWARDED)) <span class="conum" data-value="2" />
                .trustedProxies(trustedProxies)) <span class="conum" data-value="3" />
        .addRouting(yourRouting)
        .config(serverConfig);</markup>

<ul class="colist">
<li data-value="1">Create the <code>AllowList</code> describing the intermediate networks nodes to trust and not trust. Presumably the <code>lbxxx.mycorp.com</code> nodes are trusted load balancers except for the test load balancer <code>lbtest</code>, and no other nodes are trusted.
<code>AllowList</code> accepts prefixes, suffixes, predicates, regex patterns, and exact matches.
See the <a target="_blank" href="./apidocs/apidocs/io.helidon.common.configurable/io/helidon/common/configurable/AllowList.html"><code>AllowList</code></a> JavaDoc for complete information.</li>
<li data-value="2">Use <code>Forwarded</code> first, then try <code>X-Forwarded-*</code> on each request.</li>
<li data-value="3">Set the <code>AllowList</code> for trusted intermediaries.</li>
</ul>

<p>If you build your server with additional sockets, you can control requested URI discovery separately for each.</p>

</div>


<h3 id="_setting_up_requested_uri_discovery_using_configuration">Setting Up Requested URI Discovery using Configuration</h3>
<div class="section">
<p>You can
also
use configuration to set up the requested URI discovery behavior.
The following example replicates the settings assigned programmatically in the earlier code example:</p>

<markup
lang="yaml"
title="Configuring requested URI behavior"
>server:
  port: 0
  requested-uri-discovery:
    types: FORWARDED,X_FORWARDED
    trusted-proxies:
      allow:
        pattern: "lb.*\\.mycorp\\.com"
      deny:
        exact: "lbtest.mycorp.com""</markup>

</div>


<h3 id="_obtaining_the_requested_uri_information">Obtaining the Requested URI Information</h3>
<div class="section">
<p>Your code obtains the requested URI information from the Helidon server request object:</p>

<markup
lang="java"
title="Retrieving Requested URI Information"
>import io.helidon.common.http.UriInfo;

public class MyHandler implements Handler {

    @Override
    public void accept(ServerRequest req, ServerResponse res) {
        UriInfo uriInfo = req.requestedUri();
        // ...
    }
}</markup>

<p>See the <a target="_blank" href="./apidocs/io.helidon.common.http/io/helidon/common/http/UriInfo.html"><code>UriInfo</code></a> JavaDoc for more information.</p>

</div>

</div>


<h2 id="_error_handling">Error Handling</h2>
<div class="section">

<h3 id="_error_routing">Error Routing</h3>
<div class="section">
<p>You may register an error handler for a specific <code>Throwable</code> in the
<code>Routing.Builder</code> method.</p>

<markup
lang="java"

>Routing routing = Routing.builder()
                        .error(MyException.class, (req, res, ex) -&gt; { <span class="conum" data-value="1" />
                            // handle the error, set the HTTP status code
                            res.send(errorDescriptionObject); <span class="conum" data-value="2" />
                        })
                        .build</markup>

<ul class="colist">
<li data-value="1">Registers an error handler that handles <code>MyException</code> that are thrown from the
upstream handlers</li>
<li data-value="2">Finishes the request handling by sending a response</li>
</ul>

<p>Error handlers are called when</p>

<ul class="ulist">
<li>
<p>an exception is thrown from a handler</p>

</li>
<li>
<p><code>req.next(ex)</code> is called, where <code>ex</code> is an instance of <code>Throwable</code></p>

</li>
</ul>

<p>As with the standard handlers, the error handler must either</p>

<ul class="ulist">
<li>
<p>send a response</p>
<markup
lang="java"

>.error(MyException.class, (req, res, ex) -&gt; {
    res.status(Http.Status.BAD_REQUEST_400);
    res.send("Unable to parse request. Message: " + ex.getMessage());
})</markup>

</li>
<li>
<p>or, forward the error handling to the downstream error handlers</p>
<markup
lang="java"

>.error(Throwable.class, (req, res, ex) -&gt; {
    // some logic
    req.next(ex);
})</markup>

</li>
</ul>

<p>Error handling can&#8217;t be forwarded to the standard
handlers. In fact, invoking <code>req.next(ex)</code> or <code>req.next()</code> in an error handler
are equivalent.</p>

<markup
lang="java"

>.error(Throwable.class, (req, res, ex) -&gt; {
    if (condition) {
        req.next(ex); <span class="conum" data-value="1" />
    } else {
        req.next(); <span class="conum" data-value="2" />
    }
})</markup>

<ul class="colist">
<li data-value="1">Call a downstream error handler with the <code>Throwable</code> instance.</li>
<li data-value="2">Here, <code>req.next()</code> is the same as <code>req.next(ex)</code>. In both cases, the downstream error handler is called.</li>
</ul>

</div>


<h3 id="_default_error_handling">Default error handling</h3>
<div class="section">
<p>If no user-defined error handler is matched, or if the last error handler of the
exception called <code>req.next()</code>, then the exception is translated to an HTTP response as follows:</p>

<ul class="ulist">
<li>
<p>Subtypes of <code>HttpException</code> are translated to their associated HTTP error codes.</p>
<markup
lang="java"
title="Reply with the <code>406</code> HTTP error code by throwing an exception"
>(req, res) -&gt; throw new HttpException("Amount of money must be greater than 0.", Http.Status.NOT_ACCEPTABLE_406) <span class="conum" data-value="1" /></markup>

</li>
<li>
<p>Otherwise, the exceptions are translated to an Internal Server Error HTTP
error code <code>500</code>.</p>

</li>
</ul>

</div>

</div>


<h2 id="_http2_support">Http/2 Support</h2>
<div class="section">
<p>Helidon supports Http/2 upgrade from Http/1, Http/2 without prior knowledge
and Http/2 with ALPN over TLS.
Http/2 support is enabled in webserver by default when it&#8217;s artefact is available on classpath.</p>


<h3 id="_maven_coordinates">Maven Coordinates</h3>
<div class="section">
<p>To enable Http/2 support add the following dependency to your project&#8217;s <code>pom.xml</code>.</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.reactive.webserver&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-reactive-webserver-http2&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>

</div>


<h2 id="_static_content_support">Static Content Support</h2>
<div class="section">
<p>Use the <code>io.helidon.reactive.webserver.staticcontent.StaticContentSupport</code> class to serve files and classpath resources.
<code>StaticContentSupport</code> can be created for any readable directory or classpath
context root and registered on a path in <code>Routing</code>.</p>

<p>You can combine dynamic handlers with <code>StaticContentSupport</code> objects: if no file matches the request path, then the request is forwarded to
the next handler.</p>


<h3 id="_maven_coordinates_2">Maven Coordinates</h3>
<div class="section">
<p>To enable Static Content Support add the following dependency to your project&#8217;s <code>pom.xml</code>.</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.reactive.webserver&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-reactive-webserver-static-content&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h3 id="_registering_static_content">Registering Static Content</h3>
<div class="section">
<p>To register static content based on a file system (<code>/pictures</code>), and classpath (<code>/</code>):</p>

<markup
lang="java"

>Routing.builder()
       .register("/pictures", StaticContentSupport.create(Paths.get("/some/WEB/pics"))) <span class="conum" data-value="1" />
       .register("/", StaticContentSupport.builder("/static-content") <span class="conum" data-value="2" />
                                   .welcomeFileName("index.html") <span class="conum" data-value="3" />
                                   .build());</markup>

<ul class="colist">
<li data-value="1">Create a new <code>StaticContentSupport</code> object to serve data from the file system,
and associate it with the <code>"/pictures"</code> context path.</li>
<li data-value="2">Create a <code>StaticContentSupport</code> object to serve resources from the contextual
<code>ClassLoader</code>. The specific classloader can be also
defined. A builder lets you provide more configuration values.</li>
<li data-value="3"><code>index.html</code> is the file that is returned if a directory is requested.</li>
</ul>

<p>A <code>StaticContentSupport</code> object can be created using <code>create(&#8230;&#8203;)</code> factory methods or a
<code>builder</code>. The <code>builder</code> lets you provide more configuration values, including <em>welcome file-name</em>
and mappings of filename extensions to media types.</p>

</div>

</div>


<h2 id="_jersey_jax_rs_support">Jersey (JAX-RS) Support</h2>
<div class="section">

<h3 id="_maven_coordinates_3">Maven Coordinates</h3>
<div class="section">
<p>To enable Jersey (JAX-RS) Support add the following dependency to your project&#8217;s <code>pom.xml</code>.</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.reactive.webserver&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-reactive-webserver-jersey&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h3 id="_jax_rs_support">JAX-RS Support</h3>
<div class="section">
<p>You can register a Jersey (JAX-RS) application at a <em>context root</em> using the
<code>JerseySupport</code> class.</p>


<h4 id="_registering_a_jersey_application">Registering a Jersey Application</h4>
<div class="section">
<p>To register a <strong>Jersey</strong> application at a context root, use the
<code>JerseySupport</code> class and its <code>JerseySupport.Builder</code> builder.</p>

<p><code>JerseySupport</code> can register the JAX-RS resources directly.</p>

<markup
lang="java"
title="Jersey (JAX-RS) <code>HelloWorld</code> resource"
>@Path("/")
public class HelloWorld {

    @GET
    @Path("hello")
    public Response hello() {
        return Response.ok("Hello World!").build();
    }
}</markup>

<markup
lang="java"
title="Registering the <code>HelloWorld</code> resource"
>Routing.builder()
       .register("/jersey", <span class="conum" data-value="1" />
                 JerseySupport.builder()
                              .register(HelloWorld.class) <span class="conum" data-value="2" />
                              .build())
       .build();</markup>

<ul class="colist">
<li data-value="1">Register the Jersey application at <code>/jersey</code> context root</li>
<li data-value="2">The Jersey <code>Application</code> stays hidden and consists of a single <code>HelloWorld</code>
resource class</li>
</ul>

<p>As a result, an HTTP GET request to <code>/jersey/hello</code> would yield a <code>Hello World!</code>
response string.</p>


<h5 id="_registering_a_jax_rs_application">Registering a JAX-RS Application</h5>
<div class="section">
<p>You can also register the JAX-RS <code>Application</code> object.</p>

<markup
lang="java"
title="Register the <code>HelloWorld</code> resource"
>Routing.builder()
       .register("/jersey", <span class="conum" data-value="1" />
                 JerseySupport.builder(new MyApplication()) <span class="conum" data-value="2" />
                              .build())
       .build();</markup>

<ul class="colist">
<li data-value="1">Register the Jersey application at <code>/jersey</code> context root</li>
<li data-value="2"><code>MyApplication</code> handles requests made to /jersey context root.</li>
</ul>

</div>


<h5 id="_accessing_webserver_internals_from_a_jax_rs_application">Accessing WebServer Internals from a JAX-RS Application</h5>
<div class="section">
<p>You can inject WebServer request and response objects into your
JAX-RS application using <code>@Context</code>.</p>

<markup
lang="java"
title="Injection of WebServer internal objects"
>@Path("/")
@RequestScoped
public class HelloWorld {
    @Context
    private ServerRequest request;

    @Context
    private ServerResponse response;
}</markup>

</div>

</div>

</div>

</div>


<h2 id="_json_support">JSON Support</h2>
<div class="section">
<p>The WebServer supports JSON-P. When enabled, you can send and
receive JSON-P objects transparently.</p>


<h3 id="_maven_coordinates_4">Maven Coordinates</h3>
<div class="section">
<p>To enable JSON Support add the following dependency to your project&#8217;s <code>pom.xml</code>.</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.reactive.media&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-reactive-media-jsonp&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h3 id="_usage">Usage</h3>
<div class="section">
<p>To enable JSON-P support, first register it with the web server.
Then you can add routes that handle and return JSON.</p>

<markup
lang="java"
title="Configure JsonpSupport and use it for reading and writing of entities"
>JsonpSupport jsonbSupport = JsonpSupport.create(); <span class="conum" data-value="1" />
WebServer webServer = WebServer.builder()
    .addMediaSupport(jsonpSupport) <span class="conum" data-value="2" />
    .build();</markup>

<ul class="colist">
<li data-value="1">Register JsonpSupport to enable transformation from and to <code>JsonObject</code> objects</li>
<li data-value="2">Register that JsonpSupport instance to enable automatic
deserialization of Java objects from and serialization of Java objects
to JSON.</li>
</ul>

<markup
lang="java"
title="Handler that receives and returns JSON objects"
>private static final JsonBuilderFactory JSON_FACTORY = Json.createBuilderFactory(Collections.emptyMap()); <span class="conum" data-value="1" />

private void sayHello(ServerRequest req, ServerResponse res, JsonObject json) { <span class="conum" data-value="2" />
        JsonObject msg = JSON_FACTORY.createObjectBuilder()   <span class="conum" data-value="3" />
          .add("message", "Hello " + json.getString("name"))
          .build();
        res.send(msg);                            <span class="conum" data-value="4" />
}</markup>

<ul class="colist">
<li data-value="1">Using a <code>JsonBuilderFactory</code> is more efficient than <code>Json.createObjectBuilder()</code></li>
<li data-value="2">JsonObject is passed to handler</li>
<li data-value="3">Create a JsonObject using JSON-P to hold return data</li>
<li data-value="4">Send JsonObject in response</li>
</ul>

<markup
lang="bash"
title="Example of posting JSON to sayHello endpoint"
>curl --noproxy '*' -X POST -H "Content-Type: application/json" \
    http://localhost:8080/sayhello -d '{"name":"Joe"}'</markup>

<markup
lang="json"
title="Response body"
>{"message":"Hello Joe"}</markup>

</div>


<h3 id="_configuring_json_readerwriter_factories">Configuring Json Reader/Writer factories</h3>
<div class="section">
<p>To configure JSON-P <code>JsonReaderFactory</code> and <code>JsonWriterFactory</code> that are used by
the <code>JsonpSupport</code> instance, create the <code>JsonpSupport</code> object:</p>

<markup
lang="java"
title="Create <code>JsonpSupport</code> with the provided configuration"
>JsonpSupport.create(Map.of(JsonGenerator.PRETTY_PRINTING, false));</markup>

</div>

</div>


<h2 id="_json_b_support">JSON-B Support</h2>
<div class="section">
<p>The WebServer supports the <a target="_blank" href="http://json-b.net/">JSON-B
specification</a>. When this support is enabled, Java objects will be
serialized to and deserialized from JSON automatically using
<a target="_blank" href="https://github.com/eclipse-ee4j/yasson">Yasson</a>, an implementation of
the <a target="_blank" href="https://jakarta.ee/specifications/jsonb/2.0/jakarta-jsonb-spec-2.0.html">JSON-B specification</a>.</p>


<h3 id="_maven_coordinates_5">Maven Coordinates</h3>
<div class="section">
<p>To enable JSON-B Support add the following dependency to your project&#8217;s <code>pom.xml</code>.</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.reactive.media&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-reactive-media-jsonp&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h3 id="_usage_2">Usage</h3>
<div class="section">
<p>To enable JSON-B support, first create and register a
<a target="_blank" href="./apidocs/io.helidon.reactive.media.jsonb/io/helidon/reactive/media/jsonb/JsonbSupport.html"><code>JsonbSupport</code></a> instance with a
<a target="_blank" href="./apidocs/io.helidon.reactive.webserver/io/helidon/reactive/webserver/WebServer.Builder.html"><code>WebServer.Builder</code></a>.</p>

<markup
lang="java"
title="Registration of the <code>JsonbSupport</code> via <code>WebServer</code>"
>JsonbSupport jsonbSupport = JsonbSupport.create(); <span class="conum" data-value="1" />
WebServer webServer = WebServer.builder()
    .addMediaSupport(jsonbSupport) <span class="conum" data-value="2" />
    .build();</markup>

<ul class="colist">
<li data-value="1">Create a <code>JsonbSupport</code> instance.  This instance may be
reused freely.</li>
<li data-value="2">Register that <code>JsonbSupport</code> instance to enable automatic
deserialization of Java objects from and serialization of Java objects
to JSON.</li>
</ul>

<p>Now that automatic JSON serialization and deserialization facilities
have been set up, you can register a <code>Handler</code> that works with Java
objects instead of raw JSON.  Deserialization from and serialization
to JSON will be handled according to the
<a target="_blank" href="https://jcp.org/en/jsr/detail?id=367">JSON-B specification</a>.</p>

<p>Suppose you have a <code>Person</code> class that looks like this:</p>

<markup
lang="java"
title="Hypothetical <code>Person</code> class"
>public class Person {

    private String name;

    public Person() {
        super();
    }

    public String getName() {
        return this.name;
    }

    public void setName(final String name) {
        this.name = name;
    }
}</markup>

<p>Then you can set up a <code>Handler</code> like this:</p>

<markup
lang="java"
title="A <code>Handler</code> that works with Java objects instead of raw JSON"
>final Routing routing =
    routingBuilder.post("/echo", <span class="conum" data-value="1" />
                        Handler.create(Person.class, <span class="conum" data-value="2" />
                                       (req, res, person) -&gt; res.send(person)))) <span class="conum" data-value="3" />
    .build();</markup>

<ul class="colist">
<li data-value="1">Set up a route for <code>POST</code> requests using the
<a target="_blank" href="./apidocs/io.helidon.reactive.webserver/io/helidon/reactive/webserver/Routing.Builder.html#post-java.lang.String-io.helidon.reactive.webserver.Handler&#8230;&#8203;-"><code>Routing.Builder#post(String, Handler&#8230;&#8203;)</code> method</a></li>
<li data-value="2">Use the
<a target="_blank" href="./apidocs/io.helidon.reactive.webserver/io/helidon/reactive/webserver/Handler.html#create-java.lang.Class-io.helidon.reactive.webserver.Handler.EntityHandler-"><code>Handler#create(Class, Handler.EntityHandler)</code> method</a>
to install a <code>Handler.EntityHandler</code> that works with <code>Person</code> instances.</li>
<li data-value="3">This <code>Handler.EntityHandler</code> consumes a <code>Person</code> instance
(<code>person</code>) and simply echoes it back.  Note that there is no working
with raw JSON here.</li>
</ul>

<markup
lang="bash"
title="Example of posting JSON to the <code>/echo</code> endpoint"
>curl --noproxy '*' -X POST -H "Content-Type: application/json" \
    http://localhost:8080/echo -d '{"name":"Joe"}'
{"name":"Joe"}</markup>

</div>

</div>


<h2 id="_jackson_support">Jackson Support</h2>
<div class="section">
<p>The WebServer supports
<a target="_blank" href="https://github.com/FasterXML/jackson#jackson-project-home-github">Jackson</a>.
When this support is enabled, Java objects will be serialized to and
deserialized from JSON automatically using Jackson.</p>


<h3 id="_maven_coordinates_6">Maven Coordinates</h3>
<div class="section">
<p>To enable Jackson Support add the following dependency to your project&#8217;s <code>pom.xml</code>.</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.reactive.media&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-reactive-media-jackson&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h3 id="_usage_3">Usage</h3>
<div class="section">
<p>To enable Jackson support, first create and register a
<a target="_blank" href="./apidocs/io.helidon.reactive.media.jackson/io/helidon/reactive/media/jackson/JacksonSupport.html"><code>JacksonSupport</code></a>
instance with a
<a target="_blank" href="./apidocs/io.helidon.reactive.webserver/io/helidon/reactive/webserver/WebServer.Builder.html"><code>WebServer.Builder</code></a>.</p>

<markup
lang="java"
title="Registration of the <code>JacksonSupport</code> via <code>WebServer</code>"
>JacksonSupport jacksonSupport = JacksonSupport.create(); <span class="conum" data-value="1" />
WebServer webServer = WebServer.builder()
    .addMediaSupport(jacksonSupport) <span class="conum" data-value="2" />
    .build();</markup>

<ul class="colist">
<li data-value="1">Create a <code>JacksonSupport</code> instance.  This instance may be
reused freely.</li>
<li data-value="2">Register that <code>JacksonSupport</code> instance to enable automatic
deserialization of Java objects from and serialization of Java objects
to JSON.</li>
</ul>

<p>Now that automatic JSON serialization and deserialization facilities
have been set up, you can register a <code>Handler</code> that works with Java
objects instead of raw JSON.  Deserialization from and serialization
to JSON will be handled by
<a target="_blank" href="https://github.com/FasterXML/jackson#jackson-project-home-github">Jackson</a>.</p>

<p>Suppose you have a <code>Person</code> class that looks like this:</p>

<markup
lang="java"
title="Hypothetical <code>Person</code> class"
>public class Person {

    private String name;

    public Person() {
        super();
    }

    public String getName() {
        return this.name;
    }

    public void setName(final String name) {
        this.name = name;
    }
}</markup>

<p>Then you can set up a <code>Handler</code> like this:</p>

<markup
lang="java"
title="A <code>Handler</code> that works with Java objects instead of raw JSON"
>final Routing routing =
    routingBuilder.post("/echo", <span class="conum" data-value="1" />
                        Handler.create(Person.class, <span class="conum" data-value="2" />
                                       (req, res, person) -&gt; res.send(person)))) <span class="conum" data-value="3" />
    .build();</markup>

<ul class="colist">
<li data-value="1">Set up a route for <code>POST</code> requests using the
<a target="_blank" href="./apidocs/io.helidon.reactive.webserver/io/helidon/reactive/webserver/Routing.Builder.html#post-java.lang.String-io.helidon.reactive.webserver.Handler&#8230;&#8203;-"><code>Routing.Builder#post(String, Handler&#8230;&#8203;)</code> method</a></li>
<li data-value="2">Use the
<a target="_blank" href="./apidocs/io.helidon.reactive.webserver/io/helidon/reactive/webserver/Handler.html#create-java.lang.Class-io.helidon.reactive.webserver.Handler.EntityHandler-"><code>Handler#create(Class, Handler.EntityHandler)</code> method</a>
to install a <code>Handler.EntityHandler</code> that works with <code>Person</code> instances.</li>
<li data-value="3">This <code>Handler.EntityHandler</code> consumes a <code>Person</code> instance
(<code>person</code>) and simply echoes it back.  Note that there is no working
with raw JSON here.</li>
</ul>

<markup
lang="bash"
title="Example of posting JSON to the <code>/echo</code> endpoint"
>curl --noproxy '*' -X POST -H "Content-Type: application/json" \
    http://localhost:8080/echo -d '{"name":"Joe"}'</markup>

<markup
lang="json"
title="Response body"
>{"name":"Joe"}</markup>

</div>

</div>


<h2 id="_access_log">Access Log</h2>
<div class="section">
<p>Access logging in Helidon is done by a dedicated module that can be
added to WebServer and configured.</p>

<p>Access logging is a Helidon WebServer <code>Service</code> and as such is executed
in the order it is registered with WebServer routing.
This implies that if you register it last and another <code>Service</code> or
<code>Handler</code> finishes the request, the service will not be invoked.</p>

<p>To enable Access logging add the following dependency to project&#8217;s <code>pom.xml</code>:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webserver&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webserver-access-log&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>


<h3 id="_configuring_access_log_in_your_code">Configuring Access Log in your code</h3>
<div class="section">
<p>Access log is configured in your code by registering it as a service with <code>Routing</code></p>

<markup
lang="java"

>Routing.builder()
    .register(AccessLogSupport.create(config.get("server.access-log")))
    .get("/greet", myService)</markup>

<p>The order of registration is significant - make sure <code>AccessLogSupport</code> is registered first (even before security, tracing etc.).</p>

</div>


<h3 id="_configuring_access_log_in_a_configuration_file">Configuring Access Log in a configuration file</h3>
<div class="section">
<p>Access log can be configured as follows:</p>

<markup
lang="yaml"
title="Access Log configuration file"
>server:
  port: 8080
  access-log:
    format: "%h %l %u %t %r %s %b %{Referer}i"</markup>

<p>All options shown above are also available programmatically when using builder.</p>

</div>


<h3 id="_configuration_options_3">Configuration Options</h3>
<div class="section">
<p>The following configuration options can be defined:</p>


<div class="table__overflow elevation-1  flex sm10
">
<table class="datatable table">
<colgroup>
<col style="width: 18.182%;">
<col style="width: 18.182%;">
<col style="width: 18.182%;">
<col style="width: 45.455%;">
</colgroup>
<thead>
<tr>
<th>Config key</th>
<th>Default value</th>
<th>Builder method</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><code>true</code></td>
<td class=""><code>enabled(boolean)</code></td>
<td class="">When this option is set to <code>false</code>, access logging will be disabled</td>
</tr>
<tr>
<td class=""><code>logger-name</code></td>
<td class=""><code>io.helidon.webserver.AccessLog</code></td>
<td class=""><code>loggerName(String)</code></td>
<td class="">Name of the logger to use when writing log entries</td>
</tr>
<tr>
<td class=""><code>format</code></td>
<td class=""><code>helidon</code></td>
<td class=""><code>helidonLogFormat()</code>, <code>commonLogFormat()</code>, <code>add(AccessLogEntry entry)</code></td>
<td class="">Configuration of access log output,
when <code>helidon</code> is defined, the Helidon log format (see below) is used.
Can be configured to explicitly define log entries (see below as well)</td>
</tr>
<tr>
<td class=""><code>exclude-paths</code></td>
<td class="">N/A</td>
<td class=""><code>excludePaths(List&lt;String&gt;)</code></td>
<td class="">List of path patterns to exclude from access log. Path pattern syntax is as
defined in <code>io.helidon.webserver.PathMatcher</code>. Can be used to exclude
paths such as <code>/health</code> or <code>/metrics</code> to avoid cluttering log.</td>
</tr>
</tbody>
</table>
</div>

</div>


<h3 id="_supported_log_formats">Supported Log Formats</h3>
<div class="section">

<h4 id="_supported_log_entries">Supported Log Entries</h4>
<div class="section">
<p>The following log entries are supported in Helidon:</p>


<div class="table__overflow elevation-1  flex sm7
">
<table class="datatable table">
<colgroup>
<col style="width: 22.222%;">
<col style="width: 22.222%;">
<col style="width: 55.556%;">
</colgroup>
<thead>
<tr>
<th>Config format</th>
<th>Class (to use with builder)</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td class="">%h</td>
<td class=""><code>HostLogEntry</code></td>
<td class="">IP address of the remote host</td>
</tr>
<tr>
<td class="">%l</td>
<td class=""><code>UserIdLogEntry</code></td>
<td class="">Client identity, always undefined in Helidon</td>
</tr>
<tr>
<td class="">%u</td>
<td class=""><code>UserLogEntry</code></td>
<td class="">The username of logged-in user (when Security is used)</td>
</tr>
<tr>
<td class="">%t</td>
<td class=""><code>TimestampLogEntry</code></td>
<td class="">The current timestamp</td>
</tr>
<tr>
<td class="">%r</td>
<td class=""><code>RequestLineLogEntry</code></td>
<td class="">The request line (method, path and HTTP version)</td>
</tr>
<tr>
<td class="">%s</td>
<td class=""><code>StatusLogEntry</code></td>
<td class="">The HTTP status returned to the client</td>
</tr>
<tr>
<td class="">%b</td>
<td class=""><code>SizeLogEntry</code></td>
<td class="">The response entity size (if available)</td>
</tr>
<tr>
<td class="">%D</td>
<td class=""><code>TimeTakenLogEntry</code></td>
<td class="">The time taken in microseconds</td>
</tr>
<tr>
<td class="">%T</td>
<td class=""><code>TimeTakenLogEntry</code></td>
<td class="">The time taken in seconds</td>
</tr>
<tr>
<td class="">%{<code>header-name</code>}i</td>
<td class=""><code>HeaderLogEntry</code></td>
<td class="">Value of a header (can have multiple such specification to write
multiple headers)</td>
</tr>
</tbody>
</table>
</div>

<p>Currently we only support the entries defined above, with NO support for free text.</p>

</div>


<h4 id="_helidon_log_format">Helidon Log Format</h4>
<div class="section">
<p>When format is set to <code>helidon</code>, the format used is:</p>

<p><code>"%h %u %t %r %s %b %D"</code></p>

<p>The entries logged:</p>

<ol style="margin-left: 15px;">
<li>
IP Address

</li>
<li>
Username of a logged-in user

</li>
<li>
Timestamp

</li>
<li>
Request Line

</li>
<li>
HTTP Status code

</li>
<li>
Entity size

</li>
<li>
Time taken (microseconds)

</li>
</ol>

<p>Access log example:</p>

<markup
lang="listing"

>192.168.0.104 - [18/Jun/2019:22:28:55 +0200] "GET /greet/test HTTP/1.1" 200 53
0:0:0:0:0:0:0:1 - [18/Jun/2019:22:29:00 +0200] "GET /metrics/vendor HTTP/1.1" 200 1658
0:0:0:0:0:0:0:1 jack [18/Jun/2019:22:29:07 +0200] "PUT /greet/greeting HTTP/1.1" 200 21
0:0:0:0:0:0:0:1 jill [18/Jun/2019:22:29:12 +0200] "PUT /greet/greeting HTTP/1.1" 403 0
0:0:0:0:0:0:0:1 - [18/Jun/2019:22:29:17 +0200] "PUT /greet/greeting HTTP/1.1" 401 0</markup>

</div>

</div>

</div>


<h2 id="_tls_configuration">TLS Configuration</h2>
<div class="section">
<p>Configure TLS either programmatically, or by the Helidon configuration framework.</p>


<h3 id="_configuring_tls_in_your_code">Configuring TLS in your code</h3>
<div class="section">
<p>To configure TLS in WebServer programmatically create your keystore configuration and pass it to the WebServer builder.</p>

<markup
lang="java"

>KeyConfig keyConfig = KeyConfig.keystoreBuilder()
                //Whether this keystore is also trust store
                .trustStore()
                //Keystore location/name
                .keystore(Resource.create("keystore.p12"))
                //Password to the keystore
                .keystorePassphrase("password")
                .build();

WebServer.builder()
         .tls(WebServerTls.builder()
               .trust(keyConfig)
               .privateKey(keyConfig)
               .build())
         .build();</markup>

</div>

</div>


<h2 id="_tls_configuration_2">TLS configuration</h2>
<div class="section">
<p>Configure TLS either programmatically, or by the Helidon configuration framework.</p>


<h3 id="_configuring_tls_in_your_code_2">Configuring TLS in your code</h3>
<div class="section">
<p>To configure TLS in WebServer programmatically create your keystore configuration and pass it to the WebServer builder.</p>

<markup
lang="java"

>KeyConfig keyConfig = KeyConfig.keystoreBuilder()
                //Whether this keystore is also trust store
                .trustStore()
                //Keystore location/name
                .keystore(Resource.create("keystore.p12"))
                //Password to the keystore
                .keystorePassphrase("password")
                .build();

WebServer.builder()
         .tls(WebServerTls.builder()
               .trust(keyConfig)
               .privateKey(keyConfig)
               .build())
         .build();</markup>

</div>


<h3 id="_configuring_tls_in_the_config_file">Configuring TLS in the config file</h3>
<div class="section">
<p>It is also possible to configure TLS via the config file.</p>

<markup
lang="yaml"
title="WebServer TLS configuration file <code>application.yaml</code>"
>server:
  tls:
    #Truststore setup
    trust:
      keystore:
        passphrase: "password"
        trust-store: true
        resource:
          resource-path: "keystore.p12"
    #Keystore with private key and server certificate
    private-key:
      keystore:
        passphrase: "password"
        resource:
          resource-path: "keystore.p12"</markup>

<p>Then, in your application code, load the configuration from that file.</p>

<markup
lang="java"
title="WebServer initialization using the <code>application.yaml</code> file located on the classpath"
>Config config = Config.create();
WebServer webClient = WebServer.create(routing, config.get("server"));</markup>

<p>Or you can only create WebServerTls instance based on the config file.</p>

<markup
lang="java"
title="WebServerTls instance based on <code>application.yaml</code> file located on the classpath"
>Config config = Config.create();
WebServerTls.builder()
    .config(config.get("server.tls"))
    .build();</markup>

<p>This can alternatively be configured with paths to PKCS#8 PEM files rather than KeyStores:</p>

<markup
lang="yaml"
title="WebServer TLS configuration file <code>application.yaml</code>"
>server:
  tls:
    #Truststore setup
    trust:
      pem:
        certificates:
          resource:
            resource-path: "ca-bundle.pem"
    private-key:
      pem:
        key:
          resource:
            resource-path: "key.pem"
        cert-chain:
          resource:
            resource-path: "chain.pem"</markup>

</div>


<h3 id="_configuration_options_4">Configuration options</h3>
<div class="section">
<p>Type: <a target="_blank" href="./apidocs/io.helidon.reactive.webserver/io/helidon/reactive/webserver/WebServerTls.html">io.helidon.reactive.webserver.WebServerTls</a></p>


<h4 id="_configuration_options_5">Configuration options</h4>
<div class="section">
<div class="block-title"><span>Required configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>private-key</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_pki_KeyConfig">KeyConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configure private key to use for SSL context.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>cipher-suite</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Set allowed cipher suite. If an empty collection is set, an exception is thrown since
 it is required to support at least some ciphers.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>client-auth</code></td>
<td class=""><doc-view>
<p>ClientAuthentication (REQUIRE, OPTIONAL, NONE)</p>

</doc-view>
</td>
<td class=""><code>none</code></td>
<td class=""><doc-view>
<p>Configures whether client authentication will be required or not.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Can be used to disable TLS even if keys are configured.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>session-cache-size</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Set the size of the cache used for storing SSL session objects. <code>0</code> to use the
 default value.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>session-timeout-seconds</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Set the timeout for the cached SSL session objects, in seconds. <code>0</code> to use the
 default value.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>trust</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_pki_KeyConfig">KeyConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Set the trust key configuration to be used to validate certificates.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>

</div>


<h2 id="_http_compression">HTTP Compression</h2>
<div class="section">
<p>HTTP compression can improve bandwidth utilization and transfer speeds in certain scenarios. It
requires a few extra CPU cycles for compressing and uncompressing, but these can be offset
if data is transferred over low-bandwidth network links.</p>

<p>A client advertises the compression encodings it supports at request time, and the
WebServer responds by selecting an encoding it supports and setting it in a header,
effectively <em>negotiating</em> the content encoding of the response. If none of the
advertised encodings is supported by the WebServer, the response is returned
uncompressed.</p>


<h3 id="_configuring_http_compression">Configuring HTTP Compression</h3>
<div class="section">
<p>HTTP compression in the Helidon WebServer is <em>disabled</em> by default. It can sometimes interfere
with certain applications that use streaming, even if a compression encoding has not been
negotiated with the client.</p>

<p>It can be enabled either programmatically or via configuration,
and it can also be enabled on a per-socket basis. When configured at the server level, it
applies only to the <em>default</em> socket.</p>

<p>Programmatically, simply use the <code>enableCompression</code> method during server creation:</p>

<markup
lang="java"

>WebServer.builder()
         .port(8080)
         .routing(...)
         .enableCompression(true)        // compression enabled
         .build()</markup>

<p>Or use a config file as follows and make sure the WebServer is created using it:</p>

<markup
lang="yaml"
title="WebServer HTTP Compression configuration file <code>application.yaml</code>"
>server:
  port: 8080
  enable-compression: true</markup>

</div>


<h3 id="_http_compression_negotiation">HTTP Compression Negotiation</h3>
<div class="section">
<p>HTTP compression negotiation is controlled by clients using the <code>Accept-Encoding</code> header.
The value of this header is a comma-separated list of encodings. The WebServer
will select one of these encodings for compression purposes; it currently supports <code>gzip</code>
and <code>deflate</code>.</p>

<p>For example, if the request includes <code>Accept-Encoding: gzip, deflate</code>, and HTTP compression
has been enabled as shown above, the response shall include the header <code>Content-Encoding: gzip</code>
and a compressed payload.</p>

</div>

</div>


<h2 id="_quick_start">Quick Start</h2>
<div class="section">
<p>Here is the code for a minimalist web application that runs on a random free port:</p>

<markup
lang="java"

>public static void main(String[] args) {
    WebServer webServer = WebServer
            .create(Routing.builder()
                            .any((req, res) -&gt; res.send("It works!"))) <span class="conum" data-value="1" />
            .start() <span class="conum" data-value="2" />
            .await(10, TimeUnit.SECONDS); <span class="conum" data-value="3" />

    System.out.println("Server started at: http://localhost:" + webServer.port()); <span class="conum" data-value="4" />
}</markup>

<ul class="colist">
<li data-value="1">For any kind of request, at any path, respond with <code>It works!</code>.</li>
<li data-value="2">Start the server.</li>
<li data-value="3">Wait for the server to start while throwing possible errors as runtime exceptions.</li>
<li data-value="4">The server is bound to a random free port.</li>
</ul>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="./apidocs/io.helidon.reactive.webserver/module-summary.html">Helidon WebServer JavaDoc</a></p>

</li>
<li>
<p><a target="_blank" href="./apidocs/io.helidon.reactive.webserver.staticcontent/module-summary.html">Helidon WebServer Static Content JavaDoc</a></p>

</li>
<li>
<p><a target="_blank" href="./apidocs/io.helidon.reactive.webserver.jersey/module-summary.html">Helidon WebServer Jersey JavaDoc</a></p>

</li>
<li>
<p><a target="_blank" href="./apidocs/io.helidon.reactive.media.jsonp/module-summary.html">Helidon JSON-B Support JavaDoc</a></p>

</li>
<li>
<p><a target="_blank" href="./apidocs/io.helidon.reactive.media.jsonb/module-summary.html">Helidon JSON-P Support JavaDoc</a></p>

</li>
<li>
<p><a target="_blank" href="./apidocs/io.helidon.reactive.media.jackson/module-summary.html">Helidon Jackson Support JavaDoc</a></p>

</li>
</ul>

</div>

</doc-view>
