<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_configuring_the_webclient" @click.native="this.scrollFix('#_configuring_the_webclient')">Configuring the WebClient</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>WebClient is an HTTP client of Helidon SE. It handles the responses to the HTTP requests in a reactive way.</p>

<p>Helidon WebClient provides the following features:</p>

<ul class="ulist">
<li>
<p><strong>Reactive approach</strong><br>

Allows you to execute HTTP requests and handle the responses without having to wait for the server response. When the response is received, the client requests only the amount of data that it can handle at that time. So, there is no overflow of memory.</p>

</li>
<li>
<p><strong>Builder-like setup and execution</strong><br>

Creates every client and request as a builder pattern. This improves readability and code maintenance.</p>

</li>
<li>
<p><strong>Redirect chain</strong><br>

Follows the redirect chain and perform requests on the correct endpoint by itself.</p>

</li>
<li>
<p><strong>Tracing and security propagation</strong><br>

Automatically propagates the configured tracing and security settings of the Helidon WebServer to the WebClient and uses them during request and response.</p>

</li>
</ul>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable WebClient
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.reactive.webclient&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-reactive-webclient&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">

<h3 id="_creating_the_webclient">Creating the WebClient</h3>
<div class="section">
<p>You can create WebClient by executing <code>WebClient.create()</code> method. This will create an instance of client with default settings and without a base uri set.</p>

<p>To change the default settings and register
additional services, you can use simple builder that allows you to customize the client behavior.</p>

<markup
lang="java"
title="Create a WebClient with simple builder:"
>WebClient client = WebClient.builder()
        .baseUri("http://localhost")
        .build();</markup>

</div>


<h3 id="_creating_and_executing_the_webclient_request">Creating and Executing the WebClient Request</h3>
<div class="section">
<p>WebClient executes requests to the target endpoints and returns specific response type.</p>

<p>It offers variety of methods to specify the type of request you want to execute:</p>

<ul class="ulist">
<li>
<p><code>put()</code></p>

</li>
<li>
<p><code>get()</code></p>

</li>
<li>
<p><code>method(String methodName)</code></p>

</li>
</ul>

<p>These methods set specific request type based on their name or parameter to the new instance of <code>WebClientRequesBuilder</code> and return this instance based on configurations for specific request type.</p>

<p>You can set configuration for every request type before it is sent as described in <router-link to="#_request_configuration" @click.native="this.scrollFix('#_request_configuration')"></router-link>.</p>

<p>For the final execution, use the following methods with variations and different parameters:</p>

<ul class="ulist">
<li>
<p><code>Single&lt;T&gt; submit(Object entity, Class&lt;T&gt; responseType)</code></p>

</li>
<li>
<p><code>Single&lt;T&gt; request(Class&lt;T&gt; responseType)</code></p>

</li>
</ul>

<markup
lang="java"
title="Execute a simple GET request to endpoint:"
>Single&lt;String&gt; response = client.get()
        .path("/endpoint")
        .request(String.class);</markup>

</div>

</div>


<h2 id="_configuring_the_webclient">Configuring the WebClient</h2>
<div class="section">
<p>The class responsible for WebClient configuration is:</p>

<p>Configuration of the HTTP client</p>

<p>Type: <a target="_blank" href="./apidocs/io.helidon.reactive.webclient/io/helidon/reactive/webclient/WebClientConfiguration.html">io.helidon.reactive.webclient.WebClientConfiguration</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>client</code></p>


<h3 id="_configuration_options">Configuration options</h3>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>connect-timeout-millis</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class=""><code>60000</code></td>
<td class=""><doc-view>
<p>Sets new connection timeout of the request.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookies.automatic-store-enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Whether to allow automatic cookie storing</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookies.default-cookies</code></td>
<td class=""><doc-view>
<p>Map</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Default cookies to be used in each request. Each list entry has to have "name" and "value" node</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>follow-redirects</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Whether to follow any response redirections or not.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>headers</code></td>
<td class=""><doc-view>
<p>Map</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Default headers to be used in each request. Each list entry has to have "name" and "value" node</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-redirects</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>5</code></td>
<td class=""><doc-view>
<p>Sets max number of followed redirects.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>media-support</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_reactive_media_common_MediaContext">MediaContext</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>proxy</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_reactive_webclient_Proxy">Proxy</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets new request proxy.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>read-timeout-millis</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class=""><code>600000</code></td>
<td class=""><doc-view>
<p>Sets new read timeout of the response.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>relative-uris</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Can be set to <code>true</code> to force the use of relative URIs in all requests,
 regardless of the presence or absence of proxies or no-proxy lists.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>tls</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_reactive_webclient_WebClientTls">WebClientTls</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>New TLS configuration.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>uri</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Base uri for each request.</p>

<pre>@return updated builder instance</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>user-agent</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Name of the user agent which should be used.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>


<h3 id="_example_of_a_webclient_runtime_configuration">Example of a WebClient Runtime Configuration</h3>
<div class="section">
<markup
lang="java"

>Config config = Config.create();
WebClient client = WebClient.builder()
        .baseUri("http://localhost")
        .config(config.get("client"))
        .build();</markup>

</div>


<h3 id="_example_of_a_webclient_yaml_configuration">Example of a WebClient YAML Configuration</h3>
<div class="section">
<markup
lang="java"

>client:
  connect-timeout-millis: 2000
  read-timeout-millis: 2000
  follow-redirects: true <span class="conum" data-value="1" />
  max-redirects: 5
  cookies:
    automatic-store-enabled: true
    default-cookies:
      - name: "env"
        value: "dev"
  headers:
    - name: "Accept"
      value: ["application/json","text/plain"] <span class="conum" data-value="2" />
  services: <span class="conum" data-value="3" />
    config:
      metrics:
        - methods: ["PUT", "POST", "DELETE"]
        - type: METER
          name-format: "client.meter.overall"
        - type: TIMER
          # meter per method
          name-format: "client.meter.%1$s"
        - methods: ["GET"]
          type: COUNTER
          errors: false
          name-format: "client.counter.%1$s.success"
          description: "Counter of successful GET requests"
        - methods: ["PUT", "POST", "DELETE"]
          type: COUNTER
          success: false
          name-format: "wc.counter.%1$s.error"
          description: "Counter of failed PUT, POST and DELETE requests"
        - methods: ["GET"]
          type: GAUGE_IN_PROGRESS
          name-format: "client.inprogress.%2$s"
          description: "In progress requests to host"
      tracing:
  proxy: <span class="conum" data-value="4" />
    use-system-selector: false
    host: "hostName"
    port: 80
    no-proxy: ["localhost:8080", ".helidon.io", "192.168.1.1"]
  tls: <span class="conum" data-value="5" />
    server:
      trust-all: true
      disable-hostname-verification: true
      keystore:
        passphrase: "password"
        trust-store: true
        resource:
          resource-path: "client.p12"
    client:
      keystore:
        passphrase: "password"
        resource:
          resource-path: "client.p12"</markup>

<ul class="colist">
<li data-value="1">Client functional settings</li>
<li data-value="2">Default client headers and cookies</li>
<li data-value="3">Client service configuration</li>
<li data-value="4">Proxy configuration</li>
<li data-value="5">TLS configuration</li>
</ul>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">

<h3 id="_request_configuration">Request Configuration</h3>
<div class="section">
<p>The request settings are based on the following optional parameters, and change when a specific request is executed.</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Parameter</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>uri("http://example.com")</code></td>
<td class="">Overrides baseUri from WebClient</td>
</tr>
<tr>
<td class=""><code>path("/path")</code></td>
<td class="">Adds path to the uri</td>
</tr>
<tr>
<td class=""><code>queryParam("query", "parameter")</code></td>
<td class="">Adds query parameter to the request</td>
</tr>
<tr>
<td class=""><code>fragment("someFragment")</code></td>
<td class="">Adds fragment to the request</td>
</tr>
<tr>
<td class=""><code>headers(headers &#8594; headers.addAccept(MediaType.APPLICATION_JSON))</code></td>
<td class="">Adds header to the request</td>
</tr>
</tbody>
</table>
</div>

<p><code>WebClientRequestBuilder</code> class also provides specific header methods that help the user to set a particular header. The methods are:</p>

<ul class="ulist">
<li>
<p><code>contentType</code> (MediaType contentType)</p>

</li>
<li>
<p><code>accept</code> (MediaType&#8230;&#8203; mediaTypes)</p>

</li>
</ul>

<p>For more details, see the <a target="_blank" href="./apidocs/io.helidon.reactive.webserver/io/helidon/reactive/webserver/RequestHeaders.html">Request Headers</a> API.</p>

</div>


<h3 id="_adding_json_processing_media_support_to_the_webclient">Adding JSON Processing Media Support to the WebClient</h3>
<div class="section">
<p>JSON Processing (JSON-P) media support is not present in the WebClient by default. So, in this case, you must first register it before making a request.
This example shows how to register <code>JsonpSupport</code> using the following two methods.</p>

<markup
lang="java"
title="Register JSON-P support to the WebClient."
>WebClient.builder()
        .baseUri("http://localhost")
        .addReader(JsonpSupport.reader()) <span class="conum" data-value="1" />
        .addWriter(JsonpSupport.writer()) <span class="conum" data-value="2" />
        .addMediaService(JsonpSupport.create()) <span class="conum" data-value="3" />
        .build();</markup>

<ul class="colist">
<li data-value="1">Adds JSON-P reader to all client requests.</li>
<li data-value="2">Adds JSON-P writer to all client requests.</li>
<li data-value="3">Adds JSON-P writer and reader to all client requests.</li>
</ul>

<markup
lang="java"
title="Register JSON-P support only to the specific request."
>WebClient webClient = WebClient.create();

WebClientRequestBuilder requestBuilder = webClient.get();
requestBuilder.writerContext().registerWriter(JsonSupport.writer()); <span class="conum" data-value="1" />
requestBuilder.readerContext().registerReader(JsonSupport.reader()); <span class="conum" data-value="2" />

requestBuilder.request(JsonObject.class)</markup>

<ul class="colist">
<li data-value="1">Adds JSON-P writer only to this request.</li>
<li data-value="2">Adds JSON-P reader only to this request.</li>
</ul>

</div>


<h3 id="_webclient_tls_setup">WebClient TLS setup</h3>
<div class="section">
<p>Configure TLS either programmatically or by the Helidon configuration framework.</p>


<h4 id="_configuring_tls_in_your_code">Configuring TLS in your code</h4>
<div class="section">
<p>One way to configure TLS in WebClient is in your application code as shown below.</p>

<markup
lang="java"

>KeyConfig keyConfig = KeyConfig.keystoreBuilder()
                //Whether this keystore is also trust store
                .trustStore()
                //Keystore location/name
                .keystore(Resource.create("client.p12"))
                //Password to the keystore
                .keystorePassphrase("password")
                .build();

WebClient.builder()
         .tls(WebClientTls.builder()
               .certificateTrustStore(keyConfig)
               .clientKeyStore(keyConfig)
               .build())
         .build();</markup>

</div>


<h4 id="_configuring_tls_in_the_config_file">Configuring TLS in the config file</h4>
<div class="section">
<p>Another way to configure TLS in WebClient is through the <code>application.yaml</code> configuration file.</p>

<markup
lang="yaml"
title="WebClient TLS configuration file <code>application.yaml</code>"
>webclient:
  tls:
    #Server part defines settings for server certificate validation and truststore
    server:
      keystore:
        passphrase: "password"
        trust-store: true
        resource:
          resource-path: "keystore.p12"
    #Client part defines access to the keystore with client private key or certificate
    client:
      keystore:
        passphrase: "password"
        resource:
          resource-path: "keystore.p12"</markup>

<p>Then, in your application code, load the configuration from that file.</p>

<markup
lang="java"
title="WebClient initialization using the <code>application.yaml</code> file located on the classpath"
>Config config = Config.create();
WebClient webClient = WebClient.create(config.get("webclient"));</markup>

<p>Or you can only create WebClientTls instance based on the config file.</p>

<markup
lang="java"
title="WebClientTls instance based on <code>application.yaml</code> file located on the classpath"
>Config config = Config.create();
WebClientTls.builder()
    .config(config.get("webclient.tls"))
    .build();</markup>

</div>

</div>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://helidon.io/docs/v2/apidocs/io.helidon.reactive.webclient/module-summary.html">Helidon WebClient JavaDoc</a></p>

</li>
</ul>

</div>

</doc-view>
