<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#_span_propagation" @click.native="this.scrollFix('#_span_propagation')">Span Propagation</router-link></p>

</li>
<li>
<p><router-link to="#zipkin-tracing" @click.native="this.scrollFix('#zipkin-tracing')">Zipkin Tracing</router-link></p>

</li>
<li>
<p><router-link to="#jaeger-tracing" @click.native="this.scrollFix('#jaeger-tracing')">Jaeger Tracing</router-link></p>

</li>
</ul>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Distributed tracing is a critical feature of micro-service based applications, since it traces workflow both
within a service and across multiple services. This provides insight to sequence and timing data for specific blocks of work,
which helps you identify performance and operational issues.
Helidon includes support for distributed tracing through its own API, backed by either
through the <a target="_blank" href="https://opentelemetry.io/docs/instrumentation/js/api/tracing/">OpenTelemetry API</a>, or by
<a target="_blank" href="https://opentracing.io">OpenTracing API</a>. Tracing is integrated with WebServer, gRPC Server,
and Security.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable Helidon Tracing
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.tracing&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-tracing&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>This section explains a few concepts that you need to understand before you get started with tracing.</p>

<ul class="ulist">
<li>
<p>In the context of this document, a <em>service</em> is synonymous with an application.</p>

</li>
<li>
<p>A <em>span</em> is the basic unit of work done within a single service, on a single host.
Every span has a name, starting timestamp, and duration.
For example, the work done by a REST endpoint is a span.
A span is associated to a single service, but its descendants can belong to different services and hosts.</p>

</li>
<li>
<p>A <em>trace</em> contains a collection of spans from one or more services, running on one or more hosts. For example,
if you trace a service endpoint that calls another service, then the trace would contain spans from both services.
Within a trace, spans are organized as a directed acyclic graph (DAG) and
can belong to multiple services, running on multiple hosts.</p>

</li>
</ul>

<p>Support for specific tracers is abstracted. Your application can depend on
the Helidon abstraction layer and provide a specific tracer implementation as a Java
<code>ServiceLoader</code> service.
Helidon provides such an implementation for:</p>

<ul class="ulist">
<li>
<p>OpenTracing tracers, either using the <code>GlobalTracer</code>, provider resolver approach, or explicitly using Zipkin tracer</p>

</li>
<li>
<p>OpenTelemetry tracers, either using the global OpenTelemetry instance, or explicitly using Jaeger tracer</p>

</li>
</ul>


<h3 id="_setup_webserver">Setup WebServer</h3>
<div class="section">
<markup
lang="java"
title="Configuring OpenTracing <code>Tracer</code>"
>WebServer.builder()
         .tracer(TracerBuilder.create("my-application")                    <span class="conum" data-value="1" />
                       .collectorUri(URI.create("http://10.0.0.18:9411"))  <span class="conum" data-value="2" />
                       .build())
         .build()</markup>

<ul class="colist">
<li data-value="1">The name of the application (service) to associate with the tracing events</li>
<li data-value="2">The endpoint for tracing events, specific to the tracer used, usually loaded from Config</li>
</ul>

</div>


<h3 id="_setup_grpc_server">Setup gRPC Server</h3>
<div class="section">
<markup
lang="java"
title="Configuring <code>Tracer</code>"
>Tracer tracer = TracerBuilder.create("Server")
        .collectorUri(URI.create("http://10.0.0.18:9411"))   <span class="conum" data-value="1" />
        .build();</markup>

<ul class="colist">
<li data-value="1">If using zipkin tracing system, the endpoint would be: <code><a target="_blank" href="http://10.0.0.18:9411/api/v2/spans" class="bare">http://10.0.0.18:9411/api/v2/spans</a></code></li>
</ul>

<markup
lang="java"
title="Configuring Tracing Attributes"
>GrpcTracingConfig tracingConfig = new GrpcTracingConfig.Builder()
                .withStreaming()
                .withVerbosity()
                .withTracedAttributes(ServerRequestAttribute.CALL_ATTRIBUTES,
                     ServerRequestAttribute.HEADERS,
                     ServerRequestAttribute.METHOD_NAME)
                .build();</markup>

<markup
lang="java"
title="Configuring gRPC Server"
>GrpcServerConfiguration serverConfig = GrpcServerConfiguration.builder().port(0)
                .tracer(tracer)
                .tracingConfig(tracingConfig)
                .build();</markup>

</div>


<h3 id="_creating_custom_spans">Creating custom spans</h3>
<div class="section">
<p>To create a custom span that is a child of the WebServer request:</p>

<markup
lang="java"

>Span span = request.tracer()
        .buildSpan("my-operation")
        .asChildOf(request.spanContext())
                         .start();</markup>

</div>


<h3 id="_helidon_spans">Helidon Spans</h3>
<div class="section">

</div>

</div>


<h2 id="_traced_spans">Traced spans</h2>
<div class="section">
<p>The following table lists all spans traced by Helidon components:</p>


<div class="table__overflow elevation-1  flex sm10
">
<table class="datatable table">
<colgroup>
<col style="width: 25%;">
<col style="width: 25%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>component</th>
<th>span name</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>web-server</code></td>
<td class=""><code>HTTP Request</code></td>
<td class="">The overall span of the Web Server from request initiation until response
Note that in <code>Zipkin</code> the name is replaced with <code>jax-rs</code> span name if <code>jax-rs</code> tracing
is used.</td>
</tr>
<tr>
<td class=""><code>web-server</code></td>
<td class=""><code>content-read</code></td>
<td class="">Span for reading the request entity</td>
</tr>
<tr>
<td class=""><code>web-server</code></td>
<td class=""><code>content-write</code></td>
<td class="">Span for writing the response entity</td>
</tr>
<tr>
<td class=""><code>security</code></td>
<td class=""><code>security</code></td>
<td class="">Processing of request security</td>
</tr>
<tr>
<td class=""><code>security</code></td>
<td class=""><code>security:atn</code></td>
<td class="">Span for request authentication</td>
</tr>
<tr>
<td class=""><code>security</code></td>
<td class=""><code>security:atz</code></td>
<td class="">Span for request authorization</td>
</tr>
<tr>
<td class=""><code>security</code></td>
<td class=""><code>security:response</code></td>
<td class="">Processing of response security</td>
</tr>
<tr>
<td class=""><code>security</code></td>
<td class=""><code>security:outbound</code></td>
<td class="">Processing of outbound security</td>
</tr>
<tr>
<td class=""><code>jax-rs</code></td>
<td class="">A generated name</td>
<td class="">Span for the resource method invocation, name is generated from class and method name</td>
</tr>
<tr>
<td class=""><code>jax-rs</code></td>
<td class=""><code>jersey-client-call</code></td>
<td class="">Span for outbound client call</td>
</tr>
</tbody>
</table>
</div>

<p>Some of these spans <code>log</code> to the span. These log events can be (in most cases) configured:</p>


<div class="table__overflow elevation-1  flex sm10
">
<table class="datatable table">
<colgroup>
<col style="width: 20%;">
<col style="width: 20%;">
<col style="width: 20%;">
<col style="width: 40%;">
</colgroup>
<thead>
<tr>
<th>span name</th>
<th>log name</th>
<th>configurable</th>
<th>enabled by default</th>
</tr>
</thead>
<tbody>
<tr>
<td class="">description</td>
<td class=""><code>HTTP Request</code></td>
<td class=""><code>handler.class</code></td>
<td class="">YES</td>
</tr>
<tr>
<td class="">YES</td>
<td class="">Each handler has its class and event logged</td>
<td class=""><code>security</code></td>
<td class=""><code>status</code></td>
</tr>
<tr>
<td class="">YES</td>
<td class="">YES</td>
<td class="">Logs either "status: PROCEED" or "status: DENY"</td>
<td class=""><code>security:atn</code></td>
</tr>
<tr>
<td class=""><code>security.user</code></td>
<td class="">YES</td>
<td class="">NO</td>
<td class="">The username of the user if logged in</td>
</tr>
<tr>
<td class=""><code>security:atn</code></td>
<td class=""><code>security.service</code></td>
<td class="">YES</td>
<td class="">NO</td>
</tr>
<tr>
<td class="">The name of the service if logged in</td>
<td class=""><code>security:atn</code></td>
<td class=""><code>status</code></td>
<td class="">YES</td>
</tr>
<tr>
<td class="">YES</td>
<td class="">Logs the status of security response (such as <code>SUCCESS</code>)</td>
<td class=""><code>security:atz</code></td>
<td class=""><code>status</code></td>
</tr>
<tr>
<td class="">YES</td>
<td class="">YES</td>
<td class="">Logs the status of security response (such as <code>SUCCESS</code>)</td>
<td class=""><code>security:outbound</code></td>
</tr>
<tr>
<td class=""><code>status</code></td>
<td class="">YES</td>
<td class="">YES</td>
<td class="">Logs the status of security response (such as <code>SUCCESS</code>)</td>
</tr>
</tbody>
</table>
</div>

<p>There are also tags that are set by Helidon components. These are not configurable.</p>


<div class="table__overflow elevation-1  flex sm10
">
<table class="datatable table">
<colgroup>
<col style="width: 25%;">
<col style="width: 25%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>span name</th>
<th>tag name</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>HTTP Request</code></td>
<td class=""><code>component</code></td>
<td class="">name of the component - <code>helidon-reactive-webserver</code>, or <code>jaxrs</code> when using MP</td>
</tr>
<tr>
<td class=""><code>HTTP Request</code></td>
<td class=""><code>http.method</code></td>
<td class="">HTTP method of the request, such as <code>GET</code>, <code>POST</code></td>
</tr>
<tr>
<td class=""><code>HTTP Request</code></td>
<td class=""><code>http.status_code</code></td>
<td class="">HTTP status code of the response</td>
</tr>
<tr>
<td class=""><code>HTTP Request</code></td>
<td class=""><code>http.url</code></td>
<td class="">The path of the request (for SE without protocol, host and port)</td>
</tr>
<tr>
<td class=""><code>HTTP Request</code></td>
<td class=""><code>error</code></td>
<td class="">If the request ends in error, this tag is set to <code>true</code>, usually accompanied by logs with details</td>
</tr>
<tr>
<td class=""><code>content-read</code></td>
<td class=""><code>requested.type</code></td>
<td class="">Type (class) of the requested entity (if entity is read)</td>
</tr>
<tr>
<td class=""><code>content-write</code></td>
<td class=""><code>response.type</code></td>
<td class="">Type (class) of the entity being sent (if entity is sent)</td>
</tr>
<tr>
<td class=""><code>security</code></td>
<td class=""><code>security.id</code></td>
<td class="">ID of the security context created for this request (if security is used)</td>
</tr>
<tr>
<td class=""><code>jersey-client-call</code></td>
<td class=""><code>http.method</code></td>
<td class="">HTTP method of the client request</td>
</tr>
<tr>
<td class=""><code>jersey-client-call</code></td>
<td class=""><code>http.status_code</code></td>
<td class="">HTTP status code of client response</td>
</tr>
<tr>
<td class=""><code>jersey-client-call</code></td>
<td class=""><code>http.url</code></td>
<td class="">Full URL of the request (such as <code><a target="_blank" href="http://localhost:8080/greet" class="bare">http://localhost:8080/greet</a></code>)</td>
</tr>
</tbody>
</table>
</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>The following configuration should be supported by all tracer implementations (if feasible)</p>

<p>Jaeger tracer configuration.</p>

<p>Type: <a target="_blank" href="./apidocs/io.helidon.tracing/io/helidon/tracing/Tracer.html">io.helidon.tracing.Tracer</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>tracing</code></p>

</div>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>boolean-tags</code></td>
<td class=""><doc-view>
<p>Map&lt;string, boolean&gt;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Tracer level tags that get added to all reported spans.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>client-cert-pem</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Certificate of client in PEM format.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>When enabled, tracing will be sent. If enabled is false, tracing should
 use a no-op tracer.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>exporter-timeout-millis</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>10000</code></td>
<td class=""><doc-view>
<p>Timeout of exporter requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>global</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>When enabled, the created instance is also registered as a global tracer.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>host</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Host to use to connect to tracing collector.
 Default is defined by each tracing integration.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>int-tags</code></td>
<td class=""><doc-view>
<p>Map&lt;string, int&gt;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Tracer level tags that get added to all reported spans.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>path</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Path on the collector host to use when sending data to tracing collector.
 Default is defined by each tracing integration.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>port</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Port to use to connect to tracing collector.
 Default is defined by each tracing integration.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>private-key-pem</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Private key in PEM format.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>protocol</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Protocol to use (such as <code>http</code> or <code>https</code>) to connect to tracing collector.
 Default is defined by each tracing integration.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sampler-param</code></td>
<td class=""><doc-view>
<p>Number</p>

</doc-view>
</td>
<td class=""><code>1</code></td>
<td class=""><doc-view>
<p>The sampler parameter (number).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sampler-type</code></td>
<td class=""><doc-view>
<p>SamplerType (CONSTANT, RATIO)</p>

</doc-view>
</td>
<td class=""><code>CONSTANT</code></td>
<td class=""><doc-view>
<p>Sampler type.</p>

<pre>See &lt;a href="https://www.jaegertracing.io/docs/latest/sampling/#client-sampling-configuration"&gt;Sampler types&lt;/a&gt;.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>service</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Service name of the traced service.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>tags</code></td>
<td class=""><doc-view>
<p>Map&lt;string, string&gt;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Tracer level tags that get added to all reported spans.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>trusted-cert-pem</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Trusted certificates in PEM format.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>


<h3 id="_traced_spans_configuration">Traced spans configuration</h3>
<div class="section">
<p>Each component and its spans can be configured using Config.
The traced configuration has the following layers:</p>

<ul class="ulist">
<li>
<p><code>TracingConfig</code> - the overall configuration of traced components of Helidon</p>

</li>
<li>
<p><code>ComponentTracingConfig</code> - a component of Helidon that traces spans (such as <code>web-server</code>, <code>security</code>, <code>jax-rs</code>)</p>

</li>
<li>
<p><code>SpanTracingConfig</code> - a single traced span within a component (such as <code>security:atn</code>)</p>

</li>
<li>
<p><code>SpanLogTracingConfig</code> - a single log event on a span (such as <code>security.user</code> in span <code>security:atn</code>)</p>

</li>
</ul>

<p>The components using tracing configuration use the
<code>TracingConfigUtil</code>. This uses the <code>io.helidon.common.Context</code> to retrieve
current configuration.</p>


<h4 id="_configuration_using_builder">Configuration using builder</h4>
<div class="section">
<p>Builder approach, example that disables a single span log event:</p>

<markup
lang="java"
title="Configure tracing using a builder"
>TracingConfig.builder()
     .addComponent(ComponentTracingConfig.builder("web-server")
             .addSpan(SpanTracingConfig.builder("HTTP Request")
                     .addSpanLog(SpanLogTracingConfig.builder("content-write").enabled(false).build())
                     .build())
             .build())
     .build()</markup>

</div>


<h4 id="_configuration_using_helidon_config">Configuration using Helidon Config</h4>
<div class="section">
<p>Tracing configuration can be defined in a config file.</p>

<markup
lang="yaml"
title="Tracing configuration"
>tracing:
    components:
      web-server:
        spans:
          - name: "HTTP Request"
            logs:
              - name: "content-write"
                enabled: false</markup>

<markup
lang="java"
title="Use the configuration in web server"
>routing.register(WebTracingConfig.create(config.get("tracing")));</markup>

</div>


<h4 id="_path_based_configuration_in_helidon_web_server">Path based configuration in Helidon Web Server</h4>
<div class="section">
<p>For Web Server we have a path based support for configuring tracing, in addition
to the configuration described above.</p>

<p>Configuration of path can use any path string supported by the
Web Server. The configuration itself has the same possibilities
 as traced configuration described above. The path specific configuration
 will be merged with global configuration (path is the "newer" configuration, global is the "older")</p>

<markup
lang="yaml"
title="Configuration in YAML"
>tracing:
  paths:
    - path: "/favicon.ico"
      enabled: false
    - path: "/metrics"
      enabled: false
    - path: "/health"
      enabled: false
    - path: "/greet"
      components:
        web-server:
          spans:
          - name: "content-read"
            new-name: "read"
            enabled: false</markup>

<markup
lang="java"
title="Configuration with Web Server"
>routingBuilder.register(WebTracingConfig.create(config.get("tracing"));</markup>

<markup
lang="java"
title="Configuration with Web Server using a builder"
>routingBuilder.register(WebTracingConfig.builder()
    .addPathConfig(PathTracingConfig.builder()
        .path("/metrics")
        .tracingConfig(TracingConfig.DISABLED)
        .build();
    .build());</markup>

</div>


<h4 id="_renaming_top_level_span_using_request_properties">Renaming top level span using request properties</h4>
<div class="section">
<p>To have a nicer overview in search pane of a tracer, you can customize the top-level span name using configuration.</p>

<p>Example:</p>

<markup
lang="yaml"
title="Configuration in YAML"
>tracing:
  components:
    web-server:
      spans:
      - name: "HTTP Request"
        new-name: "HTTP %1$s %2$s"</markup>

<p>This is supported ONLY for the span named "HTTP Request" on component "web-server".</p>

<p>Parameters provided:</p>

<ol style="margin-left: 15px;">
<li>
Method - HTTP method

</li>
<li>
Path - path of the request (such as '/greet')

</li>
<li>
Query - query of the request (may be null)

</li>
</ol>

</div>

</div>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">

<h3 id="_span_propagation">Span Propagation</h3>
<div class="section">
<p>Span propagation is supported with Helidon WebClient (and with Jersey client, though it is blocking and not suitable for
reactive implementations).
Tracing propagation is automatic as long as the current span context is available in Helidon Context
(which is automatic when running within a WebServer request).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.reactive.webclient&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-reactive-webclient&lt;/artifactId&gt;
&lt;/dependency&gt;
&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.reactive.webclient&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-reactive-webclient-tracing&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<markup
lang="java"
title="Tracing propagation with Helidon WebClient"
>WebClient client = WebClient.builder()
    .addService(WebClientTracing.create())
    .build();

Single&lt;String&gt; response = client.get()
    .uri(uri)
    .request(String.class);</markup>

</div>


<h3 id="zipkin-tracing">Zipkin Tracing</h3>
<div class="section">
<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.tracing&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-tracing-zipkin&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>

</div>


<h2 id="_configuring_zipkin">Configuring Zipkin</h2>
<div class="section">
<p>Zipkin tracer configuration</p>

<p>Type: io.opentracing.Tracer</p>

<p>This is a standalone configuration type, prefix from configuration root: <code>tracing</code></p>

</div>


<h2 id="_configuration_options_2">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>api-version</code></td>
<td class=""><doc-view>
<p>Version (V1, V2)</p>

</doc-view>
</td>
<td class=""><code>V2</code></td>
<td class=""><doc-view>
<p>Version of Zipkin API to use.
 Defaults to Version#V2.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>boolean-tags</code></td>
<td class=""><doc-view>
<p>Map&lt;string, boolean&gt;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Tracer level tags that get added to all reported spans.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>When enabled, tracing will be sent. If enabled is false, tracing should
 use a no-op tracer.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>global</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>When enabled, the created instance is also registered as a global tracer.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>host</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Host to use to connect to tracing collector.
 Default is defined by each tracing integration.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>int-tags</code></td>
<td class=""><doc-view>
<p>Map&lt;string, int&gt;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Tracer level tags that get added to all reported spans.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>path</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Path on the collector host to use when sending data to tracing collector.
 Default is defined by each tracing integration.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>port</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Port to use to connect to tracing collector.
 Default is defined by each tracing integration.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>protocol</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Protocol to use (such as <code>http</code> or <code>https</code>) to connect to tracing collector.
 Default is defined by each tracing integration.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>service</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Service name of the traced service.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>tags</code></td>
<td class=""><doc-view>
<p>Map&lt;string, string&gt;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Tracer level tags that get added to all reported spans.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<p>The following is an example of a Zipkin configuration, specified in the YAML format.</p>

<markup
lang="yaml"

>tracing:
  zipkin:
    service: "helidon-service"
    protocol: "https"
    host: "zipkin"
    port: 9987
    api-version: 1
    # this is the default path for API version 2
    path: "/api/v2/spans"
    tags:
      tag1: "tag1-value"
      tag2: "tag2-value"
    boolean-tags:
      tag3: true
      tag4: false
    int-tags:
      tag5: 145
      tag6: 741</markup>

<p>Example of Zipkin trace:</p>



<v-card>
<v-card-text class="overflow-y-hidden" style="text-align:center">
<img src="./images/webserver/zipkin.png" alt="Zipkin example" />
</v-card-text>
</v-card>



<h3 id="jaeger-tracing">Jaeger Tracing</h3>
<div class="section">
<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.tracing&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-tracing-jaeger&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>

</div>


<h2 id="_configuring_jaeger">Configuring Jaeger</h2>
<div class="section">
<p>Jaeger tracer configuration.</p>

<p>Type: <a target="_blank" href="./apidocs/io.helidon.tracing/io/helidon/tracing/Tracer.html">io.helidon.tracing.Tracer</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>tracing</code></p>

</div>


<h2 id="_configuration_options_3">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>boolean-tags</code></td>
<td class=""><doc-view>
<p>Map&lt;string, boolean&gt;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Tracer level tags that get added to all reported spans.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>client-cert-pem</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Certificate of client in PEM format.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>When enabled, tracing will be sent. If enabled is false, tracing should
 use a no-op tracer.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>exporter-timeout-millis</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>10000</code></td>
<td class=""><doc-view>
<p>Timeout of exporter requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>global</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>When enabled, the created instance is also registered as a global tracer.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>host</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Host to use to connect to tracing collector.
 Default is defined by each tracing integration.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>int-tags</code></td>
<td class=""><doc-view>
<p>Map&lt;string, int&gt;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Tracer level tags that get added to all reported spans.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>path</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Path on the collector host to use when sending data to tracing collector.
 Default is defined by each tracing integration.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>port</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Port to use to connect to tracing collector.
 Default is defined by each tracing integration.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>private-key-pem</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Private key in PEM format.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>protocol</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Protocol to use (such as <code>http</code> or <code>https</code>) to connect to tracing collector.
 Default is defined by each tracing integration.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sampler-param</code></td>
<td class=""><doc-view>
<p>Number</p>

</doc-view>
</td>
<td class=""><code>1</code></td>
<td class=""><doc-view>
<p>The sampler parameter (number).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sampler-type</code></td>
<td class=""><doc-view>
<p>SamplerType (CONSTANT, RATIO)</p>

</doc-view>
</td>
<td class=""><code>CONSTANT</code></td>
<td class=""><doc-view>
<p>Sampler type.</p>

<pre>See &lt;a href="https://www.jaegertracing.io/docs/latest/sampling/#client-sampling-configuration"&gt;Sampler types&lt;/a&gt;.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>service</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Service name of the traced service.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>tags</code></td>
<td class=""><doc-view>
<p>Map&lt;string, string&gt;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Tracer level tags that get added to all reported spans.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>trusted-cert-pem</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Trusted certificates in PEM format.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<p>The following is an example of a Jaeger configuration, specified in the YAML format.</p>

<markup
lang="yaml"

>tracing:
    service: "helidon-full-http"
    protocol: "https"
    host: "jaeger"
    port: 14240</markup>


<h3 id="jaeger-tracing-metrics">Jaeger Tracing Metrics</h3>
<div class="section">
<p>As the <router-link to="#jaeger-tracing" @click.native="this.scrollFix('#jaeger-tracing')">Jaeger Tracing</router-link> section describes, you can use Jaeger tracing in your Helidon application.</p>

</div>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://opentracing.io/">Opentracing Project</a></p>

</li>
<li>
<p><a target="_blank" href="https://opentelemetry.io/docs/instrumentation/js/api/tracing/">OpenTelemetry API</a></p>

</li>
</ul>

</div>

</doc-view>
