<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>SmallRye offers an <a target="_blank" href="https://github.com/smallrye/smallrye-open-api/tree/2.1.16/ui/open-api-ui">OpenAPI user interface component</a> which displays a web page based on your application&#8217;s OpenAPI document.
Through that UI, users can invoke the operations declared in the document.
While not generally suitable for end-users, the OpenAPI UI can be useful for demonstrating and "test driving" your service&#8217;s endpoints.</p>

<p>The Helidon OpenAPI component allows you to integrate the SmallRye UI into your application, adding the UI web page to your application very simply.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable Helidon OpenAPI UI support
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.integrations.openapi-ui&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-integrations-openapi-ui&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>Also, make sure your project has the following dependency.</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.openapi&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-openapi&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>This dependency allows your application to create, configure, and register the <code>OpenAPISupport</code> service.</p>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>Make sure your application creates a Helidon <code>OpenAPISupport</code> instance and registers it for routing (described in detail in <a target="_blank" href="/ci/workspace/elidon-main_release-4.0.0-ALPHA6/docs/se/openapi/../../se/openapi/openapi.adoc">the Helidon OpenAPI documentation</a>). <code>OpenAPISupport</code> automatically prepares the OpenAPI UI with default settings if you also declare a dependency on the Helidon OpenAPI UI integration component as explained above. The <router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link> section below illustrates adding OpenAPI to your application and customizing the UI behavior.</p>

<p>After you modify, build, and start your Helidon SE service, you can access the OpenAPI UI by default at <code><a target="_blank" href="http://your-host:your-port/openapi/ui" class="bare">http://your-host:your-port/openapi/ui</a></code>.
Helidon also uses conventional content negotiation at <code><a target="_blank" href="http://your-host:your-port/openapi" class="bare">http://your-host:your-port/openapi</a></code> returning the UI to browsers (or any client that accepts HTML) and the OpenAPI document otherwise.</p>

<p>You can customize the path using
either the API or
<router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">configuration</router-link>.</p>

<p>The example below shows the UI
if you modify the Helidon SE QuickStart greeting application to contain a static OpenAPI file which describes the service endpoints.</p>


<div class="block-title"><span>Example OpenAPI UI Screen</span></div>
<v-card>
<v-card-text class="overflow-y-hidden" style="text-align:center">
<img src="./images/openapi-ui-screen-capture-greeting-se-start.png" alt="openapi ui screen capture greeting se start" />
</v-card-text>
</v-card>


<p>With the OpenAPI UI displayed, follow these steps to access one of your service&#8217;s operations.</p>

<ol style="margin-left: 15px;">
<li>
Find the operation you want to run and click on its row in the list.

</li>
<li>
The UI expands the operation, showing any input parameters and the possible responses. Click the "Try it out" button in the operation&#8217;s row.

</li>
<li>
The UI now allows you to type into the input parameter field(s) to the right of each parameter name. Enter any required parameter values (first highlighted rectangle) and any non-required values you wish, then click "Execute" (highlighted arrow).

</li>
<li>
Just below the "Execute" button the UI shows several sections:<br>

<ul class="ulist">
<li>
<p>the equivalent <code>curl</code> command for submitting the request with your inputs,</p>

</li>
<li>
<p>the URL used for the request, and</p>

</li>
<li>
<p>a new "Server response" section (second highlighted rectangle) containing several items from the response:<br>
</p>
<ul class="ulist">
<li>
<p>HTTP status code</p>

</li>
<li>
<p>body</p>

</li>
<li>
<p>headers</p>

</li>
</ul>

</li>
</ul>

</li>
</ol>

<p>The next image shows the screen after you submit the "Returns a personalized greeting" operation.</p>

<p>Note that the UI shows the actual response from invoking the operation in the "Server response" section. The "Responses" section farther below describes the possible responses from the operation as declared in the OpenAPI document for the application.</p>


<div class="block-title"><span>Example OpenAPI UI Screen</span></div>
<v-card>
<v-card-text class="overflow-y-hidden" style="text-align:center">
<img src="./images/openapi-ui-screen-capture-greeting-se-expanded.png" alt="openapi ui screen capture greeting se expanded" />
</v-card-text>
</v-card>


</div>


<h2 id="_api">API</h2>
<div class="section">

<h3 id="_creating_openapisupport_with_automatic_ui_behavior">Creating <code>OpenAPISupport</code> with Automatic UI Behavior</h3>
<div class="section">
<p>With the Helidon OpenAPI UI dependency in your <code>pom.xml</code> file, any <code>OpenAPISupport</code> object your application builds prepares the default OpenAPI UI behavior, possibly modified by any UI settings you have in your configuration.</p>

<markup
lang="java"
title="Create <code>OpenAPISupport</code> with automatic UI"
>Config config = Config.create(); <span class="conum" data-value="1" />
Config openApiConfig = config.get(OpenAPISupport.Builder.CONFIG_KEY)); <span class="conum" data-value="2" />

OpenAPISupport openApiSupport =
    OpenAPISupport.builder()
        .config(openApiConfig) <span class="conum" data-value="3" />
        .build();</markup>

<ul class="colist">
<li data-value="1">Load the configuration.</li>
<li data-value="2">Extract the <code>OpenAPISupport</code> configuration.</li>
<li data-value="3">Build the <code>OpenAPISupport</code> instance using the configuration.</li>
</ul>

<p>If your code invokes the <code>OpenAPISupport.Builder</code> <code>config</code> method, Helidon automatically applies the <code>ui</code> section of the <code>openapi</code> configuration to the UI.</p>

</div>


<h3 id="_customizing_the_ui_behavior">Customizing the UI Behavior</h3>
<div class="section">
<p>You can control some of the behavior of the UI programmatically in two steps:</p>

<ol style="margin-left: 15px;">
<li>
Create an <a target="_blank" href="./apidocs/io.helidon.integrations.openapi.ui/io/helidon/integrations/openapi/ui/OpenApiUi.Builder.html"><code>OpenApiUi.Builder</code></a> and invoke methods on it to set the UI behavior.

</li>
<li>
Invoke the <code>ui</code> method on <a target="_blank" href="./apidocs/io.helidon.openapi/io.helidon.openapi.OpenAPISupport.Builder.html"><code>OpenAPISupport.Builder</code></a>, passing the <code>OpenApiUi.Builder</code> you prepared above.

</li>
</ol>

<p>The following example illustrates these steps, combining configuration with explicit programmatic settings.</p>

<markup
lang="java"
title="Create <code>OpenApiUi</code> and <code>OpenAPISupport</code> instances"
>Config config = Config.create(); <span class="conum" data-value="1" />
Config openApiConfig = config.get(OpenAPISupport.Builder.CONFIG_KEY)); <span class="conum" data-value="2" />

OpenApiUi.Builder uiBuilder =
    OpenApiUi.builder() <span class="conum" data-value="3" />
        .webContext("/my-openapi-ui"); <span class="conum" data-value="4" />

OpenAPISupport openApiSupport =
    OpenAPISupport.builder() <span class="conum" data-value="5" />
        .ui(uiBuilder)
        .config(openApiConfig) <span class="conum" data-value="6" />
        .build();</markup>

<ul class="colist">
<li data-value="1">Load the configuration.</li>
<li data-value="2">Extract the <code>OpenAPISupport</code> configuration.</li>
<li data-value="3">Create the <code>OpenApiUi.Builder</code> instance.</li>
<li data-value="4">Explicitly set the web context where the UI should respond.</li>
<li data-value="5">Create the <code>OpenAPISupport</code> instance using the <code>OpenApiUi.Builder</code> just created.
You can refine the behavior of the <code>OpenAPISupport</code> object by invoking additional methods on its builder before invoking its <code>build</code> method.</li>
<li data-value="6">Apply the <code>openapi</code> configuration to the <code>OpenAPISupport</code> builder. This also automatically applies any <code>openapi.ui</code> configuration to the UI.</li>
</ul>

<p>The order in which your code invokes the methods on <code>OpenApiUi.Builder</code> and <code>OpenAPISupport.Builder</code> determines the outcome.
For instance, the example above sets the UI on the <code>OpenAPISupport.Builder</code> <em>before</em> applying configuration.
If the configuration contains a setting for the UI&#8217;s <code>web-context</code> value then the UI uses the configured value, not the programmatic value, because your code applied the configuration later.
Your code should typically apply configuration <em>after</em> setting any values programmatically.
Doing so allows users or deployers of your service to set the behavior using configuration according to their particular needs which your code might not be able to anticipate.</p>

<div class="admonition note">
<p class="admonition-textlabel">Note</p>
<p ><p>The <code>webContext(String)</code> method on <code>OpenApiUi.Builder</code>  sets the web context where the UI should respond instead of the default <code>/openapi/ui</code>.
Helidon uses the provided string to set the <em>entire</em> web context for the UI, not as a suffix appended to the web context for the <code>OpenAPISupport</code> service.</p>
</p>
</div>

</div>


<h3 id="_registering_openapisupport">Registering <code>OpenAPISupport</code></h3>
<div class="section">
<p>Whether or not your code tailors the UI or <code>OpenAPISupport</code> behavior, it must register the resulting <code>OpenAPISupport</code> instance so that the OpenAPI and UI endpoints can respond correctly.</p>

<markup
lang="java"
title="Register services for routing"
>Routing.builder()
        .register(openApiSupport)
        // Add registrations of your service(s) and other Helidon services you need.
        .build();</markup>

<p>The UI is implemented as part of the <code>OpenAPISupport</code> service which registers the UI automatically.
Your code does not register the UI explicitly.</p>

</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>To use configuration to control how the Helidon OpenAPI UI service behaves, add an <code>openapi.ui</code> section to
your configuration file, such as <code>application.yaml</code>.</p>

<p>Type: <a target="_blank" href="./apidocs/io.helidon.openapi/io/helidon/openapi/OpenApiUi.html">io.helidon.openapi.OpenApiUi</a></p>

<markup
lang="text"
title="Config key"
>ui</markup>


<h3 id="_configuration_options">Configuration options</h3>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Sets whether the UI should be enabled.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>options</code></td>
<td class=""><doc-view>
<p>Map&lt;string, string&gt;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets implementation-specific UI options.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>web-context</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>web context (path) where the UI will respond</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<p>The default UI <code>web-context</code> value is the web context for your <code>OpenAPISupport</code> service with the added suffix <code>/ui</code>. If you use the default web context for both <code>OpenAPISupport</code> and the UI, the UI responds at <code>/openapi/ui</code>.</p>

<p>You can use configuration to affect the UI path in two ways:</p>

<ul class="ulist">
<li>
<p>Configure the OpenAPI endpoint path (the <code>/openapi</code> part).</p>
<p>Recall that you can <router-link :to="{path: '/se/openapi/openapi', hash: '#config'}">configure the Helidon OpenAPI component</router-link> to change where it serves the OpenAPI document.</p>

<markup
lang="yaml"
title="Configuring the OpenAPI web context"
>openapi:
  web-context: /my-openapi</markup>

<p>In this case, the path for the UI component is your customized OpenAPI path with <code>/ui</code> as a suffix.
With the example above, the UI responds at <code>/my-openapi/ui</code> and
Helidon uses standard content negotiation at <code>/my-openapi</code> to return either the OpenAPI document or the UI.</p>

</li>
<li>
<p>Separately, configure the entire web context path for the UI independently from the web context for OpenAPI.</p>
<markup
lang="yaml"
title="Configuring the OpenAPI UI web context"
>openapi:
  ui:
    web-context: /my-ui</markup>

<div class="admonition note">
<p class="admonition-textlabel">Note</p>
<p ><p>The <code>openapi.ui.web-context</code> setting assigns the <em>entire</em> web-context for the UI, not the suffix appended to the <code>OpenAPISupport</code> endpoint.</p>
</p>
</div>

<p>With this configuration, the UI responds at <code>/my-ui</code> regardless of the path for OpenAPI itself.</p>

</li>
</ul>

<p>The SmallRye OpenAPI UI component accepts several options, but they are of minimal use to application developers and they must be passed to the SmallRye UI code programmatically.
Helidon allows you to specify these values using configuration in the <code>openapi.ui.options</code> section. Helidon then passes the corresponding options to SmallRye for you.
To configure any of these settings, use the enum values&#8212;&#8203;they are all lower case&#8212;&#8203;declared in  the SmallRye <a target="_blank" href="https://github.com/smallrye/smallrye-open-api/tree/2.1.16/ui/open-api-ui/src/main/java/io/smallrye/openapi/ui/Option.java"><code>Option.java</code></a> class as the keys in your Helidon configuration.</p>

<div class="admonition note">
<p class="admonition-textlabel">Note</p>
<p ><p>Helidon prepares several of the SmallRye options automatically based on other settings.
Any options you configure override the values Helidon assigns, possibly interfering with the proper operation of the UI.</p>
</p>
</div>

</div>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">
<p><router-link to="/se/openapi/openapi">Helidon OpenAPI SE documentation</router-link></p>

<p><a target="_blank" href="https://github.com/smallrye/smallrye-open-api/tree/2.1.16/ui/open-api-ui">SmallRye OpenAPI UI GitHub site</a></p>

</div>

</doc-view>
