<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#_maven_coordinates" @click.native="this.scrollFix('#_maven_coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#usage-section" @click.native="this.scrollFix('#usage-section')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_references" @click.native="this.scrollFix('#_references')">References</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>The <a target="_blank" href="https://github.com/OAI/OpenAPI-Specification/blob/master/versions/3.0.0.md">OpenAPI specification</a> provides a standard way to express RESTful APIs.</p>

<p>Separately, the <a target="_blank" href="https://openapi-generator.tech">OpenAPI generator</a> project has created a powerful code generator tool which accepts an OpenAPI document and generates client and server code for many languages and frameworks. The Helidon team contributes to this tool to ensure that it provides strong support for Helidon SE clients and servers.
As a result, you can use the generator to create code that fits smoothly into your Helidon applications.
The OpenAPI generator release 6.2.1 gained particularly strong support for Helidon.
This document applies to that release and later ones.</p>

<p>In the vocabulary of the tool, there are two <em>generators</em> for Helidon:</p>

<ul class="ulist">
<li>
<p><code>java-helidon-client</code> (hereafter the Helidon client generator)</p>

</li>
<li>
<p><code>java-helidon-server</code> (hereafter the Helidon server generator).</p>

</li>
</ul>

<p>Each of these generators supports two <em>libraries</em>:</p>

<ul class="ulist">
<li>
<p><code>mp</code> - for Helidon MP code generation</p>

</li>
<li>
<p><code>se</code> - for Helidon SE code generation</p>

</li>
</ul>

<p>Use the Helidon <em>client</em> generator and its <code>se</code> library to create a
Helidon SE client based on <router-link to="/nima/webclient">Helidon WebClients</router-link>.
The resulting client library works with any server that implements the API declared in the OpenAPI document you specified when you ran the generator.
The client library provides an abstraction similar to remote procedure calls (RPC).
To access a remote service that implements the endpoints declared in the OpenAPI document, your code uses the generated client library first to establish a connection to the remote service and then to call remote service endpoints by invoking local methods passing POJO business objects or Java types as arguments.</p>

<p>Use the tool&#8217;s Helidon <em>server</em> generator and its <code>se</code> library to create server endpoint stubs for a Helidon SE service. You build on these stubs by extending a generated class or implementing a generated interface, adding your specific business logic to finish the implementation of the endpoints. The combination of the generated server code plus Helidon SE underneath it allows you to focus on the business details instead of resource boilerplate.</p>

<p>You can run the OpenAPI generators in three ways:</p>

<ul class="ulist">
<li>
<p>using the OpenAPI generator CLI</p>

</li>
<li>
<p>using the OpenAPI generator Maven plug-in</p>

</li>
<li>
<p>using the online OpenAPI generator website</p>

</li>
</ul>

<p>The rest of this document walks you through <router-link to="#usage-section" @click.native="this.scrollFix('#usage-section')">how to use</router-link> each technique and how to <router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">configure</router-link> the generators to produce the code you want.</p>

</div>


<h2 id="_maven_coordinates">Maven Coordinates</h2>
<div class="section">
<p>Your project does not need any dependencies on the OpenAPI generator.</p>

<p>To use the OpenAPI generator plug-in to generate or regenerate files during your project build, add the following to your project&#8217;s <code>pom.xml</code> file to declare the plug-in. Choose whichever version of the generator plug-in meets your needs as long as it is at least 6.2.1.</p>

<markup
lang="xml"
title="Declaring the OpenAPI Generator Plug-in"
>&lt;properties&gt;
    &lt;openapi-generator-version&gt;6.2.1&lt;/openapi-generator-version&gt;
&lt;/properties&gt;
...
&lt;build&gt;
    ...
    &lt;plugin-management&gt;
        ...
        &lt;plugin&gt;
             &lt;groupId&gt;org.openapitools&lt;/groupId&gt;
             &lt;artifactId&gt;openapi-generator-maven-plugin&lt;/artifactId&gt;
             &lt;version&gt;${openapi-generator-version}&lt;/version&gt;
        &lt;/plugin&gt;
        ...
    &lt;/plugin-management&gt;
    ...
&lt;/build&gt;</markup>

<p>A <router-link to="#invoking-the-plugin" @click.native="this.scrollFix('#invoking-the-plugin')">later section</router-link> describes how to invoke the plug-in during your build.</p>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>The OpenAPI generators support a substantial, powerful, and sometimes bewildering group of configuration settings.
For complete lists see these pages:</p>

<ul class="ulist">
<li>
<p><a target="_blank" href="https://github.com/OpenAPITools/openapi-generator/blob/v6.2.1/docs/usage.md#generate">generic options</a></p>

</li>
<li>
<p><a target="_blank" href="https://github.com/OpenAPITools/openapi-generator/blob/v6.2.1/docs/generators/java-helidon-client.md">Helidon client generator options</a> and</p>

</li>
<li>
<p><a target="_blank" href="https://github.com/OpenAPITools/openapi-generator/blob/v6.2.1/docs/generators/java-helidon-server.md">Helidon server generator options</a></p>

</li>
</ul>

<p>The OpenAPI generator divides its settings into two types:</p>

<ul class="ulist">
<li>
<p><em>options</em></p>
<p>These high-level settings generally govern the overall behavior of the tool.</p>

<p>For the CLI, use the common option style:</p>

<p><code>-i petstore.yaml</code></p>

<p><code>--input-spec petstore.yaml</code></p>

<p>For the Maven plug-in, use elements within the <code>&lt;configuration&gt;</code> section of the plug-in:</p>

<markup
lang="xml"

>&lt;configuration&gt;
    &lt;inputSpec&gt;petstore.yaml&lt;/inputSpec&gt;
&lt;/configuration&gt;</markup>

</li>
<li>
<p><em>additional properties</em></p>
<p>These settings typically affect how a specific generator or library generates the code.</p>

<p>For the CLI:</p>

<p><code>--additional-properties "useAbstractClasses=false,returnResponse=true"</code></p>

<p>or</p>

<markup
lang="bash"

>-p useAbstractClasses=false
-p returnResponse=true</markup>

<p>For the Maven plug-in, use elements within the <code>&lt;configuration&gt;&lt;configOptions&gt;</code> section:</p>

<markup
lang="xml"

>&lt;configuration&gt;
    ....
    &lt;configOptions&gt;
        &lt;useAbstractClasses&gt;false&lt;/useAbstractClasses&gt;
        &lt;returnResponse&gt;true&lt;/returnResponse&gt;
    &lt;/configOptions&gt;
&lt;/configuration&gt;</markup>

</li>
</ul>

<p>Keep this distinction between options and additional properties in mind so you know how to express the configuration you want.
The <router-link to="#links-to-settings" @click.native="this.scrollFix('#links-to-settings')">earlier links</router-link> to the lists of configuration options for the Helidon generators groups options and additional properties in separate tables.</p>

<p>The next few sections describe, in turn, required settings, settings we recommend, and other common settings most developers will want to use.</p>


<h3 id="_required_settings">Required Settings</h3>
<div class="section">
<p>You must specify the following options:</p>

<div class="block-title"><span>Required OpenAPI Generator Options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 20%;">
<col style="width: 5%;">
<col style="width: 20%;">
<col style="width: 30%;">
<col style="width: 25%;">
</colgroup>
<thead>
<tr>
<th>Option</th>
<th>Short Option</th>
<th>Plug-in Setting</th>
<th>Description</th>
<th>Values</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>--inputSpec</code></td>
<td class=""><code>-i</code></td>
<td class=""><code>&lt;inputSpec&gt;</code></td>
<td class="">Path to the OpenAPI document defining the REST API</td>

</tr>
<tr>
<td class=""><code>--generatorName</code></td>
<td class=""><code>-g</code></td>
<td class=""><code>&lt;generatorName&gt;</code></td>
<td class="">Generator you want to use (<code>java-helidon-server</code> or <code>java-helidon-client</code>)</td>
<td class=""><code>java-helidon-server</code><br>

<code>java-helidon-client</code></td>
</tr>
</tbody>
</table>
</div>

</div>


<h3 id="_recommended_settings_for_the_openapi_generator">Recommended Settings for the OpenAPI Generator</h3>
<div class="section">
<p>Your project might have different needs, but in general we advise developers to use the following settings when using the OpenAPI generator.</p>

<div class="block-title"><span>Recommended OpenAPI Generator Additional Properties</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 21.428%;">
<col style="width: 42.857%;">
<col style="width: 35.714%;">
</colgroup>
<thead>
<tr>
<th>Property</th>
<th>Description</th>
<th>Default</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>apiPackage</code></td>
<td class="">Name of the package for generated API interfaces/classes</td>
<td class=""><code>org.openapitools.server.api</code> or<br>

<code>org.openapitools.client.api</code></td>
</tr>
<tr>
<td class=""><code>modelPackage</code></td>
<td class="">Name of the package for generated model (POJO) classes</td>
<td class=""><code>org.openapitools.server.model</code> or<br>

<code>org.openapitools.client.model</code></td>
</tr>
<tr>
<td class=""><code>invokerPackage</code></td>
<td class="">Name of the package for generated driver classes</td>
<td class=""><code>org.openapitools.server</code> or<br>

<code>org.openapitools.client</code></td>
</tr>
<tr>
<td class=""><code>groupId</code></td>
<td class="">Group ID in the generated <code>pom.xml</code></td>
<td class=""><code>org.openapitools</code></td>
</tr>
<tr>
<td class=""><code>artifactId</code></td>
<td class="">Artifact ID in the generated <code>pom.xml</code></td>
<td class=""><code>openapi-java-server</code> or<br>

<code>openapi-java-client</code></td>
</tr>
<tr>
<td class=""><code>artifactVersion</code></td>
<td class="">Artifact version in the generated <code>pom.xml</code></td>
<td class=""><code>1.0.0</code></td>
</tr>
</tbody>
</table>
</div>

<div class="admonition note">
<p class="admonition-textlabel">Note</p>
<p >The next table contains recommendations only for using the OpenAPI generator plug-in (not for using the CLI).</p>
</div>

<div class="block-title"><span>Recommended OpenAPI Generator Plug-in Options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.529%;">
<col style="width: 47.059%;">
<col style="width: 29.412%;">
</colgroup>
<thead>
<tr>
<th>Plug-in Option</th>
<th>Description</th>
<th>Default</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>&lt;output&gt;</code></td>
<td class="">Directory where the generator should place files.<br>

+
We strongly recommend <code>&lt;output&gt;target/generated-sources&lt;/output&gt;</code> or a subdirectory below there.</td>
<td class=""><code>.</code><br>

(current directory)</td>
</tr>
<tr>
<td class=""><code>&lt;addCompileSourceRoot&gt;</code></td>
<td class="">Whether Maven should include the output directory as a source root (that is, include it automatically in the build).<br>

+
We advise <code>&lt;addCompileSourceRoot&gt;true&lt;/addCompileSourceRoot&gt;</code>.</td>
<td class=""><code>false</code></td>
</tr>
</tbody>
</table>
</div>

</div>


<h3 id="_common_settings">Common Settings</h3>
<div class="section">
<p>Among the many configuration settings available to you, some you should particularly consider are summarized in the table below. Refer to the <router-link to="#links-to-settings" @click.native="this.scrollFix('#links-to-settings')">earlier links</router-link> for complete lists.</p>

<div class="block-title"><span>Common OpenAPI Generator Additional Properties</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 18.182%;">
<col style="width: 22.727%;">
<col style="width: 13.636%;">
<col style="width: 13.636%;">
<col style="width: 31.818%;">
</colgroup>
<thead>
<tr>
<th>Property</th>
<th>Description</th>
<th>Values</th>
<th>Default</th>
<th>Notes</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>helidonVersion</code></td>
<td class="">Version of Helidon for which to generate the files</td>
<td class="">&#160;</td>
<td class=""><code>2.5.2</code></td>
<td class=""><doc-view>
<p>Affects:</p>

<ul class="ulist">
<li>
<p>Helidon version for the <code>&lt;parent&gt;</code></p>

</li>
<li>
<p>Dependencies (<code>javax</code> vs. <code>jakarta</code>)</p>

</li>
<li>
<p><code>java import</code> statements in generated code (<code>javax</code> vs. <code>jakarta</code>)</p>

</li>
</ul>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>fullProject</code></td>
<td class="">Whether to generate all the normal files or only API files</td>
<td class=""><code>true</code>/<code>false</code></td>
<td class=""><code>false</code></td>
<td class="">The "API files" include files developers do not normally modify after they are generated: the interfaces or classes for the declared API
and the model classes.</td>
</tr>
<tr>
<td class=""><code>serializationLibrary</code></td>
<td class="">which Java library to use for serializing JSON</td>
<td class=""><code>jsonb</code>, <code>jackson</code></td>
<td class=""><code>jackson</code></td>

</tr>
</tbody>
</table>
</div>

</div>

</div>


<h2 id="usage-section">Usage</h2>
<div class="section">
<p>This section covers two major topics:</p>

<ul class="ulist">
<li>
<p><router-link to="#usage-planning" @click.native="this.scrollFix('#usage-planning')">Planning your use of the OpenAPI generators</router-link></p>

</li>
<li>
<p><router-link to="#usage-running" @click.native="this.scrollFix('#usage-running')">Running the generators</router-link></p>

</li>
</ul>


<h3 id="usage-planning">Planning Your Use of the OpenAPI Generators</h3>
<div class="section">
<p>Beyond the settings listed above, there are several important choices you need to make when planning your project and when running the OpenAPI generators. This section addresses those choices.</p>


<h4 id="_generating_a_new_project_and_generating_into_an_existing_project">Generating a New Project and Generating <em>Into</em> an Existing Project</h4>
<div class="section">
<p>You can use the OpenAPI generator to create a new project or to generate files into an existing project.
Some developers do both, using the generator to create the project at first and then to update the project as they evolve the OpenAPI document or change the generation options they select.
Others create the project in some other way&#8212;&#8203;for example, using the <router-link to="/about/cli">Helidon CLI</router-link>. The OpenAPI generator CLI and plug-in both support each type of usage.</p>

<p>If the OpenAPI generator finds a pre-existing API or model file, it overwrites it with the latest content.
It does <em>not</em> overwrite a <code>pom.xml</code> file or test files.
This is important because certain generation settings can influence the generated dependencies in the <code>pom.xml</code> file.
For example, the <code>serializationLibrary</code> setting creates dependencies on either JSON-B or Jackson artifacts.
As a result, changing the generation options can change the dependencies your project should have. If you rerun the generator, the old <code>pom.xml</code> remains and does not reflect the revised depencencies.</p>

<p>As a practical matter, many developers use the OpenAPI generators in one of the  following ways:</p>

<ul class="ulist">
<li>
<p>Use the generator CLI once to create a new project.</p>
<p>By default, the generator CLI creates files in the normal Maven project structure: <code>src/main/java</code>, etc.
Then you add your own files to that same project structure.
Because the generated files are in the standard places, the project build includes them by default.</p>

<div class="admonition note">
<p class="admonition-textlabel">Note</p>
<p ><p>You <em>can</em> run the generator CLI again to update the generated files.
Because this happens outside the project&#8217;s build lifecycle, you need to remember to rerun the CLI yourself when you change the OpenAPI document.</p>

<p>You also need to identify and manually remove any previously-generated files that become obsolete.
Similarly, you must understand how changes in the OpenAPI document or the generation options affect the project dependencies and update the project <code>pom.xml</code> accordingly.</p>
</p>
</div>

</li>
<li>
<p>Use the generator plug-in to (re)generate files during each build.</p>
<p>Specify in the plug-in configuration that the generated files should reside in <code>target/generated-sources</code> directory (the conventional location for generated sources) or a subdirectory below there.
Each project build runs the OpenAPI generator which reads the then-current OpenAPI document file.
With the generated files under <code>target</code>, you can use <code>mvn clean</code> to remove any obsolete generated files left over from previous builds.</p>

<div class="admonition note">
<p class="admonition-textlabel">Note</p>
<p ><p>In particular, with <code>mvn clean</code> each build regenerates the candidate <code>pom.xml</code> under <code>target/generated-sources</code>. You can inspect the generated <code>pom.xml</code> file for changes in dependencies and make any necessary changes in the actual project <code>pom.xml</code> file.</p>
</p>
</div>

</li>
</ul>

</div>


<h4 id="_generating_interfaces_or_classes">Generating Interfaces or Classes</h4>
<div class="section">
<p>As you generate a Helidon SE <em>server</em>, you can choose whether you want Java interfaces or classes to represent the RESTful API endpoints.</p>

<p>By default, the Helidon OpenAPI server generator creates classes.
You write your own concrete subclasses which extend those generated classes, supplying the business logic for each REST endpoint.
<em>Do not</em> modify the generated classes.</p>

<p>If you set <code>useAbstractClasses=false</code> then the generator creates Java interfaces instead of classes.
You then write classes which implement those generated interfaces.</p>

<p>Either way, you can safely regenerate the code later so long as you have not edited the generated code.
The generator replaces the generated classes or interfaces but does not touch other classes you wrote.</p>

<p>The Helidon <em>client</em> generator always creates concrete classes. Typically, you do not need to customize the behavior in the generated client API classes. If you choose to do so, write your own subclass of the generated client API class; <em>do not</em> modify the generated files.</p>

</div>


<h4 id="_grouping_operations_into_apis">Grouping Operations into "APIs"</h4>
<div class="section">
<p>Each operation in an OpenAPI document can have a <code>tags</code> attribute.
The generators group operations with the same <code>tags</code> value into the same API.</p>

<p>When you generate a Helidon SE server, the generator creates a separate interface or class for each API your service <em>exposes</em>.
You implement each interface or extend each class to add your business logic for that API.</p>

<p>When you generate a Helidon SE client, the generated code contains a separate API class for each distinct API your code might <em>invoke</em>.</p>

</div>

</div>


<h3 id="usage-running">Running the OpenAPI Generators</h3>
<div class="section">
<p>Earlier we listed the ways you can run the OpenAPI generator:</p>

<ul class="ulist">
<li>
<p>using the OpenAPI generator CLI</p>

</li>
<li>
<p>using the OpenAPI generator Maven plug-in</p>

</li>
<li>
<p>using the online OpenAPI generator website</p>

</li>
</ul>

<p>The next sections describe each of these techniques in detail.</p>


<h4 id="_using_the_openapi_generator_cli">Using the OpenAPI Generator CLI</h4>
<div class="section">
<div class="admonition note">
<p class="admonition-textlabel">Downloading the OpenAPI Generator CLI</p>
<p >You need to download the CLI <code>.jar</code> file before you can run the CLI.
Follow these <a target="_blank" href="https://github.com/OpenAPITools/openapi-generator#13---download-jar">instructions</a> and remember where you save the <code>.jar</code> file.
The examples below use the placeholder <code>path-to-generator</code> to represent the directory where you store that downloaded file.</p>
</div>

<p>The following example uses the Helidon server generator to create a project or regenerate files into an existing project.</p>

<markup
lang="bash"
title="Creating or updating a server project using the OpenAPI generator CLI"
>java -jar ${path-to-generator}/openapi-generator-cli.jar \
  generate \
  -i src/main/resources/petstore.yaml \
  -g java-helidon-server \
  --library se \
  -p groupId=io.helidon.examples \
  -p artifactId=helidon-openapigen-se-server \
  -p artifactVersion=1.0.0-SNAPSHOT \
  -p apiPackage=io.helidon.examples.openapigen.se.server.api \
  -p modelPackage=io.helidon.examples.openapigen.se.server.model \
  -p invokerPackage=io.helidon.examples.openapigen.se.server</markup>

<p>The next example runs the Helidon client generator using the same input file.</p>

<markup
lang="bash"
title="Creating or updating a client project using the OpenAPI generator CLI"
>java -jar ${path-to-generator}/openapi-generator-cli.jar \
  generate \
  -i src/main/resources/petstore.yaml \
  -g java-helidon-client \
  --library se \
  -p groupId=io.helidon.examples \
  -p artifactId=helidon-openapigen-se-client \
  -p artifactVersion=1.0.0-SNAPSHOT \
  -p apiPackage=io.helidon.examples.openapigen.se.client.api \
  -p modelPackage=io.helidon.examples.openapigen.se.client.model \
  -p invokerPackage=io.helidon.examples.openapigen.se.client</markup>

<p>The key differences between the commands are:</p>

<ul class="ulist">
<li>
<p>the generator selected by the <code>-g</code> option (<code>client</code> vs. <code>server</code>),</p>

</li>
<li>
<p>the artifact ID and package names (<code>client</code> vs. <code>server</code>).</p>

</li>
</ul>

<p>You could use these two commands together to generate a server submodule and a client submodule in a pre-existing multi-module Maven project. Remember that the resulting client project can access any server which implements the API described in the <code>petstore.yaml</code> OpenAPI document, whether it was generated using the OpenAPI generator tool or not.</p>

<p>In both examples, the generator creates the entire project if it does not exist and recreates the generated API and model files if the project already exists.
The generator does not overwrite an existing <code>pom.xml</code> file, previously-generated test files, or files you create yourself.</p>

</div>


<h4 id="invoking-the-plugin">Invoking the OpenAPI Generator Maven Plug-in</h4>
<div class="section">
<p>You can run the OpenAPI generator plug-in as part of your project build to generate or regenerate files.</p>

<p>First, declare the plug-in as explained in the <router-link to="#_maven_coordinates" @click.native="this.scrollFix('#_maven_coordinates')">earlier section on Maven coordinates</router-link>.</p>

<p>Then, in the <code>&lt;build&gt;</code> section of your <code>pom.xml</code> file, add an execution of the plug-in with the configuration you want. By default, the plug-in runs during the <code>generate-sources</code> phase of the Maven build.</p>

<p>The plug-in execution in the following example is equivalent to the CLI example above for generating server files:</p>

<markup
lang="xml"
title="Creating or updating a client project using the OpenAPI Maven plug-in"
>&lt;plugin&gt;
    &lt;groupId&gt;org.openapitools&lt;/groupId&gt;
    &lt;artifactId&gt;openapi-generator-maven-plugin&lt;/artifactId&gt;
    &lt;executions&gt;
        &lt;execution&gt;
            &lt;goals&gt;
                &lt;goal&gt;generate&lt;/goal&gt;
            &lt;/goals&gt;
            &lt;configuration&gt;
                &lt;inputSpec&gt;${project.basedir}/src/main/resources/petstore.yaml&lt;/inputSpec&gt;
                &lt;generatorName&gt;java-helidon-client&lt;/generatorName&gt;
                &lt;library&gt;se&lt;/library&gt;
                &lt;output&gt;${project.build.directory}/generated-sources/client&lt;/output&gt; <span class="conum" data-value="1" />
                &lt;addCompileSourceRoot&gt;true&lt;/addCompileSourceRoot&gt;
                &lt;configOptions&gt;
                    &lt;groupId&gt;io.helidon.examples&lt;/groupId&gt;
                    &lt;artifactId&gt;helidon-openapigen-se-client&lt;/artifactId&gt;
                    &lt;artifactVersion&gt;1.0.0-SNAPSHOT&lt;/artifactVersion&gt;
                    &lt;apiPackage&gt;io.helidon.examples.openapigen.se.client.api&lt;/apiPackage&gt;
                    &lt;modelPackage&gt;io.helidon.examples.openapigen.se.client.model&lt;/modelPackage&gt;
                    &lt;invokerPackage&gt;io.helidon.examples.openapigen.se.client&lt;/invokerPackage&gt;
                &lt;/configOptions&gt;
            &lt;/configuration&gt;
        &lt;/execution&gt;
    &lt;/executions&gt;
&lt;/plugin&gt;</markup>

<ul class="colist">
<li data-value="1">Specifies that the generated files should reside in the <code>target/generated-sources/client</code> directory.</li>
</ul>

</div>


<h4 id="_using_the_online_generator">Using the Online Generator</h4>
<div class="section">
<p>The OpenAPI tools project hosts and maintains the online OpenAPI generator at <a target="_blank" href="http://api.openapi-generator.tech" class="bare">http://api.openapi-generator.tech</a>. You can use the site&#8217;s API browser to explore the available generators and the settings each supports, expressed as JSON.</p>

<p>To generate your project, you supply the options and additional properties as JSON. The online generator provides you with a file ID, and you refer to the file ID in a subsequent HTTP request to retrieve your project.</p>

<div class="admonition note">
<p class="admonition-textlabel">Note</p>
<p >The online generator stores your project on the server which you then retrieve using a separate HTTP request.
Before you use the online generator, consider whether any of the input you provide&#8212;&#8203;the OpenAPI document, package or Maven coordinates&#8212;&#8203;and therefore the generated project will reveal any sensitive information.</p>
</div>

<p>This document does not explore further the use of the online generator.</p>

</div>

</div>

</div>


<h2 id="using-generated-code">Using the Generated Code</h2>
<div class="section">
<p>The Helidon generators go a long way in helping you write your client or server. Even so, there are important parts of your project only you can provide. This section describes your next steps <em>after</em> you have run the generator.</p>


<h3 id="_completing_the_server">Completing the Server</h3>
<div class="section">
<p>Recall from earlier how the OpenAPI generator gathers operations into one or more "APIs" and generates either a class or an interface&#8212;&#8203;your choice&#8212;&#8203;for each API.
You need to extend each generated API class or implement each generated API interface by writing your own classes.
Any input parameters to the endpoints are expressed as POJO model objects or Java types, as declared in the OpenAPI document. Your server code uses each of the input parameters to accomplish whatever business purpose that endpoint is responsible for, possibly returning a result as a POJO or Java type as indicated for that operation in the OpenAPI document.</p>

<p>The Helidon SE server generator also creates, for each API, a separate class containing handler methods for each endpoint.
Along with the <code>PetService</code> interface or abstract class which has methods such as <code>addPet</code> and <code>getPetById</code>, the tool generates <code>PetServiceImpl</code> with methods such as <code>handleAddPet</code> and <code>handleGetPetById</code>.</p>

<markup
lang="java"
title="Generated <code>PetService</code> abstract class"
>public abstract class PetService implements Service {
    void addPet(ServerRequest request, ServerResponse response, Pet pet) {
        // ...
    }
    abstract void handleAddPet(ServerRequest request, ServerResponse response, Pet pet);

    void getPetById(ServerRequest request, ServerResponse response) {
        // ...
    }
    abstract void handleGetPetById(ServerRequest request, ServerResponse response, Long petId);
}</markup>

<markup
lang="java"
title="Generated skeleton <code>PetServiceImpl</code> class (which you extend)"
>public class PetServiceImpl extends PetService {
    public void handleAddPet(ServerRequest request, ServerResponse response, Pet pet) {
        response.status(HTTP_CODE_NOT_IMPLEMENTED.send());
    }

    public void handleGetPetById(ServerRequest request, ServerResponse response, Long petId) {
        response.status(HTTP_CODE_NOT_IMPLEMENTED).send();
    }
}</markup>

<p>You write your own classes which extend <code>PetServiceImpl</code> and the other generated <code>xxxImpl</code> classes, overriding the <code>handle&#8230;&#8203;</code> methods.</p>

<p>You have control over&#8212;&#8203;and therefore responsibility for&#8212;&#8203;preparing the response to be sent to the client, including the status, any response headers, and any returned entity.
Your overriding implementation of <code>handleGetPetById</code> might look like the following example.</p>

<markup
lang="java"
title="Example override of <code>handleGetPetById</code>"
>public void handleGetPetById(ServerRequest request, ServerResponse response, Long petId) {
    Pet pet = locatePetInDatabase(petId);
    if (pet == null) {
        response.status(404).send();
    }
    response.send(pet); // Respnose status is 200 by default.
    }
}</markup>

</div>


<h3 id="_using_the_client_library">Using the Client Library</h3>
<div class="section">
<p>The generated client code represents a true library. Typically, you do not need to customize the generated client code itself. You <em>do</em> need to write code to invoke the code in that library.</p>

<p>The generated Helidon SE client includes the class <code>ApiClient</code>. This class corresponds to
the Helidon <a target="_blank" href="./apidocs/io.helidon.reactive.webclient/io/helidon/webclient/WebClient.html"><code>WebClient</code></a> and represents the connection between your code and the remote server. The generator also creates one or more <code>Api</code> interfaces and corresponding implementation classes. The examples below use the <code>PetApi</code> interface and the <code>PetApiImpl</code> class.</p>

<p>To invoke the remote service your code must:</p>

<ol style="margin-left: 15px;">
<li>
Create an instance of <code>ApiClient</code> using an <code>ApiClient.Builder</code>.

</li>
<li>
Use that <code>ApiClient</code> instance to instantiate a <code>PetApi</code> object.

</li>
<li>
Invoke the methods on the <code>PetApi</code> object to access the remote services and then retrieve the returned result value.

</li>
</ol>

<p>The following sections explain these steps.</p>


<h4 id="_creating_an_apiclient_instance">Creating an <code>ApiClient</code> Instance</h4>
<div class="section">
<p>The Helidon SE client generator gives you as much flexibility as you need in connecting to the remote service.</p>

<p>Internally, the <code>ApiClient</code> uses a Helidon <code>WebClient</code> object to contact the remote system.
The <code>ApiClient.Builder</code> automatically prepares a Helidon
<a target="_blank" href="./apidocs/io.helidon.reactive.webclient/io/helidon/webclient/WebClient.Builder.html"><code>WebClient.Builder</code></a> object using information from the OpenAPI document.</p>

<p>The next sections describe, from simplest to most complicated, the ways your code can create an <code>ApiClient</code> instance, each involving increased involvement with the <code>WebClient.Builder</code> object.</p>


<h5 id="_accepting_the_automatic_webclient_builder">Accepting the Automatic <code>WebClient.Builder</code></h5>
<div class="section">
<p>In the simplest case, your code can get an <code>ApiClient</code> instance directly.</p>

<markup
lang="java"
title="Creating an <code>ApiClient</code> instance - simple case"
>ApiClient apiClient = ApiClient.builder().build();</markup>

<p>Your code relies fully on the automatic <code>WebClient.Builder</code>.
In many cases, this approach works very well, especially if the OpenAPI document correctly declares the servers and their URIs.</p>

</div>


<h5 id="_influencing_the_automatic_webclient_builder">Influencing the Automatic <code>WebClient.Builder</code></h5>
<div class="section">
<p>Your code can use the <code>ApiClient.Builder</code> to fine-tune the settings for the internal <code>WebClient.Builder</code>.
For instance, your code can set an object mapper to be used for Jackson processing or the <code>JsonbConfig</code> object to be used for JSON-B processing, depending on which serialization library you chose when you ran the generator.</p>

<p>Your code does not need to know how the object mapper setting is conveyed to the internal <code>WebClient.Builder</code>. The <code>ApiClient.Builder</code> knows how to do that.</p>

<markup
lang="java"
title="Creating an <code>ApiClient</code> instance - influencing the <code>ApiClient.Builder</code>"
>ApiClient apiClient = apiClient.builder()
                            .objectMapper(yourCustomMapper)
                            .build();</markup>

</div>


<h5 id="_adjusting_the_automatic_webclient_builder">Adjusting the Automatic <code>WebClient.Builder</code></h5>
<div class="section">
<p>In more complicated situations, your code can adjust the settings of the <code>WebClient.Builder</code> the <code>ApiClient.Builder</code> creates.</p>

<markup
lang="java"
title="Creating an <code>ApiClient</code> instance - adjusting the <code>WebClient.Builder</code>"
>ApiClient.Builder apiClientBuilder = ApiClient.builder();

apiClientBuilder.webClientBuilder() <span class="conum" data-value="1" />
                .connectTimeout(4, TimeUnit.SECONDS); <span class="conum" data-value="2" />

ApiClient apiClient = apiClientBuilder.build(); <span class="conum" data-value="3" /></markup>

<ul class="colist">
<li data-value="1">Access the <code>ApiClient.Builder&#8217;s automatic `WebClient.Builder</code> instance.</li>
<li data-value="2">Adjust a setting of the <code>WebClient.Builder</code> directly.</li>
<li data-value="3">Build the <code>ApiClient</code> which implicitly builds the <code>WebClient</code> from the now-adjusted internal <code>WebClient.Builder</code>.</li>
</ul>

<p>The automatic <code>WebClient.Builder</code> retains information derived from the OpenAPI document unless your code overrides those specific settings.</p>

</div>


<h5 id="_providing_a_custom_webclient_builder">Providing a Custom <code>WebClient.Builder</code></h5>
<div class="section">
<p>Lastly, you can construct the <code>WebClient.Builder</code> entirely yourself and have the <code>ApiClient.Builder</code> use it instead of its own internal builder.</p>

<markup
lang="java"
title="Creating an <code>ApiClient</code> instance - using a custom <code>WebClient.Builder</code>"
>WebClient.Builder customWebClientBuilder = WebClient.builder()
                .connectTimeout(3, TimeUnit.SECONDS)
                .baseUri("https://myservice.mycompany.com");

ApiClient apiClient = ApiClient.builder()
                        .webClientBuilder(customWebClientBuilder)
                        .build();</markup>

<p>Note that this approach entirely replaces the internal, automatically-prepared <code>WebClient.Builder</code> with yours; it <em>does not</em> merge the new builder with the internal one. In particular, any information from the OpenAPI document the generator used to prepare the internal  <code>WebClient.Builder</code> is lost.</p>

</div>

</div>


<h4 id="_creating_a_petapi_instance">Creating a <code>PetApi</code> Instance</h4>
<div class="section">
<p>The <code>ApiClient</code> represents the connection to the remote server but not the individual RESTful operations.
Each generated <code>xxxApi</code> interface exposes a method for each operation declared in the OpenAPI document associated with that API via its <code>tags</code> value.
By example, the <code>PetApi</code> interface exposes a method for each operation in the OpenAPI document that pertains to pets.</p>

<p>To invoke an operation defined on the <code>PetApi</code> interface, your code instantiates a <code>PetApi</code> using an <code>ApiClient</code> object:</p>

<markup
lang="java"
title="Preparing the PetStore Client API"
>ApiClient apiClient = ApiClient.builder().build();
PetApi petApi = PetApiImpl.create(apiClient);</markup>

</div>


<h4 id="_invoking_remote_endpoints">Invoking Remote Endpoints</h4>
<div class="section">
<p>With the <code>petApi</code> object, your code can invoke any of the methods on the <code>PetApi</code> interface to contact the remote service.</p>

<p>The Helidon WebClient follows a reactive programming model, and the Helidon SE client generator creates an <code>ApiResponse</code> interface, also reactive.
Each generated <code>PetApi</code> method returns an <code>ApiResponse&lt;returnType&gt;</code> where the <code>returnType</code> is the return type declared in the OpenAPI document for the corresponding operation.</p>

<p>The <code>ApiResponse</code> interface exposes two methods your code can use to work with the response from the remote service invocation:</p>

<ul class="ulist">
<li>
<p><code>Single&lt;T&gt; result()</code></p>
<p>Provides reactive access to the value returned by the remote service in the response.
This method lets your code fetch the return value directly.</p>

</li>
<li>
<p><code>Single&lt;WebClientResponse&gt; webClientResponse()</code></p>
<p>Provides reactive access to the Helidon <code>WebClientResponse</code> object.
Your code can find out the HTTP return status, read headers in the response, and process the content (if any) in the response however it needs to.</p>

</li>
</ul>

<p>In the reactive Helidon WebClient model, the first part of the response message can  arrive (the status and headers are available) before the entity in the body of the response is readable.
So there are two reactive events associated with an incoming HTTP response:</p>

<ol style="margin-left: 15px;">
<li>
when the response <em>excluding</em> the entity content has arrived, and

</li>
<li>
when your code can begin consuming the entity content.

</li>
</ol>

<p>You can adopt different styles of retrieving the results, depending on the specific needs of the code you are writing.</p>


<h5 id="_synchronous_access_to_the_result">Synchronous access to the result</h5>
<div class="section">
<p>This example shows the simplest way to invoke the remote service and work with the result.</p>

<markup
lang="java"
title="Synchronous access to the return value"
>// Assumes the petApi field is initialized as above.
List&lt;Pet&gt; availablePets = petApi.findPetsByStatus(List.of(Pet.StatusEnum.AVAILABLE.value())) <span class="conum" data-value="1" />
                .result() <span class="conum" data-value="2" />
                .await(4, TimeUnit.SECONDS); <span class="conum" data-value="3" /></markup>

<ul class="colist">
<li data-value="1">Start the remote service invocation.</li>
<li data-value="2">Access the reactive result.</li>
<li data-value="3">Wait for the result to arrive subject to a four-second timeout.</li>
</ul>

<p>This code blocks the current thread, waiting up to four seconds for the response to arrive.
This approach might be adequate if you are developing a command-line client where the thread has no other meaningful work to do until it has the result.
This is <em>not</em> an appropriate style for server code that uses the generated client to invoke another service.</p>

<p>Note that this approach offers no access to the HTTP status for the response or any headers that might have been returned.</p>

</div>


<h5 id="_synchronous_access_with_status_checking">Synchronous access with status checking</h5>
<div class="section">
<p>The Helidon WebClient programming model includes a <code>WebClientResponse</code> interface which exposes all aspects of the HTTP response returned from the remote service.</p>

<p>The next example shows how your code can use the <code>WebClientResponse</code>.</p>

<markup
lang="java"
title="Synchronous access with status checking"
>ApiResponse&lt;List&lt;Pet&gt;&gt; apiResponse = petApi.findPetsByStatus(List.of(Pet.StatusEnum.AVAILABLE.value())); <span class="conum" data-value="1" />

WebClientResponse webClientResponse = apiResponse.webClientResponse()
            .await(4, TimeUnit.SECONDS); <span class="conum" data-value="2" />

if (webClientResponse.status().code() != 200) { <span class="conum" data-value="3" />
    // Handle a non-successful status.
}

List&lt;Pet&gt;&gt; availablePets = apiResponse.result()
            .await(4, TimeUnit.SECONDS); <span class="conum" data-value="4" /></markup>

<ul class="colist">
<li data-value="1">Start the remote service invocation.</li>
<li data-value="2">Wait for the HTTP response status and headers to arrive.</li>
<li data-value="3">Check the status in the HTTP response.</li>
<li data-value="4">Wait for the content to arrive subject to a four-second timeout.</li>
</ul>

<p>This code also blocks the current thread, first to wait for the initial response and then to wait for the result content.</p>

</div>


<h5 id="_fully_reactive_access">Fully-reactive access</h5>
<div class="section">
<p>The following example shows how your code might invoke the remote service and process the response using the reactive programming model.</p>

<markup
lang="java"
title="Fully-reactive access with status checking"
>// Assumes the petApi field is initialized as above.
ApiResponse&lt;List&lt;Pet&gt;&gt; availablePetsResponse =
    petApi.findPetsByStatus(List.of(Pet.StatusEnum.AVAILABLE.value())); <span class="conum" data-value="1" />

availablePetsResponse.webClientResponse()
    .thenAccept(resp -&gt; { <span class="conum" data-value="2" />
        if (resp.status().code() == 200) {
            try {
                availablePetsResponse.result() <span class="conum" data-value="3" />
                    .thenAccept(availablePets -&gt; {
                        // Process the List&lt;Pet&gt; of available pets. <span class="conum" data-value="4" />

                    })
                    .exceptionally(throwable -&gt; {
                        // Handle whatever problem occurred in retrieving the results. <span class="conum" data-value="5" />
                        return null;
                    });
            } catch (ExecutionException | InterruptedException e) {
                // Handle errors while waiting for the response content to arrive. <span class="conum" data-value="6" />
            }
        } else {
            // Handle non-200 HTTP status. <span class="conum" data-value="7" />
        })
    .exceptionally(throwable -&gt; {
        // Handle whatever problem occurred in receiving the response. <span class="conum" data-value="8" />
        return null;
    });</markup>

<ul class="colist">
<li data-value="1">Starts the remote service invocation.</li>
<li data-value="2">Reactively processes the first portion of the HTTP response.</li>
<li data-value="3">Reactively processes a successfully-received HTTP response.</li>
<li data-value="4">Reactively processes the successfully-returned list of available pets.</li>
<li data-value="5">Reactively handles any errors in retrieving the list of available pets.</li>
<li data-value="6">Handle problems that occurred while waiting for the response content to arrive.</li>
<li data-value="7">Handle a non-200 response status.</li>
<li data-value="8">Reactively handles any errors in receiving the HTTP response.</li>
</ul>

<p>The fully-reactive approach brings with it some complexity, but it lets your code completely avoid blocking the thread that initiates the outbound remote service access.
Avoiding blocking is especially important if the code which uses the generated client runs in a server.</p>

<p>Some of this complexity enters because there are several ways this processing can fail.
Your code should handle each of them in whatever ways make sense for your application, and that might mean dealing with each different error scenario in a different way.</p>

</div>

</div>

</div>

</div>


<h2 id="_references">References</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://openapi-generator.tech">OpenAPI Generator Official Website</a></p>

</li>
<li>
<p><a target="_blank" href="https://github.com/OpenAPITools/openapi-generator">OpenAPI Generator GitHub Repository</a></p>

</li>
<li>
<p><a target="_blank" href="https://github.com/OAI/OpenAPI-Specification/blob/master/versions/3.0.0.md">OpenAPI specification</a></p>

</li>
<li>
<p><router-link to="/nima/webclient">Helidon WebClient documentation</router-link></p>

</li>
</ul>

</div>

</doc-view>
