<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>The <a target="_blank" href="https://github.com/OAI/OpenAPI-Specification/blob/master/versions/3.0.0.md">OpenAPI specification</a> defines a standard way to express the interface exposed by a REST service.</p>

<p>The <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-open-api-3.0/microprofile-openapi-spec-3.0.html">MicroProfile OpenAPI spec</a> explains how MicroProfile embraces OpenAPI, adding annotations, configuration, and a service provider interface (SPI).</p>

<p>OpenAPI support in Helidon SE draws its inspiration from MicroProfile OpenAPI but does not implement the spec because Helidon SE does not support annotations.</p>

<p>The OpenAPI support in Helidon SE performs two main tasks:</p>

<ul class="ulist">
<li>
<p>Build an in-memory model of the REST API your service implements.</p>

</li>
<li>
<p>Expose the model in text format (typically YAML) via the <code>/openapi</code> endpoint.</p>

</li>
</ul>

<p>To construct the model, Helidon gathers information about the service API from whichever of these sources are present in the application:</p>

<ul class="ulist">
<li>
<p>a <em>model reader</em></p>
<p>The SPI defines an interface you can implement in your application for  programmatically providing part or all of the model;</p>

</li>
<li>
<p>a static OpenAPI document file packaged as part of your service;</p>

</li>
<li>
<p>a <em>filter</em> class</p>
<p>The SPI defines an interface you can implement in your application which can mask parts of the model.</p>

</li>
</ul>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable OpenAPI
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.openapi&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-openapi&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>You can very simply add support for OpenAPI to your Helidon SE application. This
document shows what changes you need to make to your application and how to access
the OpenAPI document for your application at runtime.</p>


<h3 id="_changing_your_application">Changing your application</h3>
<div class="section">

<h4 id="_register_openapisupport_in_your_application_routing">Register <code>OpenAPISupport</code> in your application routing</h4>
<div class="section">
<p>Helidon SE provides the <a target="_blank" href="./apidocs/io.helidon.openapi/OpenAPISupport.html"><code>OpenAPISupport</code></a> class which your application uses to assemble the in-memory model and expose the <code>/openapi</code> endpoint to clients. You can create an instance either using a static <code>create</code> method or by instantiating its <a target="_blank" href="./apidocs/io.helidon.openapi/OpenAPISupport.Builder.html"><code>Builder</code></a>. The <router-link to="#register_openapisupport" @click.native="this.scrollFix('#register_openapisupport')">example below</router-link>  illustrates one way to do this.</p>

</div>


<h4 id="_furnish_openapi_information_about_your_endpoints">Furnish OpenAPI information about your endpoints</h4>
<div class="section">
<p>OpenAPI support in Helidon SE largely follows the <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-open-api-3.0/microprofile-openapi-spec-3.0.html">MicroProfile OpenAPI spec</a>.
But because Helidon SE does not process annotations, your application supplies data for the OpenAPI model in the other ways listed earlier.</p>


<h5 id="_provide_a_static_openapi_file">Provide a static OpenAPI file</h5>
<div class="section">
<p>Add a static file at <code>META-INF/openapi.yml</code>, <code>META-INF/openapi.yaml</code>,
or <code>META-INF/openapi.json</code>. Tools such as Swagger let you describe your app&#8217;s API
and they then generate an OpenAPI document file which you can include in your application
so OpenAPI can use it.</p>

</div>


<h5 id="_write_and_configure_a_model_reader_class">Write and configure a model reader class</h5>
<div class="section">
<p>Write a Java class that implements the OpenAPI
<a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-open-api-3.0/apidocs/apidocs/org/eclipse/microprofile/openapi//OASModelReader.html"><code>org.eclipse.microprofile.openapi.OASModelReader</code></a> interface. Your
model reader code programmatically adds elements to the internal model that OpenAPI
builds.</p>

<p>Change your application&#8217;s MP configuration to set <code>mp.openapi.model.reader</code> as the
fully-qualified class name of your class.</p>

</div>


<h5 id="_write_and_configure_a_filter_class">Write and configure a filter class</h5>
<div class="section">
<p>Write a Java class that implements the OpenAPI
<a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-open-api-3.0/apidocs/apidocs/org/eclipse/microprofile/openapi//OASFilter.html"><code>org.eclipse.microprofile.openapi.OASFilter</code></a> interface.
As OpenAPI composes its internal model, it invokes your filter with each
model element <em>before</em> adding the element to the model. Your filter can
accept the element as-is, modify it, or suppress it.</p>

<p>Change your application&#8217;s configuration to set <code>mp.openapi.filter</code> as the full-qualified
class name of your class.</p>

</div>

</div>


<h4 id="_add_openapi_dependency">Add OpenAPI dependency</h4>
<div class="section">
<p>If you implement either a model reader or a filter, add this dependency to your
<code>pom.xml</code>:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;org.eclipse.microprofile.openapi&lt;/groupId&gt;
    &lt;artifactId&gt;microprofile-openapi-api&lt;/artifactId&gt;
    &lt;version&gt;{microprofile-openapi-version}&lt;/version&gt;
&lt;/dependency&gt;</markup>

</div>

</div>


<h3 id="_accessing_the_rest_endpoint">Accessing the REST Endpoint</h3>
<div class="section">
<p>Once you add the SE OpenAPI dependency to your
project and add code to create the <code>OpenAPISupport</code> object to your routing,
your application will automatically respond to the built-in endpoint&#8201;&#8212;&#8201;<code>/openapi</code>&#8201;&#8212;&#8201;and it will return the OpenAPI document describing the endpoints
in your application.</p>

<p>By default, per the MicroProfile OpenAPI spec, the default format of the OpenAPI document is YAML.
There is not yet an adopted IANA YAML media type, but a proposed one specifically
for OpenAPI documents that has some support is <code>application/vnd.oai.openapi</code>.
That is what Helidon returns, by default.</p>

<p>In addition, a client can specify the HTTP header <code>Accept</code> as either <code>application/vnd.oai.openapi+json</code> or
<code>application/json</code> to request JSON. Alternatively, the client can pass the query parameter <code>format</code> as either <code>JSON</code>
or <code>YAML</code> to receive <code>application/json</code> or <code>application/vnd.oai.openapi</code> (YAML) output, respectively.</p>

</div>

</div>


<h2 id="_api">API</h2>
<div class="section">
<p>The <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-open-api-3.0/apidocs">MicroProfile OpenAPI JavaDocs</a> give full details of the
classes and interfaces you can use in your code.
Remember that, although the JavaDocs describe annotations, Helidon SE does not support them.</p>

<p>Helidon SE provides an API for creating and setting up the REST endpoint which serves OpenAPI documents to clients at the <code>/openapi</code> path. Use either static methods on <a target="_blank" href="./apidocs/io.helidon.openapi/OpenAPISupport.html"><code>OpenAPISupport</code></a>  or use its <a target="_blank" href="./apidocs/io.helidon.openapi/OpenAPISupport.Builder.html"><code>Builder</code></a> to create an instance of <code>OpenAPISupport</code>. Then add that instance to your application&#8217;s routing. The <router-link to="#register_openapisupport" @click.native="this.scrollFix('#register_openapisupport')">example</router-link> below shows how to do this.</p>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>Helidon SE OpenAPI configuration supports the following settings:</p>

<p>Type: <a target="_blank" href="./apidocs/io.helidon.openapi/io/helidon/openapi/SEOpenAPISupport.html">io.helidon.openapi.SEOpenAPISupport</a></p>

<markup
lang="text"
title="Config key"
>openapi</markup>


<h3 id="_configuration_options">Configuration options</h3>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>application-path-disable</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Sets whether the app path search should be disabled.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cors</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_reactive_webserver_cors_CrossOriginConfig">CrossOriginConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Assigns the CORS settings for the OpenAPI endpoint.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>custom-schema-registry-class</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets the custom schema registry class.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>filter</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets the developer-provided OpenAPI filter class name.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>model.reader</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets the developer-provided OpenAPI model reader class name.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>schema.*</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets the schema for the indicated fully-qualified class name (represented here by '*'); value is the schema in JSON format. Repeat for multiple classes.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>servers</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets servers.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>servers.operation.*</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets alternative servers to service the indicated operation (represented here by '*'). Repeat for multiple operations.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>servers.path.*</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets alternative servers to service all operations at the indicated path (represented here by '*'). Repeat for multiple paths.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>static-file</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>META-INF/openapi.*</code></td>
<td class=""><doc-view>
<p>Sets the file system path of the static OpenAPI document file. Default types are <code>json</code>, <code>yaml</code>, and <code>yml</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>ui</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_openapi_OpenApiUi">OpenApiUi</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Assigns the OpenAPI U/I builder the <code>OpenAPISupport</code> service should use in preparing the U/I.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>web-context</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>/openapi</code></td>
<td class=""><doc-view>
<p>Sets the web context path for the OpenAPI endpoint.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>Helidon SE provides a <a target="_blank" href="https://github.com/oracle/helidon/tree/master/examples/openapi">complete OpenAPI example</a>
based on the SE QuickStart sample app which includes a model reader and a filter.</p>

<p>Most Helidon SE applications need only to create and register <code>OpenAPISupport</code>.</p>


<h3 id="register_openapisupport">Register <code>OpenAPISupport</code></h3>
<div class="section">
<markup
lang="java"
title="Java Code to Register <code>OpenAPISupport</code> for Routing"
>Config config = Config.create();
return Routing.builder()
        .register(JsonSupport.create())
        .register(OpenAPISupport.create(config)) <span class="conum" data-value="1" />
        .register(health)                   // Health at "/health"
        .register(metrics)                  // Metrics at "/metrics"
        .register("/greet", greetService)
        .build();</markup>

<ul class="colist">
<li data-value="1">Adds the <code>OpenAPISupport</code> service to your server.</li>
</ul>

<p>If you need more control over the <code>OpenAPISupport</code> instance, invoke <code>OpenAPISupport.builder()</code> to get an <code>OpenAPISupport.Builder</code> object and work with it.</p>

</div>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">

<h3 id="_building_the_jandex_index">Building the Jandex index</h3>
<div class="section">
<p>A Jandex index stores information about the classes and methods in your app and
what annotations they have. It allows CDI to process annotations faster during your
application&#8217;s start-up.</p>

<p>Add the <a target="_blank" href="https://github.com/wildfly/jandex-maven-plugin">Jandex maven plug-in</a> to the <code>&lt;build&gt;&lt;plugins&gt;</code>
section of your <code>pom.xml</code>:</p>

<markup
lang="xml"

>&lt;plugin&gt;
    &lt;groupId&gt;org.jboss.jandex&lt;/groupId&gt;
    &lt;artifactId&gt;jandex-maven-plugin&lt;/artifactId&gt;
    &lt;version&gt;{jandex-plugin-version}&lt;/version&gt;
    &lt;executions&gt;
      &lt;execution&gt;
        &lt;id&gt;make-index&lt;/id&gt;
        &lt;goals&gt;
          &lt;goal&gt;jandex&lt;/goal&gt;
        &lt;/goals&gt;
      &lt;/execution&gt;
    &lt;/executions&gt;
&lt;/plugin&gt;</markup>

<p>When you build your app <code>maven</code> should include the index <code>META-INF/jandex.idx</code> in
the JAR.</p>

<div class="admonition note">
<p class="admonition-textlabel">Note</p>
<p ><p>If you <em>do not</em> modify your build to create
the index then the Helidon MP OpenAPI runtime automatically creates one in memory during
app start-up. This slows down your app start-up and, depending on how CDI is
configured, might inadvertently miss information.</p>

<p>We <em>strongly recommend</em> using the Jandex plug-in to build the index into your app.</p>
</p>
</div>

</div>

</div>

</doc-view>
