<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#config-rest-request" @click.native="this.scrollFix('#config-rest-request')">Additional Information</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Helidon SE metrics is inspired by&#8212;&#8203;but does not fully implement&#8212;&#8203;the MicroProfile Metrics specification.
In particular, the Helidon metrics subsystem furnishes</p>

<ul class="ulist">
<li>
<p>a unified way for
Helidon
servers to export monitoring data&#8212;&#8203;telemetry&#8212;&#8203;to management agents, and</p>

</li>
<li>
<p>a unified Java API which all application programmers can use to register and update metrics to expose telemetry data from their services.</p>

</li>
</ul>

<p>Learn more about the <a target="_blank" href="https://github.com/eclipse/microprofile-metrics/releases/tag/4.0">MicroProfile Metrics specification</a>.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable metrics
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"
title="Packaging full-featured metrics"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.metrics&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-metrics&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>Adding this dependency packages the full-featured metrics implementation with your service.</p>


<h3 id="_other_packaging_options">Other packaging options</h3>
<div class="section">
<p>Helidon gives you flexibility in how you make metrics available to your service. <router-link to="/se/metrics/metrics-capable-components">This document</router-link> explains your options.</p>

</div>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">

<h3 id="_instrumenting_your_service">Instrumenting Your Service</h3>
<div class="section">
<p>You add metrics to your service
by writing code which explicitly invokes the metrics API to register metrics, retrieve previously-registered metrics, and update metric values.</p>

<p>Later sections of this document describe how to do
this.</p>

</div>


<h3 id="_categorizing_types_of_metrics">Categorizing Types of Metrics</h3>
<div class="section">
<p>Helidon distinguishes among three general <em>types</em>, or scopes, of metrics, as described in the <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-4.0/microprofile-metrics-spec-4.0.html">MP metrics specification</a>.</p>

<div class="block-title"><span>Types (scopes) of metrics</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Type/scope</th>
<th>Typical Usage</th>
</tr>
</thead>
<tbody>
<tr>
<td class="">base</td>
<td class="">Mandated by the MP metrics specification, such as OS or Java runtime measurements (available heap, disk space, etc.).</td>
</tr>
<tr>
<td class="">vendor</td>
<td class="">Implemented by vendors, including the <code>REST.request</code> metrics and other key performance indicator measurements (described in later sections).</td>
</tr>
<tr>
<td class="">application</td>
<td class="">Declared via annotations or programmatically registered by your service code.</td>
</tr>
</tbody>
</table>
</div>

<p>When you add metrics annotations to your service code, Helidon registers the resulting metrics as type <code>application</code>.</p>

</div>


<h3 id="_metric_registries">Metric Registries</h3>
<div class="section">
<p>A <em>metric registry</em> collects registered metrics of a given type. Helidon supports three registries, one for each of the three metrics types.</p>

<p>When you add code to your service to create a metric programmatically, the code first locates the appropriate registry and then registers the metric with that registry.</p>

</div>


<h3 id="_retrieving_metrics_reports_from_your_service">Retrieving Metrics Reports from your Service</h3>
<div class="section">
<p>When you add the metrics dependency to your project, Helidon automatically provides a built-in REST endpoint <code>/metrics</code> which responds with a report of the registered metrics and their values.</p>

<p>Clients can request a particular output format.</p>

<div class="block-title"><span>Formats for <code>/metrics</code> output</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Format</th>
<th>Requested by</th>
</tr>
</thead>
<tbody>
<tr>
<td class="">OpenMetrics (Prometheus)</td>
<td class="">default (<code>text/plain</code>)</td>
</tr>
<tr>
<td class="">JSON</td>
<td class="">Header <code>Accept: application/json</code></td>
</tr>
</tbody>
</table>
</div>

<p>Clients can also limit the report by appending the metric type to the path:</p>

<ul class="ulist">
<li>
<p><code>/metrics/base</code></p>

</li>
<li>
<p><code>/metrics/vendor</code></p>

</li>
<li>
<p><code>/metrics/application</code></p>

</li>
</ul>

<p>Further, clients can narrow down to a specific metric name by adding the name as a subpath such as <code>/metrics/application/myCount</code>.</p>

<markup
lang="bash"
title="Example Reporting: Prometheus format"
>curl -s -H 'Accept: text/plain' -X GET http://localhost:8080/metrics/</markup>

<div class="listing">
<pre># TYPE base:classloader_total_loaded_class_count counter
# HELP base:classloader_total_loaded_class_count Displays the total number of classes that have been loaded since the Java virtual machine has started execution.
base:classloader_total_loaded_class_count 3157</pre>
</div>

<markup
lang="bash"
title="Example Reporting: JSON format"
>curl -s -H 'Accept: application/json' -X GET http://localhost:8080/metrics/</markup>

<div class="listing">
<pre>{
   "base" : {
      "memory.maxHeap" : 3817865216,
      "memory.committedHeap" : 335544320,
    }
}</pre>
</div>

<p>In addition to your application metrics, the reports contain other
metrics of interest such as system and VM information.</p>

</div>


<h3 id="_enabling_the_metricssupport_rest_service">Enabling the <code>MetricsSupport</code> REST Service</h3>
<div class="section">
<p>To enable the metrics REST endpoint:</p>

<ol style="margin-left: 15px;">
<li>
Create an instance of <a target="_blank" href="./apidocs/io.helidon.metrics.serviceapi/MetricsSupport.html"><code>MetricsSupport</code></a>, either directly as shown below or using its <a target="_blank" href="./apidocs/io.helidon.metrics.serviceapi/MetricsSupport.Builder.html"><code>Builder</code></a>.

</li>
<li>
Include the <code>MetricsSupport</code> instance in your application&#8217;s routing.

</li>
</ol>

<markup
lang="java"

>import io.helidon.metrics.serviceapi.MetricsSupport;

Routing.builder()
        .register(MetricsSupport.create())
        .register("/myapp", new MyService())
        .build();</markup>

</div>

</div>


<h2 id="_api">API</h2>
<div class="section">
<p>To work with Helidon Metrics in your code, follow these steps:</p>

<ol style="margin-left: 15px;">
<li>
Use a static method on the <a target="_blank" href="./apidocs/io.helidon.metrics.api/RegistryFactory.html"><code>RegistryFactory</code></a> to get a reference to the  <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-4.0/apidocs/org/eclipse/microprofile/metrics/MetricRegistry.html"><code>MetricRegistry</code></a> instance you want to use.

</li>
<li>
Use the <code>MetricRegistry</code> instance to register new metrics and look up previously-registered metrics.

</li>
<li>
Use the metric reference returned from the <code>MetricRegistry</code> to update the metric or get its value.

</li>
</ol>

<p>You can also use the <code>MetricRegistry</code> to remove an existing metric.</p>


<h3 id="_helidon_metrics_api">Helidon Metrics API</h3>
<div class="section">
<p>The Helidon Metrics API is aligned with the <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-4.0/apidocs">MicroProfile Metrics API</a>.
That API defines the classes and interfaces for metric types, metric registries, and other related items. Helidon Metrics reuses that API for classes and interfaces (but not for annotations which Helidon SE does not support).</p>

<p>The following table summarizes the metric types.</p>

<div class="block-title"><span>Metric Types</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Metric Type</th>
<th>Usage</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-4.0/apidocs/org/eclipse/microprofile/metrics/Counter.html"><code>Counter</code></a></td>
<td class="">Monotonically increasing count of events.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-4.0/apidocs/org/eclipse/microprofile/metricsConcurrentGauge.html"><code>ConcurrentGauge</code></a></td>
<td class="">Increasing and decreasing measurement of currently-executing blocks of code.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-4.0/apidocs/org/eclipse/microprofile/metrics/Gauge.html"><code>Gauge</code></a></td>
<td class="">Access to a value managed by other code in the service.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-4.0/apidocs/org/eclipse/microprofile/metrics/Meter.html"><code>Meter</code></a></td>
<td class="">Count of invocations and how frequently invocations have occurred.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-4.0/apidocs/org/eclipse/microprofile/metrics/SimpleTimer.html"><code>SimpleTimer</code></a></td>
<td class="">Count of invocations and the total duration consumed by those invocations.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-4.0/apidocs/org/eclipse/microprofile/metrics/Timer.html"><code>Timer</code></a></td>
<td class="">Frequency of invocations and the distribution of how long the invocations take.</td>
</tr>
</tbody>
</table>
</div>

<p>Each metric type has its own set of methods for updating and retrieving the metric&#8217;s value.</p>

</div>


<h3 id="_the_metricregistry_api">The <code>MetricRegistry</code> API</h3>
<div class="section">
<p>To register or look up metrics programmatically, your service code uses one of the three  <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-4.0/apidocs/org/eclipse/microprofile/metrics/MetricRegistry.html"><code>MetricRegistry</code></a> instances (base, vendor, and application) which Helidon furnishes automatically.</p>

<p>To get a <code>MetricRegistry</code> reference, first get a Helidon <a target="_blank" href="./apidocs/io.helidon.metrics.api/RegistryFactory.html"><code>RegistryFactory</code></a>.
Then invoke <code>getRegistry</code> on the <code>RegistryFactory</code> instance.</p>

<p>The <code>MetricRegistry</code> allows your code to register new metrics, look up previously-registered metrics, and remove metrics.</p>

</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>To control how the Helidon metrics subsystem behaves, add a <code>metrics</code> section to
your configuration file, such as <code>application.yaml</code>.</p>

<p>Type: <a target="_blank" href="./apidocs/io.helidon.metrics.serviceapi/io/helidon/metrics/serviceapi/MetricsSupport.html">io.helidon.metrics.serviceapi.MetricsSupport</a></p>


<h3 id="_configuration_options">Configuration options</h3>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>appName</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets the value for the <code>_app</code> tag to be applied to all metrics.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>base</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_metrics_api_BaseMetricsSettings">BaseMetricsSettings</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Set the base metrics settings.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cors</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_reactive_webserver_cors_CrossOriginConfig">CrossOriginConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets the cross-origin config builder for use in establishing CORS support for the service endpoints.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets whether metrics should be enabled.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>key-performance-indicators</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_metrics_api_KeyPerformanceIndicatorMetricsSettings">KeyPerformanceIndicatorMetricsSettings</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Set the KPI metrics settings.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>registries</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_metrics_api_RegistrySettings">Map&lt;string, RegistrySettings&gt;</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets the registry settings for the specified registry type.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>routing</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets the routing name to use for setting up the service&#8217;s endpoint.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>tags</code></td>
<td class=""><doc-view>
<p>Map&lt;string, string&gt;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets the global tags to be applied to all metrics.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>web-context</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets the web context to use for the service&#8217;s endpoint.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>Helidon SE includes several prewritten example applications illustrating aspects of metrics:</p>

<ul class="ulist">
<li>
<p><a target="_blank" href="https://github.com/oracle/helidon/tree/master/examples/metrics/filtering/se">Enabling/disabling metrics</a> using
<code>MetricsSettings</code></p>

</li>
<li>
<p><a target="_blank" href="https://github.com/oracle/helidon/tree/master/examples/metrics/kpi">Controlling key performance indicator metrics</a> using configuration and <code>KeyPerformanceIndicatorMetricsSettings</code>.</p>

</li>
</ul>

<p>The rest of this section shows how to add a metric to your code and how to configure the Helidon metrics subsystem.</p>


<h3 id="_example_application_code">Example Application Code</h3>
<div class="section">
<p>The following example illustrates registering and updating a new <code>Counter</code> in application code.</p>

<markup
lang="java"
title="Define and use a <code>Counter</code>"
>import io.helidon.metrics.api.RegistryFactory;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.MetricRegistry;
//...

public class MyService implements Service {

    private final MetricRegistry registry = RegistryFactory.getInstance()
        .getRegistry(MetricRegistry.Type.APPLICATION); <span class="conum" data-value="1" />
    private final Counter accessCtr = registry.counter("accessctr"); <span class="conum" data-value="2" />

    @Override
    public void update(Routing.Rules rules) {
        rules
             .any(this::countAccess)
             .get("/", this::myGet);
    }

    private void countAccess(ServerRequest request, ServerResponse response) {
            accessCtr.inc(); <span class="conum" data-value="3" />
            request.next();
    }
}</markup>

<ul class="colist">
<li data-value="1">Get the application metric registry.</li>
<li data-value="2">Create a counter in that registry.</li>
<li data-value="3">Increment the counter for every request.</li>
</ul>

<div class="admonition note">
<p class="admonition-inline">Helidon-provided endpoints for <code>/metrics</code> do their work synchronously, using the same thread on which the request arrived via Netty. To prevent performance degradation, avoid including long-running code that can be invoked by these handlers while Helidon is responding to the metric.
For example, if you implement your own application-specific metric types, you will write logic to format the JSON and OpenMetrics output for those metric types. Helidon invokes this formatting logic whenever a client accesses the /metrics endpoints, so make that formatting code as efficient as possible.</p>
</div>

</div>


<h3 id="example-configuration">Example Configuration</h3>
<div class="section">
<p>Metrics configuration is quite extensive and powerful and, therefore, a bit complicated.
The rest of this section illustrates some of the most common scenarios:</p>

<ul class="ulist">
<li>
<p><router-link to="#config-disable" @click.native="this.scrollFix('#config-disable')">Disable metrics entirely.</router-link></p>

</li>
<li>
<p><router-link to="#config-selective" @click.native="this.scrollFix('#config-selective')">Selectively enable or disable metrics by metric registry type and, within type, by name.</router-link></p>

</li>
<li>
<p><router-link to="#config-kpi" @click.native="this.scrollFix('#config-kpi')">Choose whether to collect extended key performance indicator metrics.</router-link></p>

</li>
</ul>


<h4 id="config-disable">Disable Metrics Subsystem</h4>
<div class="section">
<markup
lang="yaml"
title="Disabling metrics entirely"
>metrics:
  enabled: false</markup>

<p>Helidon does not update metrics, and the <code>/metrics</code> endpoints respond with <code>404</code> plus a message that the metrics subsystem is disabled.</p>

</div>


<h4 id="config-selective">Disable Selected Metrics</h4>
<div class="section">
<p>You can be even more selective. Within a registry type you can configure up to two regular expression patterns:</p>

<ul class="ulist">
<li>
<p>one matching metric names to <em>exclude</em>, and</p>

</li>
<li>
<p>one matching metric names to <em>include</em>.</p>

</li>
</ul>

<p>Helidon updates and reports a metric only if two conditions hold:</p>

<ul class="ulist">
<li>
<p>the metric name <em>does not</em> match the <code>exclude</code> regex pattern (if you define one), and</p>

</li>
<li>
<p>either</p>
<ul class="ulist">
<li>
<p>there is no <code>include</code> regex pattern, or</p>

</li>
<li>
<p>the metric name matches the <code>include</code> pattern.</p>

</li>
</ul>

</li>
</ul>

<div class="admonition note">
<p class="admonition-textlabel">Note</p>
<p ><p>Make sure any <code>include</code> regex pattern you specify matches <em>all</em> the metric names you want to capture.</p>
</p>
</div>

<p>Suppose your application creates and updates a group of metrics with names such as <code>myapp.xxx.queries</code>, <code>myapp.xxx.creates</code>, <code>myapp.xxx.updates</code>, and <code>myapp.xxx.deletes</code> where <code>xxx</code> can be either <code>supplier</code> or <code>customer</code>.</p>

<p>The following example gathers all metrics <em>except</em> those from your application regarding suppliers <em>although</em> supplier updates are <em>included</em>:</p>

<markup
lang="yaml"
title="Disabling and enabling metrics by name"
>metrics:
  registries:
    - type: application
      filter:
        exclude: "myapp\.supplier\..*"
        include: "myapp\.supplier\.updates"</markup>

<p>This setting excludes metrics with names starting with <code>myapp.supplier</code> <em>except</em> for the metric <code>myapp.supplier.updates</code>. The <code>exclude</code> and <code>include</code> values are regular expressions.</p>

</div>


<h4 id="config-kpi">Collecting Basic and Extended Key Performance Indicator (KPI) Metrics</h4>
<div class="section">
<p>Any time you include the Helidon metrics module in your application, Helidon tracks two basic performance indicator metrics:</p>

<ul class="ulist">
<li>
<p>a <code>Counter</code> of all requests received (<code>requests.count</code>), and</p>

</li>
<li>
<p>a <code>Meter</code> of all requests received (<code>requests.meter</code>).</p>

</li>
</ul>

<p>Helidon SE also includes additional, extended KPI metrics which are disabled by default:</p>

<ul class="ulist">
<li>
<p>current number of requests in-flight - a <code>ConcurrentGauge</code> (<code>requests.inFlight</code>) of requests currently being processed</p>

</li>
<li>
<p>long-running requests - a <code>Meter</code> (<code>requests.longRunning</code>) measuring the rate at which Helidon processes requests which take at least a given amount of time to complete; configurable, defaults to 10000 milliseconds (10 seconds)</p>

</li>
<li>
<p>load - a <code>Meter</code> (<code>requests.load</code>) measuring the rate at which requests are worked on (as opposed to received)</p>

</li>
<li>
<p>deferred - a <code>Meter</code> (<code>requests.deferred</code>) measuring the rate at which a request&#8217;s processing is delayed after Helidon receives the request</p>

</li>
</ul>

<p>You can enable and control these metrics using configuration:</p>

<markup
lang="yaml"
title="Controlling extended KPI metrics"
>metrics:
  key-performance-indicators:
    extended: true
    long-running:
      threshold-ms: 2000</markup>

</div>

</div>

</div>


<h2 id="config-rest-request">Additional Information</h2>
<div class="section">

<h3 id="_support_for_the_prometheus_metrics_api">Support for the Prometheus Metrics API</h3>
<div class="section">
<p>Helidon provides optional support for the Prometheus metrics API.</p>

<p>To use it, your service registers Prometheus support with your routing set-up.
You can customize its configuration. For information about using Prometheus, see the
Prometheus documentation: <a target="_blank" href="https://prometheus.io/docs/introduction/overview/" class="bare">https://prometheus.io/docs/introduction/overview/</a>.</p>

<div class="admonition note">
<p class="admonition-inline">Helidon&#8217;s fully-functional, built-in metrics implementation supports Prometheus (OpenMetrics) output. Use the optional support described in <em>this</em> section only if you want to use the Prometheus <em>API</em> from your application code.</p>
</div>


<h4 id="prom-maven-coordinates">Maven Coordinates</h4>
<div class="section">
<markup
lang="xml"
title="Dependency for Helidon Prometheus API support"
>    &lt;dependency&gt;
        &lt;groupId&gt;io.helidon.metrics&lt;/groupId&gt;
        &lt;artifactId&gt;helidon-metrics-prometheus&lt;/artifactId&gt;
    &lt;/dependency&gt;</markup>

</div>


<h4 id="prom-usage">Usage</h4>
<div class="section">
<p>Your application code uses the Prometheus API to manage metrics.
To expose those metrics to clients via a REST endpoint, your code uses the <code>PrometheusSupport</code> interface which Helidon provides.</p>

</div>


<h4 id="prom-api">API</h4>
<div class="section">
<p>Your code creates a <a target="_blank" href="./apidocs/io.helidon.metrics.prometheus/PrometheusSupport.html"><code>PrometheusSupport</code></a> object either using a static factory method (shown in the following example) or by using its <a target="_blank" href="./apidocs/io.helidon.metrics.prometheus/PrometheusSupport.Builder.html"><code>Builder</code></a>.</p>

<markup
lang="java"

>import io.helidon.metrics.prometheus.PrometheusSupport;

Routing.builder()
                .register(PrometheusSupport.create())
                .register("/myapp", new MyService())
                .build();</markup>

<p>This example uses the default Prometheus <code>CollectorRegistry</code>. By default, the <code>PrometheusSupport</code> and exposes its REST endpoint at the path
<code>/metrics</code>. Use the builder obtained by <code>PrometheusSupport.builder()</code> to
configure a different <code>CollectorRegistry</code> or a different path.</p>

</div>

</div>

</div>

</doc-view>
