<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Performance Tuning</dt>
<dd slot="desc"><p>In this guide you fill find basic advice for performance tuning of your Helidon application. Most of them target Netty tuning, as Helidon is based on it.
You should also consider configuring/tuning Java heap size as per any Java application.</p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configure_netty_worker_thread_pool_size">Configure Netty worker thread pool size</h2>
<div class="section">
<p>The Netty worker thread-pool is what handles your incoming requests. It defaults to 2*NCPU. To set it to something else you can set <code>worker-count</code> in <code>resources/application.yaml</code>:</p>

<markup
lang="yaml"

>server:
  port: 8080
  host: 0.0.0.0
  worker-count: 2</markup>

</div>


<h2 id="_configure_nettys_maxorder_helidon_2_4_1_or_earlier">Configure Netty&#8217;s maxOrder (Helidon 2.4.1 or earlier)</h2>
<div class="section">
<p>In some situations Netty can aggressively allocate memory per request. This has been addressed in recent versions of Helidon and Netty, but if you are running an earlier version set this system property when you start your Helidon application:</p>

<markup
lang="bash"

>-Dio.netty.allocator.maxOrder=6</markup>

<p>You can try smaller numbers.</p>

</div>

</doc-view>
