<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Helidon SE 3.x Upgrade Guide</dt>
<dd slot="desc"><p>In Helidon 3 we have made some changes to APIs and runtime behavior. This guide
will help you upgrade a Helidon SE 2.x application to 3.x.</p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_java_17_runtime">Java 17 Runtime</h2>
<div class="section">
<p>Java 11 is no longer supported in Helidon 3. Java 17 or newer is required. Please follow the instructions in <router-link to="/about/prerequisites">Prerequisites</router-link> for proper installation.</p>

</div>


<h2 id="_new_routing">New Routing</h2>
<div class="section">
<p>Handling routes based on the protocol version is now possible by registering specific routes
on routing builder.</p>

<p>For further information check <router-link to="/se/webserver">WebServer Documentation</router-link></p>

</div>


<h2 id="_http2_support">Http/2 Support</h2>
<div class="section">
<p>Helidon support of Http/2 is no longer experimental.</p>

<p>Http/2 needed to be explicitly enabled by configuration in Helidon 2:</p>

<markup
lang="yaml"
title="Enabling Http/2 support in Helidon 2"
>server:
  port: 8080
  host: 0.0.0.0
  experimental:
    enable-http2: true
    http2-max-content-length: 16384</markup>

<p>In Helidon 3 Http/2 is automatically enabled when artifact with Http/2 support is
available on the classpath.</p>

<markup
lang="xml"
title="Enabling Http/2 support in Helidon 3 by adding dependency"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.reactive.webserver&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-reactive-webserver-http2&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>With above dependency Helidon 3 supports Http/2 upgrade from Http/1,
cleartext Http/2 without prior knowledge and Http/2 with ALPN over TLS.</p>

<p>In Helidon 2, max content length was configurable with <code>server.experimental.http2-max-content-length</code>, in Helidon 3 can be configured with <code>server.max-upgrade-content-length</code> globally or per socket with the same <code>max-upgrade-content-length</code> key.</p>

<markup
lang="yaml"
title="Max upgrade content length in Helidon 3"
>server:
  port: 8080
  host: 0.0.0.0
  max-upgrade-content-length: 16384</markup>

<p>For further information check <router-link to="/se/webserver">WebServer Documentation</router-link></p>

</div>


<h2 id="_websocket">WebSocket</h2>
<div class="section">
<p>Helidon SE support is now based on the <code>WebSocketRouting</code> class which enables Helidon application to
configure routing for both annotated and programmatic WebSocket endpoints.
<code>TyrusSupport</code> is now deprecated. Websocket support in now placed in different artifact.</p>

<markup
lang="xml"
title="Helidon 2 WebSocket support dependency"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.reactive.webserver&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-reactive-webserver-tyrus&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<markup
lang="xml"
title="Helidon 3 WebSocket support dependency"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.reactive.webserver&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-reactive-webserver-websocket&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>In Helidon 2, WebSocket routing is defined by registering <code>TyrusSupport</code> as additional service:</p>

<markup
lang="java"
title="Helidon 2 WebSocket route registering"
>WebServer.builder(Routing.builder()
             .register("/rest", new SomeRestService()) <span class="conum" data-value="1" />
             .register("/websocket",TyrusSupport.builder() <span class="conum" data-value="2" />
                 .register(ServerEndpointConfig.Builder
                           .create(MessageBoardEndpoint.class, "/")
                           .encoders(encoders)
                           .build())
                 .build()
             ))
             .port(8080)
   .build();</markup>

<ul class="colist">
<li data-value="1">Traditional REST routing service registration</li>
<li data-value="2">WebSocket setup with Tyrus service</li>
</ul>

<p>In Helidon 3, WebSocket routing is defined by adding another routing:</p>

<markup
lang="java"
title="Helidon 3 WebSocket route registering"
>WebServer.builder()
         .routing(r -&gt; r
              .register("/rest", new SomeRestService()) <span class="conum" data-value="1" />
         )
         .addRouting(WebSocketRouting.builder() <span class="conum" data-value="2" />
                        .endpoint("/websocket", ServerEndpointConfig.Builder
                                .create(MessageBoardEndpoint.class, "/board")
                                .encoders(encoders)
                                .build())
                        .build())
         .port(8080)</markup>

<ul class="colist">
<li data-value="1">Traditional REST routing service registration</li>
<li data-value="2">WebSocket routing setup</li>
</ul>

</div>


<h2 id="_deprecations">Deprecations</h2>
<div class="section">
<ul class="ulist">
<li>
<p>The custom Helidon OCI clients have been deprecated (<a target="_blank" href="https://github.com/oracle/helidon/pull/4015">See PR</a>). Use the OCI Java SDK instead. If you use Helidon MP you can inject OCI SDK clients by adding the dependency <code>io.helidon.integrations.oci.sdk:helidon-integrations-oci-sdk-cdi</code>.</p>

</li>
</ul>

<div class="admonition note">
<p class="admonition-inline">See <router-link :to="{path: '/se/integrations/oci', hash: '#oci-compatibility'}">Resolving compatibility issue with OCI SDK</router-link> for detailed information on how to work around this issue.</p>
</div>

<ul class="ulist">
<li>
<p>The MultiPart buffered readers have been deprecated (<a target="_blank" href="https://github.com/oracle/helidon/pull/4096">See PR</a>). Use the MultiPart stream readers instead.</p>

</li>
</ul>


<h3 id="_helidon_common">Helidon Common</h3>
<div class="section">
<p>Deprecations in the following classes:</p>

<ul class="ulist">
<li>
<p><code>Resource</code> - old configuration approach (since 2.0)</p>

</li>
<li>
<p><code>ThreadPoolSupplier</code> - Named thread pools (since 2.4.2)</p>

</li>
</ul>

<p>More information in the following <a target="_blank" href="https://github.com/oracle/helidon/issues/4363">Task</a>.</p>

</div>


<h3 id="_media_common">Media Common</h3>
<div class="section">
<p>Deprecations in the following classes:</p>

<ul class="ulist">
<li>
<p><code>ContentReaders</code> - Methods with alternatives (since 2.0)</p>

</li>
<li>
<p><code>ContentTypeCharset</code> - Class with alternative (since 2.0)</p>

</li>
<li>
<p><code>ContentWriters</code> - Methods with alternatives (since 2.0)</p>

</li>
<li>
<p><code>MessageBodyReaderContext</code> - Methods with alternatives (since 2.0)</p>

</li>
<li>
<p><code>MessageBodyWriterContext</code> - Methods with alternatives (since 2.0)</p>

</li>
<li>
<p><code>ReadableByteChannelPublisher</code> - Class with alternative (since 2.0)</p>

</li>
</ul>

<p>More information in the following <a target="_blank" href="https://github.com/oracle/helidon/issues/4364">Task</a>.</p>

</div>


<h3 id="_metrics">Metrics</h3>
<div class="section">
<p>Deprecations in the following classes:</p>

<ul class="ulist">
<li>
<p><code>MetricsSupport</code> - 3 methods, replacing Config with metrics settings</p>

</li>
<li>
<p><code>KeyPerformanceIndicatorMetricsSettings</code> - New class in metrics API, for backward compatibility only</p>

</li>
<li>
<p><code>RegistryFactory</code> - New class in metrics API, for backward compatibility only</p>

</li>
</ul>

<p>More information in the following <a target="_blank" href="https://github.com/oracle/helidon/issues/4365">Task</a>.</p>

</div>


<h3 id="_common_context">Common Context</h3>
<div class="section">
<p>Deprecations in the following class:</p>

<ul class="ulist">
<li>
<p><code>DataPropagationProvider</code> - clearData should use new method</p>

</li>
</ul>

<p>More information in the following <a target="_blank" href="https://github.com/oracle/helidon/issues/4366">Task</a>.</p>

</div>


<h3 id="_grpc_core">GRPC core</h3>
<div class="section">
<p>Deprecations:</p>

<ul class="ulist">
<li>
<p><code>JavaMarshaller</code> - removed support for JavaMarshaller</p>

</li>
</ul>

<p>More information in the following <a target="_blank" href="https://github.com/oracle/helidon/issues/4367">Task</a>.</p>

</div>


<h3 id="_lra">LRA</h3>
<div class="section">
<p>Deprecations in the following class:</p>

<ul class="ulist">
<li>
<p><code>CoordinatorClient</code> - multiple methods</p>

</li>
<li>
<p><code>Headers</code></p>

</li>
</ul>

<p>More information in the following <a target="_blank" href="https://github.com/oracle/helidon/issues/4368">Task</a>.</p>

</div>


<h3 id="_mp_messaging">MP Messaging</h3>
<div class="section">
<p>Deprecations in the following class:</p>

<ul class="ulist">
<li>
<p><code>MessagingCdiExtension</code> - Alternative methods used</p>

</li>
</ul>

<p>More information in the following <a target="_blank" href="https://github.com/oracle/helidon/issues/4369">Task</a>.</p>

</div>


<h3 id="_jwt">JWT</h3>
<div class="section">
<p>Deprecations in the following class:</p>

<ul class="ulist">
<li>
<p><code>Jwt</code> - Audience can be a list (since 2.4.0)</p>

</li>
</ul>

<p>More information in the following <a target="_blank" href="https://github.com/oracle/helidon/issues/4370">Task</a>.</p>

</div>


<h3 id="_mp_metrics">MP Metrics</h3>
<div class="section">
<p>Deprecations in the following class:</p>

<ul class="ulist">
<li>
<p><code>MetricUtil</code> - multiple methods</p>

</li>
<li>
<p><code>MetricsCdiExtension</code> - multiple methods</p>

</li>
</ul>

<p>More information in the following <a target="_blank" href="https://github.com/oracle/helidon/issues/4371">Task</a>.</p>

</div>


<h3 id="_http_signature_security_provider">HTTP Signature Security Provider</h3>
<div class="section">
<ul class="ulist">
<li>
<p><code>backwardCompatibleEol</code> - set to false</p>

</li>
</ul>

<p>More information in the following <a target="_blank" href="https://github.com/oracle/helidon/issues/4372">Task</a>.</p>

</div>


<h3 id="_service_common">Service Common</h3>
<div class="section">
<p>Deprecations in the following class:</p>

<ul class="ulist">
<li>
<p><code>HelidonRestServiceSupport</code> - method <em>configureEndpoint(Rules)</em></p>

</li>
</ul>

<p>More information in the following <a target="_blank" href="https://github.com/oracle/helidon/issues/4371">Task</a>.</p>

</div>


<h3 id="_webserver">WebServer</h3>
<div class="section">
<ul class="ulist">
<li>
<p><code>Static content support</code> in <code>WebServer</code> - moved to a separate module. Fully removed from <code>WebServer</code> module.</p>

</li>
</ul>

<p>More information in the following <a target="_blank" href="https://github.com/oracle/helidon/issues/4374">Task</a>.</p>

</div>

</div>

</doc-view>
