<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>The Helidon GraphQL Server provides a framework for creating <a target="_blank" href="https://github.com/graphql-java/graphql-java">GraphQL</a>
applications that integrate with the Helidon WebServer. GraphQL is a query language to access server data.
The Helidon GraphQL integration enables HTTP clients to issue queries over the network and retrieve data;
it is an alternative to other protocols such as REST or GRPC.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable GraphQL
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.graphql&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-graphql-server&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_api">API</h2>
<div class="section">
<p>An instance of <code>GraphQlSupport</code> must be registered in the Helidon WebServer routes to enable
GraphQL support in your application. In addition, a GraphQL schema needs to be specified
to verify and execute queries.</p>

<p>The following code fragment creates an instance of <code>GraphQlSupport</code> and registers it in the
Helidon WebServer.</p>

<markup
lang="java"

>    WebServer server = WebServer.builder()
            .routing(Routing.builder()
                            .register(GraphQlSupport.create(buildSchema()))
                            .build())
            .build();</markup>

<p>By default, <code>GraphQlSupport</code> will reserve  <code>/graphql</code> as the URI path to process queries.
The <code>buildSchema</code> method creates the schema and defines 2 types of queries for this
application:</p>

<markup
lang="java"

>private static GraphQLSchema buildSchema() {
    String schema = "type Query{\n"    <span class="conum" data-value="1" />
            + "hello: String \n"
            + "helloInDifferentLanguages: [String] \n"
            + "\n}";

    SchemaParser schemaParser = new SchemaParser();
    TypeDefinitionRegistry typeDefinitionRegistry = schemaParser.parse(schema);

    // DataFetcher to return various hellos in difference languages  <span class="conum" data-value="2" />
    DataFetcher&lt;List&lt;String&gt;&gt; hellosDataFetcher = (DataFetcher&lt;List&lt;String&gt;&gt;) environment -&gt;
            List.of("Bonjour", "Hola", "Zdravstvuyte", "Nǐn hǎo", "Salve", "Gudday",
                    "Konnichiwa", "Guten Tag");

    RuntimeWiring runtimeWiring = RuntimeWiring.newRuntimeWiring()  <span class="conum" data-value="3" />
            .type("Query", builder -&gt; builder.dataFetcher("hello", new StaticDataFetcher("world")))
            .type("Query", builder -&gt; builder.dataFetcher("helloInDifferentLanguages", hellosDataFetcher))
            .build();

    SchemaGenerator schemaGenerator = new SchemaGenerator();
    return schemaGenerator.makeExecutableSchema(typeDefinitionRegistry, runtimeWiring);  <span class="conum" data-value="4" />
}</markup>

<p>The following is a description of each of these steps:</p>

<ul class="colist">
<li data-value="1">Define the GraphQL schema.</li>
<li data-value="2">Create a <code>DataFetcher</code> to return a list of hellos in different languages.</li>
<li data-value="3">Wire up the <code>DataFetcher</code> s.</li>
<li data-value="4">Generate the GraphQL schema.</li>
</ul>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>The following configuration keys can be used to set up integration with WebServer:</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 22.222%;">
<col style="width: 22.222%;">
<col style="width: 55.556%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>graphql.web-context</code></td>
<td class=""><code>/graphql</code></td>
<td class="">Context that serves the GraphQL endpoint.</td>
</tr>
<tr>
<td class=""><code>graphql.schema-uri</code></td>
<td class=""><code>/schema.graphql</code></td>
<td class="">URI that serves the schema (under web context)</td>
</tr>
<tr>
<td class=""><code>graphql.cors</code></td>
<td class="">&#160;</td>
<td class="">CORS configuration for this service</td>
</tr>
<tr>
<td class=""><code>graphql.executor-service</code></td>
<td class="">&#160;</td>
<td class="">Configuration of <code>ServerThreadPoolSupplier</code> used to set up executor service</td>
</tr>
</tbody>
</table>
</div>

<p>The following configuration keys can be used to set up GraphQL invocation:</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 22.222%;">
<col style="width: 22.222%;">
<col style="width: 55.556%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>graphql.default-error-message</code></td>
<td class=""><code>Server Error</code></td>
<td class="">Error message to send to caller in case of error</td>
</tr>
<tr>
<td class=""><code>graphql.exception-white-list</code></td>
<td class="">&#160;</td>
<td class="">Array of checked exception classes that should return default error message</td>
</tr>
<tr>
<td class=""><code>graphql.exception-black-list</code></td>
<td class="">&#160;</td>
<td class="">Array of unchecked exception classes that should return message to caller (instead of default error message)</td>
</tr>
</tbody>
</table>
</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>Using the schema defined in Section <router-link to="#_api" @click.native="this.scrollFix('#_api')"></router-link>, you can probe the following endpoints:</p>

<ol style="margin-left: 15px;">
<li>
Hello world endpoint
<markup
lang="bash"

>curl -X POST http://127.0.0.1:PORT/graphql -d '{"query":"query { hello }"}'

"data":{"hello":"world"}}</markup>

</li>
<li>
Hello in different languages
<markup
lang="bash"

>curl -X POST http://127.0.0.1:PORT/graphql -d '{"query":"query { helloInDifferentLanguages }"}'

{"data":{"helloInDifferentLanguages":["Bonjour","Hola","Zdravstvuyte","Nǐn hǎo","Salve","Gudday","Konnichiwa","Guten Tag"]}}</markup>

</li>
</ol>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="./apidocs/io.helidon.graphql.server/module-summary.html">GraphQL Javadocs</a></p>

</li>
</ul>

</div>

</doc-view>
