<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>The <a target="_blank" href="https://www.w3.org/TR/cors">cross-origin resource sharing (CORS) protocol</a> helps developers control if and how REST resources served by their applications can be shared across origins.
Helidon SE includes an implementation of CORS that you can use to add CORS behavior
to the services you develop. You can define your application&#8217;s CORS behavior programmatically using the Helidon CORS API alone, or
together with configuration.</p>

<p>Helidon also provides three built-in services that add their
own endpoints to your application&#8201;&#8212;&#8201;health, metrics, and OpenAPI&#8201;&#8212;&#8201;that have integrated CORS support.
By adding very little code to your application, you control how all the resources in
your application&#8201;&#8212;&#8201;the ones you write and the ones provided by the Helidon built-in services&#8201;&#8212;&#8201;can be shared across origins.</p>


<h3 id="_before_you_begin">Before You Begin</h3>
<div class="section">
<p>Before you revise your application to add CORS support, you need to decide what type of cross-origin sharing you want
to allow for each resource your application exposes.
For example, suppose for a given resource you want to allow unrestricted sharing for GET, HEAD, and POST requests
(what CORS refers to as "simple" requests), but permit other types of requests only from the two
origins <code>foo.com</code> and <code>there.com</code>.
Your application would implement two types of CORS sharing: more relaxed for the
simple requests and stricter for others.</p>

<p>Once you know the type of sharing you want to allow for each of your resources&#8201;&#8212;&#8201;including any from built-in
services&#8201;&#8212;&#8201;you can change your application accordingly.</p>

</div>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable CORS
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.reactive.webserver&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-reactive-webserver-cors&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_api">API</h2>
<div class="section">
<p>Every Helidon SE application explicitly creates routing rules that govern how Helidon delivers each incoming
request to the code that needs to respond. To add CORS behavior to endpoints, you need to make only minimal
changes to how you set up the routing for those endpoints.
Using the Helidon SE CORS API, you define the CORS behavior that you want and then include that behavior
as you build the routing rules for the services in your application.</p>

<p>The Helidon SE CORS API provides two key classes that you use in your application:</p>

<ul class="ulist">
<li>
<p><code>CorsSupport</code> - Represents information about resource sharing for a single resource.
Typically, you create one <code>CorsSupport</code> instance for each distinct resource in your application
(such as the <code>/greet</code> resource in the QuickStart greeting application) that should participate in CORS.</p>

</li>
<li>
<p><code>CrossOriginConfig</code> - Represents the details for a particular type of sharing, such as which origins are
allowed to have access using which HTTP methods, etc.
Create one instance of <code>CrossOriginConfig</code> for each different type of sharing you need.</p>

</li>
</ul>

<p>You associate one or more <code>CrossOriginConfig</code> objects with each <code>CorsSupport</code> object.
You use the <code>CorsSupport</code> object when you construct the routing rules for the service.
When your application is running and requests arrive, the Helidon CORS implementation enforces
the CORS behavior represented by the <code>CorsSupport</code> object before routing the request to your
endpoint code for the resource.</p>

<p>Because Helidon SE does not use annotation processing to identify endpoints, you need to
provide the CORS information for your application another way&#8201;&#8212;&#8201;by including CORS into the routing you construct for your application.</p>

<p>For each distinct resource or subresource your application exposes:</p>

<ol style="margin-left: 15px;">
<li>
Create a <a target="_blank" href="./apidocs/io.helidon.reactive.webserver.cors/io/helidon/reactive/webserver/cors/CorsSupport.html"><code>CorsSupport</code></a> instance
corresponding to the resource.

</li>
<li>
For each different type of sharing you want to provide for that resource:
<ol style="margin-left: 15px;">
<li>
Create a <a target="_blank" href="./apidocs/io.helidon.reactive.webserver.cors/io/helidon/reactive/webserver/cors/CrossOriginConfig.html"><code>CrossOriginConfig</code></a> instance.<br>

The <code>CrossOriginConfig</code> Java class represents the details for a particular type of sharing, such as
which origins are allowed to share via which HTTP methods, etc.

</li>
<li>
Add the <code>CrossOriginConfig</code> to the <code>CorsSupport</code> instance for this resource.

</li>
</ol>

</li>
<li>
Use the resource&#8217;s <code>CorsSupport</code> object in setting up the routing rules for that resource.

</li>
</ol>

<p>Each of these classes has an associated builder that you use in constructing instances of the class.</p>

<p>The table below describes the methods on the <code>CrossOriginConfig.Builder</code> class and the configuration keys
that map to the headers defined in the CORS protocol. (A later section discusses <router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">configuration</router-link>.)</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 16.667%;">
<col style="width: 16.667%;">
<col style="width: 16.667%;">
<col style="width: 16.667%;">
<col style="width: 16.667%;">
<col style="width: 16.667%;">
</colgroup>
<thead>
<tr>
<th>builder method</th>
<th>config key</th>
<th>type</th>
<th>default</th>
<th>description</th>
<th>CORS header name</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>allowCredentials</code></td>
<td class=""><code>allow-credentials</code></td>
<td class="">boolean</td>
<td class=""><code>false</code></td>
<td class="">Sets the allow credentials flag.</td>
<td class=""><code>Access-Control-Allow-Credentials</code></td>
</tr>
<tr>
<td class=""><code>allowHeaders</code></td>
<td class=""><code>allow-headers</code></td>
<td class="">string[]</td>
<td class=""><code>*</code></td>
<td class="">Sets the allowed headers.</td>
<td class=""><code>Access-Control-Allow-Headers</code></td>
</tr>
<tr>
<td class=""><code>allowMethods</code></td>
<td class=""><code>allow-methods</code></td>
<td class="">string[]</td>
<td class=""><code>*</code></td>
<td class="">Sets the allowed methods.</td>
<td class=""><code>Access-Control-Allow-Methods</code></td>
</tr>
<tr>
<td class=""><code>allowOrigins</code></td>
<td class=""><code>allow-origins</code></td>
<td class="">string[]</td>
<td class=""><code>*</code></td>
<td class="">Sets the allowed origins.</td>
<td class=""><code>Access-Control-Allow-Origins</code></td>
</tr>
<tr>
<td class=""><code>exposeHeaders</code></td>
<td class=""><code>expose-headers</code></td>
<td class="">string[]</td>
<td class="">&#160;</td>
<td class="">Sets the expose headers.</td>
<td class=""><code>Access-Control-Expose-Headers</code></td>
</tr>
<tr>
<td class=""><code>maxAgeSeconds</code></td>
<td class=""><code>max-age-seconds</code></td>
<td class="">long</td>
<td class=""><code>3600</code></td>
<td class="">Sets the maximum age.</td>
<td class=""><code>Access-Control-Max-Age</code></td>
</tr>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><code>enabled</code></td>
<td class="">boolean</td>
<td class=""><code>true</code></td>
<td class="">Sets whether this config should be enabled or not.</td>
<td class="">n/a</td>
</tr>
</tbody>
</table>
</div>

<p>If the cross-origin configuration is disabled (<code>enabled</code> = false), then the Helidon CORS implementation ignores the cross-origin configuration entry.</p>


<h3 id="se-api-routing-example">Sample Routing Setup Using the <code>CrossOriginConfig</code> API</h3>
<div class="section">
<p>The <a target="_blank" href="https://github.com/oracle/helidon/tree/master/examples/quickstarts/helidon-quickstart-se">Helidon SE Quickstart application</a>
 lets you change the greeting by sending a <code>PUT</code> request to the <code>/greet/greeting</code> resource.</p>

<p>This example, based on the QuickStart greeting app, uses the low-level <code>CrossOriginConfig</code> API and
the <code>CorsSupport</code> API to influence the <router-link :to="{path: '/se/webserver', hash: '#routing'}">routing</router-link>,
thereby determining how that resource is shared. (If desired, you can use <router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">configuration</router-link> instead
of the low-level API.)</p>

<p>The following code shows how to prepare your application&#8217;s routing to support metrics and health support, as well as
CORS.</p>

<markup
lang="java"

>private static Routing createRouting(Config config) {
    MetricsSupport metrics = MetricsSupport.create();
    GreetService greetService = new GreetService(config);
    HealthSupport health = HealthSupport.builder()
            .add(HealthChecks.healthChecks())   // Adds a convenient set of checks
            .build();
    CorsSupport corsSupport = CorsSupport.builder()  <span class="conum" data-value="1" />
            .addCrossOriginConfig(CrossOriginConfig.builder() <span class="conum" data-value="2" />
                        .allowOrigins("http://foo.com", "http://there.com") <span class="conum" data-value="3" />
                        .allowMethods("PUT", "DELETE") <span class="conum" data-value="4" />
                        .build()) <span class="conum" data-value="5" />
            .addCrossOriginConfig(CrossOriginConfig.create()) <span class="conum" data-value="6" />
            .build(); <span class="conum" data-value="7" />

    // Note: Add the CORS routing *before* registering the GreetService routing.
    return Routing.builder()
            .register(JsonSupport.create())
            .register(health)                   // Health at "/health"
            .register(metrics)                 // Metrics at "/metrics"
            .register("/greet", corsSupport, greetService) <span class="conum" data-value="8" />
            .build();
}</markup>

<ul class="colist">
<li data-value="1">Create a <code>CorsSupport.Builder</code> instance.</li>
<li data-value="2">Add a <code>CrossOriginSupport</code> instance (using <em>its</em> builder) to constrain resource sharing.</li>
<li data-value="3">List the origins (sites) allowed to share resources from this app.</li>
<li data-value="4">List the HTTP methods the constraint applies to.</li>
<li data-value="5">Build the <code>CrossOriginSupport</code> instance.</li>
<li data-value="6">Add a <code>CrossOriginSupport</code> instance that permits all sharing (the default).</li>
<li data-value="7">Build the <code>CorsSupport</code> instance.</li>
<li data-value="8">Register the new <code>CorsSupport</code> instance with&#8201;&#8212;&#8201;but in front of&#8201;&#8212;&#8201;the service which implements the business logic.</li>
</ul>

<p>The order of steps 2 and 6 above is important. When processing an incoming request, the Helidon CORS implementation
scans the <code>CrossOriginConfig</code> instances in the order they were added to the <code>CorsSupport</code> object, stopping as soon as
it finds a <code>CrossOriginConfig</code> instance for which <code>allowMethods</code> matches the HTTP method of the
request.</p>

<p>The few additional lines described above allow the greeting application to participate in CORS.</p>

</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>You can use configuration in combination with the Helidon CORS SE API to add CORS support to your resources by
replacing some Java code with declarative configuration. This also gives your users a way to override the
CORS behavior of your services without requiring the code to change.</p>


<h3 id="cors-configuration-formats">Understanding the CORS Configuration Formats</h3>
<div class="section">
<p>Support in Helidon for CORS configuration uses two closely-related cross-origin configuration formats: basic and mapped.
Each format corresponds to a class
in the Helidon CORS library.
The basic format corresponds to the <a target="_blank" href="./apidocs/io.helidon.reactive.webserver.cors/io/helidon/reactive/webserver/cors/CrossOriginConfig.html"><code>CrossOriginConfig</code></a>
class, and the mapped format corresponds to the
<a target="_blank" href="./apidocs/io.helidon.reactive.webserver.cors/io/helidon/reactive/webserver/cors/MappedCrossOriginConfig.html"><code>MappedCrossOriginConfig</code></a> class.</p>

</div>


<h3 id="basic-cross-origin-config">Basic Cross-Origin Configuration</h3>
<div class="section">
<p>In configuration, Helidon represents basic CORS information as a section, identified by a configuration key of your choosing, that contains
one or more key/value pairs. Each key-value pair assigns one characteristic of CORS behavior.</p>

<p>The table below lists the configuration keys that identify the CORS characteristics.</p>

<p id="config-key-table">include::[tag=cors-config-table]</p>

<p>The following example of basic cross-origin
configuration, when loaded and used by the application,
limits cross-origin resource sharing for <code>PUT</code> and
<code>DELETE</code> operations to only <code>foo.com</code> and <code>there.com</code>:</p>

<markup
lang="yaml"

>restrictive-cors:
  allow-origins: ["http://foo.com", "http://there.com"]
  allow-methods: ["PUT", "DELETE"]</markup>

</div>


<h3 id="_mapped_cross_origin_configuration">Mapped Cross-Origin Configuration</h3>
<div class="section">
<p>In some cases, you or your users might want to configure CORS behavior based on URL path matching.
Helidon represents mapped CORS information as a section, identified by a configuration
key of your choosing, that contains:</p>

<ul class="ulist">
<li>
<p>An optional <code>enabled</code> setting which defaults to <code>true</code> and applies to the whole mapped CORS config section, and</p>

</li>
<li>
<p>An optional <code>paths</code> subsection containing zero or more entries, each of which contains:</p>
<ul class="ulist">
<li>
<p>a basic CORS config section, and</p>

</li>
<li>
<p>a <code>path-pattern</code> path pattern that maps that basic CORS config section to the resource(s) it affects.</p>

</li>
</ul>

</li>
</ul>

<p>You can use mapped configuration to your advantage if you want to allow your users to override the CORS behavior set up
in the application code.</p>

<p>The following example illustrates the mapped cross-origin configuration format.</p>

<markup
lang="hocon"

>my-cors: <span class="conum" data-value="1" />
  paths: <span class="conum" data-value="2" />
    - path-pattern: /greeting <span class="conum" data-value="3" />
      allow-origins: ["http://foo.com", "http://there.com", "http://other.com"] <span class="conum" data-value="4" />
      allow-methods: ["PUT", "DELETE"]
    - path-pattern: / <span class="conum" data-value="5" />
      allow-methods: ["GET", "HEAD", "OPTIONS", "POST"] <span class="conum" data-value="6" /></markup>

<ul class="colist">
<li data-value="1">Assigns a unique identifier for this mapped CORS config section.</li>
<li data-value="2">Collects the sequence of entries, each of which maps a basic CORS config to a path pattern.</li>
<li data-value="3">Marks the beginning of an entry (the <code>-</code> character) and maps the associated basic CORS config
to the <code>/greeting</code> subresource (the <code>path-pattern</code> key and value).</li>
<li data-value="4">Begins the basic CORS config section for <code>/greeting</code>; it
restricts sharing via <code>PUT</code> and <code>DELETE</code> to the listed origins.</li>
<li data-value="5">Marks the beginning of the next entry (the <code>-</code> character) and maps the associated basic CORS config to
the top-level resource in the app (the <code>path-pattern</code> key and value).</li>
<li data-value="6">Begins the basic CORS config section for <code>/</code>; it permits sharing of resources at the top-level path with all origins
for the indicated HTTP methods.</li>
</ul>

<p>Path patterns can be any expression accepted by the <a target="_blank" href="./apidocs/io.helidon.reactive.webserver/io/helidon/reactive/webserver/PathMatcher.html"><code>PathMatcher</code></a> class.</p>

<div class="admonition note">
<p class="admonition-inline">Be sure to arrange the entries in the order that you want Helidon to check them.
Helidon CORS support searches the cross-origin entries in the order you define them until it finds an entry that
matches an incoming request&#8217;s path pattern and HTTP method.</p>
</div>

</div>


<h3 id="using-config-from-app">Using CORS Configuration in the Application</h3>
<div class="section">
<p>You use configuration in combination with the Helidon CORS SE API
to add CORS support to your resources. The example in <router-link to="#se-api-routing-example" @click.native="this.scrollFix('#se-api-routing-example')">Sample Routing Setup Using the <code>CrossOriginConfig</code> API</router-link>
uses the low-level Helidon CORS SE API to create
a <code>CrossOriginConfig</code> instance that is then used as part of a <code>CorsSupport</code> instance to create the routing rules.
As an alternative to using the low-level API, this example uses config to create the
<code>CrossOriginConfig</code> instance instead.</p>

<markup
lang="java"

>private static Routing createRouting(Config config) {

    MetricsSupport metrics = MetricsSupport.create();
    GreetService greetService = new GreetService(config);
    HealthSupport health = HealthSupport.builder()
            .add(HealthChecks.healthChecks())   // Adds a convenient set of checks
            .build();
    CorsSupport.Builder builder = CorsSupport.builder();

    Config config = Config.create(); // Created from the current config sources
    config.get("my-cors") <span class="conum" data-value="1" />
            .ifExists(builder::mappedConfig);
    config.get("restrictive-cors") <span class="conum" data-value="2" />
            .ifExists(builder::config);
    builder.addCrossOriginConfig(CrossOriginConfig.create()); <span class="conum" data-value="3" />

    CorsSupport corsSupport = builder.build(); <span class="conum" data-value="4" />

    // Note: Add the CORS routing *before* registering the GreetService routing.
    return Routing.builder()
            .register(JsonSupport.create())
            .register(health)                   // Health at "/health"
            .register(metrics)                 // Metrics at "/metrics"
            .register("/greet", corsSupport, greetService) <span class="conum" data-value="5" />
            .build();
}</markup>

<ul class="colist">
<li data-value="1">If <code>my-cors</code> exists in the configuration, use it to add mapped CORS config to the <code>CorsSupport</code> builder.</li>
<li data-value="2">If <code>restrictive-cors</code> exists in the configuration, use it to add basic (not mapped) config to the builder.</li>
<li data-value="3">Provide default CORS handling for requests that do not match earlier entries.</li>
<li data-value="4">Obtain the finished <code>CorsSupport</code> instance.</li>
<li data-value="5">Use <code>corsSupport</code> in constructing the routing rules.</li>
</ul>

<p>As each request arrives, Helidon checks it against the cross-origin config instances in the order that your application
added them to the <code>CorsSupport.Builder</code>.
The <code>my-cors</code> mapped configuration acts as an override because the application added it to the builder first.</p>

<p>If the <code>my-cors</code> config key does not appear in the configuration, then the code skips creating a <code>CrossOriginConfig</code>
instance based on that configuration, and no overriding occurs. The CORS behavior
that is established by the other <code>CrossOriginConfig</code> instance based on the <code>restrictive-cors</code> config (if present)
prevails.</p>

<div class="admonition note">
<p class="admonition-inline">Remember that if you set configuration in a file that you include as part of your application JAR file, then you need to
rebuild and restart your application for any changes to take effect.</p>
</div>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>For a complete example, see <a target="_blank" href="https://github.com/oracle/helidon/tree/master/examples/cors">Helidon SE CORS Example</a>.</p>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">

<h3 id="_using_cors_support_in_built_in_helidon_services">Using CORS Support in Built-in Helidon Services</h3>
<div class="section">
<p>Several built-in Helidon services&#8212;&#8203;<router-link to="/se/health">health</router-link>, <router-link to="/se/metrics/metrics">metrics</router-link>, and
<router-link to="/se/openapi/openapi">OpenAPI</router-link>--have integrated CORS support.
You can include these services in your application and control how those resources can be  shared across origins.</p>

<p>For example, several websites related to OpenAPI run a web application in your browser.
You provide the URL for your application to the browser application.
The browser application uses the URL to retrieve the OpenAPI document
that describes the application&#8217;s endpoints directly from your application.
The browser application then displays a user interface that you use to "drive" your application. That is,
you provide input, have the web application
send requests to your application endpoints, and then view the responses.
This scenario is exactly the situation CORS addresses: an application in the browser from one origin&#8201;&#8212;&#8201;the user
 interface downloaded from the website&#8201;&#8212;&#8201;requests a resource from another origin&#8201;&#8212;&#8201;the <code>/openapi</code> endpoint which
 Helidon&#8217;s OpenAPI built-in service automatically adds to your application.</p>

<p>Integrating CORS support into these built-in services allows such third-party web sites and their browser applications&#8201;&#8212;&#8201;or
more generally, apps from any other origin&#8201;&#8212;&#8201;to work with your Helidon application.</p>

<p>Because all three of these built-in Helidon services serve only <code>GET</code> endpoints, by default the
integrated CORS support in all three services permits
any origin to share their resources using <code>GET</code>, <code>HEAD</code>, and <code>OPTIONS</code> HTTP requests. You can customize the CORS set-up
for these built-in services independently from each other using
 either the Helidon API, configuration, or both.
You can use this override feature to control the CORS behavior of the built-in services even if you do not add CORS behavior
to your own endpoints.</p>


<h4 id="_built_in_services_with_cors">Built-in Services with CORS</h4>
<div class="section">
<p>To use built-in services with CORS support and customize the
CORS behavior:</p>

<ol style="margin-left: 15px;">
<li>
Add the built-in service or services to your application. The health, metrics, and OpenAPI services automatically
include default CORS support.

</li>
<li>

<div><p>Add a dependency on the Helidon SE CORS artifact to your Maven <code>pom.xml</code> file.</p>

<div class="admonition note">
<p class="admonition-inline">If you want the built-in services to support CORS, then you need to add the CORS dependency even if your own endpoints do not use CORS.</p>
</div>
</div>

</li>
<li>
Use
the Helidon API or
configuration to customize the CORS behavior as needed.

</li>
</ol>

<p>The documentation for the individual built-in services describes how to add each
service to your application, including
adding a Maven
dependency and including the service in your application&#8217;s routing rules.
In your
application&#8217;s configuration file, the configuration for each service appears under its own key.</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class="">Helidon Service Documentation</td>
<td class="">Configuration Key</td>
</tr>
<tr>
<td class=""><router-link to="/se/health">health</router-link></td>
<td class=""><code>health</code></td>
</tr>
<tr>
<td class=""><router-link to="/se/metrics/metrics">metrics</router-link></td>
<td class=""><code>metrics</code></td>
</tr>
<tr>
<td class=""><router-link to="/se/openapi/openapi">OpenAPI</router-link></td>
<td class=""><code>openapi</code></td>
</tr>
</tbody>
</table>
</div>

<p>The <a target="_blank" href="https://github.com/oracle/helidon/tree/master/examples/quickstarts/helidon-quickstart-se">Helidon SE QuickStart example</a>
uses these services, so you can use that as a template for your
own application, or use the example project itself to experiment with customizing the CORS
behavior in the built-in services.</p>

</div>


<h4 id="_controlling_cors_for_built_in_services">Controlling CORS for Built-in Services</h4>
<div class="section">

<h5 id="_using_the_api">Using the API</h5>
<div class="section">
<p>Although services such as health, metrics, and OpenAPI are built into Helidon, to use them your application must create
instances of the services and then use those instances in building your application&#8217;s routing rules.</p>

<p>Recall that each
service type has a <code>Builder</code> class. To control the CORS behavior of a built-in service using the API, follow these steps:</p>

<ol style="margin-left: 15px;">
<li>
Create a <code>Builder</code> for the type of service of interest.

</li>
<li>
Build an instance of <code>CrossOriginConfig</code> with the settings you want.

</li>
<li>
Invoke the <code>builder.crossOriginConfig</code> method, passing that <code>CrossOriginConfig</code> instance.

</li>
<li>
Invoke the builder&#8217;s <code>build</code> method to initialize the service instance.

</li>
<li>
Use the service instance in preparing the routing rules.

</li>
</ol>

<p>The following excerpt shows changes to the
 <a target="_blank" href="https://github.com/oracle/helidon/tree/master/examples/quickstarts/helidon-quickstart-se">Helidon SE QuickStart example</a> which limit
sharing of the <code>/metrics</code> endpoint to <code>http://foo.com</code>.</p>

<markup
lang="java"

>private static Routing createRouting(Config config) {
    CrossOriginConfig.Builder metricsCrossOriginConfigBuilder = CrossOriginConfig.builder() <span class="conum" data-value="1" />
            .allowOrigins("http://foo.com");
    RestServiceSettings.Builder restServiceSettingsBuilder = RestServiceSettings.builder()
             .crossOriginConfig(metricsCrossOriginConfigBuilder); <span class="conum" data-value="2" />
    MetricsSupport metrics = MetricsSupport.builder()
            .restServiceSettings(restServiceSettingsBuilder) <span class="conum" data-value="3" />
            .build();
    GreetService greetService = new GreetService(config);
    HealthSupport health = HealthSupport.builder()
            .add(HealthChecks.healthChecks())   // Adds a convenient set of checks
            .build();

    return Routing.builder()
            .register(health)                   // Health at "/health"
            .register(metrics)                  // Metrics at "/metrics" <span class="conum" data-value="4" />
            .register("/greet", greetService)
            .build();
}</markup>

<ul class="colist">
<li data-value="1">Create the <code>CrossOriginConfig.Builder</code> for metrics, limiting sharing to <code>http://foo.com</code>.</li>
<li data-value="2">Use the <code>CrossOriginConfig.Builder</code> instance in constructing
the <code>RestServiceSetting.Builder</code> (which assigns common settings such as the CORS configuration and the web context for the service endpoint).</li>
<li data-value="3">Use the <code>RestServiceSetting.Builder</code> in preparing the <code>MetricsSupport</code> service.</li>
<li data-value="4">Use the <code>MetricsSupport</code> object in creating the routing rules.</li>
</ul>


<h6 id="_configuring_cors_for_built_in_services">Configuring CORS for Built-in Services</h6>
<div class="section">
<p>You can
also
use configuration to control whether and how each of the built-in services works with CORS.</p>

<p>Your application can pass configuration to the builder for each built-in service.
In the configuration for the health, metrics, and OpenAPI services, you can add a section for CORS.</p>

<p>The following example restricts sharing of the
<code>/health</code> resource, provided by the health built-in service, to only the origin <code>http://there.com</code>.</p>

<markup
lang="hocon"

>health:
  cors:
    allow-origins: [http://there.com]</markup>

<p>Modify your application to load the <code>health</code> config node and use it to construct the <code>HealthSupport</code> service.
The following code shows this change in the the QuickStart SE example.</p>

<markup
lang="java"

>HealthSupport health = HealthSupport.builder()
        .config(config.get("health")) <span class="conum" data-value="1" />
        .add(HealthChecks.healthChecks())   // Adds a convenient set of checks
        .build();</markup>

<ul class="colist">
<li data-value="1">Use the <code>health</code> config section (if present) to configure the health service.</li>
</ul>

<p>You have full control over the CORS configuration for a built-in Helidon service. Use a  CORS config section
as described in
<router-link to="#using-config-from-app" @click.native="this.scrollFix('#using-config-from-app')">Using Configuration for CORS</router-link>.</p>

</div>

</div>

</div>


<h4 id="_accessing_the_shared_resources">Accessing the Shared Resources</h4>
<div class="section">
<p>If you have edited the Helidon SE QuickStart application as described in the previous topics and saved your changes,
you can build and run the application. Once you do so you can execute <code>curl</code> commands to demonstrate the behavior changes
in the metric and health services with the addition of the CORS functionality. Note the addition of the
<code>Origin</code> header value in the <code>curl</code> commands, and the <code>Access-Control-Allow-Origin</code> in the successful responses.</p>


<h5 id="_build_and_run_the_application">Build and Run the Application</h5>
<div class="section">
<p>Build and run the QuickStart application as usual.</p>

<markup
lang="bash"

>mvn package
java -jar target/helidon-quickstart-se.jar</markup>

<markup
lang="listing"

>WEB server is up! http://localhost:8080/greet</markup>

</div>


<h5 id="_retrieve_metrics">Retrieve Metrics</h5>
<div class="section">
<p>The metrics service rejects attempts to access metrics on behalf of a disallowed origin.</p>

<markup
lang="bash"

>curl -i -H "Origin: http://other.com" http://localhost:8080/metrics</markup>

<markup
lang="listing"

>HTTP/1.1 403 Forbidden
Date: Mon, 11 May 2020 11:08:09 -0500
transfer-encoding: chunked
connection: keep-alive</markup>

<p>But accesses from <code>foo.com</code> succeed.</p>

<markup
lang="bash"

>curl -i -H "Origin: http://foo.com" http://localhost:8080/metrics</markup>

<markup
lang="listing"

>HTTP/1.1 200 OK
Access-Control-Allow-Origin: http://foo.com
Content-Type: text/plain
Date: Mon, 11 May 2020 11:08:16 -0500
Vary: Origin
connection: keep-alive
content-length: 6065

# TYPE base_classloader_loadedClasses_count gauge
# HELP base_classloader_loadedClasses_count Displays the number of classes that are currently loaded in the Java virtual machine.
base_classloader_loadedClasses_count 3568</markup>

</div>


<h5 id="_retrieve_health">Retrieve Health</h5>
<div class="section">
<p>The health service rejects requests from origins not specifically approved.</p>

<markup
lang="bash"

>curl -i -H "Origin: http://foo.com" http://localhost:8080/health</markup>

<markup
lang="listing"

>HTTP/1.1 403 Forbidden
Date: Mon, 11 May 2020 12:06:55 -0500
transfer-encoding: chunked
connection: keep-alive</markup>

<p>And responds successfully only to cross-origin requests from <code>http://there.com</code>.</p>

<markup
lang="bash"

>curl -i -H "Origin: http://there.com" http://localhost:8080/health</markup>

<markup
lang="listing"

>HTTP/1.1 200 OK
Access-Control-Allow-Origin: http://there.com
Content-Type: application/json
Date: Mon, 11 May 2020 12:07:32 -0500
Vary: Origin
connection: keep-alive
content-length: 461

{"outcome":"UP",...}</markup>

</div>

</div>

</div>

</div>

</doc-view>
