<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#_deserialization_setup" @click.native="this.scrollFix('#_deserialization_setup')">Deserialization setup</router-link></p>

</li>
<li>
<p><router-link to="#_system_property_configuration" @click.native="this.scrollFix('#_system_property_configuration')">System property configuration</router-link></p>

</li>
<li>
<p><router-link to="#_programmatic_configuration" @click.native="this.scrollFix('#_programmatic_configuration')">Programmatic configuration</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p><a target="_blank" href="https://openjdk.org/jeps/290">JEP-290</a> brought support for deserialization filters to Java programming language.
Such filtering allows us to control which classes may be deserialized using Java serialization.</p>

</div>


<h2 id="_deserialization_setup">Deserialization setup</h2>
<div class="section">
<p>Helidon default settings forbids any deserialization except for patterns defined in a <code>pattern</code>
property of any <code>META-INF/helidon/serial-config.properties</code> on classpath. The patterns are semicolon delimited strings, such as <code>io.myapp.&#42;&#42;;java.util.HashMap</code> (any subpackage of <code>io.myapp</code> and class <code>java.util.HashMap</code>).
Helidon will <strong>always</strong> add a deny-all filter pattern to the end of the pattern string (to make sure we exclude any unspecified class - we only operate on whitelists)</p>

<p>These defaults can be modified either through system properties, or programmatically.</p>

</div>


<h2 id="_system_property_configuration">System property configuration</h2>
<div class="section">
<p>The following system properties can be used to control deserialization in Helidon:</p>

<div class="block-title"><span>System properties</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 27.273%;">
<col style="width: 27.273%;">
<col style="width: 45.455%;">
</colgroup>
<thead>
<tr>
<th>property</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>helidon.serialFilter.pattern</code></td>
<td class=""><code>!&#42;</code></td>
<td class=""><doc-view>
<p>Filter pattern to use, deny all is always added</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>helidon.serialFilter.ignoreFiles</code></td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Whether to ignore files <code>META-INF/helidon/serial-config.properties</code> in libraries on the classpath</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>helidon.serialFilter.failure.action</code></td>
<td class=""><code>FAIL</code></td>
<td class=""><doc-view>
<p>Action to do when the configuration of global filter exists and is not consistent with our security expectations (e.g. contains a pattern to include all).</p>

<p>Options:</p>

<ul class="ulist">
<li>
<p><code>FAIL</code> - throw an exception to terminate startup</p>

</li>
<li>
<p><code>WARN</code> - log a warning</p>

</li>
<li>
<p><code>IGNORE</code> - ignore this and silently continue</p>

</li>
</ul>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>helidon.serialFilter.missing.action</code></td>
<td class=""><code>CONFIGURE</code></td>
<td class=""><doc-view>
<p>Action to do when there is no global configuration.</p>

<p>Options:</p>

<ul class="ulist">
<li>
<p><code>CONFIGURE</code> - configure Helidon defaults</p>

</li>
<li>
<p><code>FAIL</code> - throw an exception to terminate startup</p>

</li>
<li>
<p><code>WARN</code> - log a warning</p>

</li>
<li>
<p><code>IGNORE</code> - ignore this and silently continue</p>

</li>
</ul>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>helidon.serialFilter.trace</code></td>
<td class=""><code>NONE</code></td>
<td class=""><doc-view>
<p>Tracing configuration for deserialization. Controls what information (if any) will be logged to a logger <code>io.helidon.common.SerializationConfig.TracingObjectInputFilter</code> in <code>INFO</code> log level.</p>

<p>Options:</p>

<ul class="ulist">
<li>
<p><code>NONE</code> - do not trace</p>

</li>
<li>
<p><code>BASIC</code> - trace only classes, and only once per class</p>

</li>
<li>
<p><code>FULL</code> - trace all deserialization filter requests</p>

</li>
</ul>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>


<h2 id="_programmatic_configuration">Programmatic configuration</h2>
<div class="section">
<p>Custom <code>SerializationConfig</code> may be registered, but it <strong>must</strong> be done before Helidon server is started.</p>

<markup
lang="java"
title="Configure custom Helidon serialization config"
>SerializationConfig.builder()
  .traceSerialization(SerializationConfig.TraceOption.BASIC) <span class="conum" data-value="1" />
  .filterPattern(MyType.class.getName())                     <span class="conum" data-value="2" />
  .ignoreFiles(true)                                         <span class="conum" data-value="3" />
  .onWrongConfig(SerializationConfig.Action.IGNORE)          <span class="conum" data-value="4" />
  .build()
  .configure();                                              <span class="conum" data-value="5" /></markup>

<ul class="colist">
<li data-value="1">Trace first instance of each class that is deserialized</li>
<li data-value="2">Configure a single class filter pattern (only allows deserialization of class <code>MyType</code></li>
<li data-value="3">Ignore files defined in META-INF/helidon/serial-config.properties</li>
<li data-value="4">In case there is an existing global serialization configuration on JDK, ignore it and continue (global filter cannot be reconfigured)</li>
<li data-value="5">Configure this serialization config as the default for this JVM</li>
</ul>

</div>


<h2 id="_to_do_for_nima">TO DO FOR NIMA</h2>
<div class="section">

</div>

</doc-view>
