<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>A metric typically reflects the usage of a <em>single</em> point in your service processing <em>multiple</em> requests over time.
A value such as the total time consumed by a given REST endpoint underscores the aggregate nature of metric values; Helidon accumulates the time from all requests in the total duration.</p>

<p>Tracing, on the other hand, captures the usage of <em>multiple</em> parts of your code as your service responds to a <em>single</em> request.</p>

<p>Metrics and tracing come together in Helidon&#8217;s support for examplars.</p>

<div class="admonition note">
<p class="admonition-textlabel">Note</p>
<p ><p><a target="_blank" href="https://www.merriam-webster.com/dictionary/exemplar"><em>exemplar</em></a> - one that serves as a model or example</p>

<p>&#8201;&#8212;&#8201;Merriam-Webster Dictionary</p>
</p>
</div>

<p>In the context of metrics, an <em>exemplar</em> for a given metric is a specific sample which, in some sense, made a typical contribution to the metric&#8217;s value. For example, an exemplar for a <code>SimpleTimer</code> might be a sample in which the duration it contributed to the value of a <code>SimpleTimer</code> is near the mean of the durations over all samples. The metrics output identifies the exemplar sample using the trace ID of the trace which triggered that sample.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable OpenMetrics exemplar support
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.metrics&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-metrics-trace-exemplar&lt;/artifactId&gt;
    &lt;scope&gt;runtime&lt;/scope&gt;
&lt;/dependency&gt;</markup>

<p>Also, include the Helidon integration module for a tracing implementation (such as</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.tracing&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-tracing-zipkin&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>Add the Helidon tracing component itself:</p>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>Once you add the appropriate dependencies to your project, exemplar support runs automatically as part of Helidon metrics. You do not need to change your application or configuration.</p>


<h3 id="_interpreting_exemplars">Interpreting Exemplars</h3>
<div class="section">
<p>Helidon automatically records a sample (label, value, and timestamp) with each update to a histogram, simple timer, or counter. When a client accesses the <code>/metrics</code> endpoint, Helidon adds the label, value, and timestamp to the OpenMetrics response.</p>

<p>Helidon adds an exemplar to the output for each statistical value&#8212;&#8203;such as minimum, maximum, mean, and quantiles&#8212;&#8203;for histograms, timers, simple times, and for counters. The exemplar information in the output describes a single, actual sample that is representative of the statistical value.
Helidon chooses the representative examplar for each value using information that is already recorded for each type of metric:</p>

<div class="block-title"><span>Selection of exemplars for types of metrics</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
<tr>
<th>Metric Value Type</th>
<th>Example</th>
<th>Sample Selected as Exemplar</th>
</tr>
</thead>
<tbody>
<tr>
<td class="">corresponds directly to a specific sample</td>
<td class="">minimum or maximum of a value</td>
<td class="">any sample with that exact value</td>
</tr>
<tr>
<td class="">collects samples into bins (quantiles)</td>
<td class="">histogram (as with timers)</td>
<td class="">any sample from the bin</td>
</tr>
<tr>
<td class="">maintains running statistics</td>
<td class="">counts, totals</td>
<td class="">most recent sample</td>
</tr>
<tr>
<td class="">computes its value from multiple samples</td>
<td class="">mean</td>
<td class="">sample for which its value is at least as close as other samples to the statistical calculation</td>
</tr>
</tbody>
</table>
</div>

<p>In cases with multiple representative samples (for example, two samples' values are equally close to the mean), Helidon chooses one of them arbitrarily.</p>

</div>


<h3 id="_output_format">Output Format</h3>
<div class="section">
<p>In the OpenMetrics output, an exemplar actually appears as a comment appended to the normal OpenMetrics output.</p>

<markup

title="OpenMetrics format with exemplars"
><em>metric-identifier</em> <em>metric-value</em> # <em>exemplar-label</em> <em>sample-timestamp</em></markup>

<p>Even downstream consumers of OpenMetrics output that do not recognize the exemplar format should continue to work correctly (as long as they <em>do</em> recognize comments).</p>

<p>But some consumers, such as trace collectors and their U/Is, understand the exemplar format, and they allow you to browse metrics and then navigate directly to the trace for the metric&#8217;s exemplar.</p>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>Once you enable exemplar support you can see the exemplars in the metrics output.</p>

<div class="listing">
<pre># TYPE application_getTimer_mean_seconds gauge
application_getTimer_mean_seconds 8.303030623354298E-4 <strong># {trace_id="067632454fe4e8d1"} 1.14701E-4 1617723032.570000</strong>

# TYPE application_getTimer_max_seconds gauge
application_getTimer_max_seconds 0.003952636 <strong># {trace_id="fce183094e471633"} 0.003952636 1617723030.108000</strong>

# TYPE application_getTimer_min_seconds gauge
application_getTimer_min_seconds 5.5254E-5 <strong># {trace_id="0b1a4bf22b4e47fd"} 5.5254E-5 1617723033.311000</strong></pre>
</div>

<p>The first exemplar is a sample with value at least as close to the mean for that timer as any other sample.</p>

<p>This second exemplar is for an exact sample with value the same as the maximum value the timer has observed.</p>

<div class="listing">
<pre># TYPE application_globalRequestTracker_total counter
# HELP application_globalRequestTracker_total
application_globalRequestTracker_total 4 <strong># {trace_id="daf26fe35fee9917"} 0.001183992 1617725180.234000</strong>

# TYPE application_globalRequestTracker_elapsedTime_seconds gauge
application_globalRequestTracker_elapsedTime_seconds 0.030309068 <strong># {trace_id="daf26fe35fee9917"} 0.001183992 1617725180.234000</strong></pre>
</div>

<p>The exemplar for a <code>SimpleTimer</code> is the same for the <code>total</code> and the <code>elapsedTime</code> sub metrics: always the most recent sample which updated the <code>SimpleTimer</code>.</p>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">
<p>Brief discussion of <a target="_blank" href="https://github.com/OpenObservability/OpenMetrics/blob/main/specification/OpenMetrics.md#exemplars">exemplars in the OpenMetrics spec</a></p>

</div>


<h2 id="_to_do_for_nima">TO DO FOR NIMA</h2>
<div class="section">

</div>

</doc-view>
