<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Helidon provides built-in test support for CDI testing in TestNG.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable Testing with TestNG
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile.tests&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-tests-testng&lt;/artifactId&gt;
    &lt;scope&gt;test&lt;/scope&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage_default">Usage - default</h2>
<div class="section">
<p>A test can be annotated with <code>io.helidon.microprofile.tests.testng.HelidonTest</code> annotation to mark it as a
CDI test. This annotation will start the CDI container before any test method is invoked, and stop it after
the last method is invoked. This annotation also enables injection into the test class itself.</p>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>A test can be annotated with <code>io.helidon.microprofile.tests.testng.HelidonTest</code> annotation to mark it as a
CDI test. This annotation will start the CDI container before any test method is invoked, and stop it after
the last method is invoked. This annotation also enables injection into the test class itself.</p>


<h3 id="_usage_per_method_cdi_container">Usage - per method CDI container</h3>
<div class="section">
<p>A test can be annotated as follows:</p>

<p><code>@HelidonTest(resetPerTest = true)</code></p>

<p>This will change the behavior as follows:</p>

<ul class="ulist">
<li>
<p>A new CDI container is created for each test method invocation</p>

</li>
<li>
<p>annotations to add config, beans and extension can be added for each method in addition to the class</p>

</li>
<li>
<p>you cannot inject fields or constructor parameters of the test class itself (as a single instance is shared by more containers)</p>

</li>
</ul>

</div>


<h3 id="_usage_configuration">Usage - configuration</h3>
<div class="section">
<p>In addition to the <code>@AddConfig</code> annotation, you can also use
<code>@Configuration</code> to configure additional classpath properties config sources using <code>configSources</code>, and to
mark that a custom configuration is desired.
If <code>@Configuration(useExisting=true)</code>, the existing (or default) MicroProfile configuration would be used. In this case
it is important to set property <code>mp.initializer.allow=true</code> in order CDI container to start, when used with
<code>@HelidonTest</code>.
You can set up config in <code>@BeforeAll</code> method and register it with <code>ConfigProviderResolver</code> using MP Config APIs, and declare
<code>@Configuration(useExisting=true)</code>.
Note that this is not compatible with repeatable tests that use method sources that access CDI, as we must delay the CDI
startup to the test class instantiation (which is too late, as the method sources are already invoked by this time).</p>

<p><strong>If you want to use method sources that use CDI with repeatable tests, please do not use <code>@Configuration(useExisting=true)</code></strong></p>

<div class="admonition note">
<p class="admonition-inline">Test method parameters are currently not supported.</p>
</div>

</div>

</div>


<h2 id="_api">API</h2>
<div class="section">
<p>The annotations described in this section are inherited (for the non-repeatable ones), and additive (for repeatable).
So if you declare <code>@DisableDiscovery</code> on abstract class, all implementations will have discovery disabled, unless you
annotate the implementation class with <code>@DisableDiscovery(false)</code>.
If you declare <code>@AddBean</code> on both abstract class and implementation class, both beans will be added.</p>

<p>In addition to this simplification, the following annotations are supported:</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Annotation</th>
<th>Usage</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>@io.helidon.microprofile.tests.testng.AddBean</code></td>
<td class="">Used to add one or more beans to the container (if not part of a bean archive, or when discovery is disabled)</td>
</tr>
<tr>
<td class=""><code>@io.helidon.microprofile.tests.testng.AddExtension</code></td>
<td class="">Used to add one or more CDI extensions to the container (if not added through service loader, or when discovery is disabled)</td>
</tr>
<tr>
<td class=""><code>@io.helidon.microprofile.tests.testng.AddConfig</code></td>
<td class="">Used to add one or more configuration properties to MicroProfile config without the need of creating a <code>microprofile-config.properties</code> file</td>
</tr>
<tr>
<td class=""><code>@io.helidon.microprofile.tests.testng.DisableDiscovery</code></td>
<td class="">Used to disable automated discovery of beans and extensions</td>
</tr>
</tbody>
</table>
</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>In current example Helidon container will be launched prior test. The <em>Bean Discovery</em> will be disabled. <em>MyBean</em> will be added to the test, so that it can be injected. <em>ConfigCdiExtension</em> will be enabled for this test. And finally, a configuration property will be added using <code>@AddConfig</code> annotation.</p>

<markup
lang="java"
title="Code sample"
>@HelidonTest
@DisableDiscovery
@AddBean(MyBean.class)
@AddExtension(ConfigCdiExtension.class)
@AddConfig(key = "app.greeting", value = "TestHello")
class TestExample {
    @Inject
    private MyBean myBean;

    @Test
    void testGreeting() {
        assertThat(myBean, notNullValue());
        assertThat(myBean.greeting(), is("TestHello"));
    }
}</markup>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://testng.org/doc/documentation-main.html">TestNG User Guide</a></p>

</li>
</ul>

</div>

</doc-view>
