<doc-view>

<h2 id="_content">Content</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#_maven_coordinates" @click.native="this.scrollFix('#_maven_coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Helidon provides a MicroProfile server implementation (<code>io.helidon.microprofile.server</code>) that encapsulates the Helidon WebServer.</p>

</div>


<h2 id="_maven_coordinates">Maven-Coordinates</h2>
<div class="section">
<p>To enable MicroProfile Server add the helidon-microprofile-core bundle dependency to your project&#8217;s <code>pom.xml</code>
(see <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile.bundles&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-core&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>MicroProfile Server is already included in the bundle.</p>

<p>If full control over the dependencies is required, and you want to minimize the quantity of the dependencies -
<code>Helidon MicroProfile Server</code> should be used. In this case the following dependencies should be included in your
project&#8217;s <code>pom.xml</code>:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile.server&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-server&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>Helidon Microprofile Server is used to collect and deploy JAX-RS application. It is recommended to instantiate the server directly
as is done in the <router-link to="/mp/guides/quickstart">Helidon MP Quickstart example</router-link>. Note that the server lifecycle is bound to CDI.</p>

</div>


<h2 id="_api">API</h2>
<div class="section">
<p>Configuration of Helidon Microprofile Server</p>

<p>Type: <a target="_blank" href="./apidocs/io.helidon.microprofile.server/io/helidon/microprofile/server/Server.html">io.helidon.microprofile.server.Server</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>server</code></p>


<h3 id="_configuration_options">Configuration Options</h3>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>executor-service</code></td>
<td class=""><doc-view>
<p>ExecutorService&gt;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Set a supplier of an executor service to use for tasks connected with application
 processing (JAX-RS).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>host</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configure listen host.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>port</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configure listen port.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<p>The following table provides a brief description of routing annotations, including its parameters. More information
in <code>Configuring a reactive route</code> section.</p>


<div class="table__overflow elevation-1  flex sm10
">
<table class="datatable table">
<colgroup>
<col style="width: 37.5%;">
<col style="width: 62.5%;">
</colgroup>
<thead>
<tr>
<th>Annotation</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><doc-view>
<div class="listing">
<pre>@RoutingName(
    value = ""
    required = false
)</pre>
</div>

</doc-view>
</td>
<td class="">Binds a JAX-RS Application or Helidon Service to a specific (named) routing on <code>WebServer</code>.The routing should have
a corresponding named socket configured on the WebServer to run the routing on.</td>
</tr>
<tr>
<td class=""><doc-view>
<div class="listing">
<pre>@RoutingPath("/path")</pre>
</div>

</doc-view>
</td>
<td class="">Path of a Helidon Service to register with routing.</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>By default, the server uses the MicroProfile Config, but you may also want to use <router-link to="/mp/config/introduction">Helidon configuration</router-link>.</p>

<p>In this example, the configuration is in a file, and it includes Helidon configuration options.</p>

<p>Configuration of the HTTP server.</p>

<p>Type: <a target="_blank" href="./apidocs/io.helidon.reactive.webserver/io/helidon/reactive/webserver/WebServer.html">io.helidon.reactive.webserver.WebServer</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>server</code></p>


<h3 id="_configuration_options_2">Configuration options</h3>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>backlog</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>1024</code></td>
<td class=""><doc-view>
<p>Configures a maximum length of the queue of incoming connections on the server
 socket.</p>

<pre>Default value is #DEFAULT_BACKLOG_SIZE.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>backpressure-buffer-size</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Maximum length of the response data sending buffer can keep without flushing.
 Depends on <code>backpressure-policy</code> what happens if max buffer size is reached.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>backpressure-strategy</code></td>
<td class=""><doc-view>
<p>BackpressureStrategy (LINEAR, AUTO_FLUSH, PREFETCH, UNBOUNDED)</p>

</doc-view>
</td>
<td class=""><code>AUTO_FLUSH</code></td>
<td class=""><doc-view>
<p>Sets a backpressure strategy for the server to apply against user provided response upstream.</p>

<ul class="ulist">
<li>
<p>LINEAR - Data are requested one-by-one, in case buffer reaches watermark, no other data is requested.</p>

</li>
<li>
<p>AUTO_FLUSH - Data are requested one-by-one, in case buffer reaches watermark, no other data is requested.</p>

</li>
<li>
<p>PREFETCH - After first data chunk arrives, probable number of chunks needed to fill the buffer up to watermark is calculated and requested.</p>

</li>
<li>
<p>NONE - No backpressure is applied, Long.MAX_VALUE(unbounded) is requested from upstream.</p>

</li>
</ul>

</doc-view>
</td>
</tr>
<tr>
<td class=""><s><code>bind-address</code></s></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p><strong>Deprecated</strong> Configures local address where the server listens on with the server socket.
 If not configured, then listens an all local addresses.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>continue-immediately</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>When true WebServer answers to expect continue with 100 continue immediately,
 not waiting for user to actually request the data.</p>

<pre>Default is `false`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>enable-compression</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Enable negotiation for gzip/deflate content encodings. Clients can
 request compression using the "Accept-Encoding" header.</p>

<pre>Default is `false`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>features.print-details</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Set to <code>true</code> to print detailed feature information on startup.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>host</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>A helper method that just calls #bindAddress(String).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-header-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>16384</code></td>
<td class=""><doc-view>
<p>Maximal number of bytes of all header values combined. When a bigger value is received, a
 io.helidon.common.http.Http.Status#BAD_REQUEST_400
 is returned.</p>

<pre>Default is `16384`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-initial-line-length</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>4096</code></td>
<td class=""><doc-view>
<p>Maximal number of characters in the initial HTTP line.</p>

<pre>Default is `4096`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-payload-size</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Set a maximum payload size for a client request. Can prevent DoS
 attacks.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-upgrade-content-length</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>65536</code></td>
<td class=""><doc-view>
<p>Set a maximum length of the content of an upgrade request.</p>

<pre>Default is `64*1024`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>port</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>0</code></td>
<td class=""><doc-view>
<p>Configures a server port to listen on with the server socket. If port is
 <code>0</code> then any available ephemeral port will be used.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>receive-buffer-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configures proposed value of the TCP receive window that is advertised to the remote peer on the
 server socket.</p>

<pre>If `0` then use implementation default.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>requested-uri-discovery</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_http_RequestedUriDiscoveryContext">RequestedUriDiscoveryContext</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Requested URI discovery for the web server&#8217;s default socket.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sockets</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_reactive_webserver_SocketConfiguration">SocketConfiguration[&#93;</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Adds an additional named server socket configuration. As a result, the server will listen
 on multiple ports.</p>

<pre>An additional named server socket may have a dedicated Routing configured
through WebServer.Builder#addNamedRouting(String, Routing).</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>timeout-millis</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class=""><code>0</code></td>
<td class=""><doc-view>
<p>Socket timeout in milliseconds</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>tls</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_reactive_webserver_WebServerTls">WebServerTls</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configures SSL for this socket. When configured, the server enforces SSL
 configuration.
 If this method is called, any other method except for #tls(java.util.function.Supplier)¨
 and repeated invocation of this method would be ignored.</p>

<pre>If this method is called again, the previous configuration would be ignored.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>worker-count</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets a count of threads in pool used to process HTTP requests.
 Default value is <code>CPU_COUNT * 2</code>.</p>

<pre>Configuration key: `workers`</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">

<h3 id="_access_log">Access Log</h3>
<div class="section">
<p>Access logging in Helidon is done by a dedicated module that can be
added to Maven and configured.</p>

<p>To enable Access logging add the following dependency to project&#8217;s <code>pom.xml</code>:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-access-log&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h3 id="_configuring_access_log_in_a_configuration_file">Configuring Access Log in a configuration file</h3>
<div class="section">
<p>Access log can be configured as follows:</p>

<markup
lang="properties"
title="Access Log configuration file"
>server.port=8080
server.host=0.0.0.0
server.access-log.format=helidon</markup>

<p>All options shown above are also available programmatically when using builder.</p>

</div>


<h3 id="_configuration_options_3">Configuration Options</h3>
<div class="section">
<p>The following configuration options can be defined:</p>


<div class="table__overflow elevation-1  flex sm10
">
<table class="datatable table">
<colgroup>
<col style="width: 18.182%;">
<col style="width: 18.182%;">
<col style="width: 18.182%;">
<col style="width: 45.455%;">
</colgroup>
<thead>
<tr>
<th>Config key</th>
<th>Default value</th>
<th>Builder method</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><code>true</code></td>
<td class=""><code>enabled(boolean)</code></td>
<td class="">When this option is set to <code>false</code>, access logging will be disabled</td>
</tr>
<tr>
<td class=""><code>logger-name</code></td>
<td class=""><code>io.helidon.webserver.AccessLog</code></td>
<td class=""><code>loggerName(String)</code></td>
<td class="">Name of the logger to use when writing log entries</td>
</tr>
<tr>
<td class=""><code>format</code></td>
<td class=""><code>helidon</code></td>
<td class=""><code>helidonLogFormat()</code>, <code>commonLogFormat()</code>, <code>add(AccessLogEntry entry)</code></td>
<td class="">Configuration of access log output,
when <code>helidon</code> is defined, the Helidon log format (see below) is used.
Can be configured to explicitly define log entries (see below as well)</td>
</tr>
<tr>
<td class=""><code>exclude-paths</code></td>
<td class="">N/A</td>
<td class=""><code>excludePaths(List&lt;String&gt;)</code></td>
<td class="">List of path patterns to exclude from access log. Path pattern syntax is as
defined in <code>io.helidon.webserver.PathMatcher</code>. Can be used to exclude
paths such as <code>/health</code> or <code>/metrics</code> to avoid cluttering log.</td>
</tr>
</tbody>
</table>
</div>

</div>


<h3 id="_supported_log_formats">Supported Log Formats</h3>
<div class="section">

<h4 id="_supported_log_entries">Supported Log Entries</h4>
<div class="section">
<p>The following log entries are supported in Helidon:</p>


<div class="table__overflow elevation-1  flex sm7
">
<table class="datatable table">
<colgroup>
<col style="width: 22.222%;">
<col style="width: 22.222%;">
<col style="width: 55.556%;">
</colgroup>
<thead>
<tr>
<th>Config format</th>
<th>Class (to use with builder)</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td class="">%h</td>
<td class=""><code>HostLogEntry</code></td>
<td class="">IP address of the remote host</td>
</tr>
<tr>
<td class="">%l</td>
<td class=""><code>UserIdLogEntry</code></td>
<td class="">Client identity, always undefined in Helidon</td>
</tr>
<tr>
<td class="">%u</td>
<td class=""><code>UserLogEntry</code></td>
<td class="">The username of logged-in user (when Security is used)</td>
</tr>
<tr>
<td class="">%t</td>
<td class=""><code>TimestampLogEntry</code></td>
<td class="">The current timestamp</td>
</tr>
<tr>
<td class="">%r</td>
<td class=""><code>RequestLineLogEntry</code></td>
<td class="">The request line (method, path and HTTP version)</td>
</tr>
<tr>
<td class="">%s</td>
<td class=""><code>StatusLogEntry</code></td>
<td class="">The HTTP status returned to the client</td>
</tr>
<tr>
<td class="">%b</td>
<td class=""><code>SizeLogEntry</code></td>
<td class="">The response entity size (if available)</td>
</tr>
<tr>
<td class="">%D</td>
<td class=""><code>TimeTakenLogEntry</code></td>
<td class="">The time taken in microseconds</td>
</tr>
<tr>
<td class="">%T</td>
<td class=""><code>TimeTakenLogEntry</code></td>
<td class="">The time taken in seconds</td>
</tr>
<tr>
<td class="">%{<code>header-name</code>}i</td>
<td class=""><code>HeaderLogEntry</code></td>
<td class="">Value of a header (can have multiple such specification to write
multiple headers)</td>
</tr>
</tbody>
</table>
</div>

<p>Currently we only support the entries defined above, with NO support for free text.</p>

</div>


<h4 id="_helidon_log_format">Helidon Log Format</h4>
<div class="section">
<p>When format is set to <code>helidon</code>, the format used is:</p>

<p><code>"%h %u %t %r %s %b %D"</code></p>

<p>The entries logged:</p>

<ol style="margin-left: 15px;">
<li>
IP Address

</li>
<li>
Username of a logged-in user

</li>
<li>
Timestamp

</li>
<li>
Request Line

</li>
<li>
HTTP Status code

</li>
<li>
Entity size

</li>
<li>
Time taken (microseconds)

</li>
</ol>

<p>Access log example:</p>

<markup
lang="listing"

>192.168.0.104 - [18/Jun/2019:22:28:55 +0200] "GET /greet/test HTTP/1.1" 200 53
0:0:0:0:0:0:0:1 - [18/Jun/2019:22:29:00 +0200] "GET /metrics/vendor HTTP/1.1" 200 1658
0:0:0:0:0:0:0:1 jack [18/Jun/2019:22:29:07 +0200] "PUT /greet/greeting HTTP/1.1" 200 21
0:0:0:0:0:0:0:1 jill [18/Jun/2019:22:29:12 +0200] "PUT /greet/greeting HTTP/1.1" 403 0
0:0:0:0:0:0:0:1 - [18/Jun/2019:22:29:17 +0200] "PUT /greet/greeting HTTP/1.1" 401 0</markup>

</div>

</div>


<h3 id="_configuring_tls">Configuring TLS</h3>
<div class="section">
<p>Helidon MP also supports custom TLS configuration.</p>

<p>You can set the following properties:</p>

<ul class="ulist">
<li>
<p>Server truststore</p>
<ul class="ulist">
<li>
<p>Keystore with trusted certificates</p>

</li>
</ul>

</li>
<li>
<p>Private key and certificate</p>
<ul class="ulist">
<li>
<p>Server certificate which will be used in TLS handshake</p>

</li>
</ul>

</li>
</ul>

<markup
lang="properties"
title="META-INF/microprofile-config.properties - Server configuration"
>#Truststore setup
server.tls.trust.keystore.resource.resource-path=server.p12
server.tls.trust.keystore.passphrase=password
server.tls.trust.keystore.trust-store=true

#Keystore with private key and server certificate
server.tls.private-key.keystore.resource.resource-path=server.p12
server.tls.private-key.keystore.passphrase=password</markup>

<p>Or the same configuration done in application.yaml file.</p>

<markup
lang="yaml"
title="application.yaml - Server configuration"
>server:
  tls:
    #Truststore setup
    trust:
      keystore:
        passphrase: "password"
        trust-store: true
        resource:
          resource-path: "keystore.p12"
    #Keystore with private key and server certificate
    private-key:
      keystore:
        passphrase: "password"
        resource:
          resource-path: "keystore.p12"</markup>

</div>


<h3 id="conf-additional-ports">Configuring additional ports</h3>
<div class="section">
<p>Helidon MP can expose multiple ports, with the following limitations:</p>

<ul class="ulist">
<li>
<p>The default port is the port that serves your application (JAX-RS applications and resources)</p>

</li>
<li>
<p>Other ports (in this example we configure one "admin" port) can be assigned endpoints that are exposed by Helidon components,
currently supported by MP Health and MP Metrics</p>

</li>
</ul>

<p>For this example, we will use a <code>YAML</code> file:</p>

<ul class="ulist">
<li>
<p>The port <code>7011</code> is the default port and will serve your application</p>

</li>
<li>
<p>The port <code>8011</code> is named "admin" (this is an arbitrary name)</p>

</li>
<li>
<p>MP Metrics are configured to use the "admin" port through the <code>routing</code> configuration (reference is by name)</p>

</li>
<li>
<p>MP Health is configured the same way to reference the "admin" port</p>

</li>
</ul>

<markup
lang="yaml"
title="application.yaml - Server configuration"
>server:
  port: 7011
  host: "some.host"
  sockets:
    admin:
      port: 8011
      bind-address: "some.host"

metrics:
  routing: "admin"

health:
  routing: "admin"</markup>

</div>


<h3 id="_configuring_a_reactive_route">Configuring A Reactive Route</h3>
<div class="section">
<p>Helidon MP Server will pick up CDI beans that implement the <code>io.helidon.reactive.webserver.Service</code>
interface and configure them with the underlying WebServer.</p>

<p>This allows configuration of reactive routes to run alongside a JAX-RS application.</p>

<p>The bean is expected to be either <code>ApplicationScoped</code> or <code>Dependent</code> and will be requested
only once during the boot of the <code>Server</code>.</p>

<p>The bean will support injection of <code>ApplicationScoped</code> and <code>Dependent</code> scoped beans.
You cannot inject <code>RequestScoped</code> beans. Please use WebServer features to handle request
related objects.</p>


<h4 id="_customizing_the_reactive_service">Customizing the reactive service</h4>
<div class="section">
<p>The service can be customized using annotations and/or configuration to be</p>

<ul class="ulist">
<li>
<p>registered on a specific path</p>

</li>
<li>
<p>registered with a named routing</p>

</li>
</ul>

</div>


<h4 id="_assigning_a_reactive_service_to_named_ports">Assigning a reactive service to named ports</h4>
<div class="section">
<p>Helidon has the concept of named routing. These correspond to the named ports
configured with WebServer.</p>

<p>You can assign a reactive service to a named routing (and as a result to a named port) using
either an annotation or configuration (or both to override the value from annotation).</p>


<h5 id="annotation-routing-name">Annotation <code>@RoutingName</code></h5>
<div class="section">
<p>You can annotate a service bean with this annotation to assign it to a specific named routing,
that is (most likely) going to be bound to a specific port.</p>

<p>The annotation has two attributes:
- <code>value</code> that defines the routing name
- <code>required</code> to mark that the routing name MUST be configured in Helidon server</p>

<markup
lang="java"
title="<code>@RoutingName</code> example"
>@ApplicationScoped
@RoutingName(value="admin", required="true")
@RoutingPath("/admin")
public class AdminService implements Service {
}</markup>

<p>The example above will be bound to <code>admin</code> routing (and port) and will fail if such a port
is not configured.</p>

</div>


<h5 id="_configuration_override_of_routing_name">Configuration override of routing name</h5>
<div class="section">
<p>For each service bean you can define the routing name and its required flag by specifying a configuration
option <code>bean-class-name.routing-name.name</code> and <code>bean-class-name.routing-name.required</code>.
For service beans produced with producer method replace <code>bean-class-name</code> with <code>class-name.producer-method-name</code>.</p>

<p>Example (YAML) configuration for a service bean <code>io.helidon.examples.AdminService</code> that changes the
routing name to <code>management</code> and its required flag to <code>false</code>:</p>

<markup
lang="yaml"

>io.helidon.examples.AdminService:
  routing-name:
    name: "management"
    required: false</markup>

</div>

</div>


<h4 id="_configuring_a_reactive_service_path">Configuring a reactive service path</h4>
<div class="section">
<p>Each service is registered on a path. If none is configured, then the service would be
configured on the root path.</p>

<p>You can configure service path using an annotation or configuration (or both to override value from annotation)</p>


<h5 id="_annotation_routingpath">Annotation <code>@RoutingPath</code></h5>
<div class="section">
<p>You can configure <code>@RoutingPath</code> to define the path a service is registered on.</p>

</div>


<h5 id="_configuration_override_of_routing_path">Configuration override of routing path</h5>
<div class="section">
<p>For each reactive service class you can define the routing path by specifying a configuration
option <code>class-name.routing-path.path</code>.</p>

<p>Example (YAML) configuration for a class <code>io.helidon.example.AdminService</code> that changes the
routing path to <code>/management</code>:</p>

<markup
lang="yaml"

>io.helidon.examples.AdminService:
  routing-path:
    path: "/management"</markup>

</div>

</div>

</div>


<h3 id="_serving_static_content">Serving Static Content</h3>
<div class="section">
<markup
lang="properties"
title="META-INF/microprofile-config.properties - File system static content"
># Location of content on file system
server.static.path.location=/var/www/html
# default is index.html
server.static.path.welcome=resource.html
# static content path - default is "/"
# server.static.path.context=/static-file</markup>

<markup
lang="properties"
title="META-INF/microprofile-config.properties - Classpath static content"
># src/main/resources/WEB in your source tree
server.static.classpath.location=/WEB
# default is index.html
server.static.classpath.welcome=resource.html
# static content path - default is "/"
# server.static.classpath.context=/static-cp</markup>

</div>


<h3 id="_example_configuration_of_routing">Example configuration of routing</h3>
<div class="section">
<p>A full configuration example (YAML):</p>

<markup
lang="yaml"

>server:
  port: 8080
  sockets:
   management:
   port: 8090

io.helidon.examples.AdminApplication:
  routing-name:
    name: "management"
    required: true
  routing-path:
    path: "/management"</markup>

</div>


<h3 id="_using_requested_uri_discovery">Using Requested URI Discovery</h3>
<div class="section">
<p>Proxies and reverse proxies between an HTTP client and your Helidon application mask important information (for example <code>Host</code> header, originating IP address, protocol) about the request the client sent.
Fortunately, many of these intermediary network nodes set or update either the <a target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Forwarded">standard HTTP <code>Forwarded</code> header</a> or the <a target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For">non-standard <code>X-Forwarded-*</code> family of headers</a> to preserve information about the original client request.</p>

<p>Helidon&#8217;s requested URI discovery feature allows your application&#8212;&#8203;and Helidon itself&#8212;&#8203;to reconstruct information about the original request using the <code>Forwarded</code> header and the <code>X-Forwarded-*</code> family of headers.</p>

<p>When you prepare the connections in your server you can include the following optional requested URI discovery settings:</p>

<ul class="ulist">
<li>
<p>enabled or disabled</p>

</li>
<li>
<p>which type or types of requested URI discovery to use:</p>
<ul class="ulist">
<li>
<p><code>FORWARDED</code> - uses the <code>Forwarded</code> header</p>

</li>
<li>
<p><code>X_FORWARDED</code> - uses the <code>X-Forwarded-*</code> headers</p>

</li>
<li>
<p><code>HOST</code> - uses the <code>Host</code> header</p>

</li>
</ul>

</li>
<li>
<p>what intermediate nodes to trust</p>

</li>
</ul>

<p>When your application
receives a request
Helidon iterates through the discovery types you set up for the receiving connection, gathering information from the corresponding header(s) for that type.
If the request does not have the corresponding header(s), or your settings do not trust the intermediate nodes reflected in those headers, then Helidon tries the next discovery type you set up.
Helidon uses the <code>HOST</code> discovery type if you do not set up discovery yourself or if, for a particular request, it cannot assemble the request information using any discovery type you did set up for the socket.</p>


<h4 id="_setting_up_requested_uri_discovery">Setting Up Requested URI Discovery</h4>
<div class="section">
<p>You can
use configuration to set up the requested URI discovery behavior.</p>

<markup
lang="properties"
title="Configuring Request URI Discovery (properties format)"
>server.port=8080
server.requested-uri-discovery.types=FORWARDED,X_FORWARDED
server.requested-uri-discovery.trusted-proxies.allow.pattern=lb.*\\.mycorp\\.com
server.requested-uri-discovery.trusted-proxies.deny.exact=lbtest.mycorp.com</markup>

<p>This example might apply if <code>mycorp.com</code> had trusted load balancers named <code>lbxxx.mycorp.com</code> except for an untrusted test load balancer <code>lbtest.mycorp.com</code>.</p>

</div>


<h4 id="_obtaining_the_requested_uri_information">Obtaining the Requested URI Information</h4>
<div class="section">
<p>Helidon makes the requested URI information available as a property in the request context:</p>

<markup
lang="java"
title="Retrieving Requested URI Information"
>import io.helidon.common.http.UriInfo;

public class MyFilter implements ContainerRequestFilter {

    @Override
    public void filter(ContainerRequestContext requestContext) {
        UriInfo uriInfo = (UriInfo) requestContext.getProperty("io.helidon.jaxrs.requested-uri");
        // ...
    }
}</markup>

<p>See the <a target="_blank" href="./apidocs/io.helidon.common.http/io/helidon/common/http/UriInfo.html"><code>UriInfo</code></a> JavaDoc for more information.</p>

<div class="admonition note">
<p class="admonition-inline">The <code>requestContext.getUriInfo()</code> method returns the Jakarta RESTful web services <code>UriInfo</code> object, <em>not</em> the Helidon-provided requested URI information <code>UriInfo</code> record.</p>
</div>

</div>

</div>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://helidon.io/docs/v2/apidocs/io.helidon.microprofile.server/module-summary.html">Helidon MicroProfile Server Javadoc</a></p>

</li>
<li>
<p><a target="_blank" href="https://github.com/oracle/helidon/tree/master/microprofile/server">Helidon MicroProfile Server on GitHub</a></p>

</li>
</ul>

</div>

</doc-view>
