<doc-view>

<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable Weblogic JMS connector
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.messaging.wls-jms&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-messaging-wls-jms&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_reactive_weblogic_jms_connector">Reactive Weblogic JMS Connector</h2>
<div class="section">
<p>Connecting streams to Weblogic JMS with Reactive Messaging couldn&#8217;t be easier.
This connector extends Helidon JMS connector with special handling for Weblogic T3 thin client.</p>

<p>Connecting to Weblogic JMS connection factories requires proprietary T3 thin client library which can be obtained from
Weblogic installation.</p>

<div class="admonition warning">
<p class="admonition-inline">Avoid placing <code>wlthint3client.jar</code> on Helidon classpath, client library location needs to be
configured and loaded by Helidon messaging connector.</p>
</div>

<div class="admonition warning">
<p class="admonition-inline">Don&#8217;t forget to start your Helidon app with <code>--add-opens=java.base/java.io=ALL-UNNAMED</code> to allow
wlthint3client use reflection.</p>
</div>


<h3 id="_configuration">Configuration</h3>
<div class="section">
<p>Connector name: <code>helidon-weblogic-jms</code></p>

<div class="block-title"><span>Attributes</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class=""><code>jms-factory</code></td>
<td class="">JNDI name of the JMS factory configured in Weblogic</td>
</tr>
<tr>
<td class=""><code>url</code></td>
<td class="">t3, t3s or http address of Weblogic server</td>
</tr>
<tr>
<td class=""><code>thin-jar</code></td>
<td class="">Filepath to the Weblogic thin T3 client jar(wlthint3client.jar), can be usually found within Weblogic installation
<code>WL_HOME/server/lib/wlthint3client.jar</code></td>
</tr>
<tr>
<td class=""><code>principal</code></td>
<td class="">Weblogic initial context principal(user)</td>
</tr>
<tr>
<td class=""><code>credentials</code></td>
<td class="">Weblogic initial context credential(password)</td>
</tr>
<tr>
<td class=""><code>type</code></td>
<td class="">Possible values are: <code>queue</code>, <code>topic</code>. Default value is: <code>topic</code></td>
</tr>
<tr>
<td class=""><code>destination</code></td>
<td class="">Queue or topic name in WebLogic CDI Syntax(CDI stands for Create Destination Identifier)</td>
</tr>
<tr>
<td class=""><code>jndi.destination</code></td>
<td class="">JNDI destination identifier. When no such JNDI destination is found, falls back to <code>destination</code> with CDI syntax.</td>
</tr>
<tr>
<td class=""><code>acknowledge-mode</code></td>
<td class="">Possible values are: <code>AUTO_ACKNOWLEDGE</code>- session automatically acknowledges a client’s receipt of a message,
<code>CLIENT_ACKNOWLEDGE</code> - receipt of a message is acknowledged only when <code>Message.ack()</code> is called manually,
<code>DUPS_OK_ACKNOWLEDGE</code> - session lazily acknowledges the delivery of messages. Default value: <code>AUTO_ACKNOWLEDGE</code></td>
</tr>
<tr>
<td class=""><code>transacted</code></td>
<td class="">Indicates whether the session will use a local transaction. Default value: <code>false</code></td>
</tr>
<tr>
<td class=""><code>message-selector</code></td>
<td class="">JMS API message selector expression based on a subset of the SQL92.
Expression can only access headers and properties, not the payload.</td>
</tr>
<tr>
<td class=""><code>client-id</code></td>
<td class="">Client identifier for JMS connection.</td>
</tr>
<tr>
<td class=""><code>client-id</code></td>
<td class="">Client identifier for JMS connection.</td>
</tr>
<tr>
<td class=""><code>durable</code></td>
<td class="">True for creating durable consumer (only for topic). Default value: <code>false</code></td>
</tr>
<tr>
<td class=""><code>subscriber-name</code></td>
<td class="">Subscriber name for durable consumer used to identify subscription.</td>
</tr>
<tr>
<td class=""><code>non-local</code></td>
<td class="">If true then any messages published to the topic using this session&#8217;s connection,
or any other connection with the same client identifier,
will not be added to the durable subscription. Default value: <code>false</code></td>
</tr>
<tr>
<td class=""><code>named-factory</code></td>
<td class="">Select in case factory is injected as a named bean or configured with name.</td>
</tr>
<tr>
<td class=""><code>poll-timeout</code></td>
<td class="">Timeout for polling for next message in every poll cycle in millis. Default value: <code>50</code></td>
</tr>
<tr>
<td class=""><code>period-executions</code></td>
<td class="">Period for executing poll cycles in millis. Default value: <code>100</code></td>
</tr>
<tr>
<td class=""><code>session-group-id</code></td>
<td class="">When multiple channels share same <code>session-group-id</code>, they share same JMS session and same JDBC connection as well.</td>
</tr>
<tr>
<td class=""><code>producer.unit-of-order</code></td>
<td class="">All messages from same unit of order will be processed sequentially in the order they were created.</td>
</tr>
</tbody>
</table>
</div>

<p>Configuration is straight forward. Use JNDI for localizing and configuring of JMS ConnectionFactory
from Weblogic. Notice the destination property which is used to define queue with
<a target="_blank" href="https://docs.oracle.com/cd/E24329_01/web.1211/e24387/lookup.htm#JMSPG915">WebLogic CDI Syntax</a>(CDI stands for Create Destination Identifier).</p>

<markup
lang="yaml"
title="Example config:"
>mp:
  messaging:
    connector:
      helidon-weblogic-jms:
        # JMS factory configured in Weblogic
        jms-factory: jms/TestConnectionFactory
        # Path to the WLS Thin T3 client jar
        thin-jar: wlthint3client.jar
        url: t3://localhost:7001
    incoming:
      from-wls:
        connector: helidon-weblogic-jms
        # WebLogic CDI Syntax(CDI stands for Create Destination Identifier)
        destination: ./TestJMSModule!TestQueue
    outgoing:
      to-wls:
        connector: helidon-weblogic-jms
        # JNDI identifier for the same queue
        jndi.destination: jms/TestQueue</markup>

<p>When configuring destination with WebLogic CDI, the following syntax needs to be applied:</p>

<p><code>jms-server-name/jms-module-name!destination-name</code></p>

<p>In our example we are replacing jms-server-name with <code>.</code> as we don’t have to look up the server we are connected to.</p>

<p><code>jms-server-name/jms-module-name!jms-server-name@udd-name</code></p>

<p>Destination for UDD doesn&#8217;t have <code>./</code> prefix, because distributed destinations can be served by multiple servers within a cluster.</p>

</div>


<h3 id="_consuming">Consuming</h3>
<div class="section">
<markup
lang="java"
title="Consuming one by one unwrapped value:"
>@Incoming("from-wls")
public void consumeWls(String msg) {
    System.out.println("Weblogic says: " + msg);
}</markup>

<markup
lang="java"
title="Consuming one by one, manual ack:"
>@Incoming("from-wls")
@Acknowledgment(Acknowledgment.Strategy.MANUAL)
public CompletionStage&lt;?&gt; consumewls(JmsMessage&lt;String&gt; msg) {
    System.out.println("Weblogic says: " + msg.getPayload());
    return msg.ack();
}</markup>

</div>


<h3 id="_producing">Producing</h3>
<div class="section">
<markup
lang="java"
title="Producing to Weblogic JMS:"
>@Outgoing("to-wls")
public PublisherBuilder&lt;String&gt; produceToWls() {
    return ReactiveStreams.of("test1", "test2");
}</markup>

<markup
lang="java"
title="Example of more advanced producing to Weblogic JMS:"
>@Outgoing("to-wls")
public PublisherBuilder&lt;String&gt; produceToJms() {
    return ReactiveStreams.of("test1", "test2")
                .map(s -&gt; JmsMessage.builder(s)
                              .correlationId(UUID.randomUUID().toString())
                              .property("stringProp", "cool property")
                              .property("byteProp", 4)
                              .property("intProp", 5)
                              .onAck(() -&gt; System.out.println("Acked!"))
                              .build());
}</markup>

<markup
lang="java"
title="Example of even more advanced producing to Weblogic JMS with custom mapper:"
>@Outgoing("to-wls")
public PublisherBuilder&lt;String&gt; produceToJms() {
    return ReactiveStreams.of("test1", "test2")
                .map(s -&gt; JmsMessage.builder(s)
                            .customMapper((p, session) -&gt; {
                                TextMessage textMessage = session.createTextMessage(p);
                                textMessage.setStringProperty("custom-mapped-property", "XXX" + p);
                                return textMessage;
                            })
                            .build()
                    );
}</markup>

</div>


<h3 id="_secured_t3_over_sslt3s">Secured t3 over SSL(t3s)</h3>
<div class="section">
<p>For initiating SSL secured t3 connection, trust keystore with WLS public certificate is needed.
Standard WLS installation has pre-configured Demo trust store: <code>WL_HOME/server/lib/DemoTrust.jks</code>,
we can store it locally for connecting WLS over t3s.</p>

<markup
lang="yaml"
title="Example config:"
>mp:
  messaging:
    connector:
      helidon-weblogic-jms:
        jms-factory: jms/TestConnectionFactory
        thin-jar: wlthint3client.jar
        # Notice t3s protocol is used
        url: t3s://localhost:7002</markup>

<p>Helidon application needs to be aware about our WLS SSL public certificate.</p>

<markup
lang="bash"
title="Running example with WLS truststore"
>java --add-opens=java.base/java.io=ALL-UNNAMED \
-Djavax.net.ssl.trustStore=DemoTrust.jks \
-Djavax.net.ssl.trustStorePassword=DemoTrustKeyStorePassPhrase \
-jar ./target/helidon-wls-jms-demo.jar</markup>

</div>

</div>

</doc-view>
