<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_channel" @click.native="this.scrollFix('#_channel')">Channel</router-link></p>

</li>
<li>
<p><router-link to="#_consuming_method" @click.native="this.scrollFix('#_consuming_method')">Consuming method</router-link></p>

</li>
<li>
<p><router-link to="#_injected_publisher" @click.native="this.scrollFix('#_injected_publisher')">Injected publisher</router-link></p>

</li>
<li>
<p><router-link to="#_producing_method" @click.native="this.scrollFix('#_producing_method')">Producing method</router-link></p>

</li>
<li>
<p><router-link to="#_emitter" @click.native="this.scrollFix('#_emitter')">Emitter</router-link></p>

</li>
<li>
<p><router-link to="#_processing_method" @click.native="this.scrollFix('#_processing_method')">Processing method</router-link></p>

</li>
<li>
<p><router-link to="#_connector" @click.native="this.scrollFix('#_connector')">Connector</router-link></p>

</li>
<li>
<p><router-link to="#_message" @click.native="this.scrollFix('#_message')">Message</router-link></p>

</li>
<li>
<p><router-link to="#_acknowledgement" @click.native="this.scrollFix('#_acknowledgement')">Acknowledgement</router-link></p>

</li>
<li>
<p><router-link to="#_health_check" @click.native="this.scrollFix('#_health_check')">Health check</router-link></p>

</li>
<li>
<p><router-link to="#_upgrading_to_messaging_3_0" @click.native="this.scrollFix('#_upgrading_to_messaging_3_0')">Upgrading to 3.0</router-link></p>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>There is more to expect from the modern messaging than we got from old-fashioned Message Driven Beans,
blocking is not always favorable way to apply backpressure to the message source, actually is not the only way anymore.
Reactive messaging uses reactive streams as message channels, users can construct very effective pipelines for working
with the messages, or use messaging in the old-fashioned way. Similarly to the MDB&#8217;s
<a target="_blank" href="{microprofile-reactive-messaging-spec-url}">MicroProfile Reactive Messaging</a>
uses CDI beans to produce, consume or process messages over Reactive Streams.
Such messaging bean is expected to be either in <code>ApplicationScoped</code> or <code>Dependent</code> scope.
Messages are managed by methods annotated by <code>@Incoming</code> and <code>@Outgoing</code>
and the invocation is always driven by message core - either at assembly time, or for every message coming from the stream.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable MicroProfile Reactive Messaging
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
   &lt;groupId&gt;io.helidon.microprofile.messaging&lt;/groupId&gt;
   &lt;artifactId&gt;helidon-microprofile-messaging&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>To include health checks for Messaging add the following dependency:</p>

<markup
lang="xml"

>&lt;dependency&gt;
   &lt;groupId&gt;io.helidon.microprofile.messaging&lt;/groupId&gt;
   &lt;artifactId&gt;helidon-microprofile-messaging-health&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_channel">Channel</h2>
<div class="section">
<p>Reactive messaging uses named channels to connect always one source(upstream) with one consumer(downstream).
Each channel needs to have both ends connected otherwise container won&#8217;t successfully start.</p>



<v-card>
<v-card-text class="overflow-y-hidden" >
<img src="./images/msg/channel.svg" alt="Messaging Channel" />
</v-card-text>
</v-card>


<p>Channels can be connected either to <router-link to="#_emitter" @click.native="this.scrollFix('#_emitter')">emitter</router-link> (1), <router-link to="#_producing_method" @click.native="this.scrollFix('#_producing_method')">producing method</router-link> (2) or <router-link to="#_connector" @click.native="this.scrollFix('#_connector')">connector</router-link> (3) on the upstream side. And <router-link to="#_injected_publisher" @click.native="this.scrollFix('#_injected_publisher')">injected publisher</router-link> (4), <router-link to="#_consuming_method" @click.native="this.scrollFix('#_consuming_method')">consuming method</router-link> (5) or <router-link to="#_connector" @click.native="this.scrollFix('#_connector')">connector</router-link> (6)
on the downstream.</p>


<h3 id="_consuming_method">Consuming method</h3>
<div class="section">
<p>Consuming methods can be connected to the channel&#8217;s downstream to consume the message coming through the channel.
Incoming annotation has one required attribute <code>value</code> that defines the channel name.</p>

<p>Consuming method can function in two ways:</p>

<ul class="ulist">
<li>
<p>consume every message coming from the stream connected to the <router-link to="#_channel" @click.native="this.scrollFix('#_channel')">channel</router-link> - invoked per each message</p>

</li>
<li>
<p>prepare reactive stream&#8217;s subscriber and connect it to the channel - invoked only once during the channel construction</p>

</li>
</ul>

<markup
lang="java"
title="Example consuming every message from channel <code>example-channel-2</code>:"
>@Incoming("example-channel-2")
public void printMessage(String msg) {
    System.out.println("Just received message: " + msg);
}</markup>

<markup
lang="java"
title="Example preparing reactive stream subscriber for channel <code>example-channel-1</code>:"
>@Incoming("example-channel-2")
public Subscriber&lt;String&gt; printMessage() {
    return ReactiveStreams.&lt;String&gt;builder()
                .forEach(msg -&gt; System.out.println("Just received message: " + msg))
                .build();
}</markup>

</div>


<h3 id="_injected_publisher">Injected publisher</h3>
<div class="section">
<p>Directly injected publisher can be connected as a channel downstream,
we can consume the data from the channel by subscribing to it.</p>

<p>Helidon can inject following types of publishers:</p>

<ul class="ulist">
<li>
<p><code>Publisher&lt;PAYLOAD&gt;</code> - Reactive streams publisher with unwrapped payload</p>

</li>
<li>
<p><code>Publisher&lt;Message&lt;PAYLOAD&gt;&gt;</code> - Reactive streams publisher with whole message</p>

</li>
<li>
<p><code>PublisherBuilder&lt;PAYLOAD&gt;</code> - MP Reactive streams operators publisher builder with unwrapped payload</p>

</li>
<li>
<p><code>PublisherBuilder&lt;Message&lt;PAYLOAD&gt;&gt;</code> - MP Reactive streams operators publisher builder with whole message</p>

</li>
<li>
<p><code>Flow.Publisher&lt;PAYLOAD&gt;</code> - JDK&#8217;s flow publisher with unwrapped payload</p>

</li>
<li>
<p><code>Flow.Publisher&lt;Message&lt;PAYLOAD&gt;&gt;</code> - JDK&#8217;s flow publisher with whole message</p>

</li>
<li>
<p><code>Multi&lt;PAYLOAD&gt;</code> - Helidon flow reactive operators with unwrapped payload</p>

</li>
<li>
<p><code>Multi&lt;Message&lt;PAYLOAD&gt;&gt;</code> - Helidon flow reactive operators with whole message</p>

</li>
</ul>

<markup
lang="java"
title="Example of consuming payloads from channel <code>example-channel-1</code> with injected publisher:"
>@Inject
public MyBean(@Channel("example-channel-1") Multi&lt;String&gt; multiChannel) {
    multiChannel
            .map(String::toUpperCase)
            .forEach(s -&gt; System.out.println("Received " + s));
}</markup>

</div>


<h3 id="_producing_method">Producing method</h3>
<div class="section">
<p>The annotation has one required attribute <code>value</code> that defines the
<a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-reactive-messaging-3.0-RC2/microprofile-reactive-messaging-spec-3.0-RC2.html#_channel">channel</a> name.</p>

<p>Such annotated <router-link to="#terms" @click.native="this.scrollFix('#terms')">messaging method</router-link> can function in two ways:</p>

<ul class="ulist">
<li>
<p>produce exactly one message to the stream connected to the <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-reactive-messaging-3.0-RC2/microprofile-reactive-messaging-spec-3.0-RC2.html#_channel">channel</a></p>

</li>
<li>
<p>prepare reactive stream&#8217;s publisher and connect it to the <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-reactive-messaging-3.0-RC2/microprofile-reactive-messaging-spec-3.0-RC2.html#_channel">channel</a></p>

</li>
</ul>

<markup
lang="java"
title="Example producing exactly one message to channel <code>example-channel-1</code>:"
>@Outgoing("example-channel-1")
public String produceMessage() {
    return "foo";
}</markup>

<markup
lang="java"
title="Example preparing reactive stream publisher publishing three messages to the channel <code>example-channel-1</code>:"
>@Outgoing("example-channel-1")
public Publisher&lt;String&gt; printMessage() {
    return ReactiveStreams.of("foo", "bar", "baz").buildRs();
}</markup>

<div class="admonition warning">
<p class="admonition-inline">Messaging methods are not meant to be invoked directly!</p>
</div>

</div>


<h3 id="_emitter">Emitter</h3>
<div class="section">
<p>For sending messages from imperative code we can inject special channel source called emitter.
Emitter can serve only as an upstream, source of the messages, for messaging channel.</p>

<markup
lang="java"
title="Example of sending message from JAX-RS method to channel <code>example-channel-1</code>"
>@Inject
@Channel("example-channel-1")
private Emitter&lt;String&gt; emitter;

@PUT
@Path("/sendMessage")
@Consumes(MediaType.TEXT_PLAIN)
public Response sendMessage(final String payload) {
  emitter.send(payload);
}</markup>

<p>Emitters as a source of messages for reactive channels needs to address possible backpressure from the downstream side
of the channel. In case there is not enough demand from the downstream we can configure best fitting strategy for our use-case
with annotation <code>@OnOverflow</code>.</p>

<div class="block-title"><span>Overflow strategies</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class="">Strategy</td>
<td class="">Description</td>
</tr>
<tr>
<td class="">BUFFER</td>
<td class="">Buffer unconsumed values until configured bufferSize is reached, when reached calling <code>Emitter.emit</code> throws <code>IllegalStateException</code>. Buffer size can be configured with <code>@OnOverflow</code> or with config key <code>mp.messaging.emitter.default-buffer-size</code>. Default value is <code>128</code>.</td>
</tr>
<tr>
<td class="">UNBOUNDED_BUFFER</td>
<td class="">Buffer unconsumed values until application runs out of memory.</td>
</tr>
<tr>
<td class="">THROW_EXCEPTION</td>
<td class="">Calling <code>Emitter.emit</code> throws <code>IllegalStateException</code> if there is not enough items requested by downstream.</td>
</tr>
<tr>
<td class="">DROP</td>
<td class="">If there is not enough items requested by downstream, emitted message is silently dropped.</td>
</tr>
<tr>
<td class="">FAIL</td>
<td class="">If there is not enough items requested by downstream, emitting message causes error signal being send to downstream. Whole channel is terminated. No other messages can be sent.</td>
</tr>
<tr>
<td class="">LATEST</td>
<td class="">Keeps only the latest item. Any previous unconsumed message is silently dropped.</td>
</tr>
<tr>
<td class="">NONE</td>
<td class="">Messages are sent to downstream even if there is no demand. Backpressure is effectively ignored.</td>
</tr>
</tbody>
</table>
</div>

</div>


<h3 id="_processing_method">Processing method</h3>
<div class="section">
<p>Such <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-reactive-messaging-3.0-RC2/microprofile-reactive-messaging-spec-3.0-RC2.html#_method_consuming_and_producing">methods</a>
acts as processors, consuming messages from one channel and producing to another.</p>



<v-card>
<v-card-text class="overflow-y-hidden" >
<img src="./images/msg/processor.svg" alt="Processor method connecting two channels together" />
</v-card-text>
</v-card>


<p>Diagram shows how processing method (2) serves as a downstream to the <code>my-channel</code> (1) and an upstream to the <code>other-channel</code> (3),
connecting them together.</p>

<p>Processing method can function in multiple ways:</p>

<ul class="ulist">
<li>
<p>process every message</p>

</li>
<li>
<p>prepare reactive stream&#8217;s processor and connect it between the channels</p>

</li>
<li>
<p>on every message prepare new publisher(equivalent to <code>flatMap</code> operator)</p>

</li>
</ul>

<markup
lang="java"
title="Example processing every message from channel <code>example-channel-1</code> to channel <code>example-channel-2</code>:"
>@Incoming("example-channel-1")
@Outgoing("example-channel-2")
public String processMessage(String msg) {
    return msg.toUpperCase();
}</markup>

<markup
lang="java"
title="Example preparing processor stream to be connected between channels <code>example-channel-1</code> and <code>example-channel-2</code>:"
>@Incoming("example-channel-1")
@Outgoing("example-channel-2")
public Processor&lt;String, String&gt; processMessage() {
    return ReactiveStreams.&lt;String&gt;builder()
                .map(String::toUpperCase)
                .buildRs();
}</markup>

<markup
lang="java"
title="Example processing every message from channel <code>example-channel-1`as stream to be flattened to channel `example-channel-2</code>:"
>@Incoming("example-channel-1")
@Outgoing("example-channel-2")
public String processMessage(String msg) {
    return ReactiveStreams.of(msg.toUpperCase(), msg.toLowerCase()).buildRs();
}</markup>

</div>


<h3 id="_connector">Connector</h3>
<div class="section">
<p>Messaging connector is an application scoped bean which implements one or both of following interfaces:</p>

<ul class="ulist">
<li>
<p><code>IncomingConnectorFactory</code> - connector can create an upstream publisher to produce messages to a channel</p>

</li>
<li>
<p><code>OutgoingConnectorFactory</code> - connector can create a downstream subscriber to consume messages from a channel</p>

</li>
</ul>

<markup
lang="java"
title="Example connector <code>example-connector</code>:"
>@ApplicationScoped
@Connector("example-connector")
public class ExampleConnector implements IncomingConnectorFactory, OutgoingConnectorFactory {

   @Override
   public PublisherBuilder&lt;? extends Message&lt;?&gt;&gt; getPublisherBuilder(Config config) {
       return ReactiveStreams.of("foo", "bar")
               .map(Message::of);
   }

   @Override
   public SubscriberBuilder&lt;? extends Message&lt;?&gt;, Void&gt; getSubscriberBuilder(Config config) {
       return ReactiveStreams.&lt;Message&lt;?&gt;&gt;builder()
               .map(Message::getPayload)
               .forEach(o -&gt; System.out.println("Connector says: " + o));
   }
}</markup>

<p>Channel needs to be instructed to use connector as its upstream or downstream by configuration.</p>

<markup
lang="yaml"
title="Example of channel to connector mapping config:"
>mp.messaging.outgoing.to-connector-channel.connector: example-connector <span class="conum" data-value="1" />
mp.messaging.incoming.from-connector-channel.connector: example-connector <span class="conum" data-value="2" /></markup>

<ul class="colist">
<li data-value="1">Use connector <code>example-connector</code> as a downstream for channel <code>to-connector-channel</code> to consume the messages from the channel</li>
<li data-value="2">Use connector <code>example-connector</code> as an upstream for channel <code>to-connector-channel</code> to produce messages to the channel</li>
</ul>

<markup
lang="java"
title="Example producing to connector:"
>@Outgoing("to-connector-channel")
public Publisher&lt;String&gt; produce() {
   return Flowable.just("fee", "fie");
}

&gt; Connector says: fee
&gt; Connector says: fie</markup>

<markup
lang="java"
title="Example consuming from connector:"
>@Incoming("from-connector-channel")
public void consume(String value) {
   System.out.println("Consuming: " + value);
}

&gt; Consuming: foo
&gt; Consuming: bar</markup>

<p>When connector constructs publisher or subscriber for given channel,
it can access general connector configuration and channel specific properties merged together with
special synthetic property <code>channel-name</code>.</p>



<v-card>
<v-card-text class="overflow-y-hidden" >
<img src="./images/msg/connector-config.svg" alt="Connector config" />
</v-card-text>
</v-card>


<p>Connector specific config (1)  merged together with global connector config (2).</p>

<markup
lang="java"
title="Example connector accessing configuration:"
>@ApplicationScoped
@Connector("example-connector")
public class ExampleConnector implements IncomingConnectorFactory {

    @Override
    public PublisherBuilder&lt;? extends Message&lt;?&gt;&gt; getPublisherBuilder(final Config config) {

        String firstPropValue = config.getValue("channel-specific-prop", String.class); <span class="conum" data-value="1" />
        String secondPropValue = config.getValue("connector-specific-prop", String.class);
        String secondPropValue = config.getValue("channel-name", String.class); <span class="conum" data-value="2" />

        return ReactiveStreams.of(firstPropValue, secondPropValue)
                .map(Message::of);
    }
}</markup>

<ul class="colist">
<li data-value="1">Config context is merged from channel and connector contexts</li>
<li data-value="2">Name of the channel requesting publisher as it&#8217;s upstream from this connector</li>
</ul>

<markup
lang="yaml"
title="Example of channel to connector mapping config with custom properties:"
>mp.messaging.incoming.from-connector-channel.connector: example-connector<span class="conum" data-value="1" />
mp.messaging.incoming.from-connector-channel.channel-specific-prop: foo<span class="conum" data-value="2" />
mp.messaging.connector.example-connector.connector-specific-prop: bar<span class="conum" data-value="3" /></markup>

<ul class="colist">
<li data-value="1">Channel &#8594; Connector mapping</li>
<li data-value="2">Channel configuration properties</li>
<li data-value="3">Connector configuration properties</li>
</ul>

<markup
lang="java"
title="Example consuming from connector:"
>@Incoming("from-connector-channel")
public void consume(String value) {
   System.out.println("Consuming: " + value);
}

&gt; Consuming: foo
&gt; Consuming: bar</markup>

</div>


<h3 id="_message">Message</h3>
<div class="section">
<p>The Reactive Messaging <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-reactive-messaging-3.0-RC2/microprofile-reactive-messaging-spec-3.0-RC2.html#_message">Message</a>
class can be used to wrap or unwrap data items between methods and connectors.
The message wrapping and unwrapping can be performed explicitly by using
<code>org.eclipse.microprofile.reactive.messaging.Message#of(T)</code> or implicitly through the messaging core.</p>

<markup
lang="java"
title="Example of explicit and implicit wrapping and unwrapping"
>@Outgoing("publisher-payload")
public PublisherBuilder&lt;Integer&gt; streamOfMessages() {
    return ReactiveStreams.of(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
}

@Incoming("publisher-payload")
@Outgoing("wrapped-message")
public Message&lt;String&gt; rewrapMessageManually(Message&lt;Integer&gt; message) {
    return Message.of(Integer.toString(message.getPayload()));
}

@Incoming("wrapped-message")
public void consumeImplicitlyUnwrappedMessage(String value) {
    System.out.println("Consuming message: " + value);
}</markup>

</div>


<h3 id="_acknowledgement">Acknowledgement</h3>
<div class="section">
<p>Message carries a callback for reception acknowledgement(ack) and negative acknowledgement(nack),
acknowledgement in messaging methods is possible manually by
<code>org.eclipse.microprofile.reactive.messaging.Message#ack</code> or automatically according explicit
or implicit acknowledgement strategy by messaging core. Explicit strategy configuration is possible
with <code>@Acknowledgment</code> annotation which has one required attribute <code>value</code> that expects the strategy type from enum
<code>org.eclipse.microprofile.reactive.messaging.Acknowledgment.Strategy</code>. More information about supported signatures
and implicit automatic acknowledgement can be found in specification
<a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-reactive-messaging-3.0-RC2/microprofile-reactive-messaging-spec-3.0-RC2.html#_message_acknowledgement">Message acknowledgement</a>.</p>

<div class="block-title"><span>Acknowledgement strategies</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class=""><code>@Acknowledgment(Acknowledgment.Strategy.NONE)</code></td>
<td class="">No acknowledgment</td>
</tr>
<tr>
<td class=""><code>@Acknowledgment(Acknowledgment.Strategy.MANUAL)</code></td>
<td class="">No automatic acknowledgment</td>
</tr>
<tr>
<td class=""><code>@Acknowledgment(Acknowledgment.Strategy.PRE_PROCESSING)</code></td>
<td class="">Ack automatically before method invocation or processing</td>
</tr>
<tr>
<td class=""><code>@Acknowledgment(Acknowledgment.Strategy.POST_PROCESSING)</code></td>
<td class="">Ack automatically after method invocation or processing</td>
</tr>
</tbody>
</table>
</div>

<markup
lang="java"
title="Example of manual acknowledgment"
>@Outgoing("consume-and-ack")
public PublisherBuilder&lt;Integer&gt; streamOfMessages() {
    return ReactiveStreams.of(Message.of("This is Payload", () -&gt; {
            System.out.println("This particular message was acked!");
            return CompletableFuture.completedFuture(null);
        })).buildRs();
}

@Incoming("consume-and-ack")
@Acknowledgment(Acknowledgment.Strategy.MANUAL)
public CompletionStage&lt;Void&gt; receiveAndAckMessage(Message&lt;String&gt; msg) {
    return msg.ack(); <span class="conum" data-value="1" />
}</markup>

<ul class="colist">
<li data-value="1">Calling ack() will print "This particular message was acked!" to System.out</li>
</ul>

<markup
lang="java"
title="Example of manual acknowledgment"
>@Outgoing("consume-and-ack")
public PublisherBuilder&lt;Integer&gt; streamOfMessages() {
    return ReactiveStreams.of(Message.of("This is Payload", () -&gt; {
            System.out.println("This particular message was acked!");
            return CompletableFuture.completedFuture(null);
        })).buildRs();
}

@Incoming("consume-and-ack")
@Acknowledgment(Acknowledgment.Strategy.MANUAL)
public CompletionStage&lt;Void&gt; receiveAndAckMessage(Message&lt;String&gt; msg) {
    return msg.ack(); <span class="conum" data-value="1" />
}</markup>

<ul class="colist">
<li data-value="1">Calling ack() will print "This particular message was acked!" to System.out</li>
</ul>

<markup
lang="java"
title="Example of explicit pre-process acknowledgment"
>@Outgoing("consume-and-ack")
public PublisherBuilder&lt;Integer&gt; streamOfMessages() {
    return ReactiveStreams.of(Message.of("This is Payload", () -&gt; {
            System.out.println("This particular message was acked!");
            return CompletableFuture.completedFuture(null);
        })).buildRs();
}

/**
* Prints to the console:
* &gt; This particular message was acked!
* &gt; Method invocation!
*/
@Incoming("consume-and-ack")
@Acknowledgment(Acknowledgment.Strategy.PRE_PROCESSING)
public CompletionStage&lt;Void&gt; receiveAndAckMessage(Message&lt;String&gt; msg) {
    System.out.println("Method invocation!");
    return CompletableFuture.completedFuture(null);
}</markup>

<markup
lang="java"
title="Example of explicit post-process acknowledgment"
>@Outgoing("consume-and-ack")
public PublisherBuilder&lt;Integer&gt; streamOfMessages() {
    return ReactiveStreams.of(Message.of("This is Payload", () -&gt; {
            System.out.println("This particular message was acked!");
            return CompletableFuture.completedFuture(null);
        })).buildRs();
}

/**
* Prints to the console:
* &gt; Method invocation!
* &gt; This particular message was acked!
*/
@Incoming("consume-and-ack")
@Acknowledgment(Acknowledgment.Strategy.POST_PROCESSING)
public CompletionStage&lt;Void&gt; receiveAndAckMessage(Message&lt;String&gt; msg) {
    System.out.println("Method invocation!");
    return CompletableFuture.completedFuture(null);
}</markup>

</div>


<h3 id="_health_check">Health check</h3>
<div class="section">
<p>Messaging in Helidon has built in health probes for liveness and readiness. To activate it
add the <router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">health check dependency</router-link>.</p>

<ul class="ulist">
<li>
<p>Liveness - channel is considered UP until <code>cancel</code> or <code>onError</code> signal is intercepted on it.</p>

</li>
<li>
<p>Readiness - channel is considered DOWN until <code>onSubscribe</code> signal is intercepted on it.</p>

</li>
</ul>

<p>If you check your health endpoints <code>/health/live</code> and <code>/health/ready</code> you will discover
every messaging channel to have its own probe.</p>

<markup
lang="json"

>{
    "name": "messaging",
    "state": "UP",
    "status": "UP",
    "data": {
        "my-channel-1": "UP",
        "my-channel-2": "UP"
    }
}</markup>

<div class="admonition warning">
<p class="admonition-inline">Due to the nack support are exceptions thrown in messaging methods NOT translated to error and cancel signals implicitly anymore</p>
</div>

</div>

</div>


<h2 id="_upgrading_to_messaging_3_0">Upgrading to Messaging 3.0</h2>
<div class="section">
<ul class="ulist">
<li>
<p>Exceptions thrown in messaging methods are not propagated as error or cancel signals to the stream(use <code>mp.messaging.helidon.propagate-errors=true</code> for backward compatible mode) - errors are propagated only to the upstream by <code>nack</code> functionality.</p>

</li>
<li>
<p>Default acknowledgement strategies changed for selected signatures(all with Message as a parameter or return type) - See the specification issue <a target="_blank" href="{https://github.com/eclipse/microprofile-reactive-messaging/pull/97}">#97</a></p>

</li>
</ul>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://helidon.io/docs/v2/apidocs/io.helidon.microprofile.messaging/module-summary.html">Helidon MicroProfile Reactive Messaging</a></p>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-reactive-messaging-3.0-RC2/microprofile-reactive-messaging-spec-3.0-RC2.html">MicroProfile Reactive Messaging Specification</a></p>

</li>
<li>
<p><a target="_blank" href="https://github.com/eclipse/microprofile-reactive-messaging">MicroProfile Reactive Messaging on GitHub</a></p>

</li>
</ul>

</div>

</doc-view>
