<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>SmallRye offers an <a target="_blank" href="https://github.com/smallrye/smallrye-open-api/tree/2.1.16/ui/open-api-ui">OpenAPI user interface component</a> which displays a web page based on your application&#8217;s OpenAPI document.
Through that UI, users can invoke the operations declared in the document.
While not generally suitable for end-users, the OpenAPI UI can be useful for demonstrating and "test driving" your service&#8217;s endpoints.</p>

<p>The Helidon OpenAPI component allows you to integrate the SmallRye UI into your application, adding the UI web page to your application very simply.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable Helidon OpenAPI UI support
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.integrations.openapi-ui&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-integrations-openapi-ui&lt;/artifactId&gt;
    &lt;scope&gt;runtime&lt;/scope&gt;
&lt;/dependency&gt;</markup>

<p>Also make sure your project has the following dependency to include OpenAPI support in your Helidon MP application.</p>

<markup
lang="xml"

>    &lt;dependency&gt;
        &lt;groupId&gt;io.helidon.microprofile.openapi&lt;/groupId&gt;
        &lt;artifactId&gt;helidon-microprofile-openapi&lt;/artifactId&gt;
        &lt;scope&gt;runtime&lt;/scope&gt;
    &lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>After you modify, build, and start your Helidon MP service, you can access the OpenAPI UI by default at <code><a target="_blank" href="http://your-host:your-port/openapi/ui" class="bare">http://your-host:your-port/openapi/ui</a></code>.
Helidon also uses conventional content negotiation at <code><a target="_blank" href="http://your-host:your-port/openapi" class="bare">http://your-host:your-port/openapi</a></code> returning the UI to browsers (or any client that accepts HTML) and the OpenAPI document otherwise.</p>

<p>You can customize the path using
<router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">configuration</router-link>.</p>

<p>The example below shows the UI
for the Helidon MP QuickStart greeting application.</p>


<div class="block-title"><span>Example OpenAPI UI Screen</span></div>
<v-card>
<v-card-text class="overflow-y-hidden" style="text-align:center">
<img src="./images/openapi-ui-screen-capture-greeting-mp-start.png" alt="openapi ui screen capture greeting mp start" />
</v-card-text>
</v-card>


<p>With the OpenAPI UI displayed, follow these steps to access one of your service&#8217;s operations.</p>

<ol style="margin-left: 15px;">
<li>
Find the operation you want to run and click on its row in the list.

</li>
<li>
The UI expands the operation, showing any input parameters and the possible responses. Click the "Try it out" button in the operation&#8217;s row.

</li>
<li>
The UI now allows you to type into the input parameter field(s) to the right of each parameter name. Enter any required parameter values (first highlighted rectangle) and any non-required values you wish, then click "Execute" (highlighted arrow).

</li>
<li>
Just below the "Execute" button the UI shows several sections:<br>

<ul class="ulist">
<li>
<p>the equivalent <code>curl</code> command for submitting the request with your inputs,</p>

</li>
<li>
<p>the URL used for the request, and</p>

</li>
<li>
<p>a new "Server response" section (second highlighted rectangle) containing several items from the response:<br>
</p>
<ul class="ulist">
<li>
<p>HTTP status code</p>

</li>
<li>
<p>body</p>

</li>
<li>
<p>headers</p>

</li>
</ul>

</li>
</ul>

</li>
</ol>

<p>The next image shows the screen after you submit the "Returns a personalized greeting" operation.</p>

<p>Note that the UI shows the actual response from invoking the operation in the "Server response" section. The "Responses" section farther below describes the possible responses from the operation as declared in the OpenAPI document for the application.</p>


<div class="block-title"><span>Example OpenAPI UI Screen</span></div>
<v-card>
<v-card-text class="overflow-y-hidden" style="text-align:center">
<img src="./images/openapi-ui-screen-capture-greeting-mp-expanded.png" alt="openapi ui screen capture greeting mp expanded" />
</v-card-text>
</v-card>


</div>


<h2 id="_api">API</h2>
<div class="section">
<p>Your Helidon MP application does not use any API to enable or control Helidon OpenAPI UI support.
Adding the dependency as described earlier is sufficient, and you can control the UI behavior using <router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">configuration</router-link>.</p>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>To use configuration to control how the Helidon OpenAPI UI service behaves, add an <code>openapi.ui</code> section to
your <code>META-INF/microprofile-config.properties</code> file.</p>

<p>Type: <a target="_blank" href="./apidocs/io.helidon.openapi/io/helidon/openapi/OpenApiUi.html">io.helidon.openapi.OpenApiUi</a></p>

<markup
lang="text"
title="Config key"
>ui</markup>


<h3 id="_configuration_options">Configuration options</h3>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Sets whether the UI should be enabled.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>options</code></td>
<td class=""><doc-view>
<p>Map&lt;string, string&gt;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets implementation-specific UI options.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>web-context</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>web context (path) where the UI will respond</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<p>The default UI <code>web-context</code> value is the web context for your <code>OpenAPISupport</code> service with the added suffix <code>/ui</code>. If you use the default web context for both <code>OpenAPISupport</code> and the UI, the UI responds at <code>/openapi/ui</code>.</p>

<p>You can use configuration to affect the UI path in two ways:</p>

<ul class="ulist">
<li>
<p>Configure the OpenAPI endpoint path (the <code>/openapi</code> part).</p>
<p>Recall that you can <router-link :to="{path: '/mp/openapi/openapi', hash: '#config'}">configure the Helidon OpenAPI component</router-link> to change where it serves the OpenAPI document.</p>

<markup
lang="properties"
title="Configuring the OpenAPI web context"
>openapi.web-context=/my-openapi</markup>

<p>In this case, the path for the UI component is your customized OpenAPI path with <code>/ui</code> as a suffix.
With the example above, the UI responds at <code>/my-openapi/ui</code> and
Helidon uses standard content negotiation at <code>/my-openapi</code> to return either the OpenAPI document or the UI.</p>

</li>
<li>
<p>Separately, configure the entire web context path for the UI independently from the web context for OpenAPI.</p>
<markup
lang="properties"
title="Configuring the OpenAPI UI web context"
>openapi.ui.web-context=/my-ui</markup>

<div class="admonition note">
<p class="admonition-textlabel">Note</p>
<p ><p>The <code>openapi.ui.web-context</code> setting assigns the <em>entire</em> web-context for the UI, not the suffix appended to the <code>OpenAPISupport</code> endpoint.</p>
</p>
</div>

<p>With this configuration, the UI responds at <code>/my-ui</code> regardless of the path for OpenAPI itself.</p>

</li>
</ul>

<p>The SmallRye OpenAPI UI component accepts several options, but they are of minimal use to application developers and they must be passed to the SmallRye UI code programmatically.
Helidon allows you to specify these values using configuration in the <code>openapi.ui.options</code> section. Helidon then passes the corresponding options to SmallRye for you.
To configure any of these settings, use the enum values&#8212;&#8203;they are all lower case&#8212;&#8203;declared in  the SmallRye <a target="_blank" href="https://github.com/smallrye/smallrye-open-api/tree/2.1.16/ui/open-api-ui/src/main/java/io/smallrye/openapi/ui/Option.java"><code>Option.java</code></a> class as the keys in your Helidon configuration.</p>

<div class="admonition note">
<p class="admonition-textlabel">Note</p>
<p ><p>Helidon prepares several of the SmallRye options automatically based on other settings.
Any options you configure override the values Helidon assigns, possibly interfering with the proper operation of the UI.</p>
</p>
</div>

</div>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">
<p><router-link to="/mp/openapi/openapi">Helidon OpenAPI MP documentation</router-link></p>

<p><a target="_blank" href="https://github.com/smallrye/smallrye-open-api/tree/2.1.16/ui/open-api-ui">SmallRye OpenAPI UI GitHub site</a></p>

</div>

</doc-view>
