<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>The <a target="_blank" href="https://github.com/OAI/OpenAPI-Specification/blob/master/versions/3.0.0.md">OpenAPI specification</a> defines a standard way to express the interface exposed by a REST service.</p>

<p>The <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-open-api-3.0/microprofile-openapi-spec-3.0.html">MicroProfile OpenAPI spec</a> explains how MicroProfile embraces OpenAPI, adding annotations, configuration, and a service provider interface (SPI).</p>

<p>Helidon MP implements the MicroProfile OpenAPI specification.</p>

<p>The OpenAPI support in Helidon MP performs two main tasks:</p>

<ul class="ulist">
<li>
<p>Build an in-memory model of the REST API your service implements.</p>

</li>
<li>
<p>Expose the model in text format (typically YAML) via the <code>/openapi</code> endpoint.</p>

</li>
</ul>

<p>To construct the model, Helidon gathers information about the service API from whichever of these sources are present in the application:</p>

<ul class="ulist">
<li>
<p>a <em>model reader</em></p>
<p>The SPI defines an interface you can implement in your application for  programmatically providing part or all of the model;</p>

</li>
<li>
<p>a static OpenAPI document file packaged as part of your service;</p>

</li>
<li>
<p>OpenAPI annotations;</p>

</li>
<li>
<p>a <em>filter</em> class</p>
<p>The SPI defines an interface you can implement in your application which can mask parts of the model.</p>

</li>
</ul>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable MicroProfile OpenAPI
either add a dependency on the <router-link to="/mp/introduction/microprofile">helidon-microprofile bundle</router-link> or
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependencies&gt;
    &lt;dependency&gt; <span class="conum" data-value="1" />
        &lt;groupId&gt;org.eclipse.microprofile.openapi&lt;/groupId&gt;
        &lt;artifactId&gt;microprofile-openapi-api&lt;/artifactId&gt;
    &lt;/dependency&gt;
    &lt;dependency&gt; <span class="conum" data-value="2" />
        &lt;groupId&gt;io.helidon.microprofile.openapi&lt;/groupId&gt;
        &lt;artifactId&gt;helidon-microprofile-openapi&lt;/artifactId&gt;
        &lt;scope&gt;runtime&lt;/scope&gt;
    &lt;/dependency&gt;
&lt;/dependencies&gt;</markup>

<ul class="colist">
<li data-value="1">Defines the MicroProfile OpenAPI annotations so you can use them in your code.</li>
<li data-value="2">Adds the Helidon MP OpenAPI runtime support.</li>
</ul>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">

<h3 id="_openapi_support_in_helidon_mp">OpenAPI support in Helidon MP</h3>
<div class="section">
<p>You can very simply add support for OpenAPI to your Helidon MP application. This
document shows what changes you need to make to your application and how to access
the OpenAPI document for your application at runtime.</p>

</div>


<h3 id="_changing_your_application">Changing your application</h3>
<div class="section">
<p>To use OpenAPI from your Helidon MP app, in addition to adding dependencies as described above:</p>

<ol style="margin-left: 15px;">
<li>
Furnish OpenAPI information about your application&#8217;s endpoints.

</li>
<li>
Update your application&#8217;s configuration (optional).

</li>
</ol>


<h4 id="_furnish_openapi_information_about_your_endpoints">Furnish OpenAPI information about your endpoints</h4>
<div class="section">
<p>Helidon MP OpenAPI combines information from all of the following sources as it
builds its in-memory model of your application&#8217;s API. It constructs the OpenAPI
document from this internal model. Your application can use one or more of these
techniques.</p>


<h5 id="_annotate_the_endpoints_in_your_app">Annotate the endpoints in your app</h5>
<div class="section">
<p>You can add MicroProfile OpenAPI annotations to the endpoints in your source code.
These annotations allow the Helidon MP OpenAPI runtime to discover the endpoints
and information about them via CDI at app start-up.</p>

<p>Here is one of the endpoints, annotated for OpenAPI, from the example mentioned earlier:</p>

<markup
lang="java"

>@GET
@Operation(summary = "Returns a generic greeting", <span class="conum" data-value="1" />
        description = "Greets the user generically")
@APIResponse(description = "Simple JSON containing the greeting", <span class="conum" data-value="2" />
        content = @Content(mediaType = "application/json",
                           schema = @Schema(implementation = GreetingMessage.class)))
@Produces(MediaType.APPLICATION_JSON)
public JsonObject getDefaultMessage() {...}</markup>

<ul class="colist">
<li data-value="1"><code>@Operation</code> gives information about this endpoint.</li>
<li data-value="2"><code>@APIResponse</code> describes the HTTP response and declares its media type and contents.</li>
</ul>

<p>You can also define any request parameters the endpoint expects, although this
endpoint uses none.</p>

<p>This excerpt shows only a few annotations for illustration. The
<a target="_blank" href="https://github.com/oracle/helidon/tree/master/examples/microprofile/openapi-basic">Helidon MP OpenAPI example</a> illustrates more,
and the <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-open-api-3.0/microprofile-openapi-spec-3.0.html">MicroProfile OpenAPI spec</a> describes them all.</p>

</div>


<h5 id="_provide_a_static_openapi_file">Provide a static OpenAPI file</h5>
<div class="section">
<p>Add a static file at <code>META-INF/openapi.yml</code>, <code>META-INF/openapi.yaml</code>,
or <code>META-INF/openapi.json</code>. Tools such as Swagger let you describe your app&#8217;s API
and they then generate an OpenAPI document file which you can include in your application
so OpenAPI can use it.</p>

</div>


<h5 id="_write_and_configure_a_model_reader_class">Write and configure a model reader class</h5>
<div class="section">
<p>Write a Java class that implements the OpenAPI
<a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-open-api-3.0/apidocs/apidocs/org/eclipse/microprofile/openapi//OASModelReader.html"><code>org.eclipse.microprofile.openapi.OASModelReader</code></a> interface. Your
model reader code programmatically adds elements to the internal model that OpenAPI
builds.</p>

</div>


<h5 id="_provide_a_static_openapi_file_2">Provide a static OpenAPI file</h5>
<div class="section">
<p>Add a static file at <code>META-INF/openapi.yml</code>, <code>META-INF/openapi.yaml</code>,
or <code>META-INF/openapi.json</code>. Tools such as Swagger let you describe your app&#8217;s API
and they then generate an OpenAPI document file which you can include in your application
so OpenAPI can use it.</p>

</div>


<h5 id="_write_and_configure_a_model_reader_class_2">Write and configure a model reader class</h5>
<div class="section">
<p>Write a Java class that implements the OpenAPI
<a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-open-api-3.0/apidocs/apidocs/org/eclipse/microprofile/openapi//OASModelReader.html"><code>org.eclipse.microprofile.openapi.OASModelReader</code></a> interface. Your
model reader code programmatically adds elements to the internal model that OpenAPI
builds.</p>

<p>Change your application&#8217;s MP configuration to set <code>mp.openapi.model.reader</code> as the
fully-qualified class name of your class.</p>

</div>


<h5 id="_write_and_configure_a_filter_class">Write and configure a filter class</h5>
<div class="section">
<p>Write a Java class that implements the OpenAPI
<a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-open-api-3.0/apidocs/apidocs/org/eclipse/microprofile/openapi//OASFilter.html"><code>org.eclipse.microprofile.openapi.OASFilter</code></a> interface.
As OpenAPI composes its internal model, it invokes your filter with each
model element <em>before</em> adding the element to the model. Your filter can
accept the element as-is, modify it, or suppress it.</p>

<p>Change your application&#8217;s configuration to set <code>mp.openapi.filter</code> as the full-qualified
class name of your class.</p>

</div>

</div>

</div>


<h3 id="_update_your_application_configuration">Update your application configuration</h3>
<div class="section">
<p>Beyond the two config properties that denote the model reader and filter, Helidon
MP OpenAPI supports a number of other mandated settings. These are described in the
<a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-open-api-3.0/microprofile-openapi-spec-3.0.html#configuration">configuration section</a> of the MicroProfile
OpenAPI spec.</p>

</div>


<h3 id="_accessing_the_rest_endpoint">Accessing the REST Endpoint</h3>
<div class="section">
<p>Once you add the MP OpenAPI dependency to your
project,
your application will automatically respond to the built-in endpoint&#8201;&#8212;&#8201;<code>/openapi</code>&#8201;&#8212;&#8201;and it will return the OpenAPI document describing the endpoints
in your application.</p>

<p>By default, per the MicroProfile OpenAPI spec, the default format of the OpenAPI document is YAML.
There is not yet an adopted IANA YAML media type, but a proposed one specifically
for OpenAPI documents that has some support is <code>application/vnd.oai.openapi</code>.
That is what Helidon returns, by default.</p>

<p>In addition, a client can specify the HTTP header <code>Accept</code> as either <code>application/vnd.oai.openapi+json</code> or
<code>application/json</code> to request JSON. Alternatively, the client can pass the query parameter <code>format</code> as either <code>JSON</code>
or <code>YAML</code> to receive <code>application/json</code> or <code>application/vnd.oai.openapi</code> (YAML) output, respectively.</p>

</div>

</div>


<h2 id="_api">API</h2>
<div class="section">
<p>The <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-open-api-3.0/microprofile-openapi-spec-3.0.html">MicroProfile OpenAPI specification</a> gives a listing and brief examples of the annotations you can add to your code to convey OpenAPI information.</p>

<p>The <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-open-api-3.0/apidocs">MicroProfile OpenAPI JavaDocs</a> give full details of the
annotations and the other
classes and interfaces you can use in your code.</p>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>Helidon OpenAPI configuration supports the following settings:</p>

<p>Type: <a target="_blank" href="./apidocs/io.helidon.microprofile.openapi/io/helidon/microprofile/openapi/MPOpenAPISupport.html">io.helidon.microprofile.openapi.MPOpenAPISupport</a></p>

<markup
lang="text"
title="Config key"
>mp.openapi</markup>


<h3 id="_configuration_options">Configuration options</h3>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>application-path-disable</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Sets whether the app path search should be disabled.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cors</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_reactive_webserver_cors_CrossOriginConfig">CrossOriginConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Assigns the CORS settings for the OpenAPI endpoint.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>custom-schema-registry-class</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets the custom schema registry class.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>filter</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets the developer-provided OpenAPI filter class name.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>model.reader</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets the developer-provided OpenAPI model reader class name.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>scan.classes</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Specify the list of classes to scan.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>scan.disable</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Disable annotation scanning.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>scan.exclude.classes</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Specify the list of classes to exclude from scans.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>scan.exclude.packages</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Specify the list of packages to exclude from scans.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>scan.packages</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Specify the list of packages to scan.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>schema.*</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets the schema for the indicated fully-qualified class name (represented here by '*'); value is the schema in JSON format. Repeat for multiple classes.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>servers</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets servers.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>servers.operation.*</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets alternative servers to service the indicated operation (represented here by '*'). Repeat for multiple operations.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>servers.path.*</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets alternative servers to service all operations at the indicated path (represented here by '*'). Repeat for multiple paths.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>static-file</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>META-INF/openapi.*</code></td>
<td class=""><doc-view>
<p>Sets the file system path of the static OpenAPI document file. Default types are <code>json</code>, <code>yaml</code>, and <code>yml</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>web-context</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>/openapi</code></td>
<td class=""><doc-view>
<p>Sets the web context path for the OpenAPI endpoint.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>Helidon MP includes a <a target="_blank" href="https://github.com/oracle/helidon/tree/master/examples/microprofile/openapi-basic">complete OpenAPI example</a>
based on the MP quick-start sample app. The rest of this section shows, step-by-step, how one might change the original QuickStart service to adopt OpenAPI.</p>


<h3 id="_helidon_mp_basic_openapi_example">Helidon MP Basic OpenAPI Example</h3>
<div class="section">
<p>This example shows a simple greeting application, similar to the one from the
Helidon MP QuickStart, enhanced with OpenAPI support.</p>

<markup
lang="java"

>@Path("/greeting")
@PUT
@Operation(summary = "Set the greeting prefix",
           description = "Permits the client to set the prefix part of the greeting (\"Hello\")") <span class="conum" data-value="1" />
@RequestBody( <span class="conum" data-value="2" />
    name = "greeting",
    description = "Conveys the new greeting prefix to use in building greetings",
    content = @Content(
                mediaType = "application/json",
                schema = @Schema(implementation = GreetingMessage.class),
                examples = @ExampleObject(
                    name = "greeting",
                    summary = "Example greeting message to update",
                    value = "New greeting message")))
@Consumes(MediaType.APPLICATION_JSON)
@Produces(MediaType.APPLICATION_JSON)
public Response updateGreeting(JsonObject jsonObject) {
    ...
}</markup>

<ul class="colist">
<li data-value="1">With <code>@Operation</code> annotation we document the current method.</li>
<li data-value="2">With <code>@RequestBody</code> annotation we document the content produced. Internal annotations <code>@Content</code>, <code>@Schema</code> and
<code>@ExampleObjects</code> are used to give more details about the returned data.</li>
</ul>

<p>If we want to hide a specific path an <code>OASFilter</code> is used.</p>

<p>The OASFilter interface allows application developers to receive callbacks for various key OpenAPI elements. The
 interface has a default implementation for every method, which allows application developers to only override the
 methods they care about. To use it, simply create an implementation of this interface and register it using the
 <code>mp.openapi.filter configuration</code> key, where the value is the fully qualified name of the filter class.</p>

<p>The following example filter prevents information about a given path from appearing in the OpenAPI document.</p>

<markup
lang="java"

>import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;

public class SimpleAPIFilter implements OASFilter {

    @Override
    public PathItem filterPathItem(PathItem pathItem) {
        for (Map.Entry&lt;PathItem.HttpMethod, Operation&gt; methodOp
                : pathItem.getOperations().entrySet()) {
            if (SimpleAPIModelReader.DOOMED_OPERATION_ID
                    .equals(methodOp.getValue().getOperationId())) {
                return null;
            }
        }
        return OASFilter.super.filterPathItem(pathItem);
    }
}</markup>

<p>You can implement a model reader to provide all or part of the in-memory <code>OpenAPI</code> model programmatically. Helidon
 <code>OpenAPI</code> merges the model from the model reader with models from the other sources (a static file and annotations).</p>

<p>The example model reader below creates an <code>OpenAPI</code> object describing two paths. It turns out that the filter described
earlier will suppress one of the paths, but the model reader does not know or care.</p>

<markup
lang="java"

>import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.OASModelReader;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;

/**
 * Defines two paths using the OpenAPI model reader mechanism, one that should
 * be suppressed by the filter class and one that should appear in the published
 * OpenAPI document.
 */
public class SimpleAPIModelReader implements OASModelReader {

    /**
     * Path for the example endpoint added by this model reader that should be visible.
     */
    public static final String MODEL_READER_PATH = "/test/newpath";

    /**
     * Path for an endpoint that the filter should hide.
     */
    public static final String DOOMED_PATH = "/test/doomed";

    /**
     * ID for an endpoint that the filter should hide.
     */
    public static final String DOOMED_OPERATION_ID = "doomedPath";

    /**
     * Summary text for the endpoint.
     */
    public static final String SUMMARY = "A sample test endpoint from ModelReader";

    @Override
    public OpenAPI buildModel() {
        /*
         * Add two path items, one of which we expect to be removed by
         * the filter and a very simple one that will appear in the
         * published OpenAPI document.
         */
        PathItem newPathItem = OASFactory.createPathItem()
                .GET(OASFactory.createOperation()
                    .operationId("newPath")
                    .summary(SUMMARY));
        PathItem doomedPathItem = OASFactory.createPathItem()
                .GET(OASFactory.createOperation()
                    .operationId(DOOMED_OPERATION_ID)
                    .summary("This should become invisible"));
        OpenAPI openAPI = OASFactory.createOpenAPI();
        Paths paths = OASFactory.createPaths()
                .addPathItem(MODEL_READER_PATH, newPathItem)
                .addPathItem(DOOMED_PATH, doomedPathItem);
        openAPI.paths(paths);

        return openAPI;
    }
}</markup>

<p>Having written the filter and model reader classes, identify them by adding configuration to
 <code>META-INF/microprofile-config.properties</code> as the following example shows.</p>

<markup
lang="properties"

>mp.openapi.filter=io.helidon.microprofile.examples.openapi.basic.internal.SimpleAPIFilter
mp.openapi.model.reader=io.helidon.microprofile.examples.openapi.basic.internal.SimpleAPIModelReader</markup>

<p>Now just build and run:</p>

<markup
lang="bash"

>mvn package
java -jar target/helidon-examples-microprofile-openapi-basic.jar</markup>

<p>Try the endpoints:</p>

<markup
lang="bash"

>curl -X GET http://localhost:8080/greet
{"message":"Hello World!"}

curl -X GET http://localhost:8080/openapi
[lengthy OpenAPI document]</markup>

<p>The output describes not only then endpoints from <code>GreetResource</code> but
also one contributed by the <code>SimpleAPIModelReader</code>.</p>

<p>Full example is available <a target="_blank" href="https://github.com/oracle/helidon/tree/master}/examples/microprofile/openapi-basic">in our official repository</a></p>

</div>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">

<h3 id="_building_the_jandex_index">Building the Jandex index</h3>
<div class="section">
<p>A Jandex index stores information about the classes and methods in your app and
what annotations they have. It allows CDI to process annotations faster during your
application&#8217;s start-up.</p>

<p>Add the <a target="_blank" href="https://github.com/wildfly/jandex-maven-plugin">Jandex maven plug-in</a> to the <code>&lt;build&gt;&lt;plugins&gt;</code>
section of your <code>pom.xml</code>:</p>

<markup
lang="xml"

>&lt;plugin&gt;
    &lt;groupId&gt;org.jboss.jandex&lt;/groupId&gt;
    &lt;artifactId&gt;jandex-maven-plugin&lt;/artifactId&gt;
    &lt;version&gt;{jandex-plugin-version}&lt;/version&gt;
    &lt;executions&gt;
      &lt;execution&gt;
        &lt;id&gt;make-index&lt;/id&gt;
        &lt;goals&gt;
          &lt;goal&gt;jandex&lt;/goal&gt;
        &lt;/goals&gt;
      &lt;/execution&gt;
    &lt;/executions&gt;
&lt;/plugin&gt;</markup>

<p>When you build your app <code>maven</code> should include the index <code>META-INF/jandex.idx</code> in
the JAR.</p>

<div class="admonition note">
<p class="admonition-textlabel">Note</p>
<p ><p>If you <em>do not</em> modify your build to create
the index then the Helidon MP OpenAPI runtime automatically creates one in memory during
app start-up. This slows down your app start-up and, depending on how CDI is
configured, might inadvertently miss information.</p>

<p>We <em>strongly recommend</em> using the Jandex plug-in to build the index into your app.</p>
</p>
</div>

</div>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://github.com/eclipse/microprofile-open-api">MicroProfile OpenAPI GitHub Repository</a></p>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-open-api-3.0/microprofile-openapi-spec-3.0.html">MicroProfile OpenAPI Specification</a></p>

</li>
</ul>

</div>

</doc-view>
